/* Start from Jan 1994 and end when we reach Dec 2009 */
/* We exclude data from Jun 1995 - Sep 1995 because the BLS has made it impossible to track */
/* households between June to August. Therefore, we can't match data from Jun to Sept */
   
local orig_x=197601
local x=`orig_x'

while `x' <= 201810 {
	use "${data}/cps`x'.dta", clear
	count
	local COUNT = r(N)
	if `COUNT'!=0 {
		/* Get rid of any observations that are missing */
		drop if age < 25 //because of education
		drop if educ==-1 //missing education
        }
	count
	local COUNT = r(N)
	if `COUNT'!=0 {
		if `x' < 198901 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 
                     replace lfs = "N" if status == 4 | status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
                     /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
            }
            else if `x'==198901{
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
                     /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
            }
            else if `x' < 199401 & `x' > 198901 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
					 /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
            }
            else if `x'==199401{
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
					 /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
            }
            else if `x' > 199401 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
					 /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
            }
		  
		  /* create stocks by education */
		  pause
		  if `x'<=198812 {
			*1=less than hs diploma 2=HS diploma 3=some college 4=BA +
			recode educ (-1=0) (0/12=1) (13=2) (14/16=3) (17/999=4), gen(edgrp)
		  	*1=male 2=female
			recode sex (1=1) (2=2) , gen(sexgrp)
			egen sexedgrp=group(sexgrp edgrp), label
		  }
		  else if `x'<=199112 & `x'>198812 {
			*1=less than hs diploma 2=HS diploma 3=some college 4=BA +
			recode educ (-1=0) (0/11=1) (12=2) (13/15=3) (16/999=4), gen(edgrp)
		  	*1=male 2=female
			recode sex (1=1) (2=2) , gen(sexgrp)
			egen sexedgrp=group(sexgrp edgrp), label			
		  }
		  else if `x'>199112 {
			*1=less than hs diploma 2=HS diploma 3=some college 4=BA +
			recode educ (-1=0) (0/38=1) (39=2) (40/42=3) (43/46=4), gen(edgrp)
		  	*1=male 2=female
			recode sex (1=1) (2=2) , gen(sexgrp)
			egen sexedgrp=group(sexgrp edgrp), label			
		  }
		  
				gen weight = fweight
				sort udur sexedgrp
				egen double stock = sum(weight), by(udur sexedgrp)

                  if `x' <= 199312 {
					 replace stock = stock/100
                  }
                  else if (`x' >= 199401 & `x' < 201001) | `x' ==201112 {
					 replace stock = stock/10000
                  }
                  else if `x' >= 201001 {
					 replace stock = stock/10000
                  }

			/* counting the number of observations */
			gen obscount = 1
			bysort udur sexedgrp: egen count_udur = count(obscount)

                  /* Drop duplicate observations */
                  sort udur sexedgrp
                  quietly by udur sexedgrp: gen duplic = cond(_N==1, 0, _n)
                  drop if duplic > 1
		  pause
		  }

		  keep stock udur sexedgrp year month
			if `x' > `orig_x' {
				append using "${out}/stock_udur_sexed.dta"
            }
		  pause
		  
		  save "${out}/stock_udur_sexed.dta", replace

               local x = `x' + 1
               if (`x'-13)/100 == int((`x'-13)/100) {
                  local x = `x' + 88
                  noisily display (`x'-1)/100
               }

               sort year month

            }
	    
	    keep if udur=="less than 5"
	    ren stock U5
	    drop udur
	    save ${out}/u5_sexed_nsa, replace
