/* Start from Jan 1994 and end when we reach Dec 2009 */
/* We exclude data from Jun 1995 - Sep 1995 because the BLS has made it impossible to track */
/* households between June to August. Therefore, we can't match data from Jun to Sept */
   
local orig_x=197601
local x=`orig_x'

while `x' <= 201810 {
	use "${data}/cps`x'.dta", clear
	count
	local COUNT = r(N)
	if `COUNT'!=0 {
		/* Get rid of any observations that are missing */
		drop if age < 16
        }
	count
	local COUNT = r(N)
	if `COUNT'!=0 {
		if `x' < 198901 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 
                     replace lfs = "N" if status == 4 | status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
                     /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
					 /* Aggregate industry code*/
					 gen ind_s=real(ind)
					 gen ind1=.
					 replace ind1=1 if ind_s>0&ind_s<40
					 replace ind1=2 if ind_s>40&ind_s<60
					 replace ind1=3 if ind_s>=60&ind_s<80
					 replace ind1=4 if ind_s>=100&ind_s<400
					 replace ind1=5 if ind_s>=500&ind_s<700
					 replace ind1=6 if ind_s>=400&ind_s<500
					 replace ind1=7 if ind_s>=700&ind_s<720
					 replace ind1=8 if ind_s>720&ind_s<990
					 replace ind1=9 if ind1==.
					 drop ind ind_s
					 ren ind1 ind
            }
            else if `x'==198901{
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
                     /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
					 /* Aggregate industry code*/
					 gen ind_s=real(ind)
					 gen ind1=.
					 replace ind1=1 if ind_s>0&ind_s<40
					 replace ind1=2 if ind_s>40&ind_s<60
					 replace ind1=3 if ind_s>=60&ind_s<80
					 replace ind1=4 if ind_s>=100&ind_s<400
					 replace ind1=5 if ind_s>=500&ind_s<700
					 replace ind1=6 if ind_s>=400&ind_s<500
					 replace ind1=7 if ind_s>=700&ind_s<720
					 replace ind1=8 if ind_s>720&ind_s<990
					 replace ind1=9 if ind1==.
					 drop ind ind_s
					 ren ind1 ind
            }
            else if `x' < 199401 & `x' > 198901 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
					 /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
					 /* Aggregate industry code*/
					 gen ind_s=real(ind)
					 gen ind1=.
					 replace ind1=1 if ind_s>0&ind_s<40
					 replace ind1=2 if ind_s>40&ind_s<60
					 replace ind1=3 if ind_s>=60&ind_s<80
					 replace ind1=4 if ind_s>=100&ind_s<400
					 replace ind1=5 if ind_s>=500&ind_s<700
					 replace ind1=6 if ind_s>=400&ind_s<500
					 replace ind1=7 if ind_s>=700&ind_s<720
					 replace ind1=8 if ind_s>720&ind_s<990
					 replace ind1=9 if ind1==.
					 drop ind ind_s
					 ren ind1 ind
            }
            else if `x'==199401{
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
					 /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
					 /* Aggregate industry code*/
					 gen ind_s=real(ind)
					 gen ind1=.
					 replace ind1=1 if ind_s>0&ind_s<40
					 replace ind1=2 if ind_s>40&ind_s<60
					 replace ind1=3 if ind_s>=60&ind_s<80
					 replace ind1=4 if ind_s>=100&ind_s<400
					 replace ind1=5 if ind_s>=500&ind_s<700
					 replace ind1=6 if ind_s>=400&ind_s<500
					 replace ind1=7 if ind_s>=700&ind_s<720
					 replace ind1=8 if ind_s>720&ind_s<990
					 replace ind1=9 if ind1==.
					 drop ind ind_s
					 ren ind1 ind
            }
            else if `x' < 200301 & `x' > 199401 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
					 /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
					 /* Aggregate industry code*/
					 gen ind_s=real(ind)
					 gen ind1=.
					 replace ind1=1 if ind_s>0&ind_s<40
					 replace ind1=2 if ind_s>40&ind_s<60
					 replace ind1=3 if ind_s>=60&ind_s<80
					 replace ind1=4 if ind_s>=100&ind_s<400
					 replace ind1=5 if ind_s>=500&ind_s<700
					 replace ind1=6 if ind_s>=400&ind_s<500
					 replace ind1=7 if ind_s>=700&ind_s<720
					 replace ind1=8 if ind_s>720&ind_s<990
					 replace ind1=9 if ind1==.
					 drop ind ind_s
					 ren ind1 ind
            }
			else if `x' > 200212 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
					 /* Create Unemployment Duration Status */					 
					 gen dur_n=real(dur)
					 gen udur="less than 5" if dur_n>=0&dur_n<5&lfs=="U"
					 replace udur="5 to 14" if dur_n>=5&dur_n<15&lfs=="U"
					 replace udur="15 to 26" if dur_n>=15&dur_n<27&lfs=="U"
					 replace udur="27 and over" if dur_n>=27&lfs=="U"
					 replace udur="M" if udur==""&lfs=="U"
					 /* Aggregate industry code*******/
					 gen ind_s=real(ind)/10
					 gen ind1=.
					 replace ind1=1 if ind_s>0&ind_s<30
					 replace ind1=2 if ind_s>30&ind_s<60
					 replace ind1=3 if ind_s>70&ind_s<80
					 replace ind1=4 if ind_s>100&ind_s<400
					 replace ind1=5 if ind_s>400&ind_s<600
					 replace ind1=6 if ind_s>600&ind_s<640
					 replace ind1=6 if ind_s>50&ind_s<70
					 replace ind1=7 if ind_s>=680&ind_s<720
					 replace ind1=8 if ind_s>720&ind_s<990
					 replace ind1=8 if ind_s>640&ind_s<680
					 replace ind1=9 if ind1==.
					 drop ind ind_s
					 ren ind1 ind
            }
		  
		  /* create stocks by group */
		  pause
			egen indgrp=group(ind), label
			
				gen weight = fweight
				sort udur indgrp
				egen double stock = sum(weight), by(udur indgrp)

                  if `x' <= 199312 {
					 replace stock = stock/100
                  }
                  else if (`x' >= 199401 & `x' < 201001) | `x' ==201112 {
					 replace stock = stock/10000
                  }
                  else if `x' >= 201001 {
					 replace stock = stock/10000
                  }

			/* counting the number of observations */
			gen obscount = 1
			bysort udur indgrp: egen count_udur = count(obscount)

                  /* Drop duplicate observations */
                  sort udur indgrp
                  quietly by udur indgrp: gen duplic = cond(_N==1, 0, _n)
                  drop if duplic > 1
		  pause
		  }

		  keep stock udur indgrp year month
			if `x' > `orig_x' {
				append using "${out}/stock_ind.dta"
            }
		  pause
		  
		  save "${out}/stock_ind.dta", replace

               local x = `x' + 1
               if (`x'-13)/100 == int((`x'-13)/100) {
                  local x = `x' + 88
                  noisily display (`x'-1)/100
               }

               sort year month

            }
	    
	    keep if udur=="less than 5"
	    ren stock U5
	    drop udur
	    save ${out}/u5_ind_nsa, replace
