/* Start from Jan 1994 and end when we reach Dec 2009 */
/* We exclude data from Jun 1995 - Sep 1995 because the BLS has made it impossible to track */
/* households between June to August. Therefore, we can't match data from Jun to Sept */
   
local orig_x=197601
local x=`orig_x'

while `x' <= 201810 {
	use "${data}/cps`x'.dta", clear
	count
	local COUNT = r(N)
	if `COUNT'!=0 {
		/* Get rid of any observations that are missing */
		drop if age < 16
        }
	count
	local COUNT = r(N)
	if `COUNT'!=0 {
		if `x' < 198901 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 
                     replace lfs = "N" if status == 4 | status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x'==198901{
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x' < 199401 & `x' > 198901 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x'==199401{
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x' < 200502 & `x' > 199401 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
			else if `x' > 200501 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
                     /* state from fed def to census def */
					 gen state1=.
					 replace state1=11 if state==23
					 replace state1=12 if state==33
					 replace state1=13 if state==50
					 replace state1=14 if state==25
					 replace state1=15 if state==44
					 replace state1=16 if state==09
					 replace state1=21 if state==36
					 replace state1=22 if state==34
					 replace state1=23 if state==42
					 replace state1=31 if state==39
					 replace state1=32 if state==18
					 replace state1=33 if state==17
					 replace state1=34 if state==26
					 replace state1=35 if state==55
					 replace state1=41 if state==27
					 replace state1=42 if state==19
					 replace state1=43 if state==29
					 replace state1=44 if state==38
					 replace state1=45 if state==46
					 replace state1=46 if state==31
					 replace state1=47 if state==20
					 replace state1=51 if state==10
					 replace state1=52 if state==24
					 replace state1=53 if state==11
					 replace state1=54 if state==51
					 replace state1=55 if state==54
					 replace state1=56 if state==37
					 replace state1=57 if state==45
					 replace state1=58 if state==13
					 replace state1=59 if state==12
					 replace state1=61 if state==21
					 replace state1=62 if state==47
					 replace state1=63 if state==01
					 replace state1=64 if state==28
					 replace state1=71 if state==05
					 replace state1=72 if state==22
					 replace state1=73 if state==40
					 replace state1=74 if state==48
					 replace state1=81 if state==30
					 replace state1=82 if state==16
					 replace state1=83 if state==56
					 replace state1=84 if state==08
					 replace state1=85 if state==35
					 replace state1=86 if state==04
					 replace state1=87 if state==49
					 replace state1=88 if state==32
					 replace state1=91 if state==53
					 replace state1=92 if state==41
					 replace state1=93 if state==06
					 replace state1=94 if state==02
					 replace state1=95 if state==15
					 drop state
					 ren state1 state
            }
		  
		  /* create stocks by group */
		  pause
		  drop if state<11|state>95
			egen stategrp=group(state), label
			
			
				gen weight = fweight
				sort lfs stategrp
				egen double stock = sum(weight), by(lfs stategrp)

                  if `x' <= 199312 {
                     replace stock = stock/100
                  }
                  else if (`x' >= 199401 & `x' < 201001) | `x' ==201112 {
                     replace stock = stock/10000
                  }
                  else if `x' >= 201001 {
                     replace stock = stock/10000
                  }

			/* counting the number of observations */
			gen obscount = 1
			bysort lfs stategrp: egen count = count(obscount)

                  /* Drop duplicate observations */
                  sort lfs stategrp
                  quietly by lfs stategrp: gen duplic = cond(_N==1, 0, _n)
                  drop if duplic > 1
		  pause
		  }

		  keep stock lfs stategrp year month
			if `x' > `orig_x' {
				append using "${out}/stock_state.dta"
            }
		  pause
		  
		  save "${out}/stock_state.dta", replace

               local x = `x' + 1
               if (`x'-13)/100 == int((`x'-13)/100) {
                  local x = `x' + 88
                  noisily display (`x'-1)/100
               }

               sort year month

            }
	    
		preserve
	    keep if lfs=="U"
	    ren stock U
	    drop lfs
	    save ${out}/u_state_nsa, replace
		restore
		preserve
	    keep if lfs=="N"
	    ren stock N
	    drop lfs
	    save ${out}/n_state_nsa, replace
		restore
	    keep if lfs=="E"
	    ren stock E
	    drop lfs
	    save ${out}/e_state_nsa, replace
