/* Start from Jan 1994 and end when we reach Dec 2009 */
/* We exclude data from Jun 1995 - Sep 1995 because the BLS has made it impossible to track */
/* households between June to August. Therefore, we can't match data from Jun to Sept */
   
local orig_x=197601
local x=`orig_x'

while `x' <= 201810 {
	use "${data}/cps`x'.dta", clear
	count
	local COUNT = r(N)
	if `COUNT'!=0 {
		/* Get rid of any observations that are missing */
		drop if age < 25 //because of education
		drop if educ==-1 //missing education
        }
	count
	local COUNT = r(N)
	if `COUNT'!=0 {
		if `x' < 198901 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 
                     replace lfs = "N" if status == 4 | status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x'==198901{
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x' < 199401 & `x' > 198901 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x'==199401{
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x' > 199401 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
		  
		  /* create stocks by education */
		  pause
		  pause
		  if `x'<=198812 {
			*1=less than hs diploma 2=HS diploma 3=some college 4=BA +
			recode educ (-1=0) (0/12=1) (13=2) (14/16=3) (17/999=4), gen(edgrp)
		  	*1=male 2=female
			recode sex (1=1) (2=2) , gen(sexgrp)
			*1=25-54 2=55+
			recode age (25/54=1)(55/999=2), gen(agegrp)
			egen sexedgrp=group(sexgrp edgrp), label
			egen sexedagegrp=group(sexedgrp agegrp), label
		  }
		  else if `x'<=199112 & `x'>198812 {
			*1=less than hs diploma 2=HS diploma 3=some college 4=BA +
			recode educ (-1=0) (0/11=1) (12=2) (13/15=3) (16/999=4), gen(edgrp)
		  	*1=male 2=female
			recode sex (1=1) (2=2) , gen(sexgrp)
			*1=25-54 2=55+
			recode age (25/54=1)(55/999=2), gen(agegrp)
			egen sexedgrp=group(sexgrp edgrp), label
			egen sexedagegrp=group(sexedgrp agegrp), label
			}
		  else if `x'>199112 {
			*1=less than hs diploma 2=HS diploma 3=some college 4=BA +
			recode educ (-1=0) (0/38=1) (39=2) (40/42=3) (43/46=4), gen(edgrp)
		  	*1=male 2=female
			recode sex (1=1) (2=2) , gen(sexgrp)
			*1=25-54 2=55+
			recode age (25/54=1)(55/999=2), gen(agegrp)
			egen sexedgrp=group(sexgrp edgrp), label
			egen sexedagegrp=group(sexedgrp agegrp), label			
		  }
		  
				gen weight = fweight
				sort lfs sexedagegrp
				egen double stock = sum(weight), by(lfs sexedagegrp)

                  if `x' <= 199312 {
                     replace stock = stock/100
                  }
                  else if (`x' >= 199401 & `x' < 201001) | `x' ==201112 {
                     replace stock = stock/10000
                  }
                  else if `x' >= 201001 {
                     replace stock = stock/10000
                  }

			/* counting the number of observations */
			gen obscount = 1
			bysort lfs sexedagegrp: egen count = count(obscount)

                  /* Drop duplicate observations */
                  sort lfs sexedagegrp
                  quietly by lfs sexedagegrp: gen duplic = cond(_N==1, 0, _n)
                  drop if duplic > 1
		  pause
		  }

		  keep stock lfs sexedagegrp year month
			if `x' > `orig_x' {
				append using "${out}/stock_sexedage.dta"
            }
		  pause
		  
		  save "${out}/stock_sexedage.dta", replace

               local x = `x' + 1
               if (`x'-13)/100 == int((`x'-13)/100) {
                  local x = `x' + 88
                  noisily display (`x'-1)/100
               }

               sort year month

            }
		
		preserve
	    keep if lfs=="U"
	    ren stock U
	    drop lfs
	    save ${out}/u_sexedage_nsa, replace
		restore
		preserve
	    keep if lfs=="N"
	    ren stock N
	    drop lfs
	    save ${out}/n_sexedage_nsa, replace
		restore
		keep if lfs=="E"
	    ren stock E
	    drop lfs
	    save ${out}/e_sexedage_nsa, replace
