/* Start from Jan 1994 and end when we reach Dec 2009 */
/* We exclude data from Jun 1995 - Sep 1995 because the BLS has made it impossible to track */
/* households between June to August. Therefore, we can't match data from Jun to Sept */
   
local orig_x=197601
local x=`orig_x'

while `x' <= 201810 {
	use "${data}/cps`x'.dta", clear
	count
	local COUNT = r(N)
	if `COUNT'!=0 {
		/* Get rid of any observations that are missing */
		drop if age < 16
        }
	count
	local COUNT = r(N)
	if `COUNT'!=0 {
		if `x' < 198901 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 
                     replace lfs = "N" if status == 4 | status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x'==198901{
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x' < 199401 & `x' > 198901 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x'==199401{
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
            else if `x' > 199401 {
                     /* Create Year and Month */
                     gen year=floor(`x'/1e2)
                     gen month=mod(`x',100)
                     /* Create Employment Status */
                     gen str1 lfs = "E" if status == 1 | status == 2
                     replace lfs = "U" if status == 3 | status == 4
                     replace lfs = "N" if status == 5 | status == 6 | status == 7
                     replace lfs = "M" if status == .
            }
		  
		  /* create stocks by sex */
		  pause
			*1=male 2=female
			recode sex (1=1) (2=2) , gen(sexgrp)
		  
				gen weight = fweight
				sort lfs sexgrp
				egen double stock = sum(weight), by(lfs sexgrp)

                  if `x' <= 199312 {
                     replace stock = stock/100
                  }
                  else if (`x' >= 199401 & `x' < 201001) | `x' ==201112 {
                     replace stock = stock/10000
                  }
                  else if `x' >= 201001 {
                     replace stock = stock/10000
                  }

			/* counting the number of observations */
			gen obscount = 1
			bysort lfs sexgrp: egen count = count(obscount)

                  /* Drop duplicate observations */
                  sort lfs sexgrp
                  quietly by lfs sexgrp: gen duplic = cond(_N==1, 0, _n)
                  drop if duplic > 1
		  pause
		  }

		  keep stock lfs sexgrp year month
			if `x' > `orig_x' {
				append using "${out}/stock_sex.dta"
            }
		  pause
		  
		  save "${out}/stock_sex.dta", replace

               local x = `x' + 1
               if (`x'-13)/100 == int((`x'-13)/100) {
                  local x = `x' + 88
                  noisily display (`x'-1)/100
               }

               sort year month

            }
	    
		preserve
	    keep if lfs=="U"
	    ren stock U
	    drop lfs
	    save ${out}/u_sex_nsa, replace
		restore
		preserve
	    keep if lfs=="N"
	    ren stock N
	    drop lfs
	    save ${out}/n_sex_nsa, replace
		restore
	    keep if lfs=="E"
	    ren stock E
	    drop lfs
	    save ${out}/e_sex_nsa, replace
