clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
hazards = readtable('../csv/hazards_sex_sa_quart.csv');

%% quarterly sa hazard rates figure by groups
figure;
hold on
f_men = plot(hazards.Date,hazards.f_men,'LineWidth',1.5,'LineStyle','-','Color','k')
f_women = plot(hazards.Date,hazards.f_women,'LineWidth',1.5,'LineStyle','--','Color','k')
shadenber(gcf)
hold off
title('outflow rate (f) by gender')
legend([f_men f_women], {'f men','f women'},'Location','northeast')
saveas(gcf,'../figure/left/hazards_sex_f_sa_quart','epsc')

figure;
hold on
s_men = plot(hazards.Date,hazards.s_men,'LineWidth',1.5,'LineStyle','-','Color','k')
s_women = plot(hazards.Date,hazards.s_women,'LineWidth',1.5,'LineStyle','--','Color','k')
shadenber(gcf)
hold off
title('inflow rate (s) by gender')
legend([s_men s_women], {'s men','s women'},'Location','northeast')
saveas(gcf,'../figure/left/hazards_sex_s_sa_quart','epsc')

%close all