clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
weights = readtable('../csv/weights_age_sa_quart.csv');

%% weights figure by groups
figure;
hold on
lfs_16to24 = plot(weights.Date,weights.lfshare_16to24,'LineWidth',1.5,'LineStyle','--','Color','k')
lfs_25to54 = plot(weights.Date,weights.lfshare_25to54,'LineWidth',1.5,'LineStyle','-','Color','k')
lfs_55plus = plot(weights.Date,weights.lfshare_55plus,'LineWidth',1.5,'LineStyle','-.','Color','k')
shadenber(gcf)
hold off
title('labor force share by age')
legend([lfs_16to24 lfs_25to54 lfs_55plus], {'lfs 16to24','lfs 25to54','lfs 55plus'},'Location','northeast')
saveas(gcf,'../figure/right/lfshare_age_sa_quart','epsc') % quarterly sa

%close all

