clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
weights = readtable('../csv/weights_sex_sa_quart.csv');

%% quarterly weights figure by groups

figure;
hold on
lfs_men = plot(weights.Date,weights.lfshare_men,'LineWidth',1.5,'LineStyle','-','Color','k')
lfs_women = plot(weights.Date,weights.lfshare_women,'LineWidth',1.5,'LineStyle','--','Color','k')
shadenber(gcf)
hold off
title('labor force share by gender')
legend([lfs_men lfs_women], {'lfs men','lfs women'},'Location','northeast')
saveas(gcf,'../figure/left/lfshare_sex_sa_quart','epsc') % quarterly sa

%close all