clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
hazards = readtable('../csv/hazards_age_sa_quart.csv');
weights = readtable('../csv/weights_age_sa_quart.csv');

%% shift-share (calculate hazard rates holding weight constant at first quarter)
group=3;
T=height(hazards);

weights1976 = table2array([weights(1,2:group+1)]);
weightf1976 = table2array([weights(1,2+group:group+1+group)]);

fall=table2array(hazards(:,2:group+1));
fall_1976=fall(1:end,:);
sall=table2array(hazards(:,2+group:group+1+group));
sall_1976=sall(1:end,:);

for i=1:size(sall_1976,1)
s_ws_counter_1976(i,:) = sum(sall_1976(i,:).*weights1976,2);
end
s_ws_counter_1976(1,:)=hazards.s_act_ws(1,:);

for i=1:size(fall_1976,1)
f_ws_counter_1976(i,:) = sum(fall_1976(i,:).*weightf1976,2);
end
f_ws_counter_1976(1,:)=hazards.f_act_ws(1,:);

hazards_ss_1976 = cat(2,hazards(1:T,:), array2table(f_ws_counter_1976));
hazards_ss_1976 = cat(2,hazards_ss_1976, array2table(s_ws_counter_1976));

figure;
hold on
s_agg = plot(hazards_ss_1976.Date,hazards_ss_1976.s_act_ws,'LineWidth',1.5,'LineStyle','-','Color','k')
s_agg_ss = plot(hazards_ss_1976.Date,hazards_ss_1976.s_ws_counter_1976,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('age shift share quarterly sa inflow rate (s) 1976Q1')
legend([s_agg s_agg_ss], {'s agg','s agg ss'},'Location','northeast')
saveas(gcf,'../figure/left/hazards_age_s_sa_quart_ss_1976','epsc')

%close all

