clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
hazards = readtable('../csv/hazards_age_sa_quart.csv');

%% sa hazard rates figure by groups
figure;
hold on

f_agg = plot(hazards.Date,hazards.f_act_ws,'LineWidth',1.5,'LineStyle','-','Color','k')
shadenber(gcf)
hold off
title('Outflow rate (f)')
saveas(gcf,'../figure/right/hazards_f_sa_quart','epsc')

figure;
hold on
s_agg = plot(hazards.Date,hazards.s_act_ws,'LineWidth',1.5,'LineStyle','-','Color','k')
shadenber(gcf)
hold off
title('Inflow rate (s)')
saveas(gcf,'../figure/left/hazards_s_sa_quart','epsc')

%close all

