clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
UU = readtable('../../output/u_state_nsa.xlsx');
UU = table2array(UU);
date = UU(:,1)*100+01;
year = floor(UU(:,1)/100);
UU(:,1)=[];
[T,M] = size(UU);

for i=1:51
 U_sm(:,i) = UU(:,i);
end
for i=1:51
 U_m(:,i) =UU(:,i+51);
end
for i=1:51
 E_m(:,i) =UU(:,i+51*2);
end
for i=1:51
 N_m(:,i) =UU(:,i+51*3);
end

U_sm(217:end,:) = 1.16*U_sm(217:end,:);

U = U_m;
U_s = U_sm;
E = E_m;
N = N_m;

group = 51; % group size
% if 0 stock make it NaN
U(U==0)=NaN;
U_s(U_s==0)=NaN;
E(E==0)=NaN;
N(N==0)=NaN;

% no observation for some states in 1976 and 1977
date = date(25:end,:);
year = year(25:end,:);
U=U(25:end,:);
U_s=U_s(25:end,:);
E=E(25:end,:);
N=N(25:end,:);
T=length(date);

%% calculate aggregate unemployment rates
urate = U./(U+E);
urate = [date urate];
urate = array2table(urate);
ur_names = readtable('ur_names.xlsx');
urate.Properties.VariableNames = ur_names.Properties.VariableNames;
writetable(urate,'csv/urates_state.csv');

%% calculate hazard rates for each group
for i=1:group
 F = 1 - ((U(2:end,i)-U_s(2:end,i))./U(1:end-1,i));
 Fall(:,i) = F;
end

Fall(Fall >= 1) = NaN; % define Fall to be NaN if >=1 - this might be the case with monthly stocks
fall = -log(1 - Fall);
fall_nan=isnan(fall);
% change all NaN to some number to be able to use fsolve below
fall(fall_nan)=0.5;
U_nan=isnan(U);
U(U_nan)=0.5;
E_nan=isnan(E);
E(E_nan)=0.5;

opts = optimset('Display','off');
sall = ones(T-1,group);
s0   = 0.034;
for i=1:group
for t=1:T-1
    U_t = U(t,i);
    FU  = U(t+1,i);
    f_t = fall(t,i);
    Lf_t= U(t,i)+E(t,i);
    s(t) = fsolve('shimerall',s0,opts,U_t,FU,f_t,Lf_t);
    s0  = s(t);
end
sall(:,i) = s;
end

% change entries with NaN stocks back to be NaN
fall(fall_nan)=NaN;
sall(fall_nan)=NaN;
sall(U_nan(1:T-1,:))=NaN;
sall(U_nan(2:T,:))=NaN;
sall(E_nan(1:T-1,:))=NaN;

U(U_nan)=NaN;
E(E_nan)=NaN;

%% calculate aggregate hazard rates using total stocks
for t=1:T
    Utotal(t) = nansum(U(t,1:group));
    Ustotal(t) = nansum(U_s(t,1:group));
    Etotal(t) = nansum(E(t,1:group));
    Ntotal(t) = nansum(N(t,1:group));
    utotal(t) = Utotal(t)./(Utotal(t)+Etotal(t));
end

Ftotal = 1 - ((Utotal(2:end)-Ustotal(2:end))./Utotal(1:end-1));
ftotal = -log(1 - Ftotal);

opts = optimset('Display','off');
s0   = 0.034;
for t=1:T-1
    U_t = Utotal(t);
    FU  = Utotal(t+1);
    f_t = ftotal(t);
    Lf_t= Utotal(t)+Etotal(t);
    stotal(t) = fsolve('shimerall',s0,opts,U_t,FU,f_t,Lf_t);
    s0  = stotal(t);
end

%% calculate aggregate hazard rates using weighted sum of s and f
for i=1:group
weights(:,i) = (E(:,i)+N(:,i))./(Etotal'+Ntotal'); % s and f weight
weightf(:,i) = U(:,i)./Utotal';
popshare(:,i) = (E(:,i)+N(:,i)+U(:,i))./(Etotal'+Ntotal'+Utotal'); % population share
end

for i=1:T-1
stotal_ws(i,:) = nansum(sall(i,:).*weights(i,:),2);
end

for i=1:T-1
ftotal_ws(i,:) = nansum(fall(i,:).*weightf(i,:),2);
end

weight = [weights weightf popshare];

hazrate = [fall sall ftotal_ws stotal_ws ftotal' stotal'];

%% get monthly average for hazrate 1978-2018
[ay,~,cy] = unique(year,'rows');
[ay1,~,cy1] = unique(year(1:T-1),'rows');
urate(:,1)=[];
urate = table2array(urate);
urate_avg=zeros(length(ay),size(urate,2));
weight_avg=zeros(length(ay),size(weight,2));
hazrate_avg=zeros(length(ay),size(hazrate,2));
sall_avg=zeros(length(ay),size(sall,2));
fall_avg=zeros(length(ay),size(fall,2));
for i=1:size(urate,2)
urate_avg_m = [accumarray(cy,urate(:,i),[],@nanmean)];
urate_avg(:,i) = urate_avg_m;
end
for i=1:size(weight,2)
weight_avg_m = [accumarray(cy,weight(:,i),[],@nanmean)];
weight_avg(:,i) = weight_avg_m;
end
for i=1:size(hazrate,2)
hazrate_avg_m = [accumarray(cy1,hazrate(:,i),[],@nanmean)];
hazrate_avg(:,i) = hazrate_avg_m;
end
for i=1:size(sall,2)
sall_avg_m = [accumarray(cy1,sall(:,i),[],@nanmean)];
sall_avg(:,i) = sall_avg_m;
fall_avg_m = [accumarray(cy1,fall(:,i),[],@nanmean)];
fall_avg(:,i) = fall_avg_m;
end

date=ay;

urate=urate_avg;
weight=weight_avg;
hazrate=hazrate_avg;
sall=sall_avg;
fall=fall_avg;

weight = [date weight];
weight = array2table(weight);
weight_names = readtable('weight_names.xlsx');
weight.Properties.VariableNames = weight_names.Properties.VariableNames;
writetable(weight,'csv/weights_state.csv');

hazrate = [date hazrate];
hazrate = array2table(hazrate);
haz_names = readtable('haz_names.xlsx');
hazrate.Properties.VariableNames = haz_names.Properties.VariableNames;
writetable(hazrate,'csv/hazards_state.csv');



