clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
hazards = readtable('csv/hazards_sex_sa_quart.csv');
weights_nsa = readtable('csv/weights_sex_nsa_quart.csv');
weights = readtable('csv/weights_sex_sa_quart.csv');

%% quarterly sa hazard rates figure by groups
figure;
hold on
f_men = plot(hazards.Date,hazards.f_men,'LineWidth',1.5,'LineStyle','-','Color','k')
f_women = plot(hazards.Date,hazards.f_women,'LineWidth',1.5,'LineStyle','--','Color','k')
f_agg = plot(hazards.Date,hazards.f_act_ws,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('quarterly sa outflow rate (f) by gender')
legend([f_men f_women f_agg], {'f men','f women', 'f agg'},'Location','northeast')
saveas(gcf,'../../tex/figure/sex/hazards_sex_f_sa_quart','epsc')

figure;
hold on
s_men = plot(hazards.Date,hazards.s_men,'LineWidth',1.5,'LineStyle','-','Color','k')
s_women = plot(hazards.Date,hazards.s_women,'LineWidth',1.5,'LineStyle','--','Color','k')
s_agg = plot(hazards.Date,hazards.s_act_ws,'LineWidth',1.5,'LineStyle',':','Color','k')
shadenber(gcf)
hold off
title('quarterly sa inflow rate (s) by gender')
legend([s_men s_women s_agg], {'s men','s women', 's agg'},'Location','northeast')
saveas(gcf,'../../tex/figure/sex/hazards_sex_s_sa_quart','epsc')

close all

%% quarterly weights figure by groups

figure;
hold on
sw_men = plot(weights.Date,weights.sw_men,'LineWidth',1.5,'LineStyle','-','Color','k')
sw_women = plot(weights.Date,weights.sw_women,'LineWidth',1.5,'LineStyle','--','Color','k')
shadenber(gcf)
hold off
title('quarterly sa s weights by gender')
legend([sw_men sw_women], {'s weights men','s weights women'},'Location','northeast')
saveas(gcf,'../../tex/figure/sex/weights_sex_s_sa_quart','epsc') % quarterly sa

figure;
hold on
fw_men = plot(weights.Date,weights.fw_men,'LineWidth',1.5,'LineStyle','-','Color','k')
fw_women = plot(weights.Date,weights.fw_women,'LineWidth',1.5,'LineStyle','--','Color','k')
shadenber(gcf)
hold off
title('quarterly sa f weights by gender')
legend([fw_men fw_women], {'f weights men','f weights women'},'Location','northeast')
saveas(gcf,'../../tex/figure/sex/weights_sex_f_sa_quart','epsc') % quarterly sa

figure;
hold on
lfs_men = plot(weights.Date,weights.lfshare_men,'LineWidth',1.5,'LineStyle','-','Color','k')
lfs_women = plot(weights.Date,weights.lfshare_women,'LineWidth',1.5,'LineStyle','--','Color','k')
shadenber(gcf)
hold off
title('quarterly sa labor force share by gender')
legend([lfs_men lfs_women], {'lfs men','lfs women'},'Location','northeast')
saveas(gcf,'../../tex/figure/sex/lfshare_sex_sa_quart','epsc') % quarterly sa

close all