clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
hazards = readtable('csv/hazards_ind_sa_quart.csv');
weights_nsa = readtable('csv/weights_ind_nsa_quart.csv');
weights = readtable('csv/weights_ind_sa_quart.csv');

%% quarterly sa hazard rates figure by groups
figure;
hold on
f_agriculture = plot(hazards.date,hazards.frate_agriculture,'LineWidth',1.5)
f_mining = plot(hazards.date,hazards.frate_mining,'LineWidth',1.5)
f_construction = plot(hazards.date,hazards.frate_construction,'LineWidth',1.5)
f_manufacturing = plot(hazards.date,hazards.frate_manufacturing,'LineWidth',1.5)
f_wholesaleretail = plot(hazards.date,hazards.frate_wholesaleretail,'LineWidth',1.5)
f_transportation = plot(hazards.date,hazards.frate_transportationutilities,'LineWidth',1.5)
f_financial = plot(hazards.date,hazards.frate_financialactivities,'LineWidth',1.5)
f_other = plot(hazards.date,hazards.frate_other,'LineWidth',1.5)
f_agg = plot(hazards.date,hazards.f_act_ws,'LineWidth',1.5)
shadenber(gcf)
hold off
title('quarterly sa outflow rate (f) by industry')
legend([f_agriculture f_mining f_construction f_manufacturing f_wholesaleretail f_transportation f_financial f_other f_agg], {'f agriculture' 'f mining' 'f construction' 'f manufacturing' 'f wholesaleretail' 'f transportation' 'f financial' 'f other' 'f agg'},'Location','northeast')
saveas(gcf,'../../tex/figure/ind/hazards_ind_f_sa_quart','epsc')

figure;
hold on
s_agriculture = plot(hazards.date,hazards.srate_agriculture,'LineWidth',1.5)
s_mining = plot(hazards.date,hazards.srate_mining,'LineWidth',1.5)
s_construction = plot(hazards.date,hazards.srate_construction,'LineWidth',1.5)
s_manufacturing = plot(hazards.date,hazards.srate_manufacturing,'LineWidth',1.5)
s_wholesaleretail = plot(hazards.date,hazards.srate_wholesaleretail,'LineWidth',1.5)
s_transportation = plot(hazards.date,hazards.srate_transportationutilities,'LineWidth',1.5)
s_financial = plot(hazards.date,hazards.srate_financialactivities,'LineWidth',1.5)
s_other = plot(hazards.date,hazards.srate_other,'LineWidth',1.5)
s_agg = plot(hazards.date,hazards.s_act_ws,'LineWidth',1.5)
shadenber(gcf)
hold off
title('quarterly sa inflow rate (s) by industry')
legend([s_agriculture s_mining s_construction s_manufacturing s_wholesaleretail s_transportation s_financial s_other s_agg], {'s agriculture' 's mining' 's construction' 's manufacturing' 's wholesaleretail' 's transportation' 's financial' 's other' 's agg'},'Location','northeast')
saveas(gcf,'../../tex/figure/ind/hazards_ind_s_sa_quart','epsc')

close all

%% quarterly weights figure by groups

figure;
hold on
sw_agriculture = plot(weights.date,weights.sw_agriculture,'LineWidth',1.5)
sw_mining = plot(weights.date,weights.sw_mining,'LineWidth',1.5)
sw_construction = plot(weights.date,weights.sw_construction,'LineWidth',1.5)
sw_manufacturing = plot(weights.date,weights.sw_manufacturing,'LineWidth',1.5)
sw_wholesaleretail = plot(weights.date,weights.sw_wholesaleretail,'LineWidth',1.5)
sw_transportation = plot(weights.date,weights.sw_transportationutilities,'LineWidth',1.5)
sw_financial = plot(weights.date,weights.sw_financialactivities,'LineWidth',1.5)
sw_other = plot(weights.date,weights.sw_other,'LineWidth',1.5)
shadenber(gcf)
hold off
title('quarterly sa s weights by industry')
legend([sw_agriculture sw_mining sw_construction sw_manufacturing sw_wholesaleretail sw_transportation sw_financial sw_other], {'sw agriculture' 'sw mining' 'sw construction' 'sw manufacturing' 'sw wholesaleretail' 'sw transportation' 'sw financial' 'sw other'},'Location','northeast')
saveas(gcf,'../../tex/figure/ind/weights_ind_s_sa_quart','epsc') % quarterly sa

figure;
hold on
fw_agriculture = plot(weights.date,weights.fw_agriculture,'LineWidth',1.5)
fw_mining = plot(weights.date,weights.fw_mining,'LineWidth',1.5)
fw_construction = plot(weights.date,weights.fw_construction,'LineWidth',1.5)
fw_manufacturing = plot(weights.date,weights.fw_manufacturing,'LineWidth',1.5)
fw_wholesaleretail = plot(weights.date,weights.fw_wholesaleretail,'LineWidth',1.5)
fw_transportation = plot(weights.date,weights.fw_transportationutilities,'LineWidth',1.5)
fw_financial = plot(weights.date,weights.fw_financialactivities,'LineWidth',1.5)
fw_other = plot(weights.date,weights.fw_other,'LineWidth',1.5)
shadenber(gcf)
hold off
title('quarterly sa f weights by industry')
legend([fw_agriculture fw_mining fw_construction fw_manufacturing fw_wholesaleretail fw_transportation fw_financial fw_other], {'fw agriculture' 'fw mining' 'fw construction' 'fw manufacturing' 'fw wholesaleretail' 'fw transportation' 'fw financial' 'fw other'},'Location','northeast')
saveas(gcf,'../../tex/figure/ind/weights_ind_f_sa_quart','epsc') % quarterly sa

close all