clear all;
plotflag = 0;
warning off all

if(~isdeployed)
  cd(fileparts(which(mfilename)));
end % cd to current folder

%% load in data
UU = readtable('../../output/u_sexage_nsa.xlsx');
UU = table2array(UU);
date = UU(:,1)*100+01;
UU(:,1)=[];
[T,M] = size(UU);

for i=1:14
 U_sm(:,i) = UU(:,i);
end
for i=1:14
 U_m(:,i) =UU(:,i+14);
end
for i=1:14
 E_m(:,i) =UU(:,i+28);
end
for i=1:14
 N_m(:,i) =UU(:,i+42);
end

U(:,1) = U_m(:,1)+U_m(:,2)+U_m(:,8)+U_m(:,9);
U(:,2) = U_m(:,3)+U_m(:,4)+U_m(:,5)+U_m(:,10)+U_m(:,11)+U_m(:,12);
U(:,3) = U_m(:,6)+U_m(:,7)+U_m(:,13)+U_m(:,14);

U_s(:,1) = U_sm(:,1)+U_sm(:,2)+U_sm(:,8)+U_sm(:,9);
U_s(:,2) = U_sm(:,3)+U_sm(:,4)+U_sm(:,5)+U_sm(:,10)+U_sm(:,11)+U_sm(:,12);
U_s(:,3) = U_sm(:,6)+U_sm(:,7)+U_sm(:,13)+U_sm(:,14);

E(:,1) = E_m(:,1)+E_m(:,2)+E_m(:,8)+E_m(:,9);
E(:,2) = E_m(:,3)+E_m(:,4)+E_m(:,5)+E_m(:,10)+E_m(:,11)+E_m(:,12);
E(:,3) = E_m(:,6)+E_m(:,7)+E_m(:,13)+E_m(:,14);

N(:,1) = N_m(:,1)+N_m(:,2)+N_m(:,8)+N_m(:,9);
N(:,2) = N_m(:,3)+N_m(:,4)+N_m(:,5)+N_m(:,10)+N_m(:,11)+N_m(:,12);
N(:,3) = N_m(:,6)+N_m(:,7)+N_m(:,13)+N_m(:,14);

U_s(217:T,1) = 1.175108*U_s(217:T,1);
U_s(217:T,2) = 1.140705*U_s(217:T,2);
U_s(217:T,3) = 1.124858*U_s(217:T,3);

U(217:T,3) = (1/1.121)*U(217:T,3);

group = 3; % group size

%% calculate aggregate unemployment rates
urate = U./(U+E);
urate = [date urate];
urate = array2table(urate);
urate.Properties.VariableNames = {'Date' 'ur16to24' 'ur25to54' 'ur55plus'};
writetable(urate,'csv/urates_age.csv');

%% calculate hazard rates for each group
for i=1:group
 F = 1 - ((U(2:end,i)-U_s(2:end,i))./U(1:end-1,i));
 Fall(:,i) = F;
end
fall = -log(1 - Fall);

opts = optimset('Display','off');
sall = ones(T-1,2);
s0   = 0.034;
for i=1:group
for t=1:T-1
    U_t = U(t,i);
    FU  = U(t+1,i);
    f_t = fall(t,i);
    Lf_t= U(t,i)+E(t,i);
    s(t) = fsolve('shimerall',s0,opts,U_t,FU,f_t,Lf_t);
    s0  = s(t);
end
sall(:,i) = s;
end

%% calculate aggregate hazard rates using total stocks
for t=1:T
    Utotal(t) = sum(U(t,1:group));
    Ustotal(t) = sum(U_s(t,1:group));
    Etotal(t) = sum(E(t,1:group));
    Ntotal(t) = sum(N(t,1:group));
    utotal(t) = Utotal(t)./(Utotal(t)+Etotal(t));
end

Ftotal = 1 - ((Utotal(2:end)-Ustotal(2:end))./Utotal(1:end-1));
ftotal = -log(1 - Ftotal);

opts = optimset('Display','off');
s0   = 0.034;
for t=1:T-1
    U_t = Utotal(t);
    FU  = Utotal(t+1);
    f_t = ftotal(t);
    Lf_t= Utotal(t)+Etotal(t);
    stotal(t) = fsolve('shimerall',s0,opts,U_t,FU,f_t,Lf_t);
    s0  = stotal(t);
end

%% calculate aggregate hazard rates using weighted sum of s and f
for i=1:group
weights(:,i) = (E(:,i)+N(:,i))./(Etotal'+Ntotal'); % s and f weight
weightf(:,i) = U(:,i)./Utotal';
popshare(:,i) = (E(:,i)+N(:,i)+U(:,i))./(Etotal'+Ntotal'+Utotal'); % population share
lfshare(:,i) = (E(:,i)+U(:,i))./(Etotal'+Utotal'); % labor force share
end

for i=1:T-1
stotal_ws(i,:) = sum(sall(i,:).*weights(i,:),2);
end

for i=1:T-1
ftotal_ws(i,:) = sum(fall(i,:).*weightf(i,:),2);
end

weight = [date weights weightf lfshare popshare];
weight = array2table(weight);
weight.Properties.VariableNames = {'Date' 'sw_16to24' 'sw_25to54' 'sw_55plus' 'fw_16to24' 'fw_25to54' 'fw_55plus' 'lfshare_16to24' 'lfshare_25to54' 'lfshare_55plus' 'popshare_16to24' 'popshare_25to54' 'popshare_55plus'};
writetable(weight,'csv/weights_age.csv');

hazrate = [date(1:T-1,:) fall sall ftotal_ws stotal_ws ftotal' stotal'];
hazrate = array2table(hazrate);
hazrate.Properties.VariableNames = {'Date' 'f16to24' 'f25to54' 'f55plus' 's16to24' 's25to54' 's55plus'...
    'f_act_ws' 's_act_ws' 'f_act_total' 's_act_total'};
writetable(hazrate,'csv/hazards_age.csv');