clear all;

dataDir =  '../input/';
%graphsDir = '../Drafts/figuresdraft';

[dataRaw,stringsRaw,~] = xlsread([dataDir, 'shiftShareJDRateByFirmAge.xlsx']);

for i = 1:numel(stringsRaw), eval([stringsRaw{i}, ' = dataRaw(:,', num2str(i), ');']); end

allJD = job_destruction_rate1to5.*emp1to5Share/100+job_destruction_rate6to10.*emp6to10Share/100+...
    job_destruction_rate11plus.*emp11plusShare/100;

shiftShareJD = job_destruction_rate1to5*emp1to5Share(1)/100+job_destruction_rate6to10*emp6to10Share(1)/100+...
    job_destruction_rate11plus*emp11plusShare(1)/100;


dates = datenum(year,12,31);

figName = figure;
plot(dates,allJD, '-k')
hold on
plot(dates,shiftShareJD, '--k')
recessionplot
datetick('x','yyyy','keepticks')
legend('Overall', '1987 Fixed Weights')

%print(figName, '-dpdf', [graphsDir, filesep, 'shiftShareBDS.pdf']);
%close all;
