
clear all
graph drop _all

import delim "../flows/findhaz/sexage/csv/weights_sexage_sa_quart.csv", delimiters(",")
save temp/tmpSep, replace
clear

import delim "../flows/findhaz/sexage/csv/hazards_sexage_sa_quart.csv", delimiters(",")
merge 1:1 date using temp/tmpSep, nogen

gen year = floor(date)
gen qtr = 4*(date-year)+1
gen dateyq = yq(year,qtr)
format dateyq %tq
drop date year qtr
order dateyq
tsset dateyq

foreach var in m16to24 m25to54 m55plus f16to24 f25to54 f55plus {
	gen prods_`var' = s_`var'*sw_`var'
	gen prodf_`var' = f_`var'*fw_`var'
	
	gen ks`var' = .
	qui summ sw_`var' if year(dofq(dateyq))==1976
	replace ks`var' = `r(mean)' if !missing(sw_`var')
	gen prods_1976_`var' = s_`var'*ks`var'
	
	gen kf`var' = .
	qui summ fw_`var' if year(dofq(dateyq))==1976
	replace kf`var' = `r(mean)' if !missing(sw_`var')
	gen prodf_1976_`var' = f_`var'*kf`var'
		
}


tsline prods_m* , name("Men_Product") tline(1976q4 1996q4, lcolor(gray)) title("Product (Men)")
graph export output/productM.png, replace
tsline prods_f*, name("Women_Product") tline(1976q4 1996q4, lcolor(gray)) title("Product (Women)")
graph export output/productF.png, replace

tsline prods_1976_m* , name("Men_Product_Fixed") tline(1976q4 1996q4, lcolor(gray)) title("Product (Men) FIXED WEIGHTS at 1976 AVERAGE")
graph export output/productMfixed.png, replace
tsline prods_1976_f*, name("Women_Product_Fixed") tline(1976q4 1996q4, lcolor(gray)) title("Product (Women) FIXED WEIGHTS at 1976 AVERAGE")
graph export output/productFfixed.png, replace

tsline sw_m* , name("Men_Weights") tline(1976q4 1996q4, lcolor(gray)) title("Weights (Men)")
graph export output/weightsM.png, replace
tsline sw_f*, name("Women_Weights") tline(1976q4 1996q4, lcolor(gray)) title("Weights (Women)")
graph export output/weightsF.png, replace

tsline s_m* , name("Men_s") tline(1976q4 1996q4, lcolor(gray)) title("Separation (Men)")
graph export output/sM.png, replace
tsline s_f*, name("Women_s") tline(1976q4 1996q4, lcolor(gray)) title("Separation (Women)")
graph export output/sF.png, replace




putpdf begin, landscape
putpdf paragraph
putpdf image output/productM.png
putpdf paragraph
putpdf image output/productF.png
putpdf paragraph
putpdf image output/weightsM.png
putpdf paragraph
putpdf image output/weightsF.png
putpdf paragraph
putpdf image output/sM.png
putpdf paragraph
putpdf image output/sF.png
putpdf paragraph
putpdf image output/productMfixed.png
putpdf paragraph
putpdf image output/productFfixed.png


graph close _all

rename s_act_total s_total
rename f_act_total f_total

gen ind1976 = 0
replace ind1976 = 1 if year(dofq(dateyq))==1976
gen ind1996 = 0
replace ind1996 = 1 if year(dofq(dateyq))==1996
gen ind2018 = 0
replace ind2018 = 1 if year(dofq(dateyq))==2018

putpdf sectionbreak
putpdf paragraph
putpdf text ("Changes in Separation Rates over Sub-periods"), linebreak bold
putpdf text ("Note: Rates have been multiplied by 100"), linebreak italic
putpdf text (" "), linebreak

foreach var in s_total prods_m16to24 prods_m25to54 prods_m55plus prods_f16to24 prods_f25to54 prods_f55plus {
	
	qui summ `var' if ind1976
	local k1976 = `r(mean)'
	
	qui summ `var' if ind1996
	local k1996 = `r(mean)'
	
	qui summ `var' if ind2018
	local k2018 = `r(mean)'

	local k2018_1976 = int(10000*(`k2018' - `k1976'))/100
	local k1996_1976 = int(10000*(`k1996' - `k1976'))/100
	local k2018_1996 = int(10000*(`k2018' - `k1996'))/100
	
	putpdf text ("Variable: `var' "), linebreak underline 
	putpdf text ("Change over 1976-1996: `k1996_1976'"), linebreak font("", "", red)
	putpdf text ("Change over 1996-2018: `k2018_1996'"), linebreak font("", "", blue)
	putpdf text ("Change over 1976-2018: `k2018_1976'"), linebreak font("", "", green)
	putpdf text (" "), linebreak
	
}

putpdf sectionbreak
putpdf paragraph
putpdf text ("Changes in Separation Rates over Sub-periods FIXED WEIGHTS at 1976 AVERAGE"), linebreak bold
putpdf text ("Note: Rates have been multiplied by 100"), linebreak italic
putpdf text (" "), linebreak

foreach var in prods_1976_m16to24 prods_1976_m25to54 prods_1976_m55plus prods_1976_f16to24 prods_1976_f25to54 prods_1976_f55plus {
	
	qui summ `var' if ind1976
	local k1976 = `r(mean)'
	
	qui summ `var' if ind1996
	local k1996 = `r(mean)'
	
	qui summ `var' if ind2018
	local k2018 = `r(mean)'

	local k2018_1976 = int(10000*(`k2018' - `k1976'))/100
	local k1996_1976 = int(10000*(`k1996' - `k1976'))/100
	local k2018_1996 = int(10000*(`k2018' - `k1996'))/100
	
	putpdf text ("Variable: `var' "), linebreak underline 
	putpdf text ("Change over 1976-1996: `k1996_1976'"), linebreak font("", "", red)
	putpdf text ("Change over 1996-2018: `k2018_1996'"), linebreak font("", "", blue)
	putpdf text ("Change over 1976-2018: `k2018_1976'"), linebreak font("", "", green)
	putpdf text (" "), linebreak
	
}


putpdf pagebreak
putpdf paragraph
putpdf text ("Changes in Job-Finding Rates over Sub-periods"), linebreak bold
putpdf text ("Note: Rates have been multiplied by 100"), linebreak italic
putpdf text (" "), linebreak


foreach var in f_total prodf_m16to24 prodf_m25to54 prodf_m55plus prodf_f16to24 prodf_f25to54 prodf_f55plus {
	
	qui summ `var' if ind1976
	local k1976 = `r(mean)'
	
	qui summ `var' if ind1996
	local k1996 = `r(mean)'
	
	qui summ `var' if ind2018
	local k2018 = `r(mean)'

	local k2018_1976 = int(10000*(`k2018' - `k1976'))/100
	local k1996_1976 = int(10000*(`k1996' - `k1976'))/100
	local k2018_1996 = int(10000*(`k2018' - `k1996'))/100
	
	putpdf text ("Variable: `var' "), linebreak underline 
	putpdf text ("Change over 1976-1996: `k1996_1976'"), linebreak font("", "", red)
	putpdf text ("Change over 1996-2018: `k2018_1996'"), linebreak font("", "", blue)
	putpdf text ("Change over 1976-2018: `k2018_1976'"), linebreak font("", "", green)
	putpdf text (" "), linebreak
	
}

putpdf save output/separationRatesBySexAge.pdf, replace
