clear all
macro drop _all
set more off

local infile_sf 	= "../Flows/findhaz/ind/csv/hazards_ind_sa.csv"
local infile_jd 	= "input/jobFlowRates.dta"
local infile_3state = "input/industry_3stateFlows_fromEorU.dta"
local outfile = "output/davis2010_replicate.dta"

local makeData 						= 1
local makeRegressions_1992to2018 	= 1
local makeRegressions_1992to2005 	= 1
local makeGraphs					= 1

if `makeData'==1 {
	// import s&f data
	import delimited using `infile_sf', delimiters(",") clear
	drop *_total *_ws 
	reshape long srate_ frate_, i(date) j(group) string
	gen sector = .
	replace sector = 1 if group == "agriculture"
	replace sector = 2 if group == "mining"
	replace sector = 3 if group == "construction"
	replace sector = 4 if group == "manufacturing"
	replace sector = 5 if group == "wholesaleretail"
	replace sector = 6 if group == "transportationutilities"
	replace sector = 7 if group == "financialactivities"
	replace sector = 8 if group == "other"

	// aggregate sa monthly to quarterly level
	tostring(date), replace
	gen year = substr(date,1,4)
	gen month = substr(date,5,2)
	destring(month), replace
	gen quarter = ""
	replace quarter = "1" if month <= 3
	replace quarter = "2" if month >= 4 & month <= 6
	replace quarter = "3" if month >= 7 & month <= 9
	replace quarter = "4" if month >= 10
	drop date
	gen yq_str = year + "Q" + quarter 
	gen yq = quarterly(yq_str, "YQ")
	destring(year), replace
	destring(quarter), replace
	collapse (mean) frate_* srate_*, by(yq year quarter sector)

	// merge with job flow (destruction) data, clean and save
	merge 1:1 year quarter sector using `infile_jd', nogenerate keep(match)
	rename srate_ srate
	rename frate_ frate
	replace srate = 100 * srate
	replace frate = 100 * frate
	save `outfile', replace
	
	use `infile_3state', clear
	rename ind8_grp sector
	gen ym = ym(year,month)
	xtset sector ym
	foreach var of varlist flow* {
		gen `var'_lag = L.`var'
	}
	egen stocke = rowtotal(flowe*_lag), missing
	egen stocku = rowtotal(flowu*_lag), missing
	gen quarter = ceil(month/3)
	collapse (mean) flow* stock*, by(year quarter sector)
	// create gransition probabilities
	foreach x in e n u {
		gen p_e`x' = 100*flowe`x'/stocke
		gen p_u`x' = 100*flowu`x'/stocku
	}
	keep year quarter sector p_*
	merge 1:1 year quarter sector using `outfile', nogenerate keep(match)
	gen t = .
	replace t = 1 if year>=1993 & year<=1995
	replace t = 2 if year>=1996 & year<=1998
	replace t = 3 if year>=1999 & year<=2001
	replace t = 3 if year>=2002 & year<=2004
	replace t = 4 if year>=2005 & year<=2007
	replace t = 5 if year>=2008 & year<=2010
	replace t = 6 if year>=2011 & year<=2012
	replace t = 7 if year>=2013 & year<=2015
	replace t = 8 if year>=2016 & year<=2018
	drop if sector==2 // NO MINING
	save `outfile', replace
}

if `makeRegressions_1992to2018'==1 {
	
	use `outfile', clear
		
	// 1) * Quarterly * 
	
	// 2-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_srate_quarterly_1992to2018.tex"
	reg srate jd i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Quarterly data from 1992:Q3-2018:Q1.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg srate jd_cont i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg srate jd_deaths i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg srate jr i.yq i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// table 4 replication
	local table_frag="output/replicate_table4_frate_quarterly_1992to2018.tex"
	reg frate jd i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Quarterly data from 1992:Q3-2018:Q1.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg frate jd_cont i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg frate jd_deaths i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg frate jr i.yq i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// 3-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_eurate_quarterly_1992to2018.tex"
	reg p_eu jd i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Quarterly data from 1992:Q3-2018:Q1.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_eu jd_cont i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_eu jd_deaths i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_eu jr i.yq i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// table 4 replication
	local table_frag="output/replicate_table4_uerate_quarterly_1992to2018.tex"
	reg p_ue jd i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Quarterly data from 1992:Q3-2018:Q1.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_ue jd_cont i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_ue jd_deaths i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_ue jr i.yq i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	
	**********************************************************************
	
	
	// 2) * Annual *   
	collapse (mean) srate frate p_eu p_ue jd* jr, by(year sector)
	
	// 2-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_srate_annual_1992to2018.tex"
	reg srate jd i.year i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Annual data from 1992-2018.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg srate jd_cont i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg srate jd_deaths i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg srate jr i.year i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// Table 4 Replication
	local table_frag="output/replicate_table4_frate_annual_1992to2018.tex"
	reg frate jd i.year i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Annual data from 1992-2018.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg frate jd_cont i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg frate jd_deaths i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg frate jr i.year i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// 3-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_eurate_annual_1992to2018.tex"
	reg p_eu jd i.year i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Annual data from 1992-2018.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_eu jd_cont i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_eu jd_deaths i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_eu jr i.year i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// Table 4 Replication
	local table_frag="output/replicate_table4_uerate_annual_1992to2018.tex"
	reg p_ue jd i.year i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Annual data from 1992-2018.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_ue jd_cont i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_ue jd_deaths i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_ue jr i.year i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	**********************************************************************
	
	
	// 3) * 3yr-Period *  
	use `outfile', clear
	collapse (mean) srate frate p_eu p_ue jd* jr, by(t sector)

	// 2-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_srate_3yr_1993to2018.tex"
	reg srate jd i.t i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Data in 3-yr periods from 1993-2018.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg srate jd_cont i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg srate jd_deaths i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg srate jr i.t i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// Table 4 Replication
	local table_frag="output/replicate_table4_frate_3yr_1993to2018.tex"
	reg frate jd i.t i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Data in 3-yr periods from 1993-2018.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg frate jd_cont i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg frate jd_deaths i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg frate jr i.t i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// 3-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_eurate_3yr_1993to2018.tex"
	reg p_eu jd i.t i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Data in 3-yr periods from 1993-2018.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_eu jd_cont i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_eu jd_deaths i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_eu jr i.t i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// Table 4 Replication
	local table_frag="output/replicate_table4_uerate_3yr_1993to2018.tex"
	reg p_ue jd i.t i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Data in 3-yr periods from 1993-2018.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_ue jd_cont i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_ue jd_deaths i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_ue jr i.t i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
}

if `makeRegressions_1992to2005'==1 {
	
	use `outfile', clear
	keep if year <=2005	
	// 1) * Quarterly * 
	
	// 2-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_srate_quarterly_1992to2005.tex"
	reg srate jd i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Quarterly data from 1992:Q3-2005:Q4.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg srate jd_cont i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg srate jd_deaths i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg srate jr i.yq i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// table 4 replication
	local table_frag="output/replicate_table4_frate_quarterly_1992to2005.tex"
	reg frate jd i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Quarterly data from 1992:Q3-2005:Q4.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg frate jd_cont i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg frate jd_deaths i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg frate jr i.yq i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// 3-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_eurate_quarterly_1992to2005.tex"
	reg p_eu jd i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Quarterly data from 1992:Q3-2005:Q4.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_eu jd_cont i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_eu jd_deaths i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_eu jr i.yq i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// table 4 replication
	local table_frag="output/replicate_table4_uerate_quarterly_1992to2005.tex"
	reg p_ue jd i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Quarterly data from 1992:Q3-2005:Q4.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_ue jd_cont i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_ue jd_deaths i.yq i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_ue jr i.yq i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	
	**********************************************************************
	
	
	// 2) * Annual *   
	collapse (mean) srate frate p_eu p_ue jd* jr, by(year sector)
	
	// 2-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_srate_annual_1992to2005.tex"
	reg srate jd i.year i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Annual data from 1992-2005.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg srate jd_cont i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg srate jd_deaths i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg srate jr i.year i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// Table 4 Replication
	local table_frag="output/replicate_table4_frate_annual_1992to2005.tex"
	reg frate jd i.year i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Annual data from 1992-2005.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg frate jd_cont i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg frate jd_deaths i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg frate jr i.year i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// 3-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_eurate_annual_1992to2005.tex"
	reg p_eu jd i.year i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Annual data from 1992-2005.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_eu jd_cont i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_eu jd_deaths i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_eu jr i.year i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append

	// Table 4 Replication
	local table_frag="output/replicate_table4_uerate_annual_1992to2005.tex"
	reg p_ue jd i.year i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Annual data from 1992-2005.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_ue jd_cont i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_ue jd_deaths i.year i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_ue jr i.year i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	
	// 3) * 3yr-Period *  
	use `outfile', clear
	collapse (mean) srate frate p_eu p_ue jd* jr, by(t sector)

	// 2-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_srate_3yr_1993to2005.tex"
	reg srate jd i.t i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Data in 3-yr periods from 1993-2005.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg srate jd_cont i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg srate jd_deaths i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg srate jr i.t i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// Table 4 Replication
	local table_frag="output/replicate_table4_frate_3yr_1993to2005.tex"
	reg frate jd i.t i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Data in 3-yr periods from 1993-2005.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg frate jd_cont i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg frate jd_deaths i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg frate jr i.t i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// 3-state flows
	
	// table 3 replication
	local table_frag="output/replicate_table3_eurate_3yr_1993to2005.tex"
	reg p_eu jd i.t i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Data in 3-yr periods from 1993-2005.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_eu jd_cont i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_eu jd_deaths i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_eu jr i.t i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
	
	// Table 4 Replication
	local table_frag="output/replicate_table4_uerate_3yr_1993to2005.tex"
	reg p_ue jd i.t i.sector, robust
	outreg2 using `table_frag', keep(jd) nocons tex(frag) ctitle("") replace ///
		addnote("Replication of Davis et al. (2010).", ///
		"Data in 3-yr periods from 1993-2005.", ///
		"Includes time and sector fixed effects, with seven industry sectors.")
	reg p_ue jd_cont i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_cont) nocons tex(frag) ctitle("") append
	reg p_ue jd_deaths i.t i.sector, robust
	outreg2 using `table_frag', keep(jd_deaths) nocons tex(frag) ctitle("") append
	reg p_ue jr i.t i.sector, robust
	outreg2 using `table_frag', keep(jr) nocons tex(frag) ctitle("") append
}


if `makeGraphs'==1 {
	set scheme s1color
	set graphics on
	use `outfile', clear
	graph twoway scatter srate jd, mcolor("black") ytitle("s-rate")
	graph export "output/srate_jd_indScatter.png", replace width("2000")
	graph twoway scatter frate jd, mcolor("black") ytitle("f-rate")
	graph export "output/frate_jd_indScatter.png", replace width("2000")
}
