clear

/* ************************************************************
   This code replicates the last 4 columns of Table 5;
   Citation: Crump, Eusepi, Giannoni, and Sahin (2019)
*  ***********************************************************/

/* ******************************
*	Load inflow data by state
*  *****************************/

import delimited using "../flows/findhaz/agestate/csv/hazards_agestate.csv"
destring srate_* frate_*, replace ignore("NaN")
keep date srate*


reshape long srate_ frate_, i(date) j(stateage) string
gen pcode = substr(stateage,1,2)
replace pcode = upper(pcode)
gen age = substr(stateage,4,.)
rename date year
drop stateage
save temp/tmpStateSepRateByAgeVersusAging, replace

* Population shares

/*
import delimited "Data/us.1969_2016.19ages.adjusted.txt", delimiters("") clear

gen year = substr(v1,1,4)
gen pcode = substr(v1,5,2)
gen stateFIPS = substr(v1,7,2)
gen countyFIPS = substr(v1,9,3)
gen reg = substr(v1,12,2)
gen race = substr(v1,14,1)
gen origin = substr(v1,15,1)
gen sex = substr(v1,16,1)
gen age = substr(v1,17,2)
gen pop = substr(v1,19,8)

keep year pop age sex pcode stateFIPS

destring year pop age sex stateFIPS, replace force

save input/us.1969_2016.19ages.adjusted.dta, replace

*/

use input/us.1969_2016.19ages.adjusted.dta, clear

collapse (sum) pop, by(pcode age year)

/*
    00 = 0 years
    01 = 1-4 years
    02 = 5-9 years
    03 = 10-14 years
    04 = 15-19 years
	05 = 20-24
	06 = 25-29
	07 = 30-34
	08 = 35-39
	09 = 40-44
	10 = 45-49
	11 = 50-54
	12 = 55-59
	13 = 60-64
	14 = 65-69
	15 = 70-74
	16 = 75-79
    17 = 80-84 years
    18 = 85+ years
	
*/

gen ind0 = 0
replace ind0 = 1 if age == 0
gen ind1to4 = 0 
replace ind1to4 = 1 if age == 1
gen ind5to9 = 0 
replace ind5to9 = 1 if age == 2
gen pop0 = pop*ind0
gen pop1to4 = pop*ind1to4
gen pop5to9 = pop*ind5to9

forvalues i = 10(5)70 {
	local j = `i' + 4
	local k = `i'/5+1
	gen ind`i'to`j' = 0
	replace ind`i'to`j' = 1 if age == `k'
	gen pop`i'to`j' = pop*ind`i'to`j'
}	

gen pop15to64 = pop15to19+pop20to24+pop25to29+pop30to34+pop35to39+pop40to44+pop45to49+pop50to54+pop55to59+pop60to64
gen pop15to24 = pop15to19+pop20to24
gen pop1to44 = pop1to4+pop5to9+pop10to14+pop15to19+pop20to24+pop25to29+pop30to34+pop35to39+pop40to44

collapse (sum) pop* , by(pcode year)

merge 1:m year pcode using temp/tmpStateSepRateByAgeVersusAging, nogen

encode pcode, generate(pcodeNumber)
encode age, generate(ageNumber)

format year %ty

drop if inlist(year,2017,2018)
*drop if inrange(year,1969,1977)

egen stateage = group(pcode age)
drop if missing(stateage)

xtset stateage year

gen popShare15to24_15to64 = pop15to24/pop15to64
gen adj5popShare0to4_0to44 = (5*pop0+pop1to4)/(5*pop0+pop1to44)

gen ind = 1
replace ind = 0 if inlist(pcode,"DC")


/* ******************************
*	Run Long Diff. Regressions
*  *****************************/

bysort pcode age (year): gen s20srateAlt2 = ((srate_[_n] - srate_[_n-19])+(srate_[_n-1] - srate_[_n-19-1])+(srate_[_n-2] - srate_[_n-19-2])+(srate_[_n-3] - srate_[_n-19-3])+(srate_[_n-4] - srate_[_n-19-4]))/5
bysort pcode age (year): gen s20popShare15to24_15to64Alt2 = popShare15to24_15to64[_n-3] - popShare15to24_15to64[_n-23]
bysort pcode age (year): gen ests20popShare15to24_15to64Alt2 = adj5popShare0to4_0to44[_n-23] - popShare15to24_15to64[_n-23]

reg s20srateAlt2 s20popShare15to24_15to64Alt2 i.ageNumber if year==2001 & ind, rob

* Generate age dummies
gen ind16to24 = 0
replace ind16to24 = 1 if age=="16to24"
gen ind25to55 = 0
replace ind25to55 = 1 if age=="25to55"

condivreg s20srateAlt2 ind16to24 ind25to55 (s20popShare15to24_15to64Alt2=ests20popShare15to24_15to64Alt2) if year==2001 & ind, ar level(90)

reg s20srateAlt2 s20popShare15to24_15to64Alt2 if year==2001 & age=="16to24" & ind, rob
condivreg s20srateAlt2 (s20popShare15to24_15to64Alt2=ests20popShare15to24_15to64Alt2) if year==2001 & age=="16to24" & ind, ar level(90)
reg s20srateAlt2 s20popShare15to24_15to64Alt2 if year==2001 & age=="25to55" & ind, rob
condivreg s20srateAlt2 (s20popShare15to24_15to64Alt2=ests20popShare15to24_15to64Alt2) if year==2001 & age=="25to55" & ind, ar level(90)
reg s20srateAlt2 s20popShare15to24_15to64Alt2 if year==2001 & age=="55plus" & ind, rob
condivreg s20srateAlt2 (s20popShare15to24_15to64Alt2=ests20popShare15to24_15to64Alt2) if year==2001 & age=="55plus" & ind, ar level(90)


