clear

/* ************************************************************
   This code replicates the first column of Table 6; data 
   are downloaded from the Business Dynamics Statistics (BDS)
   available on the Census website.
   Citation: Crump, Eusepi, Giannoni, and Sahin (2019)
*  ***********************************************************/

/* -----------------------------
	Load BDS data by state/age
   ----------------------------- */

import delim "input/bds_f_agest_release.csv", delimiters(",") clear
* Generate employment at startups/older firms
gen ind0 = 0
replace ind0 = 1 if fage4 == "a) 0"
gen ind11plus = 0
replace ind11plus = 1 if inlist(fage4,"h) 11 to 15","i) 16 to 20","j) 21 to 25","k) 26+","l) Left Censored")
gen emp11plus = emp*ind11plus
gen emp0 = emp*ind0
* Collapse to year/state level
collapse (sum) emp*, by(year state) 
gen emp11plusShare = 100*emp11plus/emp
gen emp0Share = 100*emp0/emp
* Merge to FIPS
merge m:1 state using input/stateBDStoFIPS, nogen
save temp/tmpStateJDRateVersusFirmAging, replace

/* -----------------------------
	Load BDS data by state
   ----------------------------- */
   
import delim "input/bds_f_st_release.csv", delimiters(",") clear
keep state year job_destruction_rate job_destruction_rate_deaths
merge 1:1 state year using temp/tmpStateJDRateVersusFirmAging, nogen
rename stateFIPS pcode
rename year2 year

encode pcode, generate(pcodeNumber)
format year %ty
xtset pcodeNumber year

gen ind = 1
replace ind = 0 if inlist(pcode,"DC")

/* ----------------------------------
	Run Long Difference Regressions
   ---------------------------------- */

* Construct long differences (_n relative to 2014; avg(2014,2013,2012) - avg(1989,1988,1987))
bysort pcode (year): gen s25jdrateAlt = ((job_destruction_rate[_n] - job_destruction_rate[_n-25])+(job_destruction_rate[_n-1] - job_destruction_rate[_n-25-1])+(job_destruction_rate[_n-2] - job_destruction_rate[_n-25-2]))/3
bysort pcode (year): gen s25empShare11Alt = emp11plusShare[_n] - emp11plusShare[_n-27]
* Construct instrument for long difference
bysort pcode (year): gen ests25empShare11Alt = emp0Share[_n-35]
* OLS regression
reg s25jdrateAlt s25empShare11Alt if year==2014 & ind, rob
* IV regression
ivreg2 s25jdrateAlt (s25empShare11Alt=ests25empShare11Alt) if year==2014 & ind, rob
* Weak IV robust confidence intervals with nominal coverage of 90%
condivreg s25jdrateAlt (s25empShare11Alt=ests25empShare11Alt) if year==2014 & ind, ar level(90)

/* ----------------------------------------
	Run Long Double Difference Regressions
   ---------------------------------------- */

* Construct double differences (_n relative to 2014; avg(2014,2013,2012) - avg(2000,1999,1998) cf. avg(2000,1999,1998) - avg(1989,1988,1987))
bysort pcode (year): gen s2_jdrateAlt = ((job_destruction_rate[_n] - job_destruction_rate[_n-14])+(job_destruction_rate[_n-1] - job_destruction_rate[_n-14-1])+ ///
											(job_destruction_rate[_n-2] - job_destruction_rate[_n-14-2]))/3 - ((job_destruction_rate[_n-14] - job_destruction_rate[_n-14-11])+ ///
											(job_destruction_rate[_n-14-1] - job_destruction_rate[_n-14-11-1])+(job_destruction_rate[_n-14-2] - job_destruction_rate[_n-14-11-2]))/3
* Construct double differences (_n relative to 2014; 2014 - 2000 - (2000 - 1987) )
bysort pcode (year): gen s2_empShare11Alt = (emp11plusShare[_n] - emp11plusShare[_n-16])-(emp11plusShare[_n-16] - emp11plusShare[_n-13-14])

* Construct instruments
bysort pcode (year): gen ests2_empShare11Alt0 = emp0Share[_n-35]

reg s2_jdrateAlt s2_empShare11Alt if year==2014 & ind, rob
ivreg2 s2_jdrateAlt (s2_empShare11Alt=ests2_empShare11Alt0) if year==2014 & ind, rob
condivreg s2_jdrateAlt (s2_empShare11Alt=ests2_empShare11Alt0) if year==2014 & ind, ar level(90)
