
/* ************************************************************
   This code replicates the last four columns of Table 6; data 
   are downloaded from the Business Dynamics Statistics (BDS)
   available on the Census website.
   Citation: Crump, Eusepi, Giannoni, and Sahin (2019)
*  ***********************************************************/

/* -----------------------------
	Load BDS data by state/age
   ----------------------------- */

import delim "input/bds_f_agest_release.csv", delimiters(",") clear
* Generate indicators of younger firms
gen ind0 = 0
replace ind0 = 1 if fage4 == "a) 0"
gen ind1 = 0
replace ind1 = 1 if fage4 == "b) 1"
gen ind2 = 0
replace ind2 = 1 if fage4 == "c) 2"
gen ind3 = 0
replace ind3 = 1 if fage4 == "d) 3"
gen ind4 = 0
replace ind4 = 1 if fage4 == "e) 4"
gen ind5 = 0
replace ind5 = 1 if fage4 == "f) 5"
*
//gen ind0to5 = ind0+ind1+ind2+ind3+ind4+ind5
gen ind1to5 = ind1+ind2+ind3+ind4+ind5
* Generate indicators at older firms
gen ind6to10 = 0
replace ind6to10 = 1 if inlist(fage4,"g) 6 to 10")
gen ind11to15 = 0
replace ind11to15 = 1 if inlist(fage4,"h) 11 to 15")
gen ind16to20 = 0
replace ind16to20 = 1 if inlist(fage4,"i) 16 to 20")
gen ind21to25 = 0
replace ind21to25 = 1 if inlist(fage4,"j) 21 to 25")
gen ind26plus = 0
replace ind26plus = 1 if inlist(fage4,"k) 26+")
gen indLeftCens = 0
replace indLeftCens = 1 if inlist(fage4,"l) Left Censored")
*
gen ind11plus = ind11to15+ind16to20+ind21to25+ind26plus+indLeftCens
* Generate employment
gen emp0 = emp*ind0
gen emp1 = emp*ind1
gen emp2 = emp*ind2
gen emp3 = emp*ind3
gen emp4 = emp*ind4
gen emp5 = emp*ind5
gen emp6to10 = emp*ind6to10
gen emp11to15 = emp*ind11to15
gen emp16to20 = emp*ind16to20
gen emp21to25 = emp*ind21to25
gen emp26plus = emp*ind26plus
gen empLeftCens = emp*indLeftCens
*
//gen emp0to5 = emp*ind0to5
gen emp1to5 = emp*ind1to5
gen emp11plus = emp*ind11plus

gen firmAge = ""
//replace firmAge = "0to5" if ind0to5
replace firmAge = "1to5" if ind1to5
replace firmAge = "6to10" if ind6to10
replace firmAge = "11plus" if ind11plus

fillin state year firmAge
drop _fillin

bysort state year: egen emp0_tot = total(emp*ind0)
//bysort state year: egen emp0to5_tot = total(emp*ind0to5)
bysort state year: egen emp1to5_tot = total(emp*ind1to5)
bysort state year: egen emp6to10_tot = total(emp*ind6to10)
bysort state year: egen emp11plus_tot = total(emp*ind11plus)
bysort state year: egen emp_tot = total(emp)

gen emp11plusShare = 100*emp11plus_tot/emp_tot
gen emp0Share = 100*emp0_tot/emp_tot

gen job_destruction_rate2 = .
//replace job_destruction_rate2 = job_destruction_rate*emp0/emp0to5_tot if ind0
replace job_destruction_rate2 = job_destruction_rate*emp1/emp1to5_tot if ind1
replace job_destruction_rate2 = job_destruction_rate*emp2/emp1to5_tot if ind2
replace job_destruction_rate2 = job_destruction_rate*emp3/emp1to5_tot if ind3
replace job_destruction_rate2 = job_destruction_rate*emp4/emp1to5_tot if ind4
replace job_destruction_rate2 = job_destruction_rate*emp5/emp1to5_tot if ind5
replace job_destruction_rate2 = job_destruction_rate if ind6to10
replace job_destruction_rate2 = job_destruction_rate*emp11to15/emp11plus_tot if ind11to15
replace job_destruction_rate2 = job_destruction_rate*emp16to20/emp11plus_tot if ind16to20
replace job_destruction_rate2 = job_destruction_rate*emp21to25/emp11plus_tot if ind21to25
replace job_destruction_rate2 = job_destruction_rate*emp26plus/emp11plus_tot if ind26plus
replace job_destruction_rate2 = job_destruction_rate*empLeftCens/emp11plus_tot if indLeftCens

*collapse (sum) emp* firms* job_destruction_rate2, by(year state firmAge)
collapse (sum) job_destruction_rate2 (lastnm) emp11plusShare emp0Share, by(year state firmAge)

merge m:1 state using input/stateBDStoFIPS, nogen

rename stateFIPS pcode
rename year2 year
egen stateage = group(pcode firmAge)
drop if missing(stateage)
encode firmAge, generate(firmAgeNumber)
format year %ty
xtset stateage year

rename job_destruction_rate2 job_destruction_rate

gen ind = 1
replace ind = 0 if inlist(pcode,"DC")

/* ----------------------------------
	Run Long Difference Regressions
   ---------------------------------- */

   * Construct long differences (_n relative to 2014; avg(2014,2013,2012) - avg(1989,1988,1987))
bysort pcode firmAge (year): gen s25jdrateAlt = ((job_destruction_rate[_n] - job_destruction_rate[_n-25])+(job_destruction_rate[_n-1] - job_destruction_rate[_n-25-1])+(job_destruction_rate[_n-2] - job_destruction_rate[_n-25-2]))/3
bysort pcode firmAge (year): gen s25empShare11Alt = emp11plusShare[_n] - emp11plusShare[_n-27]
* Construct instrument for long difference
bysort pcode firmAge (year): gen ests25empShare11Alt = emp0Share[_n-35]
* OLS regression
reg s25jdrateAlt s25empShare11Alt i.firmAgeNumber if year==2014 & ind, rob
* IV regression
ivreg2 s25jdrateAlt i.firmAgeNumber (s25empShare11Alt=ests25empShare11Alt) if year==2014 & ind, rob
* Construct indicators
gen ind1to5=0
replace ind1to5=1 if firmAge == "1to5"
gen ind6to10=0
replace ind6to10=1 if firmAge == "6to10"
* Weak IV robust confidence intervals with nominal coverage of 90%
condivreg s25jdrateAlt ind1to5 ind6to10 (s25empShare11Alt=ests25empShare11Alt) if year==2014 & ind, ar level(90)

* Sub-group regressions
reg s25jdrateAlt s25empShare11Alt if year==2014 & ind & firmAge=="1to5", rob
condivreg s25jdrateAlt (s25empShare11Alt=ests25empShare11Alt) if year==2014 & ind & firmAge=="1to5", ar level(90)
reg s25jdrateAlt s25empShare11Alt if year==2014 & ind & firmAge=="6to10", rob
condivreg s25jdrateAlt (s25empShare11Alt=ests25empShare11Alt) if year==2014 & ind & firmAge=="6to10", ar level(90)
reg s25jdrateAlt s25empShare11Alt if year==2014 & ind & firmAge=="11plus", rob
condivreg s25jdrateAlt (s25empShare11Alt=ests25empShare11Alt) if year==2014 & ind & firmAge=="11plus", ar level(90)

/* ----------------------------------------
	Run Long Double Difference Regressions
   ---------------------------------------- */

* Construct double differences (_n relative to 2014; avg(2014,2013,2012) - avg(2000,1999,1998) cf. avg(2000,1999,1998) - avg(1989,1988,1987))
bysort pcode firmAge (year): gen s2_jdrateAlt = ((job_destruction_rate[_n] - job_destruction_rate[_n-14])+(job_destruction_rate[_n-1] - job_destruction_rate[_n-14-1])+ ///
											(job_destruction_rate[_n-2] - job_destruction_rate[_n-14-2]))/3 - ((job_destruction_rate[_n-14] - job_destruction_rate[_n-14-11])+ ///
											(job_destruction_rate[_n-14-1] - job_destruction_rate[_n-14-11-1])+(job_destruction_rate[_n-14-2] - job_destruction_rate[_n-14-11-2]))/3
* Construct double differences (_n relative to 2014; 2014 - 2000 - (2000 - 1987) )
bysort pcode firmAge (year): gen s2_empShare11Alt = (emp11plusShare[_n] - emp11plusShare[_n-16])-(emp11plusShare[_n-16] - emp11plusShare[_n-13-14])

* Construct instruments
bysort pcode firmAge (year): gen ests2_empShare11Alt0 = emp0Share[_n-35]

* OLS regression
reg s2_jdrateAlt s2_empShare11Alt if year==2014 & ind, rob
* IV regression
ivreg2 s2_jdrateAlt i.firmAgeNumber (s2_empShare11Alt=ests2_empShare11Alt0) if year==2014 & ind, rob
* Weak-IV robust confidence interval
condivreg s2_jdrateAlt ind1to5 ind6to10 (s2_empShare11Alt=ests2_empShare11Alt0) if year==2014 & ind, ar  level(90)

* Sub-group regressions
reg s2_jdrateAlt s2_empShare11Alt if year==2014 & ind & firmAge=="1to5", rob
condivreg s2_jdrateAlt  (s2_empShare11Alt=ests2_empShare11Alt0) if year==2014 & ind & firmAge=="1to5", ar level(90)
reg s2_jdrateAlt s2_empShare11Alt if year==2014 & ind & firmAge=="6to10", rob
condivreg s2_jdrateAlt  (s2_empShare11Alt=ests2_empShare11Alt0) if year==2014 & ind & firmAge=="6to10", ar level(90)
reg s2_jdrateAlt s2_empShare11Alt if year==2014 & ind & firmAge=="11plus", rob
condivreg s2_jdrateAlt  (s2_empShare11Alt=ests2_empShare11Alt0) if year==2014 & ind & firmAge=="11plus", ar level(90)

