
/* ************************************************************
   This code replicates the second column of Table 4; data 
   are downloaded from the Business Dynamics Statistics (BDS)
   available on the Census website.
   Citation: Crump, Eusepi, Giannoni, and Sahin (2019)
*  ***********************************************************/

/* -----------------------------
	Load BDS data by state/age
   ----------------------------- */

import delim "input/bds_f_age_release2016.csv", delimiters(",") clear
save temp/bds_f_age_release_2016, replace
import delim "input/bds_f_age_release2015.csv", delimiters(",") clear
save temp/bds_f_age_release_2015, replace
import delim "input/bds_f_age_release1977_2014.csv", delimiters(",") clear
append using temp/bds_f_age_release_2015
append using temp/bds_f_age_release_2016

* Generate indicators of younger firms
gen ind0 = 0
replace ind0 = 1 if fage4 == "a) 0"
gen ind1 = 0
replace ind1 = 1 if fage4 == "b) 1"
gen ind2 = 0
replace ind2 = 1 if fage4 == "c) 2"
gen ind3 = 0
replace ind3 = 1 if fage4 == "d) 3"
gen ind4 = 0
replace ind4 = 1 if fage4 == "e) 4"
gen ind5 = 0
replace ind5 = 1 if fage4 == "f) 5"
*
gen ind1to5 = ind1+ind2+ind3+ind4+ind5
* Generate indicators at older firms
gen ind6to10 = 0
replace ind6to10 = 1 if inlist(fage4,"g) 6 to 10")
gen ind11to15 = 0
replace ind11to15 = 1 if inlist(fage4,"h) 11 to 15")
gen ind16to20 = 0
replace ind16to20 = 1 if inlist(fage4,"i) 16 to 20")
gen ind21to25 = 0
replace ind21to25 = 1 if inlist(fage4,"j) 21 to 25")
gen ind26plus = 0
replace ind26plus = 1 if inlist(fage4,"k) 26+")
gen indLeftCens = 0
replace indLeftCens = 1 if inlist(fage4,"l) Left Censored")
*
gen ind11plus = ind11to15+ind16to20+ind21to25+ind26plus+indLeftCens
* Generate employment
gen emp0 = emp*ind0
gen emp1 = emp*ind1
gen emp2 = emp*ind2
gen emp3 = emp*ind3
gen emp4 = emp*ind4
gen emp5 = emp*ind5
gen emp6to10 = emp*ind6to10
gen emp11to15 = emp*ind11to15
gen emp16to20 = emp*ind16to20
gen emp21to25 = emp*ind21to25
gen emp26plus = emp*ind26plus
gen empLeftCens = emp*indLeftCens
*
gen emp1to5 = emp*ind1to5
gen emp11plus = emp*ind11plus

gen firmAge = ""
replace firmAge = "0" if ind0
replace firmAge = "1to5" if ind1to5
replace firmAge = "6to10" if ind6to10
replace firmAge = "11plus" if ind11plus

fillin year firmAge
drop _fillin

bysort year: egen emp0_tot = total(emp*ind0)
bysort year: egen emp1to5_tot = total(emp*ind1to5)
bysort year: egen emp6to10_tot = total(emp*ind6to10)
bysort year: egen emp11plus_tot = total(emp*ind11plus)
bysort year: egen emp_tot = total(emp)

gen emp11plusShare = 100*emp11plus_tot/emp_tot
gen emp0Share = 100*emp0_tot/emp_tot

gen job_destruction_rate2 = .
replace job_destruction_rate2 = job_destruction_rate*emp1/emp1to5_tot if ind1
replace job_destruction_rate2 = job_destruction_rate*emp2/emp1to5_tot if ind2
replace job_destruction_rate2 = job_destruction_rate*emp3/emp1to5_tot if ind3
replace job_destruction_rate2 = job_destruction_rate*emp4/emp1to5_tot if ind4
replace job_destruction_rate2 = job_destruction_rate*emp5/emp1to5_tot if ind5
replace job_destruction_rate2 = job_destruction_rate if ind6to10
replace job_destruction_rate2 = job_destruction_rate*emp11to15/emp11plus_tot if ind11to15
replace job_destruction_rate2 = job_destruction_rate*emp16to20/emp11plus_tot if ind16to20
replace job_destruction_rate2 = job_destruction_rate*emp21to25/emp11plus_tot if ind21to25
replace job_destruction_rate2 = job_destruction_rate*emp26plus/emp11plus_tot if ind26plus
replace job_destruction_rate2 = job_destruction_rate*empLeftCens/emp11plus_tot if indLeftCens

collapse (sum) job_destruction_rate2 (lastnm) emp11plusShare emp0Share, by(year firmAge)
drop if year < 1987

/* -----------------------------
	Display data for table
   ----------------------------- */

preserve
bysort firmAge: sum job_destruction_rate2 
restore
