clear

/* ******************************
*	Load BDS data by state/age
*  *****************************/
import delim "input/bds_f_age_release2016.csv", delimiters(",") clear
save temp/bds_f_age_release_2016, replace
import delim "input/bds_f_age_release2015.csv", delimiters(",") clear
save temp/bds_f_age_release_2015, replace
import delim "input/bds_f_age_release1977_2014.csv", delimiters(",") clear
save temp/bds_f_age_release_2014, replace
*
append using temp/bds_f_age_release_2015
append using temp/bds_f_age_release_2016

* Generate indicators of younger firms
gen ind0 = 0
replace ind0 = 1 if fage4 == "a) 0"
gen ind1 = 0
replace ind1 = 1 if fage4 == "b) 1"
gen ind2 = 0
replace ind2 = 1 if fage4 == "c) 2"
gen ind3 = 0
replace ind3 = 1 if fage4 == "d) 3"
gen ind4 = 0
replace ind4 = 1 if fage4 == "e) 4"
gen ind5 = 0
replace ind5 = 1 if fage4 == "f) 5"
*
gen ind1to5 = ind1+ind2+ind3+ind4+ind5
* Generate indicators at older firms
gen ind6to10 = 0
replace ind6to10 = 1 if inlist(fage4,"g) 6 to 10")
gen ind11to15 = 0
replace ind11to15 = 1 if inlist(fage4,"h) 11 to 15")
gen ind16to20 = 0
replace ind16to20 = 1 if inlist(fage4,"i) 16 to 20")
gen ind21to25 = 0
replace ind21to25 = 1 if inlist(fage4,"j) 21 to 25")
gen ind26plus = 0
replace ind26plus = 1 if inlist(fage4,"k) 26+")
gen indLeftCens = 0
replace indLeftCens = 1 if inlist(fage4,"l) Left Censored")
*
gen ind11plus = ind11to15+ind16to20+ind21to25+ind26plus+indLeftCens
* Generate employment
gen emp0 = emp*ind0
gen emp1to5 = emp*ind1to5
gen emp6to10 = emp*ind6to10
gen emp11plus = emp*ind11plus

collapse (sum) emp*, by(year)

gen emp0Share = emp0/emp
gen emp0to5Share = (emp0+emp1to5)/emp
gen emp1to5Share = emp1to5/emp
gen emp6to10Share = emp6to10/emp
gen emp11plusShare = emp11plus/emp

drop if year < 1987

export excel input/employmentSharesTimeSeriesBDS.xlsx, firstrow(variables) replace


