%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Dual Aging Plots
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dataDir = '../input/';

lw = 1.75;

[dataRaw,stringsRaw,~] = xlsread([dataDir, 'employmentSharesTimeSeriesBDS.xlsx']);
for i = 1:numel(stringsRaw), eval([stringsRaw{i}, ' = dataRaw(:,', num2str(i), ');']); end
clear *Raw

[dataRaw,stringsRaw,~] = xlsread([dataDir, 'youngOldShareWorkersAnnual.xlsx']);
for i = 1:numel(stringsRaw(2,:)), eval([stringsRaw{2,i}, ' = dataRaw(:,', num2str(i), ');']); end
clear *Raw

[~,idxYearBDS,idxYearES] = intersect(year2,yr);
dates = datenum(year2(idxYearBDS),6,31);

figName = figure;
set(figName,'defaultAxesColorOrder',[[0,0,0]; [0,0,0]]);
set(gca,'Xtick', datenum(1990:5:2015, 7,1));
set(gca,'XLim',[datenum(1986, 6,1), datenum(2017, 6,1)]);
datetick('x','yyyy','keepticks','keeplimits')
set(gca,'fontsize', 16);
%
yyaxis right
plot(dates, emp11plusShare, '-r', 'LineWidth', lw);
ylim([.6,.85])
ylabel('Fraction')
recessionplot
yyaxis left
plot(dates, oldEmploymentShare(idxYearES), '-b', 'LineWidth', lw);
ylim([.08,.24])
ylabel('Fraction')
legend('Mature Workers (left axis)', 'Mature Firms (right axis)', 'Location', 'southoutside', 'Orientation', 'horizontal')

figName = figure;
set(figName,'defaultAxesColorOrder',[[0,0,0]; [0,0,0]]);
set(gca,'XLim',[datenum(1986, 6,1), datenum(2017, 6,1)]);
set(gca,'Xtick', datenum(1990:5:2015, 7,1));
datetick('x','yyyy','keepticks','keeplimits')
set(gca,'fontsize', 16);
%
yyaxis right
plot(dates, emp0to5Share, '-r', 'LineWidth', lw);
ylim([.05,.25])
ylabel('Fraction')
recessionplot
yyaxis left
plot(dates, youngEmploymentShare(idxYearES), '-b', 'LineWidth', lw);
ylim([.1,.2])
ylabel('Fraction')
legend('Young Workers (left axis)', 'Young Firms (right axis)', 'Location', 'southoutside', 'Orientation', 'horizontal');

