clear
set more off

 ***change directory. 

insheet using oz_acs_data.csv, clear
gen ln_value=ln(median_value_home_2016)
gen less_than_college=1-some_college 
gen alt_poverty=max(0, pct_poverty_2016-.5*pct_enrolled_in_college)
gen d_pov=pct_poverty_2016-pct_poverty_2012
gen d_inc=median_fam_inc_2016/median_fam_inc_2012
replace d_inc=hh_inc_2016/hh_inc_2012 if d_inc==.
egen c=group(state)
sum c
local i=r(max)
foreach var of varlist less_than_college ln_value alt_poverty pct_kid_poverty_2016  d_inc d_pov {
gen c_`var'=.
forval x=1/`i' {
sum `var' if c==`x' [aw=pop_2016]
replace c_`var'=(`var'-r(mean))/r(sd) if c==`x'
replace c_`var'=3 if c_`var'>3 & c_`var'<.
replace c_`var'=-3 if c_`var'<-3 & c_`var'<.
}
}
replace c_ln_value=-1*c_ln_value
replace c_d_inc=-1*c_d_inc
egen z_score=rmean(c_*)
bys state : cumul z_score, gen(index) eq
drop c ln_value
gen low_poverty_lt20=pct_poverty_2016<.20
gen d_home_price=median_value_home_2016/median_value_home_2012
bys state: cumul d_home if d_home~=., gen(nbs_gentrify) eq
replace nbs_gentrify=nbs_gentrify>.75
replace nbs_gentrify=. if d_home==.



*share from most distressed areas: 
preserve
gen i=1
keep if submitted==1
gen centile=ceil(index*10)
collapse (sum) i picked  nbs_g low_pov  pop_2016 (mean) pct_black_2016 pct_poverty_2016 pct_kid_poverty_2016 some_college d_inc d_pov less_than_ index,by(state centile)
drop if centile==.
bys state: egen t=sum(picked)
gen pdf=picked/t
graph bar pdf if centil==10, over(state, sort(pdf) label(angle(45))) ytitle("Share of Selections") title("Share of Designations from Most Distressed 10%") saving("gr_most_distressed",replace)
sort centil pdf 
outsheet state centile pdf using fig1.csv, comma replace
restore


**how much more disstressed are a state's selections?
preserve 
keep if submitted==1
gen compare=0 if (elig=="Low-Income Community"&picked==0)
replace compare=1 if picked==1
drop if compare==.
collapse (mean) pct_black_2016 pct_white_2016 pct_poverty_2016 alt_poverty pct_kid_poverty_2016 some_college d_inc d_pov index median_value_home_2016 nbs_ [aw=tot_pov], by(state compare)
reshape wide pct_black_2016 pct_white_2016 pct_poverty_2016 alt_poverty pct_kid_poverty_2016 some_college d_inc d_pov  index median_value_home_2016 nbs_, i(state) j(compare)
foreach var in pct_black_2016 pct_white_2016 pct_poverty_2016 alt_poverty pct_kid_poverty_2016 some_college d_inc d_pov  index  median_value_home_2016 nbs_gentrify {
gen d_`var' = `var'1-`var'0
}
graph bar d_index, over(state, sort(d_index) label(angle(45))) ytitle("Difference Selected and Not Selected") title("How Much More Distressed are State's Selections?") saving("gr_distress",replace)
outsheet state d_index index1 index0 using fig2.csv, comma replace

replace d_inc1=d_inc1-1
replace d_inc0=d_inc0-1

*data for table 1
outsheet state index*  alt_poverty* pct_kid_poverty_2016* some_college* median_value_home_2016* d_inc* nbs_*  pct_black_2016* pct_white_2016*   using table1.csv, comma replace
restore


*did they pick gentrifying areas? 
preserve 
keep if submitted==1
gen compare=0 if (elig=="Low-Income Community"&picked==0)
replace compare=1 if picked==1
drop if compare==.
collapse (mean) pct_black_2016 pct_white_2016 pct_poverty_2016 alt_poverty pct_kid_poverty_2016 some_college d_inc d_pov  index  nbs_gentrify , by(state compare)
reshape wide pct_black_2016 pct_white_2016 pct_poverty_2016 alt_poverty pct_kid_poverty_2016 some_college d_inc d_pov  index nbs_gentrify, i(state) j(compare)
foreach var in pct_black_2016 pct_white_2016 pct_poverty_2016 alt_poverty pct_kid_poverty_2016 some_college d_inc d_pov  index nbs_gentrify {
gen d_`var' = `var'1-`var'0
}
graph bar d_nbs, over(state, sort(d_nbs) label(angle(45))) ytitle("Difference Selected and Not Selected") title("Did they Pick Gentrifying Areas?") saving("gr_gent",replace)
tabstat d_nbs nbs*, by(state)
outsheet state d_nbs nbs* using fig3.csv, comma replace
restore
 

