/*This do file contains replication code to produce figures showing expenditures
by parental earnings (Figures 8, 12, and 14 from Hoynes and Schanzenbach (2018)). 
The called data is first created by running
create_data.do (See readme for additional details):
*/

*Prelims
clear all
set more off, perm
cap log close 

*Set directories and log file
cap cd "./replication/"

log using "./log/create_fig_worker.log", replace

****************************************************************************
*WORKER GRAPHS
*Total programs by worker split
****************************************************************************
*Bring in Medicaid amount (added 2/12/2018)
import excel using "./out/timeseries.xlsx", clear firstrow sheet("mcaidwork")
	tempfile mcaid
		save `mcaid', replace
import excel using "./out/timeseries.xlsx", clear firstrow sheet("ssiwork")
	tempfile ssi
		save `ssi', replace
import excel using "./out/timeseries.xlsx", clear firstrow sheet("publicwork")
	tempfile public
		save `public', replace

*For A/CTC, want to limit to $s going to families < 200% poverty (use ATTI:SPM)
	import excel "./out/timeseries.xlsx", clear firstrow sheet("actcctcatti_spmamt") 
	g r_ctcu200 = actcctcatti_spm1 + actcctcatti_spm2 + actcctcatti_spm3 + actcctcatti_spm4
	keep year r_ctcu200
	tempfile ctc
		save `ctc', replace

*Bring in TANF worker tabulations
import excel using "./out/timeseries_workers.xlsx", sheet("TANF") ///
	firstrow clear
		tempfile tanf
			save `tanf', replace
		
*Bring in SNAP worker tabulations
import excel using "./out/timeseries_workers.xlsx", sheet("SNAP") ///
	firstrow clear
		rename totworkerfs* r_fs*
merge 1:1 year using "./dta/totexp_allprog.dta"
	*Make sure matched all years (randomly missing 1995 for food stamps
	tab year if _merge != 3
	drop if year < 1990 | year > 2015 //exclude years outside our window
	assert year == 1995 if _merge != 3 //make sure just missing 1995
	drop _merge
	
*Drop variables we don't need
drop r_totsnap //have already divided up by % and amount workers and $ fams w/ kids in xlsx
drop r_totmcaid //ignore for now
drop r_totssi //ignore for now

*A/CTC in combination and limit CTC amount to families < 200% pov 
drop r_actc r_ctc r_totctc
*Bring back in CTC data
merge 1:1 year using `ctc'
	tab year _merge
	assert _merge == 3 if year >= 1990 & year <= 2015 //make sure we have everything
	//for the 1990-15 range
	keep if _merge == 3
	drop _merge
*Assign other programs to workers/non-workers
foreach var in eitc ctcu200 {
	rename r_`var' r_`var'1
	lab var r_`var'1 "`var' $ to workers"
	g r_`var'0 = 0 //empty variable for nonworkers
	}
	
*AFDC: Bring in QC files showing % TANF going to workers
merge 1:1 year using `tanf', nogen assert(master match)
	cap drop r_tottanf 
	cap drop pcttanfworker*
*Merge to medicaid
merge 1:1 year using `mcaid', assert(match) nogen
merge 1:1 year using `ssi', assert(match) nogen
merge 1:1 year using `public', assert(match) nogen

*Rename medicaid for consistency
rename totmcaid* r_mcaid*
rename totssi* r_ssi*
rename totpublic* r_public*
	
*Finally, merge to population estimates
cap drop *merge*
merge 1:1 year using "./dta/pctworker.dta", keep(master match) gen(popmerge)
	*Make sure everything matches
	assert popmerge >=3
	drop *merge*
*Now pc amounts
forvalues w = 0/1 {
foreach prog in tottanf eitc ctcu200 fs mcaid ssi public {
	g r_`prog'`w'pc = (r_`prog'`w'*1000000000)/numkids_worker`w'
	lab var r_`prog'`w'pc "Per child `prog' worker `w'"
}
}
*Rename things
rename *ctcu200* *ctc*
rename *fs* *snap*
rename *tottanf* *tanf*

*********************************************************************************
*FIGURE 8: Fedearl Spending on Children, by Parental Earnings, 1990-2015
*a. Total spending
*b. Share of total spending

*Figure 12: Per-child Federal Spending on Children, by Parental Earnings, 1990-2015
*a. Per-child spending
*b. Growth in per-child spending (created from excel output)

*Appendix Figure 2: Spending on Children, by Parental Earnings, including
*Medicaid, Public Housing, and SSI
*a. Per-child spending
*b. Growth in per-child spending (created from excel output)
*********************************************************************************
*Fill in missings for CTC
foreach pc in "" pc {
forvalues w = 0/1 {
*Fill in missings for CTC
	replace r_ctc`w'`pc' = 0 if r_ctc`w'`pc' == .
	*Summ everything up for each group
	g r_total`w'`pc' = r_snap`w'`pc' + r_eitc`w'`pc' + r_tanf`w'`pc' + r_ctc`w'`pc' 
	g r_totalmcaid`w'`pc' = r_total`w'`pc' + r_mcaid`w'`pc'+ r_ssi`w'`pc' + r_public`w'`pc'
	}
	}
	
foreach m in "" mcaid {

g r_total`m' = r_total`m'0 + r_total`m'1 //total expenditures each year
forvalues w = 0/1 {
	g pct_total`m'`w' = r_total`m'`w'/r_total`m'
	}

}
	
sort year
		
export excel year r_total0 r_total1 r_total  using ///
	"./out/BPEAtablenumbers.xlsx", firstrow(variables) ///
		sheet("Figure8a_raw") sheetreplace
		
export excel year pct_total0 pct_total1 using ///
	"./out/BPEAtablenumbers.xlsx", firstrow(variables) ///
		sheet("Figure8b_raw") sheetreplace
		
export excel year r_total0pc r_total1pc  using ///
	"./out/BPEAtablenumbers.xlsx", firstrow(variables) ///
		sheet("Figure12_raw") sheetreplace
		
export excel year r_totalmcaid0 r_totalmcaid1 r_totalmcaid  using ///
	"./out/BPEAtablenumbers.xlsx", firstrow(variables) ///
		sheet("Figure_A2a_raw") sheetreplace
		
export excel year pct_totalmcaid0 pct_totalmcaid1 using ///
	"./out/BPEAtablenumbers.xlsx", firstrow(variables) ///
		sheet("Figure_A2b_raw") sheetreplace
		

*********************************************************************************
*FIGURE 14: Spending on Children, by Parental Earnings, 1990 and 2015
*********************************************************************************
*Just keep years we need
tab year, mi
keep if year == 1990 | year == 2015 //just keep first and last year

keep year r_*0 r*1
	drop *total* *ssi* *public*
export excel using ///
	"./out/BPEAtablenumbers.xlsx", firstrow(variables) ///
		sheet("Figure14_raw") sheetreplace
		
cap log close
		
