/*This do file contains replication code to produce figures 3 and 4 from
Hoynes and Schanzenbach (2018). Users should first extract the following
variables from IPUMS (from the March supplement CPS):
	H	YEAR	Survey year
	H	SERIAL	Household serial number
	H	MONTH	Month
	H	CPSID	CPSID, household record
	H	HFLAG	Flag for the 3/8 file 2014
	P	PERNUM	Person number in sample unit
	P	WTSUPP	March supplement weight
	P	CPSIDP	CPSID, person record
	P	AGE	Age
	P	MOMLOC	Person number of first mother (from programming)
	P	SPLOC	Person number of spouse (from programming)
	P	FAMKIND	Kind of family
	P	EMPSTAT	Employment status
	P	LABFORCE	Labor force status
	P	EDUC	Educational attainment recode

*/

*Prelims
clear all
set more off, perm
cap log close 

*Set directories and log file
cap cd "./replication/"

log using "./log/create_fig34_cps.log", replace

*********************************************************************************
*FIGURE 3: Share of children in HH with married parents
*********************************************************************************
cap unzipfile "./raw/cps_00035.zip", replace
use "cps_00035.dta", clear
*Momloc not available until 1968
drop if year<1971 //just need years 1970 and later
	g calyear = year - 1 
	drop year 

gen mothersed=.
*1=Less than high school diploma
replace mothersed=1 if educ<72
*2 High school diploma
replace mothersed=2 if educ==73 | educ == 72
*3 Some college, associate's degree
replace mothersed=3 if inlist(educ,80,81,90,91,92,100)==1
*4 Bachelor's degree or more
replace mothersed=4 if inlist(educ,110,111,120,121,122,123,124,125)==1

*Recode employment variable into indicator
rename empstat emp
tab emp, mi
tab emp, nolab
recode emp (1 = .) (10/12 = 1) (20/40 = 0)
	lab def emp 0 "not employed" 1 "employed"
	lab values emp emp
tab emp, mi

*Just keep prime-aged moms
rename age momage

keep calyear serial month pernum mothersed emp momage wtsupp
rename pernum momloc 
rename wtsupp momwt
*Separate indicator for whether have any college
g college = ( mothersed == 4) //don't incl some college in this

tempfile mothers
save `mothers', replace

use "cps_00035.dta", clear
*Momloc not available until 1968
drop if year<1971
	g calyear = year - 1 
	drop year //so I don't get confused
	
gen kid=.
replace kid=0 if age>17 & age!=.
replace kid=1 if age<18

*we want share of kids with parents who are married
keep if kid==1
	drop emp* lab* //don't need labor force status for kids
gen marriedparents=.
*Only using married, spouse present
*replace married=1 if marst==1
replace marriedparents=0 if inlist(famkind,2,3)==1
replace marriedparents=1 if famkind==1

merge m:1 calyear month serial momloc using `mothers', keep(match) //drop kids wo/moms
	rename calyear year
*We're just using ASEC samples so we don't have wtfinl
*Famkind not available until 1976
drop if marriedparents == .
preserve
collapse (mean) marriedparents [pw=wtsupp], by(year college)
	reshape wide marriedparents, i(year) j(college)
	rename marriedparents0 married_nocoll
	rename marriedparents1 married_coll
	
export excel using "out/BPEAtablenumbers.xlsx", ///
	firstrow(variables) sheet("Figure3_raw") sheetreplace 
restore


*********************************************************************************
*FIGURE 4: Trends in employment rates for women, by marital status and ed
*********************************************************************************
preserve
keep if momage>= 25 & momage <= 54
collapse (mean) emp [pw=wtsupp], by(year)
	lab var emp "All kids" //so know what we're exporting
tempfile all
	save `all', replace //do in tempfiles so cleaner in excel, can use lookup functions
restore

*Now by marital status -- just know marital status from 1975
preserve
keep if momage>= 25 & momage <= 54
collapse (mean) emp [pw=wtsupp], by(year marriedparents)
	*Reshape so cleaner in excel
	reshape wide emp, i(year) j(marriedparents)
	rename  emp1 emp_mar1
	rename  emp0 emp_mar0
	lab var emp_mar0 "Single moms"
	lab var emp_mar1 "Married moms"
tempfile married
	save `married', replace
restore

*Now by educational attainment
preserve
keep if momage>= 25 & momage <= 54
collapse (mean) emp [pw=wtsupp], by(year college)
	*Reshape so cleaner in excel
	reshape wide emp, i(year) j(college)
	rename  emp1 emp_col1
	rename  emp0 emp_col0
	lab var emp_col0 "No college moms"
	lab var emp_col1 "College + moms"
tempfile college
	save `college', replace
restore

*Merge tempfiles
use `college', clear
merge 1:1 year using `married', assert(match) nogen
merge 1:1 year using `all', assert(match) nogen

export excel using "./out/BPEAtablenumbers.xlsx", ///
	firstrow(varlabels) sheet("Figure4_raw") sheetreplace 

cap erase "cps_00035.dta", clear

cap log close




