/*This dofile recodes the variables for years 1989-2012 so that they are consistent 
with the variable names for earlier years.
EK updated it to include 2011 and 2012 data, to capture industry and occupation and to capture more
income variables. She also added a few flags that are needed for the Casey and Mulligan project.
Finally, she added some code from the lateryears_recode_immig.do file so that we have all necessary 
code in one unique file.
Last update: 9/2/2013

EK added 2013 data on 12/08/13 
DC added 2014 data on 09/25/14
*DC added 1988B from UNICON and PROP_TAX and HOUSRENT from UNICON to CPS year 1991
*/

** changelog 
** MB changes are typically marked *MB at start and end
** Also added some more comments and tabbing to make easier to read
** 8/30 MB added alternative poverty here, along with wic and alternative tanf to save space;
** Has 2004 and 89-90 data from external sources for creating alternative poverty;
** EK updated it to include 2011 and 2012 data. Comments or changes by EK are marked *EK;
** 08/26/2015 DC added 1988B from UNICON data
** 12/19/2015 DC added 2015 data
** 2/15/2016 DC added redesigned 2014 data
** 12/26/2016 KR added revised 2015 data and 2016 data

#delimit;
capture log close;
clear all;
clear matrix;
set mem 2g;
set more off;

*DC adds globals;
global unicon "/accounts/projects/hoynes/cycles/march/UNICON7792";
global cps "/accounts/projects/hoynes/cycles/march/CPS8912";
global march "/accounts/projects/hoynes/cycles/march";
global taxtransfer "/accounts/projects/hoynes/cycles/march/CPS7788/taxtransfer";
*DC ends;

cd "$cps";  /*Use this on baker*/;
log using ../lateryears_recode.log, replace;

*DC added 1988B from UNICON;


/***********************************************/;
/*88B*/;
/***********************************************/;

#delimit cr

foreach n in 88 {
	di ""
	di "THIS IS YEAR `n'"
	di ""
	use "$unicon/mar`n'b.dta"
	tempfile marcps19`n'
	drop year
	gen year = 19`n'
	sort hhseq
	save `marcps19`n'', replace
	
	************* Rename UNICON variables to original Census variables
	
	*Identification Variables
	rename hhseq ph_seq
	rename htrail hhpos
	
	*ph_seq, h_seq, and fh_seq are the same variable
	gen h_seq=ph_seq
	gen fh_seq=ph_seq

	rename fampos ffpos 
	rename famposo ffposold

	rename perid pppos
	rename perido ppposold

	*Weights
	rename wgt marsupwt
	rename famwgt fsup_wgt
	rename hhwgt hsup_wgt

	*Individuals Variables
	rename age a_age
	rename sex a_sex
	rename race a_race
	rename marstat a_maritl
	rename grdhi a_hga
	rename grdcom a_hgc
	rename spneth a_reorgn
	rename relhd a_exprrp
	
	rename class1 clwk
	rename wkslyr wkswork
	rename hrslyr hrswk
	rename esr a_lfsr
	rename wkstat a_wkstat
	rename runemp a_untype
	rename wksun a_wkslk
		
	rename ind a_ind
	rename occ a_occ	
	rename rnlook a_nlfrea	
	rename schenr a_enrlw	
	rename schft a_ftpt

	rename famtyp a_famtyp
	rename famrel a_famrel
	rename parent a_parent

	rename incwag wsal_val
	rename incse semp_val					
	rename incfrm frse_val		
	
	rename incuc uc_val
	rename aincuc i_ucval
	rename incwcp wc_val
	rename incvet vet_val
	
	rename incsec ssi_val
	rename aincsec i_ssival
	rename incss ss_val
	rename incpa paw_val
	rename aincpa i_pawval
	rename incdis dsab_val
	rename incds1 dis_val1
	rename incds2 dis_val2 
	rename incret rtm_val 
	
	rename incrnt rnt_val
	rename incdv2 div_val
	rename incint int_val
	
	rename inchld csp_val
	rename incalm alm_val
	rename inced ed_val
	rename incont fin_val
	rename incoth oi_val
	rename incsrv srvs_val		
	rename incsi1 sur_val1
	rename incsi2 sur_val2
	
	rename income ptotval    
	rename incern pearnval 
	rename incuer pothval

	rename covgh cov_gh
	rename covhi cov_hi
	rename chmc ch_mc
	rename chhi ch_hi

	*rename mcare mcare
	*rename mcaid mcaid
	*rename champ champ

	rename hvhi hi_yn
	*rename hiemp hiemp

	rename amcaid i_mcaid
		
	*Family and Household Variables
	rename numper h_numper
	rename hfmcnt hnumfam
	rename famknd ftype
	rename famunit fkind
	
	rename state hg_st60
	rename msafp hg_msac
	rename public hpublic

	rename rensub hlorent
	rename fdstmp hfoodsp
	rename fsnum hfoodno
	rename fsmon hfoodmo
	rename fsval hfdval
	rename fnumper fpersons

	rename afsval i_hfdval
	rename hincuc hucval
	rename hincsp hssival

	rename hotlun hhotlun
	rename hotnum hhotno
	rename hflnch hflunch
	rename hflnno hflunno
	rename hhinc htotval 
	rename henrgy hengast 
	rename hengyv hengval
	*rename hmcare hmcare
	*rename hmcaid hmcaid
	*rename hchamp hchamp
	rename hhi hhi_yn
	
	rename fhdidx fheadidx
	rename povlev famlis
	
	rename faminc ftotval
	rename povcut fpovcut
	rename pvctsf frsppct
	
	rename mis h_mis
	rename tenure h_tenure
	
	*Variables for Poverty Calculation
	rename prptax prop_tax 
	rename hmeqty housret 
	rename fmvfs f_mv_fs
	rename fmvsl f_mv_sl
	rename ffcare ffngcare 
	rename ffcaid ffngcaid 
	rename fhssub fhoussub 
	*rename ffoodr ffoodreq 
	*rename fhousr fhousreq
	rename mvcare p_mvcare
	rename mvcaid p_mvcaid
	rename emcont emcontrb
	rename flstat filestat 
	*rename dpstat dep_stat
	rename fedtaxbc fedtax_bc 
	rename eitcrd eit_cred 
	rename sttaxbc statetax_bc
	rename cpgain cap_gain
	rename cploss cap_loss
	rename taxinc tax_inc
	rename mrgtax marg_tax
	
	
	#delimit;
	
	************* Rename to match 77-88;
	rename hhpos h_pos;
	rename h_numper h_numpers;
	rename hnumfam h_numfam;

	/*geographic*/;
	rename hg_st60 h_state;
	recode h_state (11 = 23) (12 = 33) (13 = 50) (14 = 25) (15 = 44) (16 = 9) (21 = 36) (22 = 34) 
		(23 = 42) (31 = 39) (32 = 18) (33 = 17) (34 = 26) (35 = 55) (41 = 27) (42 = 19) (43 = 29) 
		(44 = 38) (45 = 46) (46 = 31) (47 = 20) (51 = 10) (52 = 24) (53 = 11) (54 = 51) (55 = 54) 
		(56 = 37) (57 = 45) (58 = 13) (59 = 12) (61 = 21) (62 = 47) (63 = 1) (64 = 28) (71 = 5) 
		(72 = 22) (73 = 40) (74 = 48) (81 = 30) (82 = 16) (83 = 56) (84 = 8) (85 = 35) (86 = 4) 
		(87 = 49) (88 = 32) (91 = 53) (92 = 41) (93 = 6) (94 = 2) (95 = 15);
	rename h_state statefip;
	rename hg_msac h_smsa;
	rename hpublic h_public;
	rename hlorent h_rentsub;
	rename hfoodsp h_foodstp;
	rename hfoodno h_fsnum;
	rename hfoodmo h_fsmo;
	rename hfdval h_fsval;

	rename i_hfdval h_flag_fsval;
	rename hucval h_ucval;
	rename hssival h_ssival;

	rename hhotlun  h_hhotlun;
	rename hhotno h_numhot;
	rename hflunch  h_freelun;
	rename hflunno h_numfree;
	rename htotval  h_hhinctot;
	rename hengast h_enrgyas;	
	rename hengval h_enrgyva;
	rename hmcare h_mcare;
	rename hmcaid h_mcaid;
	rename hchamp h_champ;
	rename hhi_yn h_hhiyn;

	rename prop_tax h_prop_tax;
	rename housret h_housret;

	rename hsup_wgt h_weight;

	/*Family variables*/;
	rename fh_seq f_seq;
	rename ffpos f_pos;

	***  88B on is change in name, family type called fkind and vice verse;
	***  so things with fkind earlier are ftype now;
	rename fkind f_kind;

	rename fpersons f_numpers;
	rename fheadidx f_headinx;
	rename famlis f_famlis;

	*** 89 on is change in name, family type called fkind and vice verse;
	*** 1 primary family 2 primary individual 3 related subfamily 4 unrelated subfamily 5 secondary individual;
	*** note ordering of categories also different from previous;
	rename ftype f_type;

	rename ftotval f_inc_tot;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename frsppct f_rsublowinc;

	capture rename ffngcare f_fngcare;
	capture rename ffngcaid f_fngcaid;
	capture rename fhoussub f_houssub;

	/*Person Variables*/;
	rename ph_seq p_seq;
	rename pppos p_pos;
	rename a_age p_age;
	rename a_maritl p_marst;
	rename a_sex p_sex;
	capture rename a_hga p_educ;
	capture rename a_hgc p_gradecom;
	rename a_race p_race;
	rename a_reorgn p_ethnicity;
	rename marsupwt p_marwt;
	rename clwk p_cow2;
	rename wkswork p_weeks;
	rename hrswk p_ushrs;
	rename a_exprrp p_relhd;
	rename a_lfsr p_esr;
	rename a_wkstat p_ftpt;
	rename a_untype p_untype;
	rename a_wkslk p_wkslk;
		
	rename a_ind p_ind;			/*industry code*/;
	rename a_occ p_occ;			/*occupation code*/;
	rename a_nlfrea p_rea_nlf;	/*reason not in labor force*/;
	rename a_enrlw p_attend;	/* high school/college attendance*/;
	rename a_ftpt p_ftpt_st;	/*full/part time school enrollment*/;

	rename a_famtyp p_famtyp;
	rename a_famrel p_famrel;
	
	rename a_parent p_parentline;

	/*Individual income variables that we will sum to get family income variables.
	JS had to combine some categories to make them consistent across years*/;
	rename wsal_val p_inc_ws;			/* wsal_val = ern_val if ern_srce==1, plus ws_val */;
	rename semp_val p_inc_se;			/* semp_val = ern_val if ern_srce==2, plus se_val */;			
	rename frse_val p_inc_fr;			/* frse_val = ern_val if ern_srce==3, plus frm_val */;
	
	/*EK notes: we don't have p_inc_uc, p_inc_wc and p_inc_vt prior to 1989*/;
	gen p_inc_vet = uc_val + wc_val + vet_val;
	rename uc_val p_inc_uc;
	rename i_ucval p_inc_flag_uc;		/* EK added this since needed */;
	rename wc_val p_inc_wc;
	rename vet_val p_inc_vt;
	
	rename ssi_val p_inc_sp;
	rename i_ssival p_inc_flag_sp; 		/* EK added this since needed */;
	rename ss_val p_inc_ss;
	rename paw_val p_inc_pa;
	rename i_pawval p_inc_flag_pa;		/* EK added this since needed */;
	rename dsab_val p_inc_dis;			/* dsab_val = dis_val1 + dis_val2 */;
	rename dis_val1 p_inc_di1;
	rename dis_val2 p_inc_di2;
	rename rtm_val p_inc_ret;			/* rtm_val = ret_val1 + ret_val2 */;
	
	gen p_inc_asset = rnt_val + div_val + int_val;
	gen p_inc_divrnt = rnt_val + div_val;
	rename rnt_val p_inc_rnt;
	rename div_val p_inc_div;
	rename int_val p_inc_val;
	
	/*EK notes: we don't have p_inc_csp, p_inc_alm, p_inc_fin, p_inc_oi, p_inc_ed prior to 1989.
	Also, we don't have p_inc_su1 and p_inc_su2 prior to 1989, nor p_inc_sur. I include it with other 
	income since this variable represents survivors' benefits other than Social Security income */;
	gen p_inc_cs = csp_val + alm_val + ed_val + fin_val + oi_val + srvs_val;
	rename csp_val p_inc_csp;
	rename alm_val p_inc_alm;
	rename ed_val p_inc_ed;
	rename fin_val p_inc_fin;
	rename oi_val p_inc_oi;
	rename srvs_val p_inc_sur; 			/* srvs_val = sur_val1 + sur_val2 */;
	rename sur_val1 p_inc_su1;
	rename sur_val2 p_inc_su2;
	
	/*Totals */;
	rename ptotval p_inc_tot;   		/* ptotval = pearnval + pothval */;    
	rename pearnval p_inc_earn;			/* pearnval = wsal_val + semp_val + frse_val */;
	rename pothval p_inc_oth;			/* pothval =  ptotval - pearnval */;

	** MB new health variables;
	** note that IPUMS suggests this group health and last time group health are not exactly comparable;
	*** next 4 are recodes;
	rename cov_gh p_cov_gh;
	rename cov_hi p_cov_hi;
	rename ch_mc p_ch_mc;
	rename ch_hi p_ch_hi;
	*** Note some recodes don't quite always match ch_mc;
	rename mcare p_care;
	rename mcaid p_caid;
	rename champ p_champ;
	*** edited yn is private plan (0 niu) for **that person**;
	rename hi_yn p_hi_yn;
	rename hiemp p_hiemp;
	* MB end;

	rename i_mcaid p_flag_caid;
	
	*EK adds this code from the lateryears_recode_immig.do file;
	* MB new citizenship starts in 94;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	** new 6/2011;
	gen p_peinusyr = .;
	capture replace p_peinusyr = peinusyr if peinusyr<.;
	gen p_penatvty = .;
	capture replace p_penatvty = penatvty if penatvty<.;
	gen p_pefntvty = .;
	capture replace p_pefntvty = pefntvty if pefntvty<.;
	gen p_pemntvty = .;
	capture replace p_pemntvty = pemntvty if pemntvty<.;
	* MB end;
	*EK ends;

	* MB new Family poverty individual;
	capture rename emcontrb p_emcontrb;
	capture rename fed_ret p_fed_ret;
	capture rename fed_tax p_fed_tax;
	capture rename statetax p_statetax;
	capture rename eit_cred p_eit_cred;
	capture rename actc_crd p_actc_crd;
	capture rename ctc_crd p_ctc_crd;
	capture rename fica p_fica;
	capture rename ted_val p_ted_val;
	*** leaving out capital gains;

	compress;

	* MB has added some variables to this;
	keep year h_seq h_pos h_numpers h_numfam statefip h_smsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_flag_fsval h_ucval h_ssival f_* p_* ;
	save `marcps19`n'', replace;
	};


*DC ends;


/***********************************************/;
/*89-90*/;
/***********************************************/;

foreach n in 89 90 {;
	di "";
	di "THIS IS YEAR `n'";
	di "";
	use cpsmar`n';
	tempfile marcps19`n';
	gen year = 19`n';
	sort h_seq;
	save `marcps19`n'', replace;

	qui infile using $taxtransfer/cpsmar8090taxtransferh.dct, using($taxtransfer/hh`n'asc.dat) clear;
	sort h_seq;
	merge h_seq using `marcps19`n'';
	tab _merge;
	drop if _merge!=3 ;
	drop _merge;
	sort fh_seq ffposold;
	save `marcps19`n'', replace;

	qui infile using $taxtransfer/cpsmar8790taxtransferf.dct, using($taxtransfer/fam`n'asc.dat) clear;
	* see if fh_seq is same as f_seq;
	sort fh_seq ffposold;
	merge fh_seq ffposold using `marcps19`n'';
	tab _merge;
	drop if _merge!=3 ;
	drop _merge;
	sort ph_seq ppposold;
	save `marcps19`n'', replace;

	qui infile using $taxtransfer/cpsmar8890taxtransferp.dct, using ($taxtransfer/per`n'asc.dat) clear;
	sort ph_seq ppposold;
	merge ph_seq ppposold using `marcps19`n'';
	tab _merge;
	drop if _merge!=3;
	drop _merge;


	** rename to match 77-88;
	rename hhpos h_pos;
	rename h_numper h_numpers;
	rename hnumfam h_numfam;

	/*geographic*/;
	rename hg_st60 h_state;
	recode h_state (11 = 23) (12 = 33) (13 = 50) (14 = 25) (15 = 44) (16 = 9) (21 = 36) (22 = 34) 
		(23 = 42) (31 = 39) (32 = 18) (33 = 17) (34 = 26) (35 = 55) (41 = 27) (42 = 19) (43 = 29) 
		(44 = 38) (45 = 46) (46 = 31) (47 = 20) (51 = 10) (52 = 24) (53 = 11) (54 = 51) (55 = 54) 
		(56 = 37) (57 = 45) (58 = 13) (59 = 12) (61 = 21) (62 = 47) (63 = 1) (64 = 28) (71 = 5) 
		(72 = 22) (73 = 40) (74 = 48) (81 = 30) (82 = 16) (83 = 56) (84 = 8) (85 = 35) (86 = 4) 
		(87 = 49) (88 = 32) (91 = 53) (92 = 41) (93 = 6) (94 = 2) (95 = 15);
	rename h_state statefip;
	rename hg_msac h_smsa;
	rename hpublic h_public;
	rename hlorent h_rentsub;
	rename hfoodsp h_foodstp;
	rename hfoodno h_fsnum;
	rename hfoodmo h_fsmo;
	rename hfdval h_fsval;
	
	*EK adds the following variables;
	rename i_hfdval h_flag_fsval;
	rename hucval h_ucval;
	rename hssival h_ssival;
	*EK ends;

	** MB add free lunch/energy assistance/health;
	rename hhotlun  h_hhotlun;
	rename hhotno h_numhot;
	rename hflunch  h_freelun;
	rename hflunno h_numfree;
	rename htotval  h_hhinctot;
	rename hengast h_enrgyas;	
	rename hengval h_enrgyva;
	rename hmcare h_mcare;
	rename hmcaid h_mcaid;
	rename hchamp h_champ;
	rename hhi_yn h_hhiyn;
	* MB end;

	** MB adds HH alt pov;
	rename prop_tax h_prop_tax;
	rename housret h_housret;
	* MB end;

	rename hsup_wgt h_weight;

	/*Family variables*/;
	rename fh_seq f_seq;
	rename ffpos f_pos;

	*** MB note;
	***  89 on is change in name, family type called fkind and vice verse;
	***  so things with fkind earlier are ftype now;
	rename fkind f_kind;
	* MB end;

	rename fpersons f_numpers;
	rename fheadidx f_headinx;
	rename famlis f_famlis;

	** MB;
	*** 89 on is change in name, family type called fkind and vice verse;
	*** 1 primary family 2 primary individual 3 related subfamily 4 unrelated subfamily 5 secondary individual;
	*** note ordering of categories also different from previous;
	rename ftype f_type;
	* MB end;

	/*Comment out all these CPS family variables since we don't use them*/;
	/* MB uncomments some at bottom */;
      	/*;
	rename fwsval f_inc_ws;	
	rename fseval f_inc_se;
	rename ffrval f_inc_fr;
	rename fucval f_inc_uc;	
	rename fwcval f_inc_wc;	
	rename fssval f_inc_ss;
	rename fssival f_inc_ssi;
	rename fpawval f_inc_pa;
	rename fvetval f_inc_v;
	rename fsurval f_inc_sur;
	rename fdisval f_inc_dis;
	rename fretval f_inc_ret;
	rename fintval f_inc_int;
	rename fdivval f_inc_div;
	rename frntval f_inc_rnt;
	rename fedval f_inc_ed;
	rename fcspval f_inc_csp;
	rename falmval f_inc_alm;
	rename ffinval f_inc_fin;
	rename foival f_inc_oi;
	rename ftotval f_inc_tot;
	rename fearnval f_inc_earn;
	rename fothval f_inc_oth;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename famlis f_famlis;
	rename fownu18 f_childu18;
	*/;

	*** MB puts back;
	rename ftotval f_inc_tot;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename frsppct f_rsublowinc;
	* MB end;

	* MB adds Family alt pov variables;
	* f_mv_fs and f_mv_sl are already named ok;
	capture rename ffngcare f_fngcare;
	capture rename ffngcaid f_fngcaid;
	capture rename fhoussub f_houssub;
	*MB end;


	/*Person Variables*/;
	rename ph_seq p_seq;
	rename pppos p_pos;
	rename a_age p_age;
	rename a_maritl p_marst;
	rename a_sex p_sex;
	capture rename a_hga p_educ;
	capture rename a_hgc p_gradecom;
	rename a_race p_race;
	rename a_reorgn p_ethnicity;
	rename marsupwt p_marwt;
	rename clwk p_cow2;
	rename wkswork p_weeks;
	rename hrswk p_ushrs;
	rename a_exprrp p_relhd;
	rename a_lfsr p_esr;
	rename a_wkstat p_ftpt;
	rename a_untype p_untype;
	rename a_wkslk p_wkslk;
		
	*EK adds industry and occupation codes, as well as reason for NiLF/school attendance;
	rename a_ind p_ind;			/*industry code*/;
	rename a_occ p_occ;			/*occupation code*/;
	rename a_nlfrea p_rea_nlf;	/*reason not in labor force*/;
	rename a_enrlw p_attend;	/* high school/college attendance*/;
	rename a_ftpt p_ftpt_st;	/*full/part time school enrollment*/;
	*EK end;

	*** MB adds a_famtyp and a_famrel from individual records ;
	rename a_famtyp p_famtyp;
	rename a_famrel p_famrel;
	* MB end;
	
	*EK adds identifier for parent of each individual;
	rename a_parent p_parentline;
	*EK ends;
	
	*** MB adds self-rated health 96-10;
	capture rename hea p_srhealth;
	* MB end;

	/*Individual income variables that we will sum to get family income variables.
	JS had to combine some categories to make them consistent across years*/;
	rename wsal_val p_inc_ws;			/* wsal_val = ern_val if ern_srce==1, plus ws_val */;
	rename semp_val p_inc_se;			/* semp_val = ern_val if ern_srce==2, plus se_val */;
	*EK thinks should use frse_val instead of frm_val;
	*rename frm_val p_inc_fr;			
	rename frse_val p_inc_fr;			/* frse_val = ern_val if ern_srce==3, plus frm_val */;
	
	/*EK notes: we don't have p_inc_uc, p_inc_wc and p_inc_vt prior to 1989*/;
	gen p_inc_vet = uc_val + wc_val + vet_val;
	rename uc_val p_inc_uc;
	rename i_ucval p_inc_flag_uc;		/* EK added this since needed */;
	rename wc_val p_inc_wc;
	rename vet_val p_inc_vt;
	
	rename ssi_val p_inc_sp;
	rename i_ssival p_inc_flag_sp; 		/* EK added this since needed */;
	rename ss_val p_inc_ss;
	rename paw_val p_inc_pa;
	rename i_pawval p_inc_flag_pa;		/* EK added this since needed */;
	rename dsab_val p_inc_dis;			/* dsab_val = dis_val1 + dis_val2 */;
	rename dis_val1 p_inc_di1;
	rename dis_val2 p_inc_di2;
	rename rtm_val p_inc_ret;			/* rtm_val = ret_val1 + ret_val2 */;
	

	gen p_inc_asset = rnt_val + div_val + int_val;
	gen p_inc_divrnt = rnt_val + div_val;
	rename rnt_val p_inc_rnt;
	rename div_val p_inc_div;
	rename int_val p_inc_val;
	
	/*EK notes: we don't have p_inc_csp, p_inc_alm, p_inc_fin, p_inc_oi, p_inc_ed prior to 1989.
	Also, we don't have p_inc_su1 and p_inc_su2 prior to 1989, nor p_inc_sur. I include it with other 
	income since this variable represents survivors' benefits other than Social Security income */;
	gen p_inc_cs = csp_val + alm_val + ed_val + fin_val + oi_val + srvs_val;
	rename csp_val p_inc_csp;
	rename alm_val p_inc_alm;
	rename ed_val p_inc_ed;
	rename fin_val p_inc_fin;
	rename oi_val p_inc_oi;
	rename srvs_val p_inc_sur; 			/* srvs_val = sur_val1 + sur_val2 */;
	rename sur_val1 p_inc_su1;
	rename sur_val2 p_inc_su2;
	
	/*Totals */;
	rename ptotval p_inc_tot;   		/* ptotval = pearnval + pothval */;    
	rename pearnval p_inc_earn;			/* pearnval = wsal_val + semp_val + frse_val */;
	rename pothval p_inc_oth;			/* pothval =  ptotval - pearnval */;

	** MB new health variables;
	** note that IPUMS suggests this group health and last time group health are not exactly comparable;
	*** next 4 are recodes;
	rename cov_gh p_cov_gh;
	rename cov_hi p_cov_hi;
	rename ch_mc p_ch_mc;
	rename ch_hi p_ch_hi;
	*** Note some recodes don't quite always match ch_mc;
	rename mcare p_care;
	rename mcaid p_caid;
	rename champ p_champ;
	*** edited yn is private plan (0 niu) for **that person**;
	rename hi_yn p_hi_yn;
	rename hiemp p_hiemp;
	* MB end;
	
	*EK adds;
	rename i_mcaid p_flag_caid;
	*EK ends;
	
	*EK comments out;
	/*;
	* MB new citizenship starts in 95;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	* MB end;
	*/;
	*EK ends commenting out;
	
	*EK adds this code from the lateryears_recode_immig.do file;
	* MB new citizenship starts in 94;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	** new 6/2011;
	gen p_peinusyr = .;
	capture replace p_peinusyr = peinusyr if peinusyr<.;
	gen p_penatvty = .;
	capture replace p_penatvty = penatvty if penatvty<.;
	gen p_pefntvty = .;
	capture replace p_pefntvty = pefntvty if pefntvty<.;
	gen p_pemntvty = .;
	capture replace p_pemntvty = pemntvty if pemntvty<.;
	* MB end;
	*EK ends;

	* MB new Family poverty individual;
	capture rename emcontrb p_emcontrb;
	capture rename fed_ret p_fed_ret;
	capture rename fed_tax p_fed_tax;
	capture rename statetax p_statetax;
	capture rename eit_cred p_eit_cred;
	capture rename actc_crd p_actc_crd;
	capture rename ctc_crd p_ctc_crd;
	capture rename fica p_fica;
	capture rename ted_val p_ted_val;
	*** leaving out capital gains;

	compress;

	* MB has added some variables to this;
	keep year h_seq h_pos h_numpers h_numfam statefip h_smsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_flag_fsval h_ucval h_ssival f_* p_* ;
	save `marcps19`n'', replace;
	};

*DC separated 91 from 91-99 block to merge UNICON variables PROP_TAX and HOUSRNT;
/***********************************************/;
/*91*/;
/***********************************************/;

foreach n in 91 {;
	di "";
	di "THIS IS YEAR `n'";
	di "";	
	use cpsmar`n';
	tempfile mar`n'
	tempfile unicon`n'
	tempfile marcps19`n';
	gen year = 19`n';


	/*Household Variables*/;
	** rename to match 77-88;
	rename hhpos h_pos;
	rename h_numper h_numpers;
	rename hnumfam h_numfam;

	/*geographic*/;
	rename hg_st60 h_state;
	recode h_state (11 = 23) (12 = 33) (13 = 50) (14 = 25) (15 = 44) (16 = 9) (21 = 36) (22 = 34) 
		(23 = 42) (31 = 39) (32 = 18) (33 = 17) (34 = 26) (35 = 55) (41 = 27) (42 = 19) (43 = 29) 
		(44 = 38) (45 = 46) (46 = 31) (47 = 20) (51 = 10) (52 = 24) (53 = 11) (54 = 51) (55 = 54) 
		(56 = 37) (57 = 45) (58 = 13) (59 = 12) (61 = 21) (62 = 47) (63 = 1) (64 = 28) (71 = 5) 
		(72 = 22) (73 = 40) (74 = 48) (81 = 30) (82 = 16) (83 = 56) (84 = 8) (85 = 35) (86 = 4) 
		(87 = 49) (88 = 32) (91 = 53) (92 = 41) (93 = 6) (94 = 2) (95 = 15);
	rename h_state statefip;
	rename hg_msac h_smsa;
	rename hpublic h_public;
	rename hlorent h_rentsub;
	rename hfoodsp h_foodstp;
	rename hfoodno h_fsnum;
	rename hfoodmo h_fsmo;
	rename hfdval h_fsval;
	
	*EK adds the following variables;
	rename i_hfdval h_flag_fsval;
	rename hucval h_ucval;
	rename hssival h_ssival;
	*EK ends;

	** MB add free lunch/energy assistance/health;
	rename hhotlun  h_hhotlun;
	rename hhotno h_numhot;
	rename hflunch  h_freelun;
	rename hflunno h_numfree;
	rename htotval  h_hhinctot;
	rename hengast h_enrgyas;	
	rename hengval h_enrgyva;
	rename hmcare h_mcare;
	rename hmcaid h_mcaid;
	rename hchamp h_champ;
	rename hhi_yn h_hhiyn;
	* MB end;

	** MB adds HH alt pov;
	gen byte h_prop_tax=.;
	capture replace h_prop_tax = prop_tax;
	gen byte h_housret=.;
	capture replace h_housret =  housret;
	* MB end;

	rename hsup_wgt h_weight;


	/*Family variables*/;
	rename fh_seq f_seq;
	rename ffpos f_pos;

	*** MB note;
	***  89 on is change in name, family type called fkind and vice verse;
	***  so things with fkind earlier are ftype now;
	rename fkind f_kind;
	* MB end;

	rename fpersons f_numpers;
	rename fheadidx f_headinx;
	rename famlis f_famlis;

	** MB;
	*** 89 on is change in name, family type called fkind and vice verse;
	*** 1 primary family 2 primary individual 3 related subfamily 4 unrelated subfamily 5 secondary individual;
	*** note ordering of categories also different from previous;
	rename ftype f_type;
	* MB end;

	/*Comment out all these CPS family variables since we don't use them*/;
	/* MB uncomments some at bottom */;
    /*;
	rename fwsval f_inc_ws;	
	rename fseval f_inc_se;
	rename ffrval f_inc_fr;
	rename fucval f_inc_uc;	
	rename fwcval f_inc_wc;	
	rename fssval f_inc_ss;
	rename fssival f_inc_ssi;
	rename fpawval f_inc_pa;
	rename fvetval f_inc_v;
	rename fsurval f_inc_sur;
	rename fdisval f_inc_dis;
	rename fretval f_inc_ret;
	rename fintval f_inc_int;
	rename fdivval f_inc_div;
	rename frntval f_inc_rnt;
	rename fedval f_inc_ed;
	rename fcspval f_inc_csp;
	rename falmval f_inc_alm;
	rename ffinval f_inc_fin;
	rename foival f_inc_oi;
	rename ftotval f_inc_tot;
	rename fearnval f_inc_earn;
	rename fothval f_inc_oth;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename famlis f_famlis;
	rename fownu18 f_childu18;
	*/;

	*** MB puts back;
	rename ftotval f_inc_tot;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename frsppct f_rsublowinc;
	* MB end;

	* MB adds Family alt pov variables;
	* f_mv_fs and f_mv_sl are already named ok;
	capture rename ffngcare f_fngcare;
	capture rename ffngcaid f_fngcaid;
	capture rename fhoussub f_houssub;
	*MB end;


	/*Person Variables*/;
	rename ph_seq p_seq;
	rename pppos p_pos;
	rename a_age p_age;
	rename a_maritl p_marst;
	rename a_sex p_sex;
	capture rename a_hga p_educ;
	capture rename a_hgc p_gradecom;
	rename a_race p_race;
	rename a_reorgn p_ethnicity;
	rename marsupwt p_marwt;
	rename clwk p_cow2;
	rename wkswork p_weeks;
	rename hrswk p_ushrs;
	rename a_exprrp p_relhd;
	rename a_lfsr p_esr;
	rename a_wkstat p_ftpt;
	rename a_untype p_untype;
	rename a_wkslk p_wkslk;
		
	*EK adds the followings for improving our EITC denominators (only for available years);
	if `n'>93 rename pemlr p_lfr;			/*major labor force recode*/;
	if `n'>93 gen p_vet_dis= vet_typ1==1;	/*reason for vet comp is disability*/;
	*EK ends;
		
	*EK adds industry and occupation codes, as well as reason for NiLF;
	rename a_ind p_ind;						/*industry code*/;
	rename a_occ p_occ;						/*occupation code*/;
	if `n'<94 rename a_nlfrea p_rea_nlf;		/*reason not in labor force*/;
	if `n'>93 rename prnlfsch p_rea_nlf_sc;	/*reason not in labor force is school*/;
	rename a_enrlw p_attend;	/* high school/college attendance*/;
	rename a_ftpt p_ftpt_st;	/*full/part time school enrollment*/;
	*EK end;

	*** MB adds a_famtyp and a_famrel from individual records ;
	rename a_famtyp p_famtyp;
	rename a_famrel p_famrel;
	* MB end;
	
	*EK adds identifier for parent of each individual;
	rename a_parent p_parentline;
	*EK ends;

	*** MB adds self-rated health 96-10;
	capture rename hea p_srhealth;
	* MB end;

	/*Individual income variables that we will sum to get family income variables.
	JS had to combine some categories to make them consistent across years*/;
	rename wsal_val p_inc_ws;			/* wsal_val = ern_val if ern_srce==1, plus ws_val */;
	rename semp_val p_inc_se;			/* semp_val = ern_val if ern_srce==2, plus se_val */;
	*EK thinks should use frse_val instead of frm_val;
	*rename frm_val p_inc_fr;			
	rename frse_val p_inc_fr;			/* frse_val = ern_val if ern_srce==3, plus frm_val */;
	
	/*EK notes: we don't have p_inc_uc, p_inc_wc and p_inc_vt prior to 1989*/;
	gen p_inc_vet = uc_val + wc_val + vet_val;
	rename uc_val p_inc_uc;
	rename i_ucval p_inc_flag_uc;		/* EK added this since needed */;
	rename wc_val p_inc_wc;
	rename vet_val p_inc_vt;
	
	rename ssi_val p_inc_sp;
	rename i_ssival p_inc_flag_sp; 		/* EK added this since needed */;
	rename ss_val p_inc_ss;
	rename paw_val p_inc_pa;
	rename i_pawval p_inc_flag_pa;		/* EK added this since needed */;
	rename dsab_val p_inc_dis;			/* dsab_val = dis_val1 + dis_val2 */;
	rename dis_val1 p_inc_di1;
	rename dis_val2 p_inc_di2;
	rename rtm_val p_inc_ret;			/* rtm_val = ret_val1 + ret_val2 */;
	

	gen p_inc_asset = rnt_val + div_val + int_val;
	gen p_inc_divrnt = rnt_val + div_val;
	rename rnt_val p_inc_rnt;
	rename div_val p_inc_div;
	rename int_val p_inc_val;
	
	/*EK notes: we don't have p_inc_csp, p_inc_alm, p_inc_fin, p_inc_oi, p_inc_ed prior to 1989.
	Also, we don't have p_inc_su1 and p_inc_su2 prior to 1989, nor p_inc_sur. I include it with other 
	income since this variable represents survivors' benefits other than Social Security income */;
	gen p_inc_cs = csp_val + alm_val + ed_val + fin_val + oi_val + srvs_val;
	rename csp_val p_inc_csp;
	rename alm_val p_inc_alm;
	rename ed_val p_inc_ed;
	rename fin_val p_inc_fin;
	rename oi_val p_inc_oi;
	rename srvs_val p_inc_sur; 			/* srvs_val = sur_val1 + sur_val2 */;
	rename sur_val1 p_inc_su1;
	rename sur_val2 p_inc_su2;
	
	/*Totals */;
	rename ptotval p_inc_tot;   		/* ptotval = pearnval + pothval */;    
	rename pearnval p_inc_earn;			/* pearnval = wsal_val + semp_val + frse_val */;
	rename pothval p_inc_oth;			/* pothval =  ptotval - pearnval */;

	** MB new health variables;
	** note that IPUMS suggests this group health and last time group health are not exactly comparable;
	*** next 4 are recodes;
	rename cov_gh p_cov_gh;
	rename cov_hi p_cov_hi;
	rename ch_mc p_ch_mc;
	rename ch_hi p_ch_hi;
	*** Note some recodes don't quite always match ch_mc;
	rename mcare p_care;
	rename mcaid p_caid;
	rename champ p_champ;
	*** edited yn is private plan (0 niu) for **that person**;
	rename hi_yn p_hi_yn;
	rename hiemp p_hiemp;
	* MB end;
	
	*EK adds;
	capture noisily rename i_caid p_flag_caid;
	capture noisily rename i_mcaid p_flag_caid;
	*EK ends;

	*EK comments out;
	/*;
	* MB new citizenship starts in 95;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	* MB end;
	*/;
	*EK ends commenting out;
	
	*EK adds this code from the lateryears_recode_immig.do file;
	* MB new citizenship starts in 94;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	** new 6/2011;
	gen p_peinusyr = .;
	capture replace p_peinusyr = peinusyr if peinusyr<.;
	gen p_penatvty = .;
	capture replace p_penatvty = penatvty if penatvty<.;
	gen p_pefntvty = .;
	capture replace p_pefntvty = pefntvty if pefntvty<.;
	gen p_pemntvty = .;
	capture replace p_pemntvty = pemntvty if pemntvty<.;
	* MB end;
	*EK ends;

	* MB new Family poverty individual;
	capture rename emcontrb p_emcontrb;
	capture rename fed_ret p_fed_ret;
	capture rename fed_tax p_fed_tax;
	capture rename statetax p_statetax;
	capture rename eit_cred p_eit_cred;
	capture rename actc_crd p_actc_crd;
	capture rename ctc_crd p_ctc_crd;
	capture rename fica p_fica;
	capture rename ted_val p_ted_val;
	*** leaving out capital gains;

	compress;

	* MB has added some variables to this;
	keep year h_seq h_pos h_numpers h_numfam statefip h_smsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_flag_fsval h_ucval h_ssival f_* p_* ;
		
	save `mar`n'', replace;
	
	*DC adds merge with UNICON variables;
	use "$unicon/mar`n'.dta",clear;
	
	keep hhseq perid age sex marstat race prptax hmeqty fmvfs fmvsl ffcare 
		ffcaid fhssub mvcare mvcaid emcont fedtaxbc eitcrd sttaxbc fica;
	
	rename hhseq h_seq;
	rename perid p_pos;
	rename age p_age;
	rename marstat p_marst;
	rename race p_race;
	
	rename prptax h_prop_tax;
	rename hmeqty h_housret; 
	rename fmvfs f_mv_fs;
	rename fmvsl f_mv_sl;
	rename ffcare f_fngcare; 
	rename ffcaid f_fngcaid; 
	rename fhssub f_houssub;
	rename mvcare p_mvcare;
	rename mvcaid p_mvcaid;
	rename emcont p_emcontrb;
	rename fedtaxbc p_fed_tax; 
	rename eitcrd p_eit_cred; 
	rename sttaxbc p_statetax;
	rename fica p_fica;
	
	foreach x in h_prop_tax h_housret f_mv_fs f_mv_sl f_fngcare f_fngcaid f_houssub p_mvcare p_mvcaid p_emcontr
		p_fed_tax p_eit_cred p_statetax p_fica {;
		rename `x' uni_`x';
	};
	
	save `unicon`n'', replace;
	
	*Merge;
	use `mar`n'',clear;
	merge 1:1 h_seq p_pos p_age p_marst p_race using `unicon`n'';
	drop _merge;
	
	*Compare variables and keep UNICON version;
	
	foreach x in h_prop_tax h_housret f_mv_fs f_mv_sl f_fngcare f_fngcaid f_houssub p_mvcare p_mvcaid p_emcontr
		p_fed_tax p_eit_cred p_statetax p_fica {;
			di "this is `x'";
			sum uni_`x';
			capture sum `x';
			capture drop `x';
			rename uni_`x' `x';
	};
	
	save `marcps19`n'', replace;
	
	*DC ends;
};
	
	
/***********************************************/;
/*92-99 minus 95*/;
/***********************************************/;

foreach n in 92 93 94 96 97 98 99 {;
	di "";
	di "THIS IS YEAR `n'";
	di "";	
	use cpsmar`n';
	tempfile marcps19`n';
	gen year = 19`n';


	/*Household Variables*/;
	** rename to match 77-88;
	rename hhpos h_pos;
	rename h_numper h_numpers;
	rename hnumfam h_numfam;

	/*geographic*/;
	rename hg_st60 h_state;
	recode h_state (11 = 23) (12 = 33) (13 = 50) (14 = 25) (15 = 44) (16 = 9) (21 = 36) (22 = 34) 
		(23 = 42) (31 = 39) (32 = 18) (33 = 17) (34 = 26) (35 = 55) (41 = 27) (42 = 19) (43 = 29) 
		(44 = 38) (45 = 46) (46 = 31) (47 = 20) (51 = 10) (52 = 24) (53 = 11) (54 = 51) (55 = 54) 
		(56 = 37) (57 = 45) (58 = 13) (59 = 12) (61 = 21) (62 = 47) (63 = 1) (64 = 28) (71 = 5) 
		(72 = 22) (73 = 40) (74 = 48) (81 = 30) (82 = 16) (83 = 56) (84 = 8) (85 = 35) (86 = 4) 
		(87 = 49) (88 = 32) (91 = 53) (92 = 41) (93 = 6) (94 = 2) (95 = 15);
	rename h_state statefip;
	rename hg_msac h_smsa;
	rename hpublic h_public;
	rename hlorent h_rentsub;
	rename hfoodsp h_foodstp;
	rename hfoodno h_fsnum;
	rename hfoodmo h_fsmo;
	rename hfdval h_fsval;
	
	*EK adds the following variables;
	rename i_hfdval h_flag_fsval;
	rename hucval h_ucval;
	rename hssival h_ssival;
	*EK ends;

	** MB add free lunch/energy assistance/health;
	rename hhotlun  h_hhotlun;
	rename hhotno h_numhot;
	rename hflunch  h_freelun;
	rename hflunno h_numfree;
	rename htotval  h_hhinctot;
	rename hengast h_enrgyas;	
	rename hengval h_enrgyva;
	rename hmcare h_mcare;
	rename hmcaid h_mcaid;
	rename hchamp h_champ;
	rename hhi_yn h_hhiyn;
	* MB end;

	** MB adds HH alt pov;
	gen byte h_prop_tax=.;
	capture replace h_prop_tax = prop_tax;
	gen byte h_housret=.;
	capture replace h_housret =  housret;
	* MB end;

	rename hsup_wgt h_weight;


	/*Family variables*/;
	rename fh_seq f_seq;
	rename ffpos f_pos;

	*** MB note;
	***  89 on is change in name, family type called fkind and vice verse;
	***  so things with fkind earlier are ftype now;
	rename fkind f_kind;
	* MB end;

	rename fpersons f_numpers;
	rename fheadidx f_headinx;
	rename famlis f_famlis;

	** MB;
	*** 89 on is change in name, family type called fkind and vice verse;
	*** 1 primary family 2 primary individual 3 related subfamily 4 unrelated subfamily 5 secondary individual;
	*** note ordering of categories also different from previous;
	rename ftype f_type;
	* MB end;

	/*Comment out all these CPS family variables since we don't use them*/;
	/* MB uncomments some at bottom */;
    /*;
	rename fwsval f_inc_ws;	
	rename fseval f_inc_se;
	rename ffrval f_inc_fr;
	rename fucval f_inc_uc;	
	rename fwcval f_inc_wc;	
	rename fssval f_inc_ss;
	rename fssival f_inc_ssi;
	rename fpawval f_inc_pa;
	rename fvetval f_inc_v;
	rename fsurval f_inc_sur;
	rename fdisval f_inc_dis;
	rename fretval f_inc_ret;
	rename fintval f_inc_int;
	rename fdivval f_inc_div;
	rename frntval f_inc_rnt;
	rename fedval f_inc_ed;
	rename fcspval f_inc_csp;
	rename falmval f_inc_alm;
	rename ffinval f_inc_fin;
	rename foival f_inc_oi;
	rename ftotval f_inc_tot;
	rename fearnval f_inc_earn;
	rename fothval f_inc_oth;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename famlis f_famlis;
	rename fownu18 f_childu18;
	*/;

	*** MB puts back;
	rename ftotval f_inc_tot;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename frsppct f_rsublowinc;
	* MB end;

	* MB adds Family alt pov variables;
	* f_mv_fs and f_mv_sl are already named ok;
	capture rename ffngcare f_fngcare;
	capture rename ffngcaid f_fngcaid;
	capture rename fhoussub f_houssub;
	*MB end;


	/*Person Variables*/;
	rename ph_seq p_seq;
	rename pppos p_pos;
	rename a_age p_age;
	rename a_maritl p_marst;
	rename a_sex p_sex;
	capture rename a_hga p_educ;
	capture rename a_hgc p_gradecom;
	rename a_race p_race;
	rename a_reorgn p_ethnicity;
	rename marsupwt p_marwt;
	rename clwk p_cow2;
	rename wkswork p_weeks;
	rename hrswk p_ushrs;
	rename a_exprrp p_relhd;
	rename a_lfsr p_esr;
	rename a_wkstat p_ftpt;
	rename a_untype p_untype;
	rename a_wkslk p_wkslk;
		
	*EK adds the followings for improving our EITC denominators (only for available years);
	if `n'>93 rename pemlr p_lfr;			/*major labor force recode*/;
	if `n'>93 gen p_vet_dis= vet_typ1==1;	/*reason for vet comp is disability*/;
	*EK ends;
		
	*EK adds industry and occupation codes, as well as reason for NiLF;
	rename a_ind p_ind;						/*industry code*/;
	rename a_occ p_occ;						/*occupation code*/;
	if `n'<94 rename a_nlfrea p_rea_nlf;		/*reason not in labor force*/;
	if `n'>93 rename prnlfsch p_rea_nlf_sc;	/*reason not in labor force is school*/;
	rename a_enrlw p_attend;	/* high school/college attendance*/;
	rename a_ftpt p_ftpt_st;	/*full/part time school enrollment*/;
	*EK end;

	*** MB adds a_famtyp and a_famrel from individual records ;
	rename a_famtyp p_famtyp;
	rename a_famrel p_famrel;
	* MB end;
	
	*EK adds identifier for parent of each individual;
	rename a_parent p_parentline;
	*EK ends;

	*** MB adds self-rated health 96-10;
	capture rename hea p_srhealth;
	* MB end;

	/*Individual income variables that we will sum to get family income variables.
	JS had to combine some categories to make them consistent across years*/;
	rename wsal_val p_inc_ws;			/* wsal_val = ern_val if ern_srce==1, plus ws_val */;
	rename semp_val p_inc_se;			/* semp_val = ern_val if ern_srce==2, plus se_val */;
	*EK thinks should use frse_val instead of frm_val;
	*rename frm_val p_inc_fr;			
	rename frse_val p_inc_fr;			/* frse_val = ern_val if ern_srce==3, plus frm_val */;
	
	/*EK notes: we don't have p_inc_uc, p_inc_wc and p_inc_vt prior to 1989*/;
	gen p_inc_vet = uc_val + wc_val + vet_val;
	rename uc_val p_inc_uc;
	rename i_ucval p_inc_flag_uc;		/* EK added this since needed */;
	rename wc_val p_inc_wc;
	rename vet_val p_inc_vt;
	
	rename ssi_val p_inc_sp;
	rename i_ssival p_inc_flag_sp; 		/* EK added this since needed */;
	rename ss_val p_inc_ss;
	rename paw_val p_inc_pa;
	rename i_pawval p_inc_flag_pa;		/* EK added this since needed */;
	rename dsab_val p_inc_dis;			/* dsab_val = dis_val1 + dis_val2 */;
	rename dis_val1 p_inc_di1;
	rename dis_val2 p_inc_di2;
	rename rtm_val p_inc_ret;			/* rtm_val = ret_val1 + ret_val2 */;
	

	gen p_inc_asset = rnt_val + div_val + int_val;
	gen p_inc_divrnt = rnt_val + div_val;
	rename rnt_val p_inc_rnt;
	rename div_val p_inc_div;
	rename int_val p_inc_val;
	
	/*EK notes: we don't have p_inc_csp, p_inc_alm, p_inc_fin, p_inc_oi, p_inc_ed prior to 1989.
	Also, we don't have p_inc_su1 and p_inc_su2 prior to 1989, nor p_inc_sur. I include it with other 
	income since this variable represents survivors' benefits other than Social Security income */;
	gen p_inc_cs = csp_val + alm_val + ed_val + fin_val + oi_val + srvs_val;
	rename csp_val p_inc_csp;
	rename alm_val p_inc_alm;
	rename ed_val p_inc_ed;
	rename fin_val p_inc_fin;
	rename oi_val p_inc_oi;
	rename srvs_val p_inc_sur; 			/* srvs_val = sur_val1 + sur_val2 */;
	rename sur_val1 p_inc_su1;
	rename sur_val2 p_inc_su2;
	
	/*Totals */;
	rename ptotval p_inc_tot;   		/* ptotval = pearnval + pothval */;    
	rename pearnval p_inc_earn;			/* pearnval = wsal_val + semp_val + frse_val */;
	rename pothval p_inc_oth;			/* pothval =  ptotval - pearnval */;

	** MB new health variables;
	** note that IPUMS suggests this group health and last time group health are not exactly comparable;
	*** next 4 are recodes;
	rename cov_gh p_cov_gh;
	rename cov_hi p_cov_hi;
	rename ch_mc p_ch_mc;
	rename ch_hi p_ch_hi;
	*** Note some recodes don't quite always match ch_mc;
	rename mcare p_care;
	rename mcaid p_caid;
	rename champ p_champ;
	*** edited yn is private plan (0 niu) for **that person**;
	rename hi_yn p_hi_yn;
	rename hiemp p_hiemp;
	* MB end;
	
	*EK adds;
	capture noisily rename i_caid p_flag_caid;
	capture noisily rename i_mcaid p_flag_caid;
	*EK ends;

	*EK comments out;
	/*;
	* MB new citizenship starts in 95;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	* MB end;
	*/;
	*EK ends commenting out;
	
	*EK adds this code from the lateryears_recode_immig.do file;
	* MB new citizenship starts in 94;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	** new 6/2011;
	gen p_peinusyr = .;
	capture replace p_peinusyr = peinusyr if peinusyr<.;
	gen p_penatvty = .;
	capture replace p_penatvty = penatvty if penatvty<.;
	gen p_pefntvty = .;
	capture replace p_pefntvty = pefntvty if pefntvty<.;
	gen p_pemntvty = .;
	capture replace p_pemntvty = pemntvty if pemntvty<.;
	* MB end;
	*EK ends;

	* MB new Family poverty individual;
	capture rename emcontrb p_emcontrb;
	capture rename fed_ret p_fed_ret;
	capture rename fed_tax p_fed_tax;
	capture rename statetax p_statetax;
	capture rename eit_cred p_eit_cred;
	capture rename actc_crd p_actc_crd;
	capture rename ctc_crd p_ctc_crd;
	capture rename fica p_fica;
	capture rename ted_val p_ted_val;
	*** leaving out capital gains;

	compress;

	* MB has added some variables to this;
	if "`n'"=="96" | "`n'"=="97" | "`n'"=="98" | "`n'"=="99" {;
		keep year h_seq h_pos h_numpers h_numfam statefip h_smsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_flag_fsval h_ucval h_ssival filestat 
		f_* p_* ;
	};		
	else {;
		keep year h_seq h_pos h_numpers h_numfam statefip h_smsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_flag_fsval h_ucval h_ssival f_* p_* ;
		};	
	save `marcps19`n'', replace;
};

/***********************************************/;
/*95*/;
/***********************************************/;
#delimit ;
	foreach n in 95 {;
	di "";
	di "THIS IS YEAR `n'";
	di "";
	use cpsmar`n';
	tempfile marcps19`n';
	gen year = 19`n';

	/*Household Variables*/;
	** rename to match 77-88;
	rename hhpos h_pos;
	rename hrnumhou h_numpers;
	rename hnumfam h_numfam;


	** mb cut some text, moved below;

	/*geographic*/;
	rename hg_st60 h_state;
	recode h_state (11 = 23) (12 = 33) (13 = 50) (14 = 25) (15 = 44) (16 = 9) (21 = 36) (22 = 34) 
		(23 = 42) (31 = 39) (32 = 18) (33 = 17) (34 = 26) (35 = 55) (41 = 27) (42 = 19) (43 = 29) 
		(44 = 38) (45 = 46) (46 = 31) (47 = 20) (51 = 10) (52 = 24) (53 = 11) (54 = 51) (55 = 54) 
		(56 = 37) (57 = 45) (58 = 13) (59 = 12) (61 = 21) (62 = 47) (63 = 1) (64 = 28) (71 = 5) 
		(72 = 22) (73 = 40) (74 = 48) (81 = 30) (82 = 16) (83 = 56) (84 = 8) (85 = 35) (86 = 4) 
		(87 = 49) (88 = 32) (91 = 53) (92 = 41) (93 = 6) (94 = 2) (95 = 15);
	rename h_state statefip;
	rename hg_msac h_smsa;

	rename hpublic h_public;
	rename hlorent h_rentsub;
	rename hfoodsp h_foodstp;
	rename hfoodno h_fsnum;
	rename hfoodmo h_fsmo;
	rename hfdval h_fsval;
	
	*EK adds the following variables;
	rename i_hfdval h_flag_fsval;
	rename hucval h_ucval;
	rename hssival h_ssival;
	*EK ends;

	** MB add free lunch/energy assistance/health;
	rename hhotlun  h_hhotlun;
	rename hhotno h_numhot;
	rename hflunch  h_freelun;
	rename hflunno h_numfree;
	rename htotval  h_hhinctot;
	rename hengast h_enrgyas;
	rename hengval h_enrgyva;
	rename hmcare h_mcare;
	rename hmcaid h_mcaid;
	rename hchamp h_champ;
	rename hhi_yn h_hhiyn;
	* MB end;

	** MB adds HH alt pov;
	rename prop_tax h_prop_tax;
	rename housret h_housret;
	* MB end;

	rename hsup_wgt h_weight;


	/*Family Variables*/;
	rename fh_seq f_seq;
	rename ffpos f_pos;

	*** MB change;
	***  89 on is change in name, family type called fkind and vice verse;
	*** use name consistent with 80-88 data;
	*** used to say rename fkind f_kind;
	rename fkind f_kind;
	* MB end;

	rename fpersons f_numpers;
	rename fheadidx f_headinx;
	rename famlis f_famlis;

	** MB;
	*** 89 on is change in name, family type called fkind and vice verse;
	*** 1 primary family 2 primary individual 3 related subfamily 4 unrelated subfamily 5 secondary individual;
	*** note ordering of categories also different from previous;
	rename ftype f_type;
	* MB end;

	/*Comment out all these CPS family variables since we don't use them*/;
	/* MB uncomments some */;
	/*;
	rename fwsval f_inc_ws;
	rename fseval f_inc_se;
	rename ffrval f_inc_fr;
	rename fucval f_inc_uc;
	rename fwcval f_inc_wc;
	rename fssval f_inc_ss;
	rename fssival f_inc_ssi;
	rename fpawval f_inc_pa;
	rename fvetval f_inc_v;
	rename fsurval f_inc_sur;
	rename fdisval f_inc_dis;
	rename fretval f_inc_ret;
	rename fintval f_inc_int;
	rename fdivval f_inc_div;
	rename frntval f_inc_rnt;
	rename fedval f_inc_ed;
	rename fcspval f_inc_csp;
	rename falmval f_inc_alm;
	rename ffinval f_inc_fin;
	rename foival f_inc_oi;
	rename ftotval f_inc_tot;
	rename fearnval f_inc_earn;
	rename fothval f_inc_oth;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename famlis f_famlis;
	rename fownu18 f_childu18;
	*/;

	*** MB puts back;
	rename ftotval f_inc_tot;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename frsppct f_rsublowinc;
	* MB end;      


	* MB adds new alt pov variables;
	* f_mv_fs and f_mv_sl are already named ok;
	rename ffngcare f_fngcare;
	rename ffngcaid f_fngcaid;
	rename fhoussub f_houssub;
	*MB end;

	/*Person Variables*/;
	rename ph_seq p_seq;
	rename pppos p_pos;
	rename peage p_age;
	rename prmarsta p_marst;
	rename pesex p_sex;
	rename peeduca p_educ;
	rename perace p_race;
	rename prorigin p_ethnicity;
	rename marsupwt p_marwt;
	rename clwk p_cow2;
	rename wkswork p_weeks;
	rename hrswk p_ushrs;
	rename a_exprrp p_relhd;
	rename a_lfsr p_esr;
	rename prftlf p_ftpt;     
	/*EK thinks the previous line is incostistent, as in most years we use a_wkstat for this variable.
	If a_wkstat==2, we have full time work. Here instead, full time is prftlf==1. So EK modifies this*/;
	tab p_ftpt, missing;
	replace p_ftpt=2 if p_ftpt==1; 
	*EK ends;
	rename a_untype p_untype;
	
	* MB  comment out, named something different for 95 rename nwlkwk p_wkslk;
	rename prunedur p_wkslk;
	* MB end;
	
	*EK adds the followings for improving our EITC denominators (only for available years);
	rename pemlr p_lfr;			/*major labor force recode*/;
	*EK ends;
	
	*EK adds industry and occupation codes, as well as reason for NiLF/school attendance;
	*Dunno why 95 has different variable names;
	rename pei01icd p_ind;		/*industry code*/;
	rename pei01ocd p_occ;		/*occupation code*/;
	rename prnlfsch p_rea_nlf_sc;	/*reason not in labor force is school*/;
	rename peschenr p_attend;	/* high school/college attendance*/;
	rename peschft p_ftpt_st;	/*full/part time school enrollment*/;
	*EK end;

	*** MB adds a_famtyp and a_famrel from individual records ;
	rename prfamtyp p_famtyp;
	rename prfamrel p_famrel;
	*** MB end;
	
	*EK adds identifier for parent of each individual;
	rename peparent p_parentline;
	*EK ends;

	*** MB adds self-rated health 96-10;
	capture rename hea p_srhealth;
	* MB end;

	/*Individual income variables that we will sum to get family income variables.
	JS had to combine some categories to make them consistent across years*/;
	rename wsal_val p_inc_ws;			/* wsal_val = ern_val if ern_srce==1, plus ws_val */;
	rename semp_val p_inc_se;			/* semp_val = ern_val if ern_srce==2, plus se_val */;
	*EK thinks should use frse_val instead of frm_val;
	*rename frm_val p_inc_fr;			
	rename frse_val p_inc_fr;			/* frse_val = ern_val if ern_srce==3, plus frm_val */;
	
	/*EK notes: we don't have p_inc_uc, p_inc_wc and p_inc_vt prior to 1989*/;
	gen p_inc_vet = uc_val + wc_val + vet_val;
	rename uc_val p_inc_uc;
	rename i_ucval p_inc_flag_uc;		/* EK added this since needed */;
	rename wc_val p_inc_wc;
	rename vet_val p_inc_vt;
	
	rename ssi_val p_inc_sp;
	rename i_ssival p_inc_flag_sp; 		/* EK added this since needed */;
	rename ss_val p_inc_ss;
	rename paw_val p_inc_pa;
	rename i_pawval p_inc_flag_pa;		/* EK added this since needed */;
	rename dsab_val p_inc_dis;			/* dsab_val = dis_val1 + dis_val2 */;
	rename dis_val1 p_inc_di1;
	rename dis_val2 p_inc_di2;
	rename rtm_val p_inc_ret;			/* rtm_val = ret_val1 + ret_val2 */;
	

	gen p_inc_asset = rnt_val + div_val + int_val;
	gen p_inc_divrnt = rnt_val + div_val;
	rename rnt_val p_inc_rnt;
	rename div_val p_inc_div;
	rename int_val p_inc_val;
	
	/*EK notes: we don't have p_inc_csp, p_inc_alm, p_inc_fin, p_inc_oi, p_inc_ed prior to 1989.
	Also, we don't have p_inc_su1 and p_inc_su2 prior to 1989, nor p_inc_sur. I include it with other 
	income since this variable represents survivors' benefits other than Social Security income */;
	gen p_inc_cs = csp_val + alm_val + ed_val + fin_val + oi_val + srvs_val;
	rename csp_val p_inc_csp;
	rename alm_val p_inc_alm;
	rename ed_val p_inc_ed;
	rename fin_val p_inc_fin;
	rename oi_val p_inc_oi;
	rename srvs_val p_inc_sur; 			/* srvs_val = sur_val1 + sur_val2 */;
	rename sur_val1 p_inc_su1;
	rename sur_val2 p_inc_su2;
	
	/*Totals */;
	rename ptotval p_inc_tot;   		/* ptotval = pearnval + pothval */;    
	rename pearnval p_inc_earn;			/* pearnval = wsal_val + semp_val + frse_val */;
	rename pothval p_inc_oth;			/* pothval =  ptotval - pearnval */;

	** MB new health variables;
	** note that IPUMS suggests this group health and last time group health are not exactly comparable;
	*** next 4 are recodes;
	rename cov_gh p_cov_gh;
	rename cov_hi p_cov_hi;
	rename ch_mc p_ch_mc;
	rename ch_hi p_ch_hi;
	*** Note some recodes don't quite always match ch_mc;
	rename mcare p_care;
	rename mcaid p_caid;
	rename champ p_champ;
	*** edited yn is private plan (0 niu) for **that person**;
	rename hi_yn p_hi_yn;
	rename hiemp p_hiemp;
	* MB end;
	
	*EK adds;
	gen p_flag_caid=.;
	*EK ends;
	
	*EK comments out;
	/*;
	* MB new citizenship starts in 95;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	* MB end;
	*/;
	*EK ends commenting out;
	
	*EK adds this code from the lateryears_recode_immig.do file;
	* MB new citizenship starts in 94;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	** new 6/2011;
	gen p_peinusyr = .;
	capture replace p_peinusyr = peinusyr if peinusyr<.;
	gen p_penatvty = .;
	capture replace p_penatvty = penatvty if penatvty<.;
	gen p_pefntvty = .;
	capture replace p_pefntvty = pefntvty if pefntvty<.;
	gen p_pemntvty = .;
	capture replace p_pemntvty = pemntvty if pemntvty<.;
	* MB end;
	*EK ends;

	* MB new alt poverty individual;
	capture rename emcontrb p_emcontrb;
	capture rename fed_ret p_fed_ret;
	capture rename fed_tax p_fed_tax;
	capture rename statetax p_statetax;
	capture rename eit_cred p_eit_cred;
	capture rename actc_crd p_actc_crd;
	capture rename ctc_crd p_ctc_crd;
	capture rename fica p_fica;
	capture rename ted_val p_ted_val;

	*** leaving out capital gains;

	compress;


	* MB has added some variables to this;
	keep year h_seq h_pos h_numpers h_numfam statefip h_smsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_flag_fsval h_ucval h_ssival f_* p_* ;

	save `marcps19`n'', replace;
};

/***********************************************/;
/*00-02*/;
/***********************************************/;
#delimit ;
clear;
foreach n in 00 01 02 {;
	di "";
	di "THIS IS YEAR `n'";
	di "";
	display `n';
	use cpsmar`n';
	tempfile marcps20`n';
	gen year = 20`n';

	/*Household variables*/;
	** rename to match 77-88;
	rename hhpos h_pos;
	rename h_numper h_numpers;
	rename hnumfam h_numfam;

	* MB moved some text below;

	/*geographic*/;
	rename hg_st60 h_state;
	recode h_state (11 = 23) (12 = 33) (13 = 50) (14 = 25) (15 = 44) (16 = 9) (21 = 36) (22 = 34) 
	       (23 = 42) (31 = 39) (32 = 18) (33 = 17) (34 = 26) (35 = 55) (41 = 27) (42 = 19) (43 = 29) 
	       (44 = 38) (45 = 46) (46 = 31) (47 = 20) (51 = 10) (52 = 24) (53 = 11) (54 = 51) (55 = 54) 
	       (56 = 37) (57 = 45) (58 = 13) (59 = 12) (61 = 21) (62 = 47) (63 = 1) (64 = 28) (71 = 5) 
	       (72 = 22) (73 = 40) (74 = 48) (81 = 30) (82 = 16) (83 = 56) (84 = 8) (85 = 35) (86 = 4) 
	       (87 = 49) (88 = 32) (91 = 53) (92 = 41) (93 = 6) (94 = 2) (95 = 15);
	rename h_state statefip;
	rename hg_msac h_smsa;

	rename hpublic h_public;
	rename hlorent h_rentsub;
	rename hfoodsp h_foodstp;
	rename hfoodno h_fsnum;
	rename hfoodmo h_fsmo;
	rename hfdval h_fsval;
	
	*EK adds the following variables;
	rename i_hfdval h_flag_fsval;
	rename hucval h_ucval;
	rename hssival h_ssival;
	*EK ends;

	** MB add free lunch/energy assistance/health;
	rename hhotlun  h_hhotlun;
	rename hhotno h_numhot;
	rename hflunch  h_freelun;
	rename hflunno h_numfree;
	rename htotval  h_hhinctot;
	rename hengast h_enrgyas;
	rename hengval h_enrgyva;
	rename hmcare h_mcare;
	rename hmcaid h_mcaid;
	rename hchamp h_champ;
	rename hhi_yn h_hhiyn;
	* MB end;

	** MB adds HH alt pov;
	rename prop_tax h_prop_tax;
	rename housret h_housret;
	* MB end;

	** MB adds WIC and new TANF from 01 on (new TANF end in 09 survey);
	** combine transportation assistance and child care;
	** 01-09;
	gen h_tanftranscc = .;
	capture replace h_tanftranscc = hrtayn==1 | hrccayn==1 if hrtayn<.;
	** combine community service job club job resource job readiness job training or GED classes;
	gen h_tanftred = .;
	capture replace h_tanftred = hrcmsryn==1 | hrjcyn==1 | hrjryn==1 | hrjtyn==1 | (hrnumsc>=1 & hrnumsc<.) if hrcmsryn<.;
	*** check;
	if "`n'"!="00" {;
		di "checking on TANF recodes";
		di "tab hrtayn hrccayn, su(h_tanftranscc) missing";
		tab hrtayn hrccayn, su(h_tanftranscc) missing;
		di "for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: tab h_tanftred X, missing";
		for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: tab h_tanftred X, missing;
		di "for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: su X if h_tanftred==0";
		for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: su X if h_tanftred==0;
		};
	gen h_numwic=.;
	capture replace h_numwic= hrnumwic;
	gen h_wicyn=.;
	capture replace h_wicyn= hrwicyn;
	* MB end;


	rename hsup_wgt h_weight;

	/*Family variables*/;
	rename fh_seq f_seq;
	rename ffpos f_pos;

	*** MB change;
	***  89 on is change in name, family type called fkind and vice verse;
	*** use name consistent with 80-88 data;
	*** used to say rename fkind f_kind and similarly for f_type;
	rename fkind f_kind;
	* MB end;

	rename fpersons f_numpers;
	rename fheadidx f_headinx;
	rename famlis f_famlis;

	** MB;
	*** 89 on is change in name, family type called fkind and vice verse;
	*** 1 primary family 2 primary individual 3 related subfamily 4 unrelated subfamily 5 secondary individual;
	*** note ordering of categories also different from previous;
	rename ftype f_type;
	* MB end;

	/*Comment out all these CPS family variables since we don't use them*/;
	/* MB uncomments some */;
	/*;
	rename fwsval f_inc_ws;
	rename fseval f_inc_se;
	rename ffrval f_inc_fr;
	rename fucval f_inc_uc;
	rename fwcval f_inc_wc;
	rename fssval f_inc_ss;
	rename fssival f_inc_ssi;
	rename fpawval f_inc_pa;
	rename fvetval f_inc_v;
	rename fsurval f_inc_sur;
	rename fdisval f_inc_dis;
	rename fretval f_inc_ret;
	rename fintval f_inc_int;
	rename fdivval f_inc_div;
	rename frntval f_inc_rnt;
	rename fedval f_inc_ed;
	rename fcspval f_inc_csp;
	rename falmval f_inc_alm;
	rename ffinval f_inc_fin;
	rename foival f_inc_oi;
	rename ftotval f_inc_tot;
	rename fearnval f_inc_earn;
	rename fothval f_inc_oth;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename famlis f_famlis;
	rename fownu18 f_childu18;
	*/;

	** MB puts back;
	rename ftotval f_inc_tot;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename frsppct f_rsublowinc;
	* MB end;

	* MB adds new alt pov variables;
	* f_mv_fs and f_mv_sl are already named ok;
	rename ffngcare f_fngcare;
	rename ffngcaid f_fngcaid;
	rename fhoussub f_houssub;
	*MB end;


	/*Personal Variables*/;
	rename ph_seq p_seq;
	rename pppos p_pos;
	rename a_age p_age;
	rename a_maritl p_marst;
	rename a_sex p_sex;
	rename a_hga p_educ;
	rename a_race p_race;
	rename a_reorgn p_ethnicity;
	rename marsupwt p_marwt;
	rename clwk p_cow2;
	rename wkswork p_weeks;
	rename hrswk p_ushrs;
	rename a_exprrp p_relhd;
	rename a_lfsr p_esr;
	rename a_wkstat p_ftpt;			/*EK changes this from rename a_ftlf p_ftpt*/;
	rename a_untype p_untype;

	* MB comments out wrong weeks variable, adds one goes to 99;
	rename	a_wkslk p_wkslk;
	
	*EK adds the followings for improving our EITC denominators;
	rename pemlr p_lfr;			/*major labor force recode*/;
	gen p_vet_dis= vet_typ1==1; /*reason for veteran comp is disability*/
	if `n'>00 gen p_ss_dis = resnss1==2 | resnss2==2;	/*reason for SS is disability*/;
	if `n'>00 gen p_ssi_dis = resnssi1==2 | resnssi2==2;	/*reason for SSI is disability*/;
	*EK ends;
	
	*EK adds industry and occupation codes, as well as reason for NiLF/school variables;
	*Notes: Beginning in January 2003, the CPS began using the North American Industry Classification
	System (NAICS) based on the Census 2000 industry and occupation codes. PEIOIND AND PEIOOCC 
	replace A-IND and A-OCC on the file;
	rename a_ind p_ind;		/*industry code*/;
	rename a_occ p_occ;		/*occupation code*/;
	rename prnlfsch p_rea_nlf_sc;	/*reason not in labor force is school*/;
	rename a_enrlw p_attend;	/* high school/college attendance*/;
	rename a_ftpt p_ftpt_st;	/*full/part time school enrollment*/;
	*EK end;
	
	*** MB adds a_famtyp and a_famrel from individual records ;
	rename a_famtyp p_famtyp;
	rename a_famrel p_famrel;
	* MB end;
	
	*EK adds identifier for parent of each individual;
	rename a_parent p_parentline;
	*EK ends;

	*** MB adds self-rated health 96-10;
	rename hea p_srhealth;
	* MB end;

	/*Individual income variables that we will sum to get family income variables.
	JS had to combine some categories to make them consistent across years*/;
	rename wsal_val p_inc_ws;			/* wsal_val = ern_val if ern_srce==1, plus ws_val */;
	rename semp_val p_inc_se;			/* semp_val = ern_val if ern_srce==2, plus se_val */;
	*EK thinks should use frse_val instead of frm_val;
	*rename frm_val p_inc_fr;			
	rename frse_val p_inc_fr;			/* frse_val = ern_val if ern_srce==3, plus frm_val */;
	
	/*EK notes: we don't have p_inc_uc, p_inc_wc and p_inc_vt prior to 1989*/;
	gen p_inc_vet = uc_val + wc_val + vet_val;
	rename uc_val p_inc_uc;
	rename i_ucval p_inc_flag_uc;		/* EK added this since needed */;
	rename wc_val p_inc_wc;
	rename vet_val p_inc_vt;
	
	rename ssi_val p_inc_sp;
	rename i_ssival p_inc_flag_sp; 		/* EK added this since needed */;
	rename ss_val p_inc_ss;
	rename paw_val p_inc_pa;
	rename i_pawval p_inc_flag_pa;		/* EK added this since needed */;
	rename dsab_val p_inc_dis;			/* dsab_val = dis_val1 + dis_val2 */;
	rename dis_val1 p_inc_di1;
	rename dis_val2 p_inc_di2;
	rename rtm_val p_inc_ret;			/* rtm_val = ret_val1 + ret_val2 */;
	

	gen p_inc_asset = rnt_val + div_val + int_val;
	gen p_inc_divrnt = rnt_val + div_val;
	rename rnt_val p_inc_rnt;
	rename div_val p_inc_div;
	rename int_val p_inc_val;
	
	/*EK notes: we don't have p_inc_csp, p_inc_alm, p_inc_fin, p_inc_oi, p_inc_ed prior to 1989.
	Also, we don't have p_inc_su1 and p_inc_su2 prior to 1989, nor p_inc_sur. I include it with other 
	income since this variable represents survivors' benefits other than Social Security income */;
	gen p_inc_cs = csp_val + alm_val + ed_val + fin_val + oi_val + srvs_val;
	rename csp_val p_inc_csp;
	rename alm_val p_inc_alm;
	rename ed_val p_inc_ed;
	rename fin_val p_inc_fin;
	rename oi_val p_inc_oi;
	rename srvs_val p_inc_sur; 			/* srvs_val = sur_val1 + sur_val2 */;
	rename sur_val1 p_inc_su1;
	rename sur_val2 p_inc_su2;
	
	/*Totals */;
	rename ptotval p_inc_tot;   		/* ptotval = pearnval + pothval */;    
	rename pearnval p_inc_earn;			/* pearnval = wsal_val + semp_val + frse_val */;
	rename pothval p_inc_oth;			/* pothval =  ptotval - pearnval */;

	** MB new health variables;
	** note that IPUMS suggests this group health and last time group health are not exactly comparable;
	*** next 4 are recodes;
	rename cov_gh p_cov_gh;
	rename cov_hi p_cov_hi;
	rename ch_mc p_ch_mc;
	rename ch_hi p_ch_hi;
	*** Note some recodes don't quite always match ch_mc;
	rename mcare p_care;
	rename mcaid p_caid;
	rename champ p_champ;
	** chip only shows up 2001 on;
	capture rename pchip p_chip;
	*** edited yn is private plan (0 niu) for **that person**;
    	rename hi_yn p_hi_yn;
	rename hiemp p_hiemp;
	* MB end;
	
	*EK adds;
	rename i_caid p_flag_caid;
	*EK ends;

	*EK comments out;
	/*;
	* MB new citizenship starts in 95;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	* MB end;
	*/;
	*EK ends commenting out;
	
	*EK adds this code from the lateryears_recode_immig.do file;
	* MB new citizenship starts in 94;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	** new 6/2011;
	gen p_peinusyr = .;
	capture replace p_peinusyr = peinusyr if peinusyr<.;
	gen p_penatvty = .;
	capture replace p_penatvty = penatvty if penatvty<.;
	gen p_pefntvty = .;
	capture replace p_pefntvty = pefntvty if pefntvty<.;
	gen p_pemntvty = .;
	capture replace p_pemntvty = pemntvty if pemntvty<.;
	* MB end;
	*EK ends;

	* MB new alt poverty individual;
	rename emcontrb p_emcontrb;
	rename fed_ret p_fed_ret;
	rename fed_tax p_fed_tax;
	rename statetax p_statetax;
	rename eit_cred p_eit_cred;
	rename fica p_fica;
	rename ted_val p_ted_val;

	*** leaving out capital gains;

	* MB has added some variables to this;
	keep year h_seq h_pos h_numpers h_numfam statefip h_smsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_tanftranscc h_tanftred h_wicyn 
		h_numwic h_flag_fsval h_ucval h_ssival filestat f_* p_*;
	save `marcps20`n'', replace;
};

/***********************************************/
/*03*/
/* MB has to do 04 separately to get tax stuff in */
/***********************************************/
#delimit ;
clear;
foreach n in 03 {;
	di "";
	di "THIS IS YEAR `n'";
	di "";
	use cpsmar`n';
	tempfile marcps20`n';
	gen year = 20`n';

	/*Household variables*/
	rename hhpos h_pos;
	rename h_numper h_numpers;
	rename hnumfam h_numfam;

	* MB moved some text below;

	/*geographic*/
	rename hg_st60 h_state;
	recode h_state (11 = 23) (12 = 33) (13 = 50) (14 = 25) (15 = 44) (16 = 9) (21 = 36) (22 = 34) 
	       (23 = 42) (31 = 39) (32 = 18) (33 = 17) (34 = 26) (35 = 55) (41 = 27) (42 = 19) (43 = 29) 
	       (44 = 38) (45 = 46) (46 = 31) (47 = 20) (51 = 10) (52 = 24) (53 = 11) (54 = 51) (55 = 54) 
	       (56 = 37) (57 = 45) (58 = 13) (59 = 12) (61 = 21) (62 = 47) (63 = 1) (64 = 28) (71 = 5) 
	       (72 = 22) (73 = 40) (74 = 48) (81 = 30) (82 = 16) (83 = 56) (84 = 8) (85 = 35) (86 = 4) 
	       (87 = 49) (88 = 32) (91 = 53) (92 = 41) (93 = 6) (94 = 2) (95 = 15);
	rename h_state statefip;
    rename hg_msac h_smsa;

    rename hpublic h_public;
    rename hlorent h_rentsub;
	rename hfoodsp h_foodstp;
	rename hfoodno h_fsnum;
	rename hfoodmo h_fsmo;
	rename hfdval h_fsval;
	
	*EK adds the following variables;
	rename i_hfdval h_flag_fsval;
	rename hucval h_ucval;
	rename hssival h_ssival;
	*EK ends;

	** MB add free lunch/energy assistance/health;
	rename hhotlun  h_hhotlun;
	rename hhotno h_numhot;
	rename hflunch  h_freelun;
	rename hflunno h_numfree;
	rename htotval  h_hhinctot;
	rename hengast h_enrgyas;
	rename hengval h_enrgyva;
	rename hmcare h_mcare;
	rename hmcaid h_mcaid;
	rename hchamp h_champ;
	rename hhi_yn h_hhiyn;
	* MB end;

	** MB adds HH alt pov;
	rename prop_tax h_prop_tax;
	rename housret h_housret;
	* MB end;

	** MB adds WIC and new TANF from 01 on (new TANF end in 09 survey);
	** combine transportation assistance and child care;
	** 01-09;
	gen h_tanftranscc = .;
	capture replace h_tanftranscc = hrtayn==1 | hrccayn==1 if hrtayn<.;
	** combine community service job club job resource job readiness job training or GED classes;
	gen h_tanftred = .;
	capture replace h_tanftred = hrcmsryn==1 | hrjcyn==1 | hrjryn==1 | hrjtyn==1 | (hrnumsc>=1 & hrnumsc<.) if hrcmsryn<.;
	*** check;
	if "`n'"!="00" {;
		di "checking on TANF recodes";
		di "tab hrtayn hrccayn, su(h_tanftranscc) missing";
		tab hrtayn hrccayn, su(h_tanftranscc) missing;
		di "for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: tab h_tanftred X, missing";
		for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: tab h_tanftred X, missing;
		di "for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: su X if h_tanftred==0";
		for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: su X if h_tanftred==0;
		};
	gen h_numwic=.;
	capture replace h_numwic= hrnumwic;
	gen h_wicyn=.;
	capture replace h_wicyn= hrwicyn;
	* MB end;

	rename hsup_wgt h_weight;

	/*Family variables*/
	rename fh_seq f_seq;
	rename ffpos f_pos;

	*** MB change;
	***  89 on is change in name, family type called fkind and vice verse;
	*** use name consistent with 80-88 data;
	*** used to say rename fkind f_kind and similarly for f_type;
	rename fkind f_kind;
	* MB end;

	rename fpersons f_numpers;
	rename fheadidx f_headinx;
	rename famlis f_famlis;

	** MB;
	*** 89 on is change in name, family type called fkind and vice verse;
	*** 1 primary family 2 primary individual 3 related subfamily 4 unrelated subfamily 5 secondary individual;
	*** note ordering of categories also different from previous;
	rename ftype f_type;
	* MB end;

	/*Comment out all these CPS family variables since we don't use them*/;
	/* MB uncomments some */;
	/*;
	rename fwsval f_inc_ws;
	rename fseval f_inc_se;
	rename ffrval f_inc_fr;
	rename fucval f_inc_uc;
	rename fwcval f_inc_wc;
	rename fssval f_inc_ss;
	rename fssival f_inc_ssi;
	rename fpawval f_inc_pa;
	rename fvetval f_inc_v;
	rename fsurval f_inc_sur;
	rename fdisval f_inc_dis;
	rename fretval f_inc_ret;
	rename fintval f_inc_int;
	rename fdivval f_inc_div;
	rename frntval f_inc_rnt;
	rename fedval f_inc_ed;
	rename fcspval f_inc_csp;
	rename falmval f_inc_alm;
	rename ffinval f_inc_fin;
	rename foival f_inc_oi;
	rename ftotval f_inc_tot;
	rename fearnval f_inc_earn;
	rename fothval f_inc_oth;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename famlis f_famlis;
       	rename fownu18 f_childu18;
       	*/;

	** MB puts back;
	rename ftotval f_inc_tot;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename frsppct f_rsublowinc;
	* MB end;

	* MB adds new alt pov variables;
	* f_mv_fs and f_mv_sl are already named ok;
	rename ffngcare f_fngcare;
	rename ffngcaid f_fngcaid;
	rename fhoussub f_houssub;
	*MB end;

	/*Personal variables*/
	rename ph_seq p_seq;
	rename pppos p_pos;
	rename a_age p_age;
	rename a_maritl p_marst;
	rename a_sex p_sex;
	rename a_hga p_educ;
	rename prdtrace p_race;
	rename pehspnon p_ethnicity;
	rename marsupwt p_marwt;
	rename clwk p_cow2;
	rename wkswork p_weeks;
	rename hrswk p_ushrs;
	rename a_exprrp p_relhd;
	rename a_lfsr p_esr;
	rename a_wkstat p_ftpt;			/*EK changes this from rename a_ftlf p_ftpt*/;
	rename a_untype p_untype;

	* MB comments out wrong weeks variable, adds one goes to 99;
	rename	a_wkslk p_wkslk;
	
	*EK adds the followings for improving our EITC denominators;
	rename pemlr p_lfr;			/*major labor force recode*/;
	gen p_vet_dis= vet_typ1==1; /*reason for veteran comp is disability*/
	gen p_ss_dis = resnss1==2 | resnss2==2;	/*reason for SS is disability*/;
	gen p_ssi_dis = resnssi1==2 | resnssi2==2;	/*reason for SSI is disability*/;
	*EK ends;
		
	*EK adds industry and occupation codes, as well as reason for NiLF/school variables;
	*Notes: Beginning in January 2003, the CPS began using the North American Industry Classification
	System (NAICS) based on the Census 2000 industry and occupation codes. PEIOIND AND PEIOOCC 
	replace A-IND and A-OCC on the file;
	rename peioind p_ind;		/*industry code*/;
	rename peioocc p_occ;		/*occupation code*/;
	rename prnlfsch p_rea_nlf_sc;	/*reason not in labor force is school*/;
	rename a_enrlw p_attend;	/* high school/college attendance*/;
	rename a_ftpt p_ftpt_st;	/*full/part time school enrollment*/;
	*EK end;
	
	*** MB adds a_famtyp and a_famrel from individual records ;
	rename a_famtyp p_famtyp;
	rename a_famrel p_famrel;
	* MB end;
	
	*EK adds identifier for parent of each individual;
	rename a_parent p_parentline;
	*EK ends;

	*** MB adds self-rated health 96-10;
	rename hea p_srhealth;
	* MB end;

	/*Individual income variables that we will sum to get family income variables.
	JS had to combine some categories to make them consistent across years*/;
	rename wsal_val p_inc_ws;			/* wsal_val = ern_val if ern_srce==1, plus ws_val */;
	rename semp_val p_inc_se;			/* semp_val = ern_val if ern_srce==2, plus se_val */;
	*EK thinks should use frse_val instead of frm_val;
	*rename frm_val p_inc_fr;			
	rename frse_val p_inc_fr;			/* frse_val = ern_val if ern_srce==3, plus frm_val */;
	
	/*EK notes: we don't have p_inc_uc, p_inc_wc and p_inc_vt prior to 1989*/;
	gen p_inc_vet = uc_val + wc_val + vet_val;
	rename uc_val p_inc_uc;
	rename i_ucval p_inc_flag_uc;		/* EK added this since needed */;
	rename wc_val p_inc_wc;
	rename vet_val p_inc_vt;
	
	rename ssi_val p_inc_sp;
	rename i_ssival p_inc_flag_sp; 		/* EK added this since needed */;
	rename ss_val p_inc_ss;
	rename paw_val p_inc_pa;
	rename i_pawval p_inc_flag_pa;		/* EK added this since needed */;
	rename dsab_val p_inc_dis;			/* dsab_val = dis_val1 + dis_val2 */;
	rename dis_val1 p_inc_di1;
	rename dis_val2 p_inc_di2;
	rename rtm_val p_inc_ret;			/* rtm_val = ret_val1 + ret_val2 */;
	

	gen p_inc_asset = rnt_val + div_val + int_val;
	gen p_inc_divrnt = rnt_val + div_val;
	rename rnt_val p_inc_rnt;
	rename div_val p_inc_div;
	rename int_val p_inc_val;
	
	/*EK notes: we don't have p_inc_csp, p_inc_alm, p_inc_fin, p_inc_oi, p_inc_ed prior to 1989.
	Also, we don't have p_inc_su1 and p_inc_su2 prior to 1989, nor p_inc_sur. I include it with other 
	income since this variable represents survivors' benefits other than Social Security income */;
	gen p_inc_cs = csp_val + alm_val + ed_val + fin_val + oi_val + srvs_val;
	rename csp_val p_inc_csp;
	rename alm_val p_inc_alm;
	rename ed_val p_inc_ed;
	rename fin_val p_inc_fin;
	rename oi_val p_inc_oi;
	rename srvs_val p_inc_sur; 			/* srvs_val = sur_val1 + sur_val2 */;
	rename sur_val1 p_inc_su1;
	rename sur_val2 p_inc_su2;
	
	/*Totals */;
	rename ptotval p_inc_tot;   		/* ptotval = pearnval + pothval */;    
	rename pearnval p_inc_earn;			/* pearnval = wsal_val + semp_val + frse_val */;
	rename pothval p_inc_oth;			/* pothval =  ptotval - pearnval */;
	compress;

	** MB new health variables;
	** note that IPUMS suggests this group health and last time group health are not exactly comparable;
	*** next 4 are recodes;
	rename cov_gh p_cov_gh;
	rename cov_hi p_cov_hi;
	rename ch_mc p_ch_mc;
	rename ch_hi p_ch_hi;
	*** Note some recodes don't quite always match ch_mc;
	rename mcare p_care;
	rename mcaid p_caid;
	rename champ p_champ;
	** chip only shows up 2001 on;
	capture rename pchip p_chip;
	*** edited yn is private plan (0 niu) for **that person**;
    	rename hi_yn p_hi_yn;
	rename hiemp p_hiemp;
	* MB end;
	
	*EK adds;
	rename i_caid p_flag_caid;
	*EK ends;

	*EK comments out;
	/*;
	* MB new citizenship starts in 95;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	* MB end;
	*/;
	*EK ends commenting out;
	
	*EK adds this code from the lateryears_recode_immig.do file;
	* MB new citizenship starts in 94;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	** new 6/2011;
	gen p_peinusyr = .;
	capture replace p_peinusyr = peinusyr if peinusyr<.;
	gen p_penatvty = .;
	capture replace p_penatvty = penatvty if penatvty<.;
	gen p_pefntvty = .;
	capture replace p_pefntvty = pefntvty if pefntvty<.;
	gen p_pemntvty = .;
	capture replace p_pemntvty = pemntvty if pemntvty<.;
	* MB end;
	*EK ends;

	* MB new alt poverty individual;
	rename emcontrb p_emcontrb;
	rename fed_ret p_fed_ret;
	rename fed_tax p_fed_tax;
	rename statetax p_statetax;
	rename eit_cred p_eit_cred;
	rename fica p_fica;
	rename ted_val p_ted_val;

	*** leaving out capital gains;

	* MB has added some variables to this;
	keep year h_seq h_pos h_numpers h_numfam statefip h_smsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_tanftranscc h_tanftred h_wicyn 
		h_numwic h_flag_fsval h_ucval h_ssival filestat f_* p_* ;
	save `marcps20`n'', replace;
};

/***********************************************/
/*04*/
/* have to read in after tax variables separately */
/***********************************************/
*** read in after tax variables;
*** Note from Table 3 in Appendix C of technical doc;
*** www.census.gov/aspd/techdoc/cps/cpsmar04.pdf;
*** total unites 98979 but only 79549 records;
*** merge with HH 21830 not interviewed (in this tax/transfer not in using);
*** this is number of 2s below in merge;
quietly infile using "cpsmar04taxtransferhh.dct", using("04aftertax/hhext04.dat") clear;
su;
** note that housret is 0 for all obs in this data file;
** drop it, merge in from othersource;
assert housret==0;
drop housret;
sort h_seq hhpos;
save tmp-04-merge-hh, replace;
quietly infile using "cpsmar04taxtransferff.dct", using("04aftertax/ffext04.dat") clear;
su;
sort fh_seq ffpos;
save tmp-04-merge-ff, replace;
quietly infile using "cpsmar04taxtransferpp.dct", using("04aftertax/ppext04.dat") clear;
su;
sort ph_seq pppos;
save tmp-04-merge-pp, replace;

*** 2004 housret;
*** at http://www.census.gov/housing/asec_2004_housret_extract.dat;
qui infile using "cpsmar04housrethh.dct", using ("04aftertax/asec_2004_housret_extract.dat") clear;
su;
sort h_seq;
save tmp-04-housret-merge-hh, replace;


#delimit ;
clear;
foreach n in 04 {;
	di "";
	di "THIS IS YEAR `n'";
	di "";
	use cpsmar`n';
	tempfile marcps20`n';
	gen year = 20`n';

	*** MB ;
	*** merge in various files for taxes/estimated value of transfers;

	** HH tax items;
	*** see that they are all 0 here;
	su hfdval prop_tax housret;
	*** now drop things that are in new file;
	drop hfdval prop_tax housret;

	sort h_seq hhpos;
	merge h_seq hhpos using tmp-04-merge-hh, update;
	tab _merge;
	*** Note from Table 3 in Appendix C of technical doc;
	*** www.census.gov/aspd/techdoc/cps/cpsmar04.pdf;
	*** total unites 98979 but only 79549 records;
	*** merge with HH 21830 not interviewed (in this tax/transfer not in using);
	*** this is number of 2s below in merge;
	drop if _merge!=3;
	drop _merge;

	** MB ;
	** merge in housing return on equity;
	sort h_seq;
	merge h_seq using tmp-04-housret-merge-hh, update;
	tab _merge;
	drop if _merge!=3;
	drop _merge;

	** family tax items;
	** see that they are all 0;
	su f_mv_fs f_mv_sl ffngcaid ffngcare ffoodreq fhousreq fhoussub;
	** drop them;
	drop f_mv_fs f_mv_sl ffngcaid ffngcare ffoodreq fhousreq fhoussub;

	sort fh_seq ffpos;
	merge fh_seq ffpos using tmp-04-merge-ff, update;
	tab _merge;
	** fhousret in after tax file should really be fhousreq;
	rename fhousret fhousreq;

	drop if _merge!=3 ;
	drop _merge;

	** person tax items;
	** see that they are 0;
	su agi cap_gain cap_loss dep_stat eit_cred emcontrb fed_ret fed_tax fica filestat marg_tax 
		p_mvcaid p_mvcare statetax tax_inc;
	** drop them;
	drop agi cap_gain cap_loss dep_stat eit_cred emcontrb fed_ret fed_tax filestat fica marg_tax 
		p_mvcaid p_mvcare statetax tax_inc;
	sort ph_seq pppos;
	merge ph_seq pppos using tmp-04-merge-pp, update;
	tab _merge;
	drop if _merge!=3;
	drop _merge;

	*** see if variables are now non zero;
	*** that should all be nonzero;
	su hfdval prop_tax housret;
	su f_mv_fs f_mv_sl ffngcaid ffngcare ffoodreq fhousreq fhoussub;
	su agi cap_gain cap_loss dep_stat eit_cred emcontrb fed_ret fed_tax fica filestat marg_tax 
		p_mvcaid p_mvcare statetax tax_inc;

	/*Household variables*/
	rename hhpos h_pos;
	rename h_numper h_numpers;
	rename hnumfam h_numfam;

	* MB moved some text below;

	/*geographic*/
	rename hg_st60 h_state;
	recode h_state (11 = 23) (12 = 33) (13 = 50) (14 = 25) (15 = 44) (16 = 9) (21 = 36) (22 = 34) 
	       (23 = 42) (31 = 39) (32 = 18) (33 = 17) (34 = 26) (35 = 55) (41 = 27) (42 = 19) (43 = 29) 
	       (44 = 38) (45 = 46) (46 = 31) (47 = 20) (51 = 10) (52 = 24) (53 = 11) (54 = 51) (55 = 54) 
	       (56 = 37) (57 = 45) (58 = 13) (59 = 12) (61 = 21) (62 = 47) (63 = 1) (64 = 28) (71 = 5) 
	       (72 = 22) (73 = 40) (74 = 48) (81 = 30) (82 = 16) (83 = 56) (84 = 8) (85 = 35) (86 = 4) 
	       (87 = 49) (88 = 32) (91 = 53) (92 = 41) (93 = 6) (94 = 2) (95 = 15);
    rename h_state statefip;
    rename hg_msac h_smsa;

    rename hpublic h_public;
    rename hlorent h_rentsub;
    rename hfoodsp h_foodstp;
    rename hfoodno h_fsnum;
    rename hfoodmo h_fsmo;
    rename hfdval h_fsval;
       
    *EK adds the following variables;
	rename i_hfdval h_flag_fsval;
	rename hucval h_ucval;
	rename hssival h_ssival;
	*EK ends;   

	** MB add free lunch/energy assistance/health;
	rename hhotlun  h_hhotlun;
	rename hhotno h_numhot;
	rename hflunch  h_freelun;
	rename hflunno h_numfree;
	rename htotval  h_hhinctot;
	rename hengast h_enrgyas;
	rename hengval h_enrgyva;
	rename hmcare h_mcare;
	rename hmcaid h_mcaid;
	rename hchamp h_champ;
	rename hhi_yn h_hhiyn;
	* MB end;

	** MB adds HH alt pov;
	rename prop_tax h_prop_tax;
	rename housret h_housret;
	* MB end;

	** MB adds WIC and new TANF from 01 on (new TANF end in 09 survey);
	** combine transportation assistance and child care;
	** 01-09;
	gen h_tanftranscc = .;
	capture replace h_tanftranscc = hrtayn==1 | hrccayn==1 if hrtayn<.;
	** combine community service job club job resource job readiness job training or GED classes;
	gen h_tanftred = .;
	capture replace h_tanftred = hrcmsryn==1 | hrjcyn==1 | hrjryn==1 | hrjtyn==1 | (hrnumsc>=1 & hrnumsc<.) if hrcmsryn<.;
	*** check;
	if "`n'"!="00" {;
		di "checking on TANF recodes";
		di "tab hrtayn hrccayn, su(h_tanftranscc) missing";
		tab hrtayn hrccayn, su(h_tanftranscc) missing;
		di "for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: tab h_tanftred X, missing";
		for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: tab h_tanftred X, missing;
		di "for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: su X if h_tanftred==0";
		for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: su X if h_tanftred==0;
		};
	gen h_numwic=.;
	capture replace h_numwic= hrnumwic;
	gen h_wicyn=.;
	capture replace h_wicyn= hrwicyn;
	* MB end;
	rename hsup_wgt h_weight;

	/*Family variables*/
	rename fh_seq f_seq;
	rename ffpos f_pos;

	*** MB change;
	***  89 on is change in name, family type called fkind and vice verse;
	*** use name consistent with 80-88 data;
	*** used to say rename fkind f_kind and similarly for f_type;
	rename fkind f_kind;
	* MB end;

	rename fpersons f_numpers;
	rename fheadidx f_headinx;
	rename famlis f_famlis;

	** MB;
	*** 89 on is change in name, family type called fkind and vice verse;
	*** 1 primary family 2 primary individual 3 related subfamily 4 unrelated subfamily 5 secondary individual;
	*** note ordering of categories also different from previous;
	rename ftype f_type;
	* MB end;

	/*Comment out all these CPS family variables since we don't use them*/;
	/* MB uncomments some */;
	/*;
	rename fwsval f_inc_ws;
	rename fseval f_inc_se;
	rename ffrval f_inc_fr;
	rename fucval f_inc_uc;
	rename fwcval f_inc_wc;
	rename fssval f_inc_ss;
	rename fssival f_inc_ssi;
	rename fpawval f_inc_pa;
	rename fvetval f_inc_v;
	rename fsurval f_inc_sur;
	rename fdisval f_inc_dis;
	rename fretval f_inc_ret;
	rename fintval f_inc_int;
	rename fdivval f_inc_div;
	rename frntval f_inc_rnt;
	rename fedval f_inc_ed;
	rename fcspval f_inc_csp;
	rename falmval f_inc_alm;
	rename ffinval f_inc_fin;
	rename foival f_inc_oi;
	rename ftotval f_inc_tot;
	rename fearnval f_inc_earn;
	rename fothval f_inc_oth;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename famlis f_famlis;
	rename fownu18 f_childu18;
	*/;

	** MB puts back;
	rename ftotval f_inc_tot;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename frsppct f_rsublowinc;
	* MB end;

	* MB adds new alt pov variables;
	* f_mv_fs and f_mv_sl are already named ok;
	rename ffngcare f_fngcare;
	rename ffngcaid f_fngcaid;
	rename fhoussub f_houssub;
	*MB end;

	/*Personal variables*/
	rename ph_seq p_seq;
    rename pppos p_pos;
    rename a_age p_age;
    rename a_maritl p_marst;
    rename a_sex p_sex;
    rename a_hga p_educ;
    rename prdtrace p_race;
    rename pehspnon p_ethnicity;
    rename marsupwt p_marwt;
    rename clwk p_cow2;
    rename wkswork p_weeks;
    rename hrswk p_ushrs;
    rename a_exprrp p_relhd;
    rename a_lfsr p_esr;
    rename a_wkstat p_ftpt;			/*EK changes this from rename a_ftlf p_ftpt*/;
    rename a_untype p_untype;
    rename nwlkwk p_wkslk;
       
    *EK adds the followings for improving our EITC denominators;
	rename pemlr p_lfr;			/*major labor force recode*/;
	gen p_vet_dis= vet_typ1==1; /*reason for veteran comp is disability*/
	gen p_ss_dis = resnss1==2 | resnss2==2;	/*reason for SS is disability*/;
	gen p_ssi_dis = resnssi1==2 | resnssi2==2;	/*reason for SSI is disability*/;
	*EK ends;
  	
	*EK adds industry and occupation codes, as well as reason for NiLF/school variables;
	*Notes: Beginning in January 2003, the CPS began using the North American Industry Classification
	System (NAICS) based on the Census 2000 industry and occupation codes. PEIOIND AND PEIOOCC 
	replace A-IND and A-OCC on the file;
	rename peioind p_ind;		/*industry code*/;
	rename peioocc p_occ;		/*occupation code*/;
	rename prnlfsch p_rea_nlf_sc;	/*reason not in labor force is school*/;
	rename a_enrlw p_attend;	/* high school/college attendance*/;
	rename a_ftpt p_ftpt_st;	/*full/part time school enrollment*/;
	*EK end;

	*** MB adds a_famtyp and a_famrel from individual records ;
	rename a_famtyp p_famtyp;
	rename a_famrel p_famrel;
	* MB end;
	
	*EK adds identifier for parent of each individual;
	rename a_parent p_parentline;
	*EK ends;

	*** MB adds self-rated health 96-10;
	rename hea p_srhealth;
	* MB end;

	/*Individual income variables that we will sum to get family income variables.
	JS had to combine some categories to make them consistent across years*/;
	rename wsal_val p_inc_ws;			/* wsal_val = ern_val if ern_srce==1, plus ws_val */;
	rename semp_val p_inc_se;			/* semp_val = ern_val if ern_srce==2, plus se_val */;
	*EK thinks should use frse_val instead of frm_val;
	*rename frm_val p_inc_fr;			
	rename frse_val p_inc_fr;			/* frse_val = ern_val if ern_srce==3, plus frm_val */;
	
	/*EK notes: we don't have p_inc_uc, p_inc_wc and p_inc_vt prior to 1989*/;
	gen p_inc_vet = uc_val + wc_val + vet_val;
	rename uc_val p_inc_uc;
	rename i_ucval p_inc_flag_uc;		/* EK added this since needed */;
	rename wc_val p_inc_wc;
	rename vet_val p_inc_vt;
	
	rename ssi_val p_inc_sp;
	rename i_ssival p_inc_flag_sp; 		/* EK added this since needed */;
	rename ss_val p_inc_ss;
	rename paw_val p_inc_pa;
	rename i_pawval p_inc_flag_pa;		/* EK added this since needed */;
	rename dsab_val p_inc_dis;			/* dsab_val = dis_val1 + dis_val2 */;
	rename dis_val1 p_inc_di1;
	rename dis_val2 p_inc_di2;
	rename rtm_val p_inc_ret;			/* rtm_val = ret_val1 + ret_val2 */;
	
	gen p_inc_asset = rnt_val + div_val + int_val;
	gen p_inc_divrnt = rnt_val + div_val;
	rename rnt_val p_inc_rnt;
	rename div_val p_inc_div;
	rename int_val p_inc_val;
	
	/*EK notes: we don't have p_inc_csp, p_inc_alm, p_inc_fin, p_inc_oi, p_inc_ed prior to 1989.
	Also, we don't have p_inc_su1 and p_inc_su2 prior to 1989, nor p_inc_sur. I include it with other 
	income since this variable represents survivors' benefits other than Social Security income */;
	gen p_inc_cs = csp_val + alm_val + ed_val + fin_val + oi_val + srvs_val;
	rename csp_val p_inc_csp;
	rename alm_val p_inc_alm;
	rename ed_val p_inc_ed;
	rename fin_val p_inc_fin;
	rename oi_val p_inc_oi;
	rename srvs_val p_inc_sur; 			/* srvs_val = sur_val1 + sur_val2 */;
	rename sur_val1 p_inc_su1;
	rename sur_val2 p_inc_su2;
	
	/*Totals */;
	rename ptotval p_inc_tot;   		/* ptotval = pearnval + pothval */;    
	rename pearnval p_inc_earn;			/* pearnval = wsal_val + semp_val + frse_val */;
	rename pothval p_inc_oth;			/* pothval =  ptotval - pearnval */;
	compress;

	** MB new health variables;
	** note that IPUMS suggests this group health and last time group health are not exactly comparable;
	*** next 4 are recodes;
	rename cov_gh p_cov_gh;
	rename cov_hi p_cov_hi;
	rename ch_mc p_ch_mc;
	rename ch_hi p_ch_hi;
	*** Note some recodes don't quite always match ch_mc;
	rename mcare p_care;
	rename mcaid p_caid;
	rename champ p_champ;
	** chip only shows up 2001 on;
	capture rename pchip p_chip;
	*** edited yn is private plan (0 niu) for **that person**;
    	rename hi_yn p_hi_yn;
	rename hiemp p_hiemp;
	* MB end;
	
	*EK adds;
	rename i_caid p_flag_caid;
	*EK ends;

	*EK comments out;
	/*;
	* MB new citizenship starts in 95;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	* MB end;
	*/;
	*EK ends commenting out;
	
	*EK adds this code from the lateryears_recode_immig.do file;
	* MB new citizenship starts in 94;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	** new 6/2011;
	gen p_peinusyr = .;
	capture replace p_peinusyr = peinusyr if peinusyr<.;
	gen p_penatvty = .;
	capture replace p_penatvty = penatvty if penatvty<.;
	gen p_pefntvty = .;
	capture replace p_pefntvty = pefntvty if pefntvty<.;
	gen p_pemntvty = .;
	capture replace p_pemntvty = pemntvty if pemntvty<.;
	* MB end;
	*EK ends;

	* MB new alt poverty individual;
	rename emcontrb p_emcontrb;
	rename fed_ret p_fed_ret;
	rename fed_tax p_fed_tax;
	rename statetax p_statetax;
	rename eit_cred p_eit_cred;
	rename fica p_fica;
	rename ted_val p_ted_val;

	*** leaving out capital gains;

	* MB has added some variables to this;
	keep year h_seq h_pos h_numpers h_numfam statefip h_smsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_tanftranscc h_tanftred h_wicyn 
		h_numwic h_flag_fsval h_ucval h_ssival filestat f_* p_* ;
	save `marcps20`n'', replace;
};

/***********************************************/;
/*05-09*/;
/***********************************************/;
#delimit ;
clear;
foreach n in 05 06 07 08 09 {;
	di "";
	di "THIS IS YEAR `n'";
	di "";
	use cpsmar`n';
	tempfile marcps20`n';
	gen year = 20`n';

	/*Household Variables*/;
	** rename to match 77-88;
	rename hhpos h_pos;
	rename h_numper h_numpers;
	rename hnumfam h_numfam;


	/*geographic*/;
	** Note change in geographic concepts in 05;
	rename gestfips statefip;
	rename gtcbsa h_cbsa;

	rename hpublic h_public;
	rename hlorent h_rentsub;
	rename hfoodsp h_foodstp;
	rename hfoodno h_fsnum;
	rename hfoodmo h_fsmo;
	rename hfdval h_fsval;
	
	*EK adds the following variables;
	rename i_hfdval h_flag_fsval;
	rename hucval h_ucval;
	rename hssival h_ssival;
	*EK ends;

	** MB add free lunch/energy assistance/health;
	rename hhotlun  h_hhotlun;
	rename hhotno h_numhot;
	rename hflunch  h_freelun;
	rename hflunno h_numfree;
	rename htotval  h_hhinctot;
	rename hengast h_enrgyas;	
	rename hengval h_enrgyva;
	rename hmcare h_mcare;
	rename hmcaid h_mcaid;
	rename hchamp h_champ;
	rename hhi_yn h_hhiyn;
	* MB end;

	** MB adds HH alt pov;
	rename prop_tax h_prop_tax;
	rename housret h_housret;
	* MB end;

	** MB adds WIC and new TANF from 01 on (new TANF end in 09 survey);
	** combine transportation assistance and child care;
	** 01-09;
	gen h_tanftranscc = hrtayn==1 | hrccayn==1 if hrtayn<.;
	** combine community service job club job resource job readiness job training or GED classes;
	gen h_tanftred = hrcmsryn==1 | hrjcyn==1 | hrjryn==1 | hrjtyn==1 | (hrnumsc>=1 & hrnumsc<.) if hrcmsryn<.;
	*** check;
	tab hrtayn hrccayn, su(h_tanftranscc) missing;
	for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: tab h_tanftred X, missing;
	for any hrcmsryn hrjcyn hrjryn hrjtyn hrnumsc: tab X if h_tanftred==0;

	rename hrnumwic h_numwic;
	rename hrwicyn h_wicyn;
	* MB end;

	rename hsup_wgt h_weight;

	/*Family variables*/;
	rename fh_seq f_seq;
	rename ffpos f_pos;

	*** MB change;
	***  89 on is change in name, family type called fkind and vice verse;
	*** use name consistent with 80-88 data;
	*** used to say rename fkind f_kind and similarly for f_type;
	rename fkind f_kind;
	* MB end;

	rename fpersons f_numpers;
	rename fheadidx f_headinx;
	rename famlis f_famlis;

	** MB;
	*** 89 on is change in name, family type called fkind and vice verse;
	*** 1 primary family 2 primary individual 3 related subfamily 4 unrelated subfamily 5 secondary individual;
	*** note ordering of categories also different from previous;
	rename ftype f_type;
	* MB end;

	/*Comment out all these CPS family variables since we don't use them*/;
	/* MB uncomments some at bottom */;
	/*;
	rename fwsval f_inc_ws;
	rename fseval f_inc_se;
	rename ffrval f_inc_fr;
	rename fucval f_inc_uc;
	rename fwcval f_inc_wc;
	rename fssval f_inc_ss;
	rename fssival f_inc_ssi;
	rename fpawval f_inc_pa;
	rename fvetval f_inc_v;
	rename fsurval f_inc_sur;
	rename fdisval f_inc_dis;
	rename fretval f_inc_ret;
	rename fintval f_inc_int;
	rename fdivval f_inc_div;
	rename frntval f_inc_rnt;
	rename fedval f_inc_ed;
	rename fcspval f_inc_csp;
	rename falmval f_inc_alm;
	rename ffinval f_inc_fin;
	rename foival f_inc_oi;
	rename ftotval f_inc_tot;
	rename fearnval f_inc_earn;
	rename fothval f_inc_oth;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename famlis f_famlis;
	rename fownu18 f_childu18;
	*/;
	
	*** MB puts back;
	rename ftotval f_inc_tot;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename frsppct f_rsublowinc;
	* MB end;

	* MB adds new alt pov variables;
	* f_mv_fs and f_mv_sl are already named ok;
	rename ffngcare f_fngcare;
	rename ffngcaid f_fngcaid;
	rename fhoussub f_houssub;
	*MB end;


	/*Person variables*/;
	rename ph_seq p_seq;
	rename pppos p_pos;
	rename a_age p_age;
	rename a_maritl p_marst;
	rename a_sex p_sex;
	rename a_hga p_educ;
	rename prdtrace p_race;
	rename pehspnon p_ethnicity;
	rename marsupwt p_marwt;
	rename a_wkstat p_ftpt;
	rename clwk p_cow2;
	rename wkswork p_weeks;
	rename hrswk p_ushrs;
	
	*EK adds the followings for improving our EITC denominators;
	rename pemlr p_lfr;			/*major labor force recode*/;
	gen p_vet_dis= vet_typ1==1; /*reason for veteran comp is disability*/
	gen p_ss_dis = resnss1==2 | resnss2==2;	/*reason for SS is disability*/;
	gen p_ssi_dis = resnssi1==2 | resnssi2==2;	/*reason for SSI is disability*/;
	*EK ends;

	* MB add;
	rename a_exprrp p_relhd;
	* MB end;

	rename a_lfsr p_esr;
	rename a_untype p_untype;
	rename a_wkslk p_wkslk;
		
	*EK adds industry and occupation codes, as well as reason for NiLF/school variables;
	*Notes: Beginning in January 2003, the CPS began using the North American Industry Classification
	System (NAICS) based on the Census 2000 industry and occupation codes. PEIOIND AND PEIOOCC 
	replace A-IND and A-OCC on the file;
	rename peioind p_ind;		/*industry code*/;
	rename peioocc p_occ;		/*occupation code*/;
	rename prnlfsch p_rea_nlf_sc;	/*reason not in labor force is school*/;
	rename a_enrlw p_attend;	/* high school/college attendance*/;
	rename a_ftpt p_ftpt_st;	/*full/part time school enrollment*/;
	*EK end;
	
	*** MB adds a_famtyp and a_famrel from individual records ;
	rename a_famtyp p_famtyp;
	rename a_famrel p_famrel;
	* MB end;
	
	*EK adds identifier for parent of each individual;
	rename a_parent p_parentline;
	*EK ends;

	* MB change name of before credit federal tax to match earlier years;
	** see if have appropriate credits;
	di "check if fedtax_bc -crdits = fedtax_ac";
	gen fedtax_mb = fedtax_bc - eit_cred - ctc_crd - actc_crd;
	reg fedtax_mb fedtax_ac;
	rename fedtax_bc fed_tax;
	rename statetax_bc statetax;
	* MB end;
	
	*EK thinks the paragraph above is wrong;
	di "EK: check if fedtax_bc - crdits = fedtax_ac";
	gen fedtax_ek = fed_tax - eit_cred - actc_crd;  	/* no - ctc_crd */;
	reg fedtax_ek fedtax_ac;
	*EK end;

	*** MB adds self-rated health 96-10;
	rename hea p_srhealth;
	* MB end;

	* MB adds stimulus for 2009, another after tax field;
	capture rename stimulus p_stimulus;

	/*Individual income variables that we will sum to get family income variables.
	JS had to combine some categories to make them consistent across years*/;
	rename wsal_val p_inc_ws;			/* wsal_val = ern_val if ern_srce==1, plus ws_val */;
	rename semp_val p_inc_se;			/* semp_val = ern_val if ern_srce==2, plus se_val */;
	*EK thinks should use frse_val instead of frm_val;
	*rename frm_val p_inc_fr;			
	rename frse_val p_inc_fr;			/* frse_val = ern_val if ern_srce==3, plus frm_val */;
	
	/*EK notes: we don't have p_inc_uc, p_inc_wc and p_inc_vt prior to 1989*/;
	gen p_inc_vet = uc_val + wc_val + vet_val;
	rename uc_val p_inc_uc;
	rename i_ucval p_inc_flag_uc;		/* EK added this since needed */;
	rename wc_val p_inc_wc;
	rename vet_val p_inc_vt;
	
	rename ssi_val p_inc_sp;
	rename i_ssival p_inc_flag_sp; 		/* EK added this since needed */;
	rename ss_val p_inc_ss;
	rename paw_val p_inc_pa;
	rename i_pawval p_inc_flag_pa;		/* EK added this since needed */;
	rename dsab_val p_inc_dis;			/* dsab_val = dis_val1 + dis_val2 */;
	rename dis_val1 p_inc_di1;
	rename dis_val2 p_inc_di2;
	rename rtm_val p_inc_ret;			/* rtm_val = ret_val1 + ret_val2 */;

	gen p_inc_asset = rnt_val + div_val + int_val;
	gen p_inc_divrnt = rnt_val + div_val;	/*EK: this is the variable we have pre-89 */;
	rename rnt_val p_inc_rnt;
	rename div_val p_inc_div;
	rename int_val p_inc_val;
	
	/*EK notes: we don't have p_inc_csp, p_inc_alm, p_inc_fin, p_inc_oi, p_inc_ed prior to 1989.
	Also, we don't have p_inc_su1 and p_inc_su2 prior to 1989, nor p_inc_sur. I include it with other 
	income since this variable represents survivors' benefits other than Social Security income */;
	gen p_inc_cs = csp_val + alm_val + ed_val + fin_val + oi_val + srvs_val;
	rename csp_val p_inc_csp;
	rename alm_val p_inc_alm;
	rename ed_val p_inc_ed;
	rename fin_val p_inc_fin;
	rename oi_val p_inc_oi;
	rename srvs_val p_inc_sur; 			/* srvs_val = sur_val1 + sur_val2 */;
	rename sur_val1 p_inc_su1;
	rename sur_val2 p_inc_su2;
	
	/*Totals */;
	rename ptotval p_inc_tot;   		/* ptotval = pearnval + pothval */;    
	rename pearnval p_inc_earn;			/* pearnval = wsal_val + semp_val + frse_val */;
	rename pothval p_inc_oth;			/* pothval =  ptotval - pearnval */;

	** MB new health variables;
	** note that IPUMS suggests this group health and last time group health are not exactly comparable;
	*** next 4 are recodes;
	rename cov_gh p_cov_gh;
	rename cov_hi p_cov_hi;
	rename ch_mc p_ch_mc;
	rename ch_hi p_ch_hi;
	*** Note some recodes don't quite always match ch_mc;
	rename mcare p_care;
	rename mcaid p_caid;
	rename champ p_champ;
	rename pchip p_chip;
	*** edited yn is private plan (0 niu) for **that person**;
	rename hi_yn p_hi_yn;
	rename hiemp p_hiemp;
	* MB end;
	
	*EK adds;
	rename i_caid p_flag_caid;
	*EK ends;

	*EK comments out;
	/*;
	* MB new citizenship starts in 95;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	* MB end;
	*/;
	*EK ends commenting out;
	
	*EK adds this code from the lateryears_recode_immig.do file;
	* MB new citizenship starts in 94;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	** new 6/2011;
	gen p_peinusyr = .;
	capture replace p_peinusyr = peinusyr if peinusyr<.;
	gen p_penatvty = .;
	capture replace p_penatvty = penatvty if penatvty<.;
	gen p_pefntvty = .;
	capture replace p_pefntvty = pefntvty if pefntvty<.;
	gen p_pemntvty = .;
	capture replace p_pemntvty = pemntvty if pemntvty<.;
	* MB end;
	*EK ends;

	* MB new alt poverty individual;
	rename emcontrb p_emcontrb;
	rename fed_ret p_fed_ret;
	rename fed_tax p_fed_tax;
	rename statetax p_statetax;
	rename eit_cred p_eit_cred;
	rename actc_crd p_actc_crd;
	rename ctc_crd p_ctc_crd;
	rename fica p_fica;
	rename ted_val p_ted_val;
	*** leaving out capital gains;

	compress;

	* MB has added some variables to this;
	keep year h_seq h_pos h_numpers h_numfam statefip h_cbsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_tanftranscc h_tanftred h_wicyn 
		h_numwic h_flag_fsval h_ucval h_ssival filestat f_* p_* ;
	save `marcps20`n'', replace;
	};


/***********************************************/;
/*10 11 12 13 14 14R 15 16 17*/;
/***********************************************/;
#delimit ;
clear;
foreach n in 10 11 12 13 14 14r 15 16 17 {;
	di "";
	di "THIS IS YEAR `n'";
	di "";
	use cpsmar`n';
	tempfile marcps20`n';
	if "`n'" != "14r" {;
		gen year = 20`n';
	};
	if "`n'" == "14r" {;
		gen year = 2014;
		gen redesigned = 1;
	};

	/*Household Variables*/;
	** rename to match 77-88;
	rename hhpos h_pos;
	rename h_numper h_numpers;
	rename hnumfam h_numfam;


	/*geographic*/;
	** Note change in geographic concepts in 05;
	rename gestfips statefip;
	rename gtcbsa h_cbsa;

	rename hpublic h_public;
	rename hlorent h_rentsub;
	rename hfoodsp h_foodstp;
	rename hfoodno h_fsnum;
	rename hfoodmo h_fsmo;
	rename hfdval h_fsval;
	
	*EK adds the following variables;
	rename i_hfdval h_flag_fsval;
	rename hucval h_ucval;
	rename hssival h_ssival;
	*EK ends;

	** MB add free lunch/energy assistance/health;
	rename hhotlun  h_hhotlun;
	rename hhotno h_numhot;
	rename hflunch  h_freelun;
	rename hflunno h_numfree;
	rename htotval  h_hhinctot;
	rename hengast h_enrgyas;	
	rename hengval h_enrgyva;
	rename hmcare h_mcare;
	rename hmcaid h_mcaid;
	rename hchamp h_champ;
	rename hhi_yn h_hhiyn;
	* MB end;


	** MB adds HH alt pov;
	rename prop_tax h_prop_tax;
	rename housret h_housret;
	* MB end;

	** MB adds WIC from 01 on (new TANF end in 09 survey);

	rename hrnumwic h_numwic;
	rename hrwicyn h_wicyn;
	* MB end;

	rename hsup_wgt h_weight;

	/*Family variables*/;
	rename fh_seq f_seq;
	rename ffpos f_pos;

	*** MB change;
	***  89 on is change in name, family type called fkind and vice verse;
	*** use name consistent with 80-88 data;
	*** used to say rename fkind f_kind and similarly for f_type;
	rename fkind f_kind;
	* MB end;

	rename fpersons f_numpers;
	rename fheadidx f_headinx;
	rename famlis f_famlis;

	** MB;
	*** 89 on is change in name, family type called fkind and vice verse;
	*** 1 primary family 2 primary individual 3 related subfamily 4 unrelated subfamily 5 secondary individual;
	*** note ordering of categories also different from previous;
	rename ftype f_type;
	* MB end;

	/*Comment out all these CPS family variables since we don't use them*/;
	/* MB uncomments some at bottom */;
	/*;
	rename fwsval f_inc_ws;
	rename fseval f_inc_se;
	rename ffrval f_inc_fr;
	rename fucval f_inc_uc;
	rename fwcval f_inc_wc;
	rename fssval f_inc_ss;
	rename fssival f_inc_ssi;
	rename fpawval f_inc_pa;
	rename fvetval f_inc_v;
	rename fsurval f_inc_sur;
	rename fdisval f_inc_dis;
	rename fretval f_inc_ret;
	rename fintval f_inc_int;
	rename fdivval f_inc_div;
	rename frntval f_inc_rnt;
	rename fedval f_inc_ed;
	rename fcspval f_inc_csp;
	rename falmval f_inc_alm;
	rename ffinval f_inc_fin;
	rename foival f_inc_oi;
	rename ftotval f_inc_tot;
	rename fearnval f_inc_earn;
	rename fothval f_inc_oth;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename famlis f_famlis;
	rename fownu18 f_childu18;
	*/;
	
	*** MB puts back;
	rename ftotval f_inc_tot;
	rename fsup_wgt f_famwgt;
	rename fpovcut f_lowinc;
	rename frsppct f_rsublowinc;
	* MB end;

	* MB adds new alt pov variables;
	* f_mv_fs and f_mv_sl are already named ok;
	* DC notes: FFNGCARE and FFNGCAID not available in CPS 2015;
	capture rename ffngcare f_fngcare;
	capture rename ffngcaid f_fngcaid;
	*DC ends;
	*KR: This variable changed to h_rentsub in 2017;
	cap rename fhoussub f_houssub;
	cap rename f_rentsub f_houssub;
	*MB end;


	/*Person variables*/;
	rename ph_seq p_seq;
	rename pppos p_pos;
	rename a_age p_age;
	rename a_maritl p_marst;
	rename a_sex p_sex;
	rename a_hga p_educ;
	rename prdtrace p_race;
	rename pehspnon p_ethnicity;
	rename marsupwt p_marwt;
	rename a_wkstat p_ftpt;  	/*full time status*/;
	rename clwk p_cow2;			/*longest job class of worker, recode*/;
	rename wkswork p_weeks;
	rename hrswk p_ushrs;
	
	*EK adds the followings for improving our EITC denominators;
	rename pemlr p_lfr;			/*major labor force recode*/;
	gen p_vet_dis= vet_typ1==1; /*reason for veteran comp is disability*/
	gen p_ss_dis = resnss1==2 | resnss2==2;	/*reason for SS is disability*/;
	gen p_ssi_dis = resnssi1==2 | resnssi2==2;	/*reason for SSI is disability*/;
	*EK ends;

	* MB add;
	rename a_exprrp p_relhd;	/*expanded relationship code*/;
	* MB end;

	rename a_lfsr p_esr;
	rename a_untype p_untype;	/*unemployment, reason*/;
	rename a_wkslk p_wkslk;		/*unemployment duration*/;
	
	*EK adds industry and occupation codes, as well as reason for NiLF/school variables;
	*Notes: Beginning in January 2003, the CPS began using the North American Industry Classification
	System (NAICS) based on the Census 2000 industry and occupation codes. PEIOIND AND PEIOOCC 
	replace A-IND and A-OCC on the file;
	rename peioind p_ind;		/*industry code*/;
	rename peioocc p_occ;		/*occupation code*/;
	rename prnlfsch p_rea_nlf_sc;	/*reason not in labor force is school*/;
	rename a_enrlw p_attend;	/* high school/college attendance*/;
	rename a_ftpt p_ftpt_st;	/*full/part time school enrollment*/;
	*EK end;
	
	*** MB adds a_famtyp and a_famrel from individual records ;
	rename a_famtyp p_famtyp;
	rename a_famrel p_famrel;
	* MB end;
	
	*EK adds identifier for parent of each individual;
	rename a_parent p_parentline;
	*EK ends;

	* MB change name of before credit federal tax to match earlier years;
	** see if have appropriate credits;
	di "check if fedtax_bc - crdits = fedtax_ac";
	gen fedtax_mb = fedtax_bc - eit_cred - ctc_crd - actc_crd;
	reg fedtax_mb fedtax_ac;
	rename fedtax_bc fed_tax;
	rename statetax_bc statetax;
	* MB end;
	
	*EK thinks the paragraph above is wrong;
	di "EK: check if fedtax_bc - crdits = fedtax_ac";
	gen fedtax_ek = fed_tax - eit_cred - actc_crd;  /* no - ctc_crd */;
	reg fedtax_ek fedtax_ac;
	*EK end;

	*** MB adds self-rated health 96-10;
	rename hea p_srhealth;
	* MB end;

	/*Individual income variables that we will sum to get family income variables.
	JS had to combine some categories to make them consistent across years*/;
	rename wsal_val p_inc_ws;			/* wsal_val = ern_val if ern_srce==1, plus ws_val */;
	rename semp_val p_inc_se;			/* semp_val = ern_val if ern_srce==2, plus se_val */;
	*EK thinks should use frse_val instead of frm_val;
	*rename frm_val p_inc_fr;			
	rename frse_val p_inc_fr;			/* frse_val = ern_val if ern_srce==3, plus frm_val */;
	
	/*EK notes: we don't have p_inc_uc, p_inc_wc and p_inc_vt prior to 1989*/;
	gen p_inc_vet = uc_val + wc_val + vet_val;
	rename uc_val p_inc_uc;
	rename i_ucval p_inc_flag_uc;		/* EK added this since needed */;
	rename wc_val p_inc_wc;
	rename vet_val p_inc_vt;
	
	rename ssi_val p_inc_sp;
	rename i_ssival p_inc_flag_sp; 		/* EK added this since needed */;
	rename ss_val p_inc_ss;
	rename paw_val p_inc_pa;
	rename i_pawval p_inc_flag_pa;		/* EK added this since needed */;
	rename dsab_val p_inc_dis;			/* dsab_val = dis_val1 + dis_val2 */;
	rename dis_val1 p_inc_di1;
	rename dis_val2 p_inc_di2;
	rename rtm_val p_inc_ret;			/* rtm_val = ret_val1 + ret_val2 */;
	
	gen p_inc_asset = rnt_val + div_val + int_val;
	gen p_inc_divrnt = rnt_val + div_val;	/*EK: this is the variable we have pre-89 */;
	rename rnt_val p_inc_rnt;
	rename div_val p_inc_div;
	rename int_val p_inc_val;
	
	/*EK notes: we don't have p_inc_csp, p_inc_alm, p_inc_fin, p_inc_oi, p_inc_ed prior to 1989.
	Also, we don't have p_inc_su1 and p_inc_su2 prior to 1989, nor p_inc_sur. I include it with other 
	income since this variable represents survivors' benefits other than Social Security income */;
	*DC/KR notes: don't have alm_val for CPS 2015 or 2016;
	capture gen p_inc_cs = csp_val + alm_val + ed_val + fin_val + oi_val + srvs_val;
	*DC ends;
	rename csp_val p_inc_csp;
	capture rename alm_val p_inc_alm;
	rename ed_val p_inc_ed;
	rename fin_val p_inc_fin;
	rename oi_val p_inc_oi;
	rename srvs_val p_inc_sur; 			/* srvs_val = sur_val1 + sur_val2 */;
	rename sur_val1 p_inc_su1;
	rename sur_val2 p_inc_su2;

	
	/*Totals */;
	rename ptotval p_inc_tot;   		/* ptotval = pearnval + pothval */;    
	rename pearnval p_inc_earn;			/* pearnval = wsal_val + semp_val + frse_val */;
	rename pothval p_inc_oth;			/* pothval =  ptotval - pearnval */;
	

	** MB new health variables;
	** note that IPUMS suggests this group health and last time group health are not exactly comparable;
	*** next 4 are recodes;
	rename cov_gh p_cov_gh;
	rename cov_hi p_cov_hi;
	rename ch_mc p_ch_mc;
	rename ch_hi p_ch_hi;
	*** Note some recodes don't quite always match ch_mc;
	rename mcare p_care;
	rename mcaid p_caid;
	rename champ p_champ;
	rename pchip p_chip;
	*** edited yn is private plan (0 niu) for **that person**;
	rename hi_yn p_hi_yn;
	rename hiemp p_hiemp;
	* MB end;
	
	*EK adds;
	rename i_caid p_flag_caid;
	*EK ends;

	*EK comments out;
	/*;
	* MB new citizenship starts in 95;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	* MB end;
	*/;
	*EK ends commenting out;
	
	*EK adds this code from the lateryears_recode_immig.do file;
	* MB new citizenship starts in 94;
	gen p_prcitshp = .;
	capture replace p_prcitshp= prcitshp if prcitshp<.;
	** new 6/2011;
	gen p_peinusyr = .;
	capture replace p_peinusyr = peinusyr if peinusyr<.;
	gen p_penatvty = .;
	capture replace p_penatvty = penatvty if penatvty<.;
	gen p_pefntvty = .;
	capture replace p_pefntvty = pefntvty if pefntvty<.;
	gen p_pemntvty = .;
	capture replace p_pemntvty = pemntvty if pemntvty<.;
	* MB end;
	*EK ends;

	* MB new alt poverty individual;
	rename emcontrb p_emcontrb;
	rename fed_ret p_fed_ret;
	rename fed_tax p_fed_tax;
	rename statetax p_statetax;
	rename eit_cred p_eit_cred;
	rename actc_crd p_actc_crd;
	rename ctc_crd p_ctc_crd;
	rename fica p_fica;
	rename ted_val p_ted_val;
	*** Cap gains not collected for 2010;
	
	*EK adds make work pay credit (for cps 2010-2011) and ERP value (cps 2010);
	*DC adds condition that year!=14r (string);
	if "`n'"!="14r" {;
		if `n'==11 | `n'==10 rename mwp_val p_mwp_cred;
		if `n'==10 rename erp_val p_erp_cred;
	};
	*DC ends;
	*EK ends;

	compress;

	* MB has added some variables to this;
	if "`n'"!="14r" {; 
		keep year h_seq h_pos h_numpers h_numfam statefip h_cbsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_wicyn h_numwic h_flag_fsval h_ucval 
		h_ssival f_* p_*;
	};
	if "`n'"=="14r" {;
		keep year h_seq h_pos h_numpers h_numfam statefip h_cbsa h_public h_rentsub h_foodstp h_fsnum 
		h_fsval h_hhotlun h_freelun h_numfree h_enrgyas h_enrgyva h_mcare h_mcaid h_champ h_hhiyn 
		h_weight h_hhinctot h_mis h_tenure h_prop_tax h_housret h_wicyn h_numwic h_flag_fsval h_ucval 
		h_ssival f_* p_* redesigned;
	};
	save `marcps20`n'', replace;
};

*DC adds 1988B and 2014r;

use `marcps1988';
foreach n in 1989 1990 1991 1992 1993 1994 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 
	2007 2008 2009 2010 2011 2012 2013 2014 2014r 2015 2016 2017 {;
qui append using `marcps`n'';

*DC ends;

** set self rated health to be missing for pre-96;
replace p_srhealth = . if year<1996 ;
tab year p_srhealth;
capture label variable p_srhealth "general health";
};


*EK comments this out, since we do have these variables for all years, including 2013;
/*;
*** check that variables for alternative poverty are indeed missing for survey year 2012 as of 11/6/2012;
for any h_fsval h_housret h_prop_tax: assert X==0 if year==2012;
for any f_mv_fs f_mv_sl f_fngcaid f_fngcare f_houssub: assert X==0 if year==2012;
for any p_emcontrb p_fed_ret p_fed_tax p_statetax p_eit_cred p_fica p_ctc_crd p_actc_crd: assert X==0 if year==2012;

*** set to missing for 2012 if still not there;
for any h_fsval h_housret h_prop_tax: replace X= . if year==2012;
for any f_mv_fs f_mv_sl f_fngcaid f_fngcare f_houssub: replace X= . if year==2012;
for any p_emcontrb p_fed_ret p_fed_tax p_statetax p_eit_cred p_fica p_ctc_crd p_actc_crd: replace X= . if year==2012;
*/;
*EK ends commenting out;

*EK adds the following from lateryears_recode_immig.do file, and changes 2010 to 2013;
su h_fsval h_housret h_prop_tax if year==2013;
su f_mv_fs f_mv_sl f_fngcaid f_fngcare f_houssub if year==2013;
su p_emcontrb p_fed_ret p_fed_tax p_statetax p_eit_cred p_fica p_ctc_crd p_actc_crd if year==2013;
*EK ends;

*** check that housret is not all for 2004;
su h_housret if year==2004, d;
su h_housret if year!=2004 & year!=2013, d;


*** make sure after tax stuff is here that we use;
*** possible problems with following:
*** 	     houssub = should it be multiplied by 12?;
*** 	     fedret 1/8 size in 2000 of other years;
for any h_fsval h_housret h_prop_tax: tab year, su(X);
for any f_mv_fs f_mv_sl f_fngcaid f_fngcare f_houssub: tab year, su(X);
for any p_emcontrb p_fed_ret p_fed_tax p_statetax p_eit_cred p_fica p_ctc_crd p_actc_crd: tab year, su(X);

for any h_fsval h_housret h_prop_tax: gen got_X = X!=0 & X!=.;
for any f_mv_fs f_mv_sl f_fngcaid f_fngcare f_houssub: gen got_X = X!=0 & X!=.;
for any p_emcontrb p_fed_ret p_fed_tax p_statetax p_eit_cred p_fica p_ctc_crd p_actc_crd: gen got_X = X!=0 & X!=.;

for any h_fsval h_housret h_prop_tax: tab year, su(got_X);
for any f_mv_fs f_mv_sl f_fngcaid f_fngcare f_houssub: tab year, su(got_X);
for any p_emcontrb p_fed_ret p_fed_tax p_statetax p_eit_cred p_fica p_ctc_crd p_actc_crd: tab year, su(got_X);

** erase files;
erase tmp-04-housret-merge-hh.dta;
for any pp ff hh: erase tmp-04-merge-X.dta;

drop got_*;

cd ..;
save "$march/marcps88b17.dta", replace;

log close;

