/*This dofile creates an extract of the main March CPS file
("./marcps88on/marcps`y'_recode.dta") for
Hoynes-Schanzenbach BPEA (2018) Medicaid and public housing receipt

Changed 1/22/2018: Added in measures of SNAP, EITC, ACTC, TANF/AFDC, Medicaid

Created 12/28/2017 KR*/

*Prelims
clear all
set more off, perm
cap log close

cd /accounts/projects/hoynes/cycles/march/

log using ./BPEA/marchextract_BPEA.log, replace

*Global for variables we need
global vars *year* h*kid* h_weight f_famwgt p_marwt marsupwt h*inc* *kidcaid* ///
	h_public *threshold *numpers* *kid* *taxesnet* p_relhd edcat employed ///
	under18 hhid p_age ///next line is estimated amount program benefits (not already incld)
	h_foodstp h_fsval h_anyinc_pa h_inc_pa sf_ctc* heitc redesigned *parent* ///
	p_pos p_male p_famrel bf_inc_tot* h_public h_ssival

*Load in relevant years -- calendar year is survey year -1
use $vars using "./marcps88on/marcps1991_recode.dta", clear

forvalues y = 1992/2016 {
	append using "./marcps88on/marcps`y'_recode.dta", keep($vars)
	}

*Just keep redesigned observations for 2014
keep if (redesigned == 1 & year == 2014) | (year != 2014)

*Combine ctc and actc 
g ctc = sf_ctc_taxsim + sf_ctc_add

gen kids = sf_kidu18
*** 1 fewer kid if kid is householder and under 18
replace kids = kids-1 if (p_relhd==1 | p_relhd==2) & under18==1
	replace kids = 8 if kids>8 & kids~=.
gen famsize = h_numpers
	replace famsize = 9 if famsize>9 & famsize~=.
g worker = h_inc_earn > 0 & h_inc_earn != .

*** Ccategory to get other thresholds for 1/2 person elderly families
*** under652person is indicator for <=2 persons and no elderly
*** it is 1 if 2 person family and no elderly
*** 0 if 2 person family and elderly
*** -1 if >=3 person family

*elderly
gen elderly = p_age>=65
bysort hhid year: egen h_elderly = sum(elderly)
gen under652person =1 if famsize<=2 & h_elderly>=0
replace under652person = 0 if famsize<=2 & h_elderly>=1 & h_elderly<.
replace under652person = -1 if famsize>=3

*Just keep observations with kids
drop if kids == 0

*Number of kids in hh w/ Medicaid
egen h_numkidcaid = total(p_kidcaid*(p_age <= 18)), by(hhid year)

*Generate after-tax income
g h_atti = h_inc_tot + h_taxesnet_taxsim

*Get income as percent of poverty threshold
g calyear = year - 1
merge m:1 calyear famsize kids under652person using pov_thresholds_1980_2015.dta
	drop _merge
merge m:1 calyear using "./BPEA/spmthresh14.dta", keep(master match)
*Make sure have info for all years
assert _merge >= 3
	drop _merge
*Calculate family-specific thresholds
/*From Fox, 2017:
https://www.census.gov/content/dam/Census/library/publications/2017/demo/p60-261.pdf
One and two adults: scale = (adults)0.5
Single parents: scale = (adults + 0.8* first child + 0.5 * other children
All other families: scale = (adults + 0.5 * children).
*/
*Current thresholds given for 2-adult, 2 kid family--back out rate for single
cap drop spmthreshold
replace spmrent = spmrent/(2 + (2*0.5))
g spmthreshold = (1 + 0.8)*spmrent if famsize == 2 & kids == 1 //single parent 1 kid
	replace spmthreshold = (1+0.8+ 0.5*(famsize - 2))*spmrent if (famsize - kids) == 1 //single parent, multiple kids
	replace spmthreshold = ((famsize - kids) + 0.5*kids)*spmrent if (famsize - kids ) > 1 //multiple adult hh

/*
numerator = Bitler-Hoynes ATTI income
denominator = SPM poverty line
*/

*Just keep variables we need
keep *atti* *threshold* *year* *inc_tot* *w*t famsize kids *public* *caid* *age*  ///
	worker h_foodstp h_fsval h_anyinc_pa h_inc_pa ctc heitc bf_inc_tot*  h_public h_ssival hhid
g incyear = calyear
	
*1. ATTI as fraction alt1a
g h_inc_alt1a_spm = h_inc_tot_alt1a/spmthreshold
*2: family ATTI
g bf_inc_alt1a_spm = bf_inc_tot_alt1a/spmthreshold

		
*Save shorter file
keep if p_age <= 18
compress
save ./BPEA/cps_BPEA.dta, replace

cap log close
	
