/*This do file contains replication code to produce figure 5 from
Hoynes and Schanzenbach (2018). Raw table p24 available from Census at:
https://www.census.gov/data/tables/time-series/demo/income-poverty/historical-income-people.html
*/

*Prelims
clear all
set more off, perm
cap log close 

*Set directories and log file
cap cd "./replication/"

log using "./log/create_fig5.log", replace

*********************************************************************************
*FIGURE 5: Trends in Real Wages of FT Workers
*********************************************************************************
*Change 2/10/2018: Drop grad school, combine as ba+
*9-12th graders
import excel using "./raw/p24.xls", clear firstrow cellrange(A69:G95)
	rename A year
		replace year = substr(year, 1, 4)
		destring year, replace
		tab year, mi
	rename dollars men_lths
	rename G women_lths
	keep year men_lths women_lths
	tempfile lths
		save `lths', replace
		
*HS grads
import excel using "./raw/p24.xls", clear firstrow cellrange(A99:G125)
	rename A year
		replace year = substr(year, 1, 4)
		destring year, replace
		tab year, mi
	rename dollars men_hs
	rename G women_hs
	keep year men_hs women_hs
	tempfile hs
		save `hs', replace
	
*some college
import excel using "./raw/p24.xls", clear firstrow cellrange(A129:G155)
	rename A year
		replace year = substr(year, 1, 4)
		destring year, replace
		tab year, mi
	rename dollars men_sc
	rename G women_sc
	keep year men_sc women_sc
	tempfile sc
		save `sc', replace
*ba or more	
import excel using "./raw/p24.xls", clear firstrow cellrange(A190:G216)
	rename A year
		replace year = substr(year, 1, 4)
		destring year, replace
		tab year, mi
	rename dollars men_ba
	rename G women_ba
	keep year men_ba women_ba
	tempfile ba
		save `ba', replace
		
*Merge everything together	
merge 1:1 year using `sc', assert(match) nogen	
merge 1:1 year using `hs', assert(match) nogen		
merge 1:1 year using `lths', assert(match) nogen
keep if year < 2016 //drop 2016 for consistency w/ rest of paper

*Ratio in 1990
foreach gender in men women {
		foreach level in lths hs sc ba  {
			egen `gender'_`level'_1991 = max(`gender'_`level'*(year == 1991))
			g `gender'_`level'_rel1991 = (`gender'_`level'/`gender'_`level'_1991)*100
			}
			}
			
sort year
export excel year *rel1991 using "./out/BPEAtablenumbers.xlsx", ///
	firstrow(varlabels) sheet("Figure5_raw") sheetreplace 
	
