/*This do file contains replication code to produce Figure 10 (share of children
in each poverty bin) from Hoynes and Schanzenbach (2018)). 
The called data is first created by running
create_data.do (See readme for additional details):
*/

*Prelims
clear all
set more off, perm
cap log close 

*Set directories and log file
cap cd "./replication/"

log using "./log/create_fig10.log", replace

*********************************************************************************
*FIGURE 10: Share of kids in each poverty bin 
*********************************************************************************
use "./dta/pctkidbin.dta", clear
	cap drop pctsfspm 
*Reshape and export to excel for graph version
reshape wide pctspm, i(year) j(bin)
	rename pctspm* h_pctspm*
	export excel using ///
	"./out/BPEAtablenumbers.xlsx", firstrow(variables) ///
		sheet("Figure10_raw") sheetreplace
		
cap log close
