cd 
set more off

****************************************************************************
****************************************************************************
**  8. APPENDIX FIGURES AND TABLES 

** John W. McArthur & Krista Rasmussen
** January 2018
****************************************************************************
****************************************************************************

****************************************************************************
*A. Apdx 4A: No. countries that experienced post-2000 accelerations
*B. Apdx 4B: Sensitivity test for "real" acceleration
*C. Apdx 4C: T-test results
*D. Apdx 5A: Testing for unconditional convergence in child mortality
*E. Apdx 5B: Testing annual rates of progress on initial indicator values
*F. Apdx 6 : Acceleration vs. progress during the MDG era
****************************************************************************

**********************************************************************
* A. Appendix 4A
* Number of countries that experienced post-2000 acceleration, by region
**********************************************************************

**1. Standardize variable names and create country counts for each indicator by income group
local lista "maternal_mort_modeled_analysis u5mr_analysis improvedwater_pct__analysis improvedsanitation_pct__analysis primary_completion_85_analysis genderratio_primary_85_analysis undernourishment__analysis forest_analysis_expand antiretro_pct_analysis inc_poverty___analysis malaria_deaths_analysis terrestrial_protected_analysis_expand"

foreach p of local lista{
use "`p'", clear

rename difrp*any difrp_any // any acceleration
rename difrp*1 difrp_1 // "real" acceleration
drop if Region==""

keep Region IndicatorName difrp_any difrp_1 
gen fulldata_dif = 1 if difrp_any!=. // countries in sample
gsort -IndicatorName

collapse (first) IndicatorName (sum) difrp_any difrp_1 fulldata*, by(Region)

save "`p'_colRegion", replace
}

**2. Append and reorder all datasets
use "maternal_mort_modeled_analysis_colRegion.dta", clear

local lista "malaria_deaths_analysis inc_poverty___analysis u5mr_analysis genderratio_primary_85_analysis improvedwater_pct__analysis improvedsanitation_pct__analysis undernourishment__analysis  primary_completion_85_analysis forest_analysis_expand  antiretro_pct_analysis terrestrial_protected_analysis_expand"
foreach p of local lista{
append using "`p'_colRegion"
}
order IndicatorName fulldata*

 *Calculate shares for each category
gen difrp_any_pct = difrp_any/fulldata_dif // % of countries with any acceleration
gen difrp_1_pct = difrp_1/fulldata_dif // % of countries with "real" acceleration
order IndicatorName fulldata_dif difrp_any* difrp_1*

 * Generate category names
gen category = "Life and Death" 
replace category = "Basic Needs" if IndicatorName=="Improved water source (% of population with access)"
replace category = "Basic Needs" if IndicatorName=="Improved sanitation facilities (% of population with access)"
replace category = "Basic Needs" if IndicatorName=="Prevalence of undernourishment (% of population)"
replace category = "Basic Needs" if IndicatorName=="Primary completion rate, both sexes (%)"
replace category = "Basic Needs" if IndicatorName=="Gross enrolment ratio, primary, gender parity index (GPI)"
replace category = "Natural Capital" if IndicatorName=="Forest area (% of land area)"
replace category = "Natural Capital" if IndicatorName=="Terrestrial protected areas (% of land area)"
replace category = "Extreme Income Poverty" if IndicatorName=="Poverty headcount ratio at $1.90 (2011 PPP) % of pop"

gen life_deathorder = .
replace life_deathorder = 1 if IndicatorName=="u5mr"
replace life_deathorder = 2 if IndicatorName=="Estimated number of malaria deaths"
replace life_deathorder = 2 if IndicatorName=="Estimated number of malria deaths"
replace life_deathorder = 3 if IndicatorName=="Maternal mortality ratio (modeled estimate, per 100,000 live births)"
replace life_deathorder = 4 if IndicatorName=="Antiretroviral therapy coverage (% of people living with HIV)"

gen basic_order = .
replace basic_order = 1 if IndicatorName=="Improved water source (% of population with access)"
replace basic_order = 2 if IndicatorName=="Improved sanitation facilities (% of population with access)"
replace basic_order = 3 if IndicatorName=="Prevalence of undernourishment (% of population)"
replace basic_order = 4 if IndicatorName=="Primary completion rate, both sexes (%)"
replace basic_order = 5 if IndicatorName=="Gross enrolment ratio, primary, gender parity index (GPI)"

gen nat_order = .
replace nat_order = 1 if IndicatorName=="Forest area (% of land area)"
replace nat_order = 2 if IndicatorName=="Terrestrial protected areas (% of land area)"

gen categorynum = .
replace categorynum = 1 if category=="Life and Death"
replace categorynum = 2 if category == "Basic Needs"
replace categorynum = 3 if category == "Extreme Income Poverty"
replace categorynum = 4 if category == "Natural Capital"

replace IndicatorName = "Under-5 child mortality rate" if IndicatorName=="u5mr"
replace IndicatorName = "Gender parity index (GPI), gross enrollment ratio in primary" if IndicatorName=="Gross enrolment ratio, primary, gender parity index (GPI)"
replace IndicatorName = "Maternal mortality ratio" if IndicatorName=="Maternal mortality ratio (modeled estimate, per 100,000 live births)"
replace IndicatorName = "Antiretroviral therapy coverage" if IndicatorName=="Antiretroviral therapy coverage (% of people living with HIV)"
replace IndicatorName = "Access to improved water source" if IndicatorName=="Improved water source (% of population with access)"
replace IndicatorName = "Access to improved sanitation facilities" if IndicatorName=="Improved sanitation facilities (% of population with access)"
replace IndicatorName = "Undernourishment, prevalence" if IndicatorName=="Prevalence of undernourishment (% of population)"
replace IndicatorName = "Forest area" if IndicatorName =="Forest area (% of land area)"
replace IndicatorName = "Poverty head-count ratio at US$1.90 (2011 PPP)" if category=="Extreme Income Poverty"

sort Region categorynum life_deathorder basic_order nat_order

drop life_deathorder basic_order

save "apx_table_countrycount_reg.dta", replace



**********************************************************************
* B. Appendix 4B
* Sensitivity test for "real" acceleration
**********************************************************************

*Child mortality
use "u5mr_analysis.dta", clear
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.005 & rp0015>0 & difrp9000_0015!=. & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.0075 & rp0015>0 & difrp9000_0015!=. & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.01 & rp0015>0 & difrp9000_0015!=. & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.0125 & rp0015>0 & difrp9000_0015!=. & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.015 & rp0015>0 & difrp9000_0015!=. & rp0015!=.

*Malaria deaths
use "malaria_deaths_analysis.dta", clear
bysort IncomeGroup: tab CountryName if difrp0005_0513>=.005 & rp0513>0 & n2000>100 & difrp0005_0513!=. & rp0513!=. & n2000!=.
bysort IncomeGroup: tab CountryName if difrp0005_0513>=.0075 & rp0513>0 & n2000>100 & difrp0005_0513!=. & rp0513!=. & n2000!=.
bysort IncomeGroup: tab CountryName if difrp0005_0513>=.01 & rp0513>0 & n2000>100 & difrp0005_0513!=. & rp0513!=. & n2000!=.
bysort IncomeGroup: tab CountryName if difrp0005_0513>=.0125 & rp0513>0 & n2000>100 & difrp0005_0513!=. & rp0513!=. & n2000!=.
bysort IncomeGroup: tab CountryName if difrp0005_0513>=.015 & rp0513>0 & n2000>100 & difrp0005_0513!=. & rp0513!=. & n2000!=.

*Maternal mortality
use "maternal_mort_modeled_analysis.dta", clear
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.005 & rp0015>0 & difrp9000_0015!=. & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.0075 & rp0015>0 & difrp9000_0015!=. & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.01 & rp0015>0 & difrp9000_0015!=. & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.0125 & rp0015>0 & difrp9000_0015!=. & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.015 & rp0015>0 & difrp9000_0015!=. & rp0015!=.

*Antiretroviral therapy
use "antiretro_pct_analysis.dta", clear
bysort IncomeGroup: tab CountryName if difrp0002_0215>=.002 & difrp0002_0215!=. & rp0215>0 & rp0215!=.
bysort IncomeGroup: tab CountryName if difrp0002_0215>=.0025 & difrp0002_0215!=. & rp0215>0 & rp0215!=.
bysort IncomeGroup: tab CountryName if difrp0002_0215>=.0033 & difrp0002_0215!=. & rp0215>0 & rp0215!=.
bysort IncomeGroup: tab CountryName if difrp0002_0215>=.004 & difrp0002_0215!=. & rp0215>0 & rp0215!=.
bysort IncomeGroup: tab CountryName if difrp0002_0215>=.0045 & difrp0002_0215!=. & rp0215>0 & rp0215!=.

*Improved water
use "improvedwater_pct__analysis.dta", clear
bysort IncomeGroup: tab CountryName if difrppre_post>=.002 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0025 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0033 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.004 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0045 & difrppre_post!=. & rppost>0 & rppost!=.

*Improved sanitation
use "improvedsanitation_pct__analysis.dta", clear
bysort IncomeGroup: tab CountryName if difrppre_post>=.002 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0025 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0033 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.004 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0045 & difrppre_post!=. & rppost>0 & rppost!=.

*Undernourishment
use "undernourishment__analysis.dta", clear
bysort IncomeGroup: tab CountryName if difrp9100_0015>=.002 & difrp9100_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9100_0015>=.0025 & difrp9100_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9100_0015>=.0033 & difrp9100_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9100_0015>=.004 & difrp9100_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9100_0015>=.0045 & difrp9100_0015!=. & rp0015>0 & rp0015!=.

*Primary school completion rate
use "primary_completion_85_analysis.dta", clear
bysort IncomeGroup: tab CountryName if difrppre_post>=.002 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0025 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0033 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.004 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0045 & difrppre_post!=. & rppost>0 & rppost!=.

*Gendery parity index primary
use "genderratio_primary_85_analysis.dta", clear
bysort IncomeGroup: tab CountryName if difrppre_post>=.002 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0025 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0033 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.004 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0045 & difrppre_post!=. & rppost>0 & rppost!=.

*Income Poverty
use "inc_poverty___analysis.dta", clear
bysort IncomeGroup: tab CountryName if difrppre_post>=.002 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0025 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0033 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.004 & difrppre_post!=. & rppost>0 & rppost!=.
bysort IncomeGroup: tab CountryName if difrppre_post>=.0045 & difrppre_post!=. & rppost>0 & rppost!=.

*Forest Area
use "forest_analysis_expand.dta", clear
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.002 & difrp9000_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.0025 & difrp9000_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.0033 & difrp9000_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.004 & difrp9000_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.0045 & difrp9000_0015!=. & rp0015>0 & rp0015!=.

*Terrestrial protected land area
use "terrestrial_protected_analysis_expand.dta", clear
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.002 & difrp9000_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.0025 & difrp9000_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.0033 & difrp9000_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.004 & difrp9000_0015!=. & rp0015>0 & rp0015!=.
bysort IncomeGroup: tab CountryName if difrp9000_0015>=.0045 & difrp9000_0015!=. & rp0015>0 & rp0015!=.


**********************************************************************
* C. Appendix 4C
* Difference in mean rates of progress (t-test), full results
**********************************************************************

**See do-file "7. Paper tables and figures", Table 2 for t-test code (for Counterfactual A)

**Counterfactual B only for child mortality and maternal mortality 
*******************
** 1. Child mortality
use "u5mr_analysis.dta", clear

	*a. All developing
	ttest rp0115==rp9601
	*b. Low-income
	ttest rp0115==rp9601 if IncomeGroup=="L"
	*c. Middle-income
	ttest rp0115==rp9601 if IncomeGroup!="L" 
	*d. Region
	bysort Region: ttest rp0115==rp9601

** 2. Maternal mortality
use "maternal_mort_modeled_analysis.dta", clear

	*a. All developing
	ttest rp0115==rp9601
	*b. Low-income
	ttest rp0115==rp9601 if IncomeGroup=="L"
	*c. Middle-income
	ttest rp0115==rp9601 if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rp0115==rp9601
	


**********************************************************************
* D. Appendix 5A
* Testing for unconditional convergence in child mortality
**********************************************************************

** Create long dataset (includes all income groups)
use "u5mr_clean_all.dta", clear
drop if pop2000<200000
keep CountryCode CountryName n* 

reshape long n, i(CountryName CountryCode) j(year)
rename n cmr
encode CountryCode, gen(id)

xtset id year
codebook CountryName 
gen lcmr =ln(L1.cmr)

** Annual proportional rate of progress
gen cmr_f=(cmr-L1.cmr)/L1.cmr*-1

save "CMR_converge_LONG.dta", replace

** Graph coefficients 
use "CMR_converge_LONG.dta", clear
xtset id year

*Graph the coefs
statsby "reg cmr_f lcmr, r" size=e(N) b1=_b[lcmr] tb1 = (_b[lcmr]/_se[lcmr]) se1=_se[lcmr] b0=_b[_cons] se0=_se[_cons] df=e(df_r), by(year) clear
gen p = 2*ttail(df,abs(tb1))
drop if year>2015
serrbar  b1 se1  year, scale(1.96) yline(0) xscale(r(1950 2015)) xlabel(1950(5)2015) ytitle("") xtitle("") scheme(s1mono)
graph export "converge_CMR_95ci.png", replace


**********************************************************************
* E. Appendix 5B
* Testing annual rates of progress on initial indicator values
**********************************************************************

**Child mortality
use "u5mr_analysis.dta", clear
gen log1990 = ln(n1990)
gen log1996 = ln(n1996)
gen log2000 = ln(n2000)
gen log2001 = ln(n2001)

*1990-2000
replace rp9000 = rp9000*100
reg rp9000 log1990 if difrp9000_0015!=., r
outreg2 using u5mr_mmrtest.xls, replace ctitle(U5MR RP 1990-2000) title(Initial value and rate of progress for acceleration-test country sample)

*1996-2001
replace rp9601 = rp9601*100
reg rp9601 log1996 if difrp9601_0115!=., r
outreg2 using u5mr_mmrtest.xls, append ctitle(CMR RP 1996-2001)

*2000-2015
replace rp0015 = rp0015*100
reg rp0015 log2000 if difrp9000_0015!=., r
outreg2 using u5mr_mmrtest.xls, append ctitle(CMR RP 2000-2015)

*2001-2015
replace rp0115 = rp0115*100
reg rp0115 log2001 if difrp9601_0115!=., r
outreg2 using u5mr_mmrtest.xls, append ctitle(CMR RP 2001-2015)

**Maternal mortality
use "maternal_mort_modeled_analysis.dta", clear
gen log1990 = ln(n1990)
gen log1996 = ln(n1996)
gen log2000 = ln(n2000)
gen log2001 = ln(n2001)

*1990-2000
replace rp9000 = rp9000*100
reg rp9000 log1990 if difrp9000_0015!=., r
outreg2 using u5mr_mmrtest.xls, append ctitle(MMR RP 1990-2000)

*1996-2001
replace rp9601 = rp9601*100
reg rp9601 log1996 if difrp9601_0115!=., r
outreg2 using u5mr_mmrtest.xls, append ctitle(MMR RP 1996-2001)

*2000-2015
replace rp0015 = rp0015*100
reg rp0015 log2000 if difrp9000_0015!=., r
outreg2 using u5mr_mmrtest.xls, append ctitle(MMR RP 2000-2015)

*2001-2015
replace rp0115 = rp0115*100
reg rp0115 log2001 if difrp9601_0115!=., r
outreg2 using u5mr_mmrtest.xls, append ctitle(MMR RP 2001-2015)

**Malaria deaths
use "malaria_deaths_analysis.dta", clear
gen log2000 = log(n2000)
gen log2005 = log(n2005)

*2000-2005
replace rp0005 = rp0005*100
reg rp0005 log2000 if difrp0005_0513!=., r
outreg2 using malaria_ART.xls, replace ctitle(Malaria RP 2000-2005) title(Initial value and rate of progress for acceleration-test country sample)

*2005-2013
replace rp0513 = rp0513*100
reg rp0513 log2005 if difrp0005_0513!=., r
outreg2 using malaria_ART.xls, append ctitle(Malaria RP 2005-2013) 


**Antiretroviral therapy
use "antiretro_pct_analysis.dta", clear

*2000-2002
replace rp0002 = rp0002*100
replace n2000 = n2000*100
reg rp0002 n2000 if difrp0002_0215!=., r
outreg2 using malaria_ART.xls, append ctitle(ART RP 2000-2002)

*2002-2015
replace rp0215 = rp0215*100
replace n2002 = n2002*100
reg rp0215 n2002 if difrp0002_0215!=., r
outreg2 using malaria_ART.xls, append ctitle(ART RP 2002-2015)


**Improved water - Initial values <90%
use "improvedwater_pct__analysis.dta", clear
gen InitialValue1990 = n1990
replace InitialValue1990 = n1991 if InitialValue1990==.
replace InitialValue1990 = n1992 if InitialValue1990==.
replace InitialValue1990 = n1993 if InitialValue1990==.
replace InitialValue1990 = n1994 if InitialValue1990==.
replace InitialValue1990 = n1995 if InitialValue1990==.

gen InitialValue2000 = n2000
replace InitialValue2000 = n2001 if InitialValue2000==.
replace InitialValue2000 = n1999 if InitialValue2000==.
replace InitialValue1990 = InitialValue1990*100

*~1990-2000
replace rppre = rppre*100
reg rppre InitialValue1990 if difrppre_post!=. & InitialValue1990<90, r
outreg2 using water_santest90.xls, replace ctitle(Water RP ~1990-2000) title(Initial value and rate of progress for countries greater than 10 pct. points from goal in initial year) dec(3) pdec(3)

*~2000-2015
replace InitialValue2000 = InitialValue2000*100
replace rppost = rppost*100
reg rppost InitialValue2000 if difrppre_post!=. & InitialValue2000<90, r
outreg2 using water_santest90.xls, append ctitle(Water RP ~2000-2015) dec(3) pdec(3)


**Improved sanitation - Initial values <90%
use "improvedsanitation_pct__analysis.dta", clear
gen InitialValue1990 = n1990
replace InitialValue1990 = n1991 if InitialValue1990==.
replace InitialValue1990 = n1992 if InitialValue1990==.
replace InitialValue1990 = n1993 if InitialValue1990==.
replace InitialValue1990 = n1994 if InitialValue1990==.
replace InitialValue1990 = n1995 if InitialValue1990==.

gen InitialValue2000 = n2000 
replace InitialValue2000 = n2001 if InitialValue2000==.
replace InitialValue2000 = n1999 if InitialValue2000==.
replace InitialValue1990 = InitialValue1990*100

*~1990-2000
replace rppre = rppre*100
reg rppre InitialValue1990 if difrppre_post!=. & InitialValue1990 <90, r
outreg2 using water_santest90.xls, append ctitle(San RP ~1990-2000) dec(3) pdec(3)

*~2000-2015
replace InitialValue2000 = InitialValue2000*100
replace rppost = rppost*100
reg rppost InitialValue2000 if difrppre_post!=. & InitialValue2000 <90, r
outreg2 using water_santest90.xls, append ctitle(San RP ~2000-2015) dec(3) pdec(3)


**Undernourishment - Initial values <90%
use "undernourishment__analysis.dta", clear
rename n1991 InitialValue1990
replace InitialValue1990 = InitialValue1990*100

*1991-2000
replace rp9100 = rp9100*100
reg rp9100 InitialValue1990 if difrp9100_0015!=. & InitialValue1990 <90, r
outreg2 using water_santest90.xls, append ctitle(Nourished RP 1991-2000) dec(3) pdec(3)

*2000-2015
replace rp0015 = rp0015*100
rename n2000 InitialValue2000
replace InitialValue2000 = InitialValue2000*100
reg rp0015 InitialValue2000 if difrp9100_0015!=. & InitialValue2000 <90, r
outreg2 using water_santest90.xls, append ctitle(Nourished RP 2000-2015) dec(3) pdec(3)


**Primary school completion - Initial values <90%
use "primary_completion_85_analysis.dta", clear
rename fulln1990 InitialValue1990

*~1990-2000
replace rppre = rppre*100
replace InitialValue1990 = InitialValue1990*100
reg rppre InitialValue1990 if difrppre_post!=. & InitialValue1990<90, r
outreg2 using water_santest90.xls, append ctitle(PCR RP ~1990-2000) dec(3) pdec(3)

*~2000-2015
replace rppost = rppost*100
rename fulln2000 InitialValue2000
replace InitialValue2000 = InitialValue2000*100
reg rppost InitialValue2000 if difrppre_post!=. & InitialValue2000<90, r
outreg2 using water_santest90.xls, append ctitle(PCR RP ~2000-2015) dec(3) pdec(3)
 

**Gender ratio primary school - Initial values <90%
use "genderratio_primary_85_analysis.dta", clear
rename fulln1990 InitialValue1990

*~1990-2000
replace rppre = rppre*100
replace InitialValue1990 = InitialValue1990*100
reg rppre InitialValue1990 if difrppre_post!=. & InitialValue1990 <90, r
outreg2 using water_santest90.xls, append ctitle(GPI Prim RP ~1990-2000) dec(3) pdec(3)

*~2000-2015
replace rppost = rppost*100
rename fulln2000 InitialValue2000
replace InitialValue2000 = InitialValue2000*100
reg rppost InitialValue2000 if difrppre_post!=. & InitialValue2000 <90, r
outreg2 using water_santest90.xls, append ctitle(GPI Prim RP ~2000-2015) dec(3) pdec(3)


**Improved water
use "improvedwater_pct__analysis.dta", clear
gen InitialValue1990 = n1990
replace InitialValue1990 = n1991 if InitialValue1990==.
replace InitialValue1990 = n1992 if InitialValue1990==.
replace InitialValue1990 = n1993 if InitialValue1990==.
replace InitialValue1990 = n1994 if InitialValue1990==.
replace InitialValue1990 = n1995 if InitialValue1990==.

gen InitialValue2000 = n2000
replace InitialValue2000 = n2001 if InitialValue2000==.
replace InitialValue2000 = n1999 if InitialValue2000==.

*~1990-2000
replace InitialValue1990 = InitialValue1990*100
replace rppre = rppre*100
reg rppre InitialValue1990 if difrppre_post!=., r
outreg2 using water_santest.xls, replace ctitle(Water RP ~1990-2000) title(Initial value and rate of progress for acceleration-test country sample) dec(3) pdec(3)

*~2000-2015
replace InitialValue2000 = InitialValue2000*100
replace rppost = rppost*100
reg rppost InitialValue2000 if difrppre_post!=., r
outreg2 using water_santest.xls, append ctitle(Water RP ~2000-2015) dec(3) pdec(3)


**Improved sanitation
use "improvedsanitation_pct__analysis.dta", clear
gen InitialValue1990 = n1990
replace InitialValue1990 = n1991 if InitialValue1990==.
replace InitialValue1990 = n1992 if InitialValue1990==.
replace InitialValue1990 = n1993 if InitialValue1990==.
replace InitialValue1990 = n1994 if InitialValue1990==.
replace InitialValue1990 = n1995 if InitialValue1990==.

gen InitialValue2000 = n2000 
replace InitialValue2000 = n2001 if InitialValue2000==.
replace InitialValue2000 = n1999 if InitialValue2000==.

*~1990-2000
replace InitialValue1990 = InitialValue1990*100
replace rppre = rppre*100
reg rppre InitialValue1990 if difrppre_post!=., r
outreg2 using water_santest.xls, append ctitle(San RP ~1990-2000) dec(3) pdec(3)

*~2000-2015
replace InitialValue2000 = InitialValue2000*100
replace rppost = rppost*100
reg rppost InitialValue2000 if difrppre_post!=., r
outreg2 using water_santest.xls, append ctitle(San RP ~2000-2015) dec(3) pdec(3)


**Undernourishment
use "undernourishment__analysis.dta", clear
rename n1991 InitialValue1990
replace rp9100 = rp9100*100
replace InitialValue1990 = InitialValue1990*100

*1991-2000
reg rp9100 InitialValue1990 if difrp9100_0015!=., r
outreg2 using water_santest.xls, append ctitle(Nourished RP 1991-2000) dec(3) pdec(3)

*2000-2015
replace rp0015 = rp0015*100
rename n2000 InitialValue2000
replace InitialValue2000 = InitialValue2000*100
reg rp0015 InitialValue2000 if difrp9100_0015!=., r
outreg2 using water_santest.xls, append ctitle(Nourished RP 2000-2015) dec(3) pdec(3)


**Primary school completion
use "primary_completion_85_analysis.dta", clear
rename fulln1990 InitialValue1990
replace rppre = rppre*100
replace InitialValue1990 = InitialValue1990*100

*~1990-2000
reg rppre InitialValue1990 if difrppre_post!=., r
outreg2 using water_santest.xls, append ctitle(PCR RP ~1990-2000) dec(3) pdec(3)

*~2000-2015
replace rppost = rppost*100
rename fulln2000 InitialValue2000
replace InitialValue2000 = InitialValue2000*100
reg rppost InitialValue2000 if difrppre_post!=., r
outreg2 using water_santest.xls, append ctitle(PCR RP ~2000-2015) dec(3) pdec(3)


**Gender ratio primary school
use "genderratio_primary_85_analysis.dta", clear
rename fulln1990 InitialValue1990
replace rppre = rppre*100
replace InitialValue1990 = InitialValue1990*100

*~1990-2000
reg rppre InitialValue1990 if difrppre_post!=., r
outreg2 using water_santest.xls, append ctitle(GPI Prim RP ~1990-2000) dec(3) pdec(3)

*~2000-2015
rename fulln2000 InitialValue2000
replace rppost = rppost*100
replace InitialValue2000 = InitialValue2000*100
reg rppost InitialValue2000 if difrppre_post!=., r
outreg2 using water_santest.xls, append ctitle(GPI Prim RP ~2000-2015) dec(3) pdec(3)


**Forest cover
use "forest_analysis_expand.dta", clear
replace rp9000 = rp9000*100
replace n1990 = n1990*100

*1990-2000
reg rp9000 n1990 if difrp9000_0015!=., r
outreg2 using forest_land.xls, replace ctitle(Forest RP 1990-2000) title(Initial value and rate of progress for acceleration test country sample) dec(3) pdec(3)

*2000-2015
replace rp0015 = rp0015*100
replace n2000= n2000*100
reg rp0015 n2000 if difrp9000_0015!=., r
outreg2 using forest_land.xls, append ctitle(Forest RP 2000-2015) dec(3) pdec(3)


**Terrestrial protected land area
use "terrestrial_protected_analysis_expand.dta", clear
replace rp9000 = rp9000*100
replace n1990 = n1990*100

*1990-2000
reg rp9000 n1990 if difrp9000_0015!=., r
outreg2 using forest_land.xls, append ctitle(Land RP 1990-2000) dec(3) pdec(3)

*2000-2015
replace rp0015 = rp0015*100
replace n2000 = n2000*100
reg rp0015 n2000 if difrp9000_0015!=., r
outreg2 using forest_land.xls, append ctitle(Land RP 2000-2015) dec(3) pdec(3)



**********************************************************************
* F. Appendix 6
* Synthesizing MDG outcomes
**********************************************************************


***************************
***1. Proportional rates of progress
***************************


****************************************************************
**MMR and U5MR - birth-weighted average for 1990, 2000, and 2015; RP 90-00 RP 00-15
* LIC ex India (pull from do-file "7. Paper tables and figures", Figure 5)
* MIC ex China (pull from do-file "7. Paper tables and figures", Figure 5)
*1. Regions
*2. China and India
*3. RoW (ex. China, India, SSA)
****************************************************************
local lista "maternal_mort_modeled_analysis u5mr_analysis" 
foreach p of local lista{

****************
*1. By Region
****************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of loca listreg{
use "`p'_syn_LONG", clear
keep if Region=="`reg'"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "`reg'"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp0015 = 1- (n2015/n2000)^(1/15)
save "`p'_pctchng`reg'", replace
}
****************
*2. India & China
****************
use "`p'", clear
keep if CountryCode=="CHN" | CountryCode=="IND"

keep CountryName n1990 n2000 n2015 birth1990 birth2015 birth2000
gen group = CountryName
drop CountryName 
 * RP calculations
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp0015 = 1- (n2015/n2000)^(1/15)
save "`p'_pctchngINDCHN", replace

****************
*3. RoW (ex. China, India, SSA)
****************
use "`p'_syn_LONG", clear
drop if Region=="SSA"
drop if CountryCode=="CHN" | CountryCode=="IND"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "RoW"
reshape wide n, i(group) j(year)
 *  RP calculations
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp0015 = 1- (n2015/n2000)^(1/15)
save "`p'_pctchngRoW", replace

append using "`p'_pctchngSSA"
append using "`p'_pctchngEAP"
append using "`p'_pctchngLAC"
append using "`p'_pctchngMENA"
append using "`p'_pctchngSA"
append using "`p'_pctchngECA"
append using "`p'_pctchngINDCHN"
append using "`p'_pctchng_LICexIND"
append using "`p'_pctchng_MICexCHN"
gen indicator ="`p'"
save "`p'_pctchngMICLICSSA", replace
}

********************************************************************************
**Water and Sanitation
* LIC ex India (pull from do-file "7. Paper tables and figures", Figure 5)
* MIC ex China (pull from do-file "7. Paper tables and figures", Figure 5)
*1. Regions
*2. China and India
*3. RoW (ex. China, India, SSA)
********************************************************************************
local listd "improvedwater_pct__analysis improvedsanitation_pct__analysis"
foreach d of local listd{

****************
*1. By Region
****************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "`d'_LONG_all.dta", clear
keep if Region=="`reg'"
save "`d'_LONG_`reg'.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "`reg'"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * rate of progress
gen rppre_EX = 1-((created2000/created1990)^(1/10))
gen rppost_EX = 1-((created2015/created2000)^(1/15))
save "`d'_pctchng`reg'", replace
}
****************
*2. India & China
****************
use "`d'_LONG_all.dta", clear
keep if CountryCode=="CHN" | CountryCode=="IND"
save "`d'_LONG_INDCHN.dta", replace

gen group = CountryName

 *RP calculations use % without to standardize
drop pop Region IncomeGroup fulln
 reshape wide created, i(group) j(year)
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * rate of progress
gen rppre_EX = 1-((created2000/created1990)^(1/10))
gen rppost_EX = 1-((created2015/created2000)^(1/15))
save "`d'_pctchngINDCHN", replace

****************
*3. RoW (ex. China, India, SSA)
****************
use "`d'_LONG_all.dta", clear
drop if Region=="SSA"
drop if CountryCode=="CHN" | CountryCode=="IND"
save "`d'_LONG_RoW.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "RoW"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * rate of progress
gen rppre_EX = 1-((created2000/created1990)^(1/10))
gen rppost_EX = 1-((created2015/created2000)^(1/15))
save "`d'_pctchngRoW", replace

append using "`d'_pctchngSSA"
append using "`d'_pctchngEAP"
append using "`d'_pctchngLAC"
append using "`d'_pctchngMENA"
append using "`d'_pctchngSA"
append using "`d'_pctchngECA"
append using "`d'_pctchngINDCHN"
append using "`d'_pctchngLICexIND"
append using "`d'_pctchngMICexCHN"
gen indicator ="`d'"
save "`d'_pctchngMICLICSSA", replace
}

*****************************************************
**Undernourishment
*use WB aggregate for SSA
*use country-level for China and India 
*use created "rest of world" (dev. ex China, India, SSA)
*****************************************************

****************
*1. WB Aggregate for regions
****************

*rename to ease merging
use "undernourishment_ag_analysis.dta", clear
replace CountryCode="MENA" if CountryCode=="MNA"
replace CountryCode="SA" if CountryCode=="SAS"
save "undernourishment_ag_analysis_reg.dta", replace

local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "undernourishment_ag_analysis_reg.dta", clear
keep if CountryCode=="`reg'"

keep CountryName n1991 n2000 n2015 regpop1991 regpop2000 regpop2015
rename regpop1991 pop1991
rename regpop2000 pop2000
rename regpop2015 pop2015

 *RP calculations use % without to standardize
foreach var of varlist n1991 n2000 n2015{
replace `var' = 1-`var'
}
 * rate of progress 1991-2000 and 2000-2015
gen rp9100 = 1-((n2000/n1991)^(1/9))
gen rp0015 = 1-((n2015/n2000)^(1/15))
gen group ="`reg'"
gen indicator = "undernourishment"
save "undernourishment_`reg'", replace
}
****************
*2. China and India
****************
use "undernourishment__analysis.dta", clear
keep if CountryName =="China" | CountryName=="India"
keep CountryName n1991 n2000 n2015 pop1991 pop2000 pop2015

 *RP calculations use % without to standardize
foreach var of varlist n1991 n2000 n2015{
replace `var' = 1-`var'
}
 * rate of progress 1991-2000 and 2000-2015
gen rp9100 = 1-((n2000/n1991)^(1/9))
gen rp0015 = 1-((n2015/n2000)^(1/15))
rename CountryName group
gen indicator = "undernourishment"
save "undernourishment_ChiInd.dta", replace

****************
*3. Rest of World
****************
use "undernourishment_ag_analysis.dta", clear
keep if CountryCode=="ROW"

keep CountryName n1991 n2000 n2015 

 *RP calculations use % without to standardize
foreach var of varlist n1991 n2000 n2015{
replace `var' = 1-`var'
}
 * rate of progress 1991-2000 and 2000-2015
gen rp9100 = 1-((n2000/n1991)^(1/9)) 
gen rp0015 = 1-((n2015/n2000)^(1/15))
gen indicator = "undernourishment"
gen group="ROW"
save "undernourishment_ROW.dta", replace


*****************************************************
**Primary Completion Rate
*uses WB aggregate because available country-level data is low
*****************************************************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "primary_completion_ag_clean_analysis.dta", clear
keep if CountryCode=="`reg'"

keep CountryName CountryCode n1990 n2000 n2013 n2014 
 *RP calculations use % without to standardize
 *Cannot use proportional rate of change calculations when a value = 0, replace with .01%
foreach var of varlist n1990 n2000 n2013 n2014 {
replace `var' = 1-`var'
replace `var' = .0001 if `var'<=0
}
 * rate of progress 1990-2000 and 2000-2014
gen rp9000 = 1-((n2000/n1990)^(1/10))
gen rp0014 = 1-((n2014/n2000)^(1/14))
 replace rp0014 = 1-((n2013/n2000))^(1/13) if CountryCode=="ECA"
gen fulln2015 = n2014
gen group ="`reg'"
gen indicator = "Primary Completion Rate"

foreach var of varlist n1990 n2000 fulln2015{
replace `var' = 0 if `var'<=.0001
}
drop CountryCode
save "PCR_`reg'", replace
}

*****************************************************
**Gender parity in primary
*uses WB aggregate because country level cannot be aggregated
*****************************************************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "genderratio_primary_aggregate_clean.dta", clear
for num 1990/2015: replace nX = 1 if nX>1 & nX!=.
keep if CountryCode=="`reg'"
drop if n2000>=.96 // exclude regions above exclusion threshold

keep CountryName n1990 n2000 n2008 n2014
 *RP calculations use % without to standardize
 *Cannot use proportional rate of change calculations when a value = 0, replace with .0001
foreach var of varlist n1990 n2000 n2008 n2014{
replace `var' = 1-`var'
replace `var' = .0001 if `var'<=0
}
gen rp9000 = 1-((n2000/n1990)^(1/10))
gen rp0014 = 1-((n2014/n2000)^(1/14))
 replace rp0014 = 1-((n2008/n2000)^(1/8)) if CountryName=="South Asia" //crosses .97
 
gen fulln2015 = n2014
gen group ="`reg'"
gen indicator = "Gender Parity in Primary Education"

foreach var of varlist n1990 n2000 fulln2015{
replace `var' = 0 if `var'<= .0001
}

save "GPI_`reg'", replace
}
****************
**Gender Parity in China and India
****************
use "genderratio_primary_85_analysis.dta", clear
keep if CountryCode=="CHN" | CountryCode=="IND"
drop if n2000>=.96 // exclude if above exclusion threshold

keep CountryName n1990 n2000 n2003 n2015
 *RP calculations use % without to standardize
 *Cannot use proportional rate of change calculations when a value = 0, replace with .01%
foreach var of varlist n1990 n2000 n2003 n2015{
replace `var' = 1-`var'
replace `var' = .0001 if `var'<=0
}
 * rate of progress 1990-2000 and 2000-2015
gen rp9000 = 1-((n2000/n1990)^(1/10))
gen rp0015 = 1-((n2003/n2000)^(1/3)) if CountryName=="India" // First year India hits parity index >=.97
 
gen fulln2015 = n2015
gen group = CountryName
gen indicator = "Gender Parity in Primary Education"

foreach var of varlist n1990 n2000 fulln2015{
replace `var' = 0 if `var'<= .0001
}
save "GPI_ChiInd.dta", replace

********************************************************************************
********************************************************************************
***APPEND ALL FOR EXPORT and standardize names
********************************************************************************
********************************************************************************
local lista "maternal_mort_modeled_analysis improvedwater_pct__analysis improvedsanitation_pct__analysis"
use "u5mr_analysis_pctchngMICLICSSA.dta", clear

foreach p of local lista{
append using "`p'_pctchngMICLICSSA"
}

local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
append using "undernourishment_`reg'"
append using "PCR_`reg'"
append using "GPI_`reg'"
}
append using "GPI_ChiInd.dta"
append using "undernourishment_ChiInd.dta"
append using "undernourishment_ROW.dta"

replace n1990 = created1990 if created1990!=.
replace n2015 = created2015 if created2015!=.
replace n2000 = created2000 if created2000!=.

replace n1990 = n1991 if n1991!=.
replace n2015 = fulln2015 if fulln2015!=.

replace rp9000 = rppre if rppre!=.
replace rp0015 = rppost if rppost!=.

replace rp9000 = rp9100 if rp9100!=.
replace rp0015 = rp0014 if rp0014!=.

replace rp9000 = rppre_EX if rppre_EX!=.
replace rp0015 = rppost_EX if rppost_EX!=.

keep group n1990 n2000 n2015 rp9000 rp0015 indicator

order indicator group n1990 n2000 n2015 rp9000 rp0015
sort group indicator

****************
**Calculate the value of the problem in percent
****************
gen prob_pct1990 = n1990
replace prob_pct1990 = n1990/100000 if indicator=="maternal_mort_modeled_analysis"
replace prob_pct1990 = n1990/1000 if indicator=="u5mr_analysis"

gen prob_pct2015 = n2015
replace prob_pct2015 = n2015/100000 if indicator=="maternal_mort_modeled_analysis"
replace prob_pct2015 = n2015/1000 if indicator=="u5mr_analysis"

****************
**Calculate the share of the problem eliminated from 1990 to 2015
****************
gen share_elim = 1-(prob_pct2015/prob_pct1990)

****************
**Calculate the ratio of rate of progress pre and post
****************
gen rp_ratio = rp0015/rp9000
replace rp_ratio = . if rp_ratio<0 //calculation cannot be performed when rates of progress flip from negative to positive 

save "synthesis_scatter_proportional.dta", replace





***************************
***2. Percentage point rate of progress
***************************

****************************************************************
**MMR birth-weighted average for 1990, 2000, and 2015; RP 90-00 RP 00-15
*1. LIC ex India
*3. MIC ex China
*4. Region
*5. China and India
*6. RoW (ex. China, India, SSA)
****************************************************************
local lista "maternal_mort_modeled_analysis" 
foreach p of local lista{

use "`p'", clear
keep CountryName CountryCode IncomeGroup Region n1990 n2000 n2015 birth1990 birth2015 birth2000
 * convert indicator to % (divide by 100,000)
foreach var of varlist n1990 n2000 n2015{
replace `var' = `var'/100000
}
 * Reshape long to enable collapse
reshape long n birth, i(CountryName CountryCode) j(year)
save "`p'_syn_LONGpp", replace

****************
*1. LIC ex India
****************
keep if IncomeGroup=="L"
drop if CountryCode=="IND"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "LIC ex India"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = (n1990-n2000)/10 
gen rp0015 = (n2000-n2015)/15
save "`p'_pp_LICexIND", replace

****************
*2. MIC ex China
****************
use "`p'_syn_LONGpp", clear
keep if IncomeGroup!="L"
drop if CountryCode=="CHN"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "MIC ex China"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = (n1990-n2000)/10 
gen rp0015 = (n2000-n2015)/15
save "`p'_pp_MICexCHN", replace

****************
*3. By Region
****************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of loca listreg{
use "`p'_syn_LONGpp", clear
keep if Region=="`reg'"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "`reg'"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = (n1990-n2000)/10 
gen rp0015 = (n2000-n2015)/15
save "`p'_pp`reg'", replace
}
****************
*4. India & China
****************
use "`p'", clear
keep if CountryCode=="CHN" | CountryCode=="IND"

keep CountryName n1990 n2000 n2015 birth1990 birth2015 birth2000
 * convert indicator to % (divide by 100,000)
foreach var of varlist n1990 n2000 n2015{
replace `var' = `var'/100000
}
gen group = CountryName
drop CountryName 
 * RP calculations
gen rp9000 = (n1990-n2000)/10 
gen rp0015 = (n2000-n2015)/15
save "`p'_ppINDCHN", replace

****************
*5. RoW (ex. China, India, SSA)
****************
use "`p'_syn_LONGpp", clear
drop if Region=="SSA"
drop if CountryCode=="CHN" | CountryCode=="IND"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "RoW"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = (n1990-n2000)/10 
gen rp0015 = (n2000-n2015)/15
save "`p'_ppRoW", replace

append using "`p'_ppSSA"
append using "`p'_ppEAP"
append using "`p'_ppLAC"
append using "`p'_ppMENA"
append using "`p'_ppSA"
append using "`p'_ppECA"
append using "`p'_ppINDCHN"
append using "`p'_pp_LICexIND"
append using "`p'_pp_MICexCHN"
gen indicator ="`p'"
save "`p'_ppMICLICSSA", replace
}

****************************************************************
**U5MR birth-weighted average for 1990, 2000, and 2015; RP 90-00 RP 00-15
*1. LIC ex India
*3. MIC ex China
*4. Region
*5. China and India
*6. RoW (ex. China, India, SSA)
****************************************************************
local lista "u5mr_analysis" 
foreach p of local lista{

use "`p'", clear
keep CountryName CountryCode IncomeGroup Region n1990 n2000 n2015 birth1990 birth2015 birth2000
 * convert indicator to % (divide by 1,000)
foreach var of varlist n1990 n2000 n2015{
replace `var' = `var'/1000
}
 * Reshape long to enable collapse
reshape long n birth, i(CountryName CountryCode) j(year)
save "`p'_syn_LONGpp", replace

****************
*1. LIC ex India
****************
keep if IncomeGroup=="L"
drop if CountryCode=="IND"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "LIC ex India"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = (n1990-n2000)/10 
gen rp0015 = (n2000-n2015)/15
save "`p'_pp_LICexIND", replace

****************
*2. MIC ex China
****************
use "`p'_syn_LONGpp", clear
keep if IncomeGroup!="L"
drop if CountryCode=="CHN"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "MIC ex China"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = (n1990-n2000)/10 
gen rp0015 = (n2000-n2015)/15
save "`p'_pp_MICexCHN", replace

****************
*3. By Region
****************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of loca listreg{
use "`p'_syn_LONGpp", clear
keep if Region=="`reg'"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "`reg'"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = (n1990-n2000)/10 
gen rp0015 = (n2000-n2015)/15
save "`p'_pp`reg'", replace
}
****************
*4. India & China
****************
use "`p'", clear
keep if CountryCode=="CHN" | CountryCode=="IND"
keep CountryName n1990 n2000 n2015 birth1990 birth2015 birth2000
 * convert indicator to % (divide by 1,000)
foreach var of varlist n1990 n2000 n2015{
replace `var' = `var'/1000
}
gen group = CountryName
drop CountryName 
 * RP calculations
gen rp9000 = (n1990-n2000)/10 
gen rp0015 = (n2000-n2015)/15
save "`p'_ppINDCHN", replace

****************
*5. RoW (ex. China, India, SSA)
****************
use "`p'_syn_LONGpp", clear
drop if Region=="SSA"
drop if CountryCode=="CHN" | CountryCode=="IND"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "RoW"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = (n1990-n2000)/10 
gen rp0015 = (n2000-n2015)/15
save "`p'_ppRoW", replace

append using "`p'_ppSSA"
append using "`p'_ppEAP"
append using "`p'_ppLAC"
append using "`p'_ppMENA"
append using "`p'_ppSA"
append using "`p'_ppECA"
append using "`p'_ppINDCHN"
append using "`p'_pp_LICexIND"
append using "`p'_pp_MICexCHN"
gen indicator ="`p'"
save "`p'_ppMICLICSSA", replace
}



********************************************************************************
**Water and Sanitation
* use up to 1995 for 1990 value and down to 2010 for 2015 value if missing data
*1. LIC ex India
*3. MIC ex China
*4. Region
*5. China and India
*6. RoW (ex. China, India, SSA)
********************************************************************************
local listd "improvedwater_pct__analysis improvedsanitation_pct__analysis"
foreach d of local listd{

****************
*1. LIC ex India
****************
use "`d'_LONG_all.dta", clear
keep if IncomeGroup=="L"
drop if CountryCode=="IND"
save "`d'_LONG_LICexINDpp.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "LIC ex IND"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * % change and rate of progress
gen rppre_EX = (created1990-created2000)/10 
gen rppost_EX = (created2000-created2015)/15 
save "`d'_ppLICexIND", replace

****************
*2. MIC ex China
****************
use "`d'_LONG_all.dta", clear
keep if IncomeGroup!="L"
drop if CountryCode=="CHN"
save "`d'_LONG_MICexCHNpp.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "MIC ex CHN"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * % change and rate of progress
gen rppre_EX = (created1990-created2000)/10 
gen rppost_EX = (created2000-created2015)/15 
save "`d'_ppMICexCHN", replace

****************
*3. By Region
****************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "`d'_LONG_all.dta", clear
keep if Region=="`reg'"
save "`d'_LONG_`reg'pp.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse(mean) created [weight=pop], by(year)
gen group = "`reg'"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * % change and rate of progress 
gen rppre_EX = (created1990-created2000)/10 
gen rppost_EX = (created2000-created2015)/15 
save "`d'_pp`reg'", replace
}
****************
*4. India & China
****************
use "`d'_LONG_all.dta", clear
keep if CountryCode=="CHN" | CountryCode=="IND"
save "`d'_LONG_INDCHNpp.dta", replace
gen group = CountryName
 *RP calculations use % without to standardize
drop pop Region IncomeGroup fulln
 reshape wide created, i(group) j(year)
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * % change and rate of progress 
gen rppre_EX = (created1990-created2000)/10 
gen rppost_EX = (created2000-created2015)/15 
save "`d'_ppINDCHN", replace

****************
*5. RoW (ex. China, India, SSA)
****************
use "`d'_LONG_all.dta", clear
drop if Region=="SSA"
drop if CountryCode=="CHN" | CountryCode=="IND"
gen count = 1 if fulln!=.
save "`d'_LONG_RoWpp.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "RoW"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * % change and rate of progress 
gen rppre_EX = (created1990-created2000)/10 
gen rppost_EX = (created2000-created2015)/15 
save "`d'_ppRoW", replace

append using "`d'_ppSSA"
append using "`d'_ppEAP"
append using "`d'_ppLAC"
append using "`d'_ppMENA"
append using "`d'_ppSA"
append using "`d'_ppECA"
append using "`d'_ppINDCHN"
append using "`d'_ppLICexIND"
append using "`d'_ppMICexCHN"
gen indicator ="`d'"
save "`d'_ppMICLICSSA", replace
}

*********************************************************************
**Undernourishment
*use WB aggregate for SSA
*use country-level for China and India 
*create "rest of world" (dev. ex Chin, India, SSA)
*********************************************************************

****************
*1. WB Aggregate for regions
****************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "undernourishment_ag_analysis_reg.dta", clear
keep if CountryCode=="`reg'"

keep CountryName n1991 n2000 n2015 regpop1991 regpop2000 regpop2015
rename regpop1991 pop1991
rename regpop2000 pop2000
rename regpop2015 pop2015

 *RP calculations use % without to standardize
foreach var of varlist n1991 n2000 n2015{
replace `var' = 1-`var'
}
gen rp9100 = (n1991-n2000)/9
gen rp0015 = (n2000-n2015)/15
gen group ="`reg'"
gen indicator = "undernourishment"
save "undernourishment_`reg'pp", replace
}
****************
*2. China and India
****************
use "undernourishment__analysis.dta", clear
keep if CountryName =="China" | CountryName=="India"
keep CountryName n1991 n2000 n2015 pop1991 pop2000 pop2015

 *RP calculations use % without to standardize
foreach var of varlist n1991 n2000 n2015{
replace `var' = 1-`var'
}
gen rp9100 = (n1991-n2000)/9
gen rp0015 = (n2000-n2015)/15
rename CountryName group
gen indicator = "undernourishment"
save "undernourishment_ChiIndpp.dta", replace

****************
*3. Rest of World
****************
use "undernourishment_ag_analysis.dta", clear
keep if CountryCode=="ROW"

keep CountryName n1991 n2000 n2015 

 *RP calculations use % without to standardize
foreach var of varlist n1991 n2000 n2015{
replace `var' = 1-`var'
}
gen rp9100 = (n1991-n2000)/9 //update to new numbers
gen rp0015 = (n2000-n2015)/15
gen group = "RoW"
drop CountryName
gen indicator = "undernourishment"
save "undernourishment_ROWpp.dta", replace


*********************************************************************
**Primary Completion Rate
*uses WB aggregate because country count is low
*********************************************************************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "primary_completion_ag_clean_analysis.dta", clear
keep if CountryCode=="`reg'"

keep CountryName CountryCode n1990 n2000 n2014 n2013
 *RP calculations use % without to standardize
foreach var of varlist n1990 n2000 n2014 n2013 {
replace `var' = 1-`var'
}
gen rp9000 = (n1990-n2000)/10
gen rp0014 = (n2000-n2014)/14
 replace rp0014 = (n2000-n2013)/13 if CountryCode=="ECA" // crosses 100%
 
gen fulln2015 = n2014

gen group ="`reg'"
gen indicator = "Primary Completion Rate"
drop CountryCode
save "PCR_`reg'pp", replace
}


*********************************************************************
**Gender parity in primary
*uses WB aggregate because country level cannot be aggregated
*********************************************************************
local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
use "genderratio_primary_aggregate_clean.dta", clear
for num 1990/2015: replace nX = 1 if nX>1 & nX!=.
keep if CountryCode=="`reg'"
drop if n2000>=.96 // exclude regions above exclusion threshold

keep CountryName n1990 n2000 n2008 n2014
 *RP calculations use % without to standardize
foreach var of varlist n1990 n2000 n2008 n2014{
replace `var' = 1-`var'
}
gen rp9000 = (n1990-n2000)/10
gen rp0014 = (n2000-n2014)/14
 replace rp0014 = (n2000-n2008)/8 if CountryName=="South Asia"
 
gen fulln2015 = n2014
gen group ="`reg'"
gen indicator = "Gender Parity in Primary Education"

save "GPI_`reg'pp", replace
}
****************
**Gender Parity in China and India
****************
use "genderratio_primary_85_analysis.dta", clear
keep if CountryCode=="CHN" | CountryCode=="IND"
drop if n2000>=.96 // exclude regions above exclusion threshold

keep CountryName n1990 n2000 n2003 n2015
 *RP calculations use % without to standardize
foreach var of varlist n1990 n2000 n2003 n2015{
replace `var' = 1-`var'
}
gen rp9000 = (n1990-n2000)/10
gen rp0015 = (n2000-n2003)/3 if CountryName=="India" 
 
gen fulln2015 = n2015
gen group = CountryName
gen indicator = "Gender Parity in Primary Education"

save "GPI_ChiIndpp.dta", replace

********************************************************************************
********************************************************************************
***APPEND ALL FOR EXPORT and standardize names
********************************************************************************
********************************************************************************
local lista "maternal_mort_modeled_analysis improvedwater_pct__analysis improvedsanitation_pct__analysis"
use "u5mr_analysis_ppMICLICSSA.dta", clear

foreach p of local lista{
append using "`p'_ppMICLICSSA"
}

local listreg "EAP ECA LAC MENA SA SSA"
foreach reg of local listreg{
append using "undernourishment_`reg'pp"
append using "PCR_`reg'pp"
append using "GPI_`reg'pp"
}
append using "undernourishment_ChiIndpp.dta"
append using "undernourishment_ROWpp.dta"
append using "GPI_ChiIndpp.dta"

replace n1990 = created1990 if created1990!=.
replace n2015 = created2015 if created2015!=.
replace n2000 = created2000 if created2000!=.

replace n1990 = n1991 if n1991!=.
replace n2015 = fulln2015 if fulln2015!=.

replace rp9000 = rppre if rppre!=.
replace rp0015 = rppost if rppost!=.

replace rp9000 = rp9100 if rp9100!=.
replace rp0015 = rp0014 if rp0014!=.

replace rp9000 = rppre_EX if rppre_EX!=.
replace rp0015 = rppost_EX if rppost_EX!=.

keep group n1990 n2000 n2015 rp9000 rp0015 indicator

order indicator group n1990 n2000 n2015 rp9000 rp0015
sort group indicator

****************
**Calculate the value of the problem in percent
****************
gen prob_pct1990 = n1990
gen prob_pct2015 = n2015
gen prob_pct2000 = n2000

****************
**Calculate the share of the problem eliminated from 1990 to 2015
****************
gen share_elim = 1-(prob_pct2015/prob_pct1990)

****************
**Calculate the ratio of rate of progress pre and post
****************
gen rp_ratio = rp0015/rp9000
replace rp_ratio = . if rp_ratio<0 //calculation cannot be performed when rates of progress flip from negative to positive 

****************
** For appendix tables accompanying MDG outcome graphs, merge with porpotional rate of progress
****************
rename rp_ratio pctp_rp_ratio
rename rp9000 pctp_rp9000
rename rp0015 pctp_rp0015

merge 1:1 indicator group using "synthesis_scatter_proportional.dta"
drop _merge
rename rp_ratio prop_rp_ratio
rename rp9000 prop_rp9000
rename rp0015 prop_rp0015

order indicator group n1990 n2000 n2015 prob_pct1990 prob_pct2000 prob_pct2015 share_elim pctp_rp9000 pctp_rp0015  pctp_rp_ratio prop_rp9000 prop_rp0015 prop_rp_ratio
sort group indicator

replace indicator = "Sanitation" if indicator=="improvedsanitation_pct__analysis"
replace indicator = "Water" if indicator=="improvedwater_pct__analysis"
replace indicator = "Maternal Mortality Ratio" if indicator=="maternal_mort_modeled_analysis"
replace indicator = "Child Mortality Rate" if indicator=="u5mr_analysis"

replace pctp_rp9000 = pctp_rp9000*100
replace pctp_rp0015 = pctp_rp0015*100
replace prop_rp9000 = prop_rp9000*100
replace prop_rp0015 = prop_rp0015*100
replace prob_pct1990 = prob_pct1990*100
replace prob_pct2000 = prob_pct2000*100
replace prob_pct2015 = prob_pct2015*100
replace share_elim = share_elim*100

order group indicator n1990 n2000 n2015 share_elim prop_rp9000 prop_rp0015 prop_rp_ratio pctp_rp9000 pctp_rp0015 pctp_rp_ratio 

keep group indicator n1990 n2000 n2015 share_elim prop_rp9000 prop_rp0015 prop_rp_ratio pctp_rp9000 pctp_rp0015 pctp_rp_ratio



save "syn_apdx_graphs.dta", replace

 
 
 



