cd 
set more off

****************************************************************************
****************************************************************************
**  7. PAPER FIGURES AND TABLES

** John W. McArthur & Krista Rasmussen
** January 2018
****************************************************************************
****************************************************************************

****************************************************************************
*A. Figure 2: Annual birth-weighted rates of progress in reducing child mortality
*B. Figure 3: Total deaths in children under-5 compared to BAU trajectories
*C. Table  1: No. of countries with any and "real" acceleration post-2000
*D. Figure 4: Distribution of annual rates of progress in primary school completion
*E. Table  2: T-test results
*F. Table  3: Cumulative lives saved due to accelerated progress
*G. Table  4: Lives improved as of 2015
*H. Figure 5: Acceleration vs. progress during the MDG era
****************************************************************************


**********************************************************************
* A. Figure 2
* Annual birth-weighted rates of progress in reducing child mortality among 
* low-income countries (LICs) excluding India and middle-income countries 
* (MICs) excluding China
**********************************************************************

*1. Reshape long
use "u5mr_analysis.dta", clear
reshape long n birth, i(CountryName) j(year)
rename n cmr
keep CountryName CountryCode Region IncomeGroup cmr birth year
save "u5mr_LONG.dta", replace


*2. Calculate birth-weighted annual proportional change by group

****MIC x China
********************
use "u5mr_LONG.dta", clear

drop if CountryCode=="CHN"
drop if IncomeGroup=="L" 

 * birth-weighted average CMR
collapse (mean) cmr [weight=birth], by(year)

gen id = 1
xtset id year 
drop if year >2015

 * generate annual percent change
gen micxchn_cmr_d = (D.cmr/L.cmr*100)*-1    
label variable micxchn_cmr_d "MIC x China CMR"
drop if year<1975

 * Apply 3-year smoothing to CMR
tssmooth ma micxchn_cmr_ma_3yr = micxchn_cmr_d, window(1 1 1) 
label variable micxchn_cmr_ma_3yr "MIC ex. China CMR"

drop if year<1975
save "u5mr_micXChinacollapse.dta", replace


****LIC x India
********************
use "u5mr_LONG.dta", clear

drop if CountryCode=="IND"
keep if IncomeGroup=="L" 

 * birth-weighted average CMR
collapse (mean) cmr [weight=birth], by(year)

gen id = 1
xtset id year 
drop if year >2015

 * generate annual percent change
gen licxind_cmr_d = (D.cmr/L.cmr*100)*-1    
label variable licxind_cmr_d "LIC ex. India CMR"

drop if year<1975

 * Apply 3-year smoothing to CMR
tssmooth ma licxind_cmr_ma_3yr = licxind_cmr_d, window(1 1 1) 
label variable licxind_cmr_ma_3yr "LIC ex. India"

drop if year<1975
save "u5mr_licXIndiacollapse.dta", replace


*3. Merge categories and graph
use "u5mr_licXIndiacollapse.dta", clear
merge 1:1 year using "u5mr_micXChinacollapse.dta"

**Figure 2:
**CMR LIC ex India, 3 year moving average with average rate of progress pre 2000 and after 2000
egen mean_rateCMR_preMDG = mean(licxind_cmr_d) if year<=2000 // average rate of progress up to 2000
label variable mean_rateCMR_preMDG "LIC avg. annual rate, 1975-2000"
egen mean_rateCMR_postMDG = mean(licxind_cmr_d) if year>=2000 // average rate of progress after 2000
label variable mean_rateCMR_postMDG "LIC avg. annual rate, 2000-2015"
label variable micxchn_cmr_ma_3yr "MIC ex. China"
twoway (line  micxchn_cmr_ma_3yr year, lcolor(midblue) lwidth(medium)) (line licxind_cmr_ma_3yr year, lpattern(solid) lcolor(cranberry) lwidth(thick)) (line mean_rateCMR_preMDG year, lpattern(shortdash) lcolor(gray) lwidth(medium)) (line mean_rateCMR_postMDG year, lpattern(dash) lcolor(black) lwidth(medium)), xline(2000) yscale(r(0 5)) ylabel(0(1)5) xscale(r(1975 2015)) xlabel(1975(5)2015) ytitle("Annual rate of progress (%)" "3-year moving average", size(medium)) yscale(titlegap(*10)) yticks(,noticks) plotregion(color(white) lcolor(white)) ylabel(,angle(0)) xtitle("") scheme(s1mono) legend(size(small))
graph export "figure2.tif", replace



**********************************************************************
* B. Figure 3
* Total deaths in children under-5 compared to business-as-usual trajectories,
* developing countries
**********************************************************************

use "u5mr_analysis.dta", clear

** 1. Generate final value for each country if MDG had been achieved
**U5MR = reduced by 2/3rds
gen mdgyes_final_2015 = n1990 * (1/3)

** 2. Generate rate of progress needed to reach MDG by 2015 from 2000
gen mdgyes_rpneeded = 1- (mdgyes_final_2015/n2000)^(1/15)

** 3. Identify values for each country and year as if it had achieved the MDG
for num 2001/2015: gen mdgyes_X = n2000*((1-mdgyes_rpneeded)^(X-2000))

** 4. Estimate under-5 deaths for each year that would have occured if MDG achieved
for num 2001/2015: gen mdgyes_deaths_X = (mdgyes_X / nX ) * cdX    //cd is total U5 deaths per each country per year
for num 2001/2015: label variable mdgyes_deaths_X "estimated X deaths if scaled by (mdgyes_X / U5MR in X )"

** 5. Estimate lives that would have been saved in 2001-2015 if MDG achieved
for num 2001/2015: gen dif_actual_mdgyes_X = cdX - mdgyes_deaths_X   //actual deaths - number of deaths that would have occured if MDG met
for num 2001/2015: label variable dif_actual_mdgyes_X "Counterfactual C: additional lives that would have been saved had MDG been achieved by all"

** 6. Calculate total lives affected
  for num 2001/2015: egen dev_mdgyes_lives_X = sum(dif_actual_mdgyes_X) 
for num 2001/2015: label variable dev_mdgyes_lives_X "Counterfactual C: developing world additional lives that would have been affected in X if MDG achieved"
egen dev_mdgyes_lives_total = rowtotal(dev_mdgyes_lives_2001-dev_mdgyes_lives_2015), missing
label variable dev_mdgyes_lives_total "Counterfactual C: developing world total additional lives that would have been saved 2001-2015 if MDG achieved"

** 7. Keep only relevant variables and reshape
keep CountryName cd* xcmdeaths_cf9000_* xcmdeaths_cf9601_* mdgyes_deaths_*
reshape long cd  xcmdeaths_cf9000_ xcmdeaths_cf9601_ mdgyes_deaths_, i(CountryName) j(year)

** 8. Find the sum of:
* A. Actual deaths
* B. Deaths if 1990-2000 trajectory had continued
* C. Deaths if 1996-2001 trajectory had continued 
* D. Deaths if MDG had been met exactly
collapse (sum) cd mdgyes_deaths_ xcmdeaths_cf9000_ xcmdeaths_cf9601_, by(year)

drop if year<1990 
drop if year >2015

save "figure3.dta", replace




**********************************************************************
* C. Table 1
* Number of countries with any and "real" acceleration post-2000, by initial income group
**********************************************************************

**1. Standardize variable names and create country counts for each indicator by income group
local lista "maternal_mort_modeled_analysis u5mr_analysis genderratio_primary_85_analysis improvedwater_pct__analysis improvedsanitation_pct__analysis primary_completion_85_analysis genderratio_secondary_85_analysis genderratio_tertiary_85_analysis undernourishment__analysis forest_analysis_expand antiretro_pct_analysis inc_poverty___analysis malaria_deaths_analysis terrestrial_protected_analysis_expand"

foreach p of local lista{
use "`p'", clear
drop if IncomeGroup==""

replace IncomeGroup="M" if IncomeGroup=="LM" | IncomeGroup=="UM"

rename difrp*any difrp_any // any acceleration
rename difrp*1 difrp_1 // "real" acceleration 
keep IncomeGroup IndicatorName difrp_any difrp_1 
gen fulldata_dif = 1 if difrp_any!=. // countries in sample

collapse (first) IndicatorName (sum) difrp_any difrp_1 fulldata*, by(IncomeGroup)
save "`p'_colinc", replace
}

**2. Append and reorder all datasets
use "maternal_mort_modeled_analysis_colinc.dta", clear

local lista "inc_poverty___analysis malaria_deaths_analysis u5mr_analysis genderratio_primary_85_analysis improvedwater_pct__analysis improvedsanitation_pct__analysis undernourishment__analysis  primary_completion_85_analysis forest_analysis_expand  antiretro_pct_analysis terrestrial_protected_analysis_expand"
foreach p of local lista{
append using "`p'_colinc"
}

order IndicatorName fulldata*
 * Calculate percent of countries for each category
gen difrp_any_pct = difrp_any/fulldata_dif // % of countries with any accleration
gen difrp_1_pct = difrp_1/fulldata_dif // % of countries with "real" acceleration
order IndicatorName fulldata_dif difrp_any* difrp_1*

 * Generate category names
gen category = "Life and Death" 
replace category = "Basic Needs" if IndicatorName=="Improved water source (% of population with access)"
replace category = "Basic Needs" if IndicatorName=="Improved sanitation facilities (% of population with access)"
replace category = "Basic Needs" if IndicatorName=="Prevalence of undernourishment (% of population)"
replace category = "Basic Needs" if IndicatorName=="Primary completion rate, both sexes (%)"
replace category = "Basic Needs" if IndicatorName=="Gross enrolment ratio, primary, gender parity index (GPI)"
replace category = "Natural Capital" if IndicatorName=="Forest area (% of land area)"
replace category = "Natural Capital" if IndicatorName=="Terrestrial protected areas (% of land area)"
replace category = "Extreme Income Poverty" if IndicatorName=="Poverty headcount ratio at $1.90 (2011 PPP) % of pop"

gen life_deathorder = .
replace life_deathorder = 1 if IndicatorName=="u5mr"
replace life_deathorder = 2 if IndicatorName=="Estimated number of malaria deaths"
replace life_deathorder = 3 if IndicatorName=="Maternal mortality ratio (modeled estimate, per 100,000 live births)"
replace life_deathorder = 4 if IndicatorName=="Antiretroviral therapy coverage (% of people living with HIV)"

gen basic_order = .
replace basic_order = 1 if IndicatorName=="Improved water source (% of population with access)"
replace basic_order = 2 if IndicatorName=="Improved sanitation facilities (% of population with access)"
replace basic_order = 3 if IndicatorName=="Prevalence of undernourishment (% of population)"
replace basic_order = 4 if IndicatorName=="Primary completion rate, both sexes (%)"
replace basic_order = 5 if IndicatorName=="Gross enrolment ratio, primary, gender parity index (GPI)"

gen nat_order = .
replace nat_order = 1 if IndicatorName=="Forest area (% of land area)"
replace nat_order = 2 if IndicatorName=="Terrestrial protected areas (% of land area)"

gen categorynum = .
replace categorynum = 1 if category=="Life and Death"
replace categorynum = 2 if category == "Basic Needs"
replace categorynum = 3 if category == "Extreme Income Poverty"
replace categorynum = 4 if category == "Natural Capital"

sort IncomeGroup categorynum life_deathorder basic_order nat_order
replace IndicatorName = "Under-5 child mortality rate" if IndicatorName=="u5mr"
replace IndicatorName = "Gender parity index (GPI), gross enrollment ratio" if IndicatorName=="Gross enrolment ratio, primary, gender parity index (GPI)"

drop life_deathorder basic_order nat_order

save "table1.dta", replace



**********************************************************************
* D. Figure 4
* Distribution of annual rates of progress in primary school copmletion, 
* 1990-2000 versus 2000-2015
**********************************************************************
use "primary_completion_85_analysis.dta", clear

replace rppre = rppre*100
replace rppost = rppost*100

* All LIC ~1990-2000 v. ~2000-15 *
kdensity  rppre if IncomeGroup=="L" & difrppre_post!=., addplot (kdensity rppost if IncomeGroup=="L" & difrppre_post!=., lpattern(dash) color(black)) ///
lpattern(solid) color(black) legend (label(1 "1990-2000") label(2 "2000-2015") size(small)) title("Low-income countries") xscale(range (-4 5)) ylabel(, angle(0)) yscale(range (0 .4)) ylabel(0(.1).4) xlabel(-4(1)5) xtitle("Average annual rate of progress (pct. point)") ylabel(,labsize(medlarge)) ytitle(, size(large)) xlabel(,labsize(medlarge)) xtitle(, size(large)) scheme(s1mono) 
graph export "figure4_LIC.tif", replace

* All MIC ~1990-2000 v. ~2000-15 *
kdensity  rppre if IncomeGroup!="L" & difrppre_post!=., addplot (kdensity rppost if IncomeGroup!="L" & difrppre_post!=., lpattern(dash) color(black)) ///
lpattern(solid) color(black) legend (label(1 "1990-2000") label(2 "2000-2015") size(small)) title("Middle-income countries")  xscale(range (-4 5)) ylabel(, angle(0)) yscale(range (0 .4)) ylabel(0(.1).4) xlabel(-4(1)5) xtitle("Average annual rate of progress (pct. point)") ylabel(,labsize(medlarge)) ytitle(, size(large)) xlabel(,labsize(medlarge)) xtitle(, size(large)) scheme(s1mono)
graph export "figure4_MIC.tif", replace

* SSA ~1990-2000 v. ~2000-15 *
kdensity  rppre if Region=="SSA" & difrppre_post!=., addplot (kdensity rppost if Region=="SSA" & difrppre_post!=., lpattern(dash) color(black)) ///
lpattern(solid) color(black) legend (label(1 "1990-2000") label(2 "2000-2015") size(small)) title("Sub-Saharan Africa")  xscale(range (-4 5)) ylabel(, angle(0)) xlabel(-4(1)5) yscale(range (0 .4)) ylabel(0(.1).4) xtitle("Average annual rate of progress (pct. point)") ylabel(,labsize(medlarge)) ytitle(, size(large)) xlabel(,labsize(medlarge)) xtitle(, size(large)) scheme(s1mono) 
graph export "figure4_SSA.tif", replace






**********************************************************************
* E. Table 2
* T-test results - changes in average country rates of progress, 1990-2000 versus 2000-2015
**********************************************************************

*A. Life and death
*******************
** 1. Child mortality
use "u5mr_analysis.dta", clear

	*a. All developing
	ttest rp0015==rp9000
	*b. Low-income
	ttest rp0015==rp9000 if IncomeGroup=="L"
	*c. Middle-income
	ttest rp0015==rp9000 if IncomeGroup!="L" 
	*d. Region
	bysort Region: ttest rp0015==rp9000

** 2. Malaria deaths
use "malaria_deaths_analysis.dta", clear

	*a. All developing
	ttest rp0513 == rp0005	
	*b. Low-income
	ttest rp0513 == rp0005 if IncomeGroup=="L"
	*c. Middle-income
	ttest rp0513 == rp0005 if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rp0513 == rp0005	

** 3. Maternal mortality
use "maternal_mort_modeled_analysis.dta", clear

	*a. All developing
	ttest rp0015==rp9000
	*b. Low-income
	ttest rp0015==rp9000 if IncomeGroup=="L"
	*c. Middle-income
	ttest rp0015==rp9000 if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rp0015==rp9000
	
** 4. Antiretroviral therapy
use "antiretro_pct_analysis.dta", clear

	*a. All developing
	ttest rp0215== rp0002	
	*b. Low-income
	ttest rp0215== rp0002 if IncomeGroup=="L"
	*c. Middle-income
	ttest rp0215== rp0002 if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rp0215== rp0002
	

*B. Basic needs
*******************
** 1. Improved water
use "improvedwater_pct__analysis.dta", clear

	*a. All developing
	ttest rppost==rppre
	*b. Low-income
	ttest rppost== rppre if IncomeGroup=="L"
	*c. Middle-income
	ttest rppost== rppre if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rppost==rppre

** 2. Improved sanitation
use "improvedsanitation_pct__analysis.dta", clear

	*a. All developing
	ttest rppost==rppre
	*b. Low-income
	ttest rppost== rppre if IncomeGroup=="L"
	*c. Middle-income
	ttest rppost== rppre if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rppost==rppre
	
** 3. Undernourishment
use "undernourishment__analysis.dta", clear

	*a. All developing
	ttest rp0015== rp9100
	*b. Low-income
	ttest rp0015== rp9100 if IncomeGroup=="L"
	*c. Middle-income
	ttest rp0015== rp9100 if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rp0015== rp9100

** 4. Primary school completion
use "primary_completion_85_analysis.dta", clear

	*a. All developing
	ttest rppost==rppre
	*b. Low-income
	ttest rppost== rppre if IncomeGroup=="L"
	*c. Middle-income
	ttest rppost== rppre if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rppost==rppre
	
** 5. Gender parity index, primary
use "genderratio_primary_85_analysis.dta", clear

	*a. All developing
	ttest rppost==rppre
	*b. Low-income
	ttest rppost== rppre if IncomeGroup=="L"
	*c. Middle-income
	ttest rppost== rppre if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rppost==rppre

	
*C. Income poverty
*******************
** 1. Extreme income poverty
use "inc_poverty___analysis.dta", clear

	*a. All developing
	ttest rppost==rppre
	*b. Low-income
	ttest rppost== rppre if IncomeGroup=="L"
	*c. Middle-income
	ttest rppost== rppre if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rppost==rppre
	
	
*D. Natural capital
*******************
** 1. Forest area
use "forest_analysis_expand.dta", clear

	*a. All developing
	ttest rp0015==rp9000
	*b. Low-income
	ttest rp0015==rp9000 if IncomeGroup=="L"
	*c. Middle-income
	ttest rp0015==rp9000 if IncomeGroup!="L"
	*d. Region
	bysort Region: ttest rp0015==rp9000
	
	
** 2. Protected land area
use "terrestrial_protected_analysis_expand.dta", clear

	*a. All developing
	ttest rp0015==rp9000 
	*b. Low-income
	ttest rp0015==rp9000 if IncomeGroup=="L"
	*c. Middle-income
	ttest rp0015==rp9000 if IncomeGroup!="L" 
	*d. Region
	bysort Region: ttest rp0015==rp9000



**********************************************************************
* F. Table 3
* Cumulative lives saved between 2000/2001 and 2015 due to accelerated progress
**********************************************************************

putexcel set table3.xlsx, sheet(WD) modify

*Heading
putexcel B1 = "All Developing"
putexcel D1 = "China"
putexcel F1 = "India"
putexcel H1 = "Sub-Saharan Africa"
putexcel J1 = "Rest of developing world"
putexcel L1 = "Low-income ex. India"
putexcel N1 = "Middle-income ex. China"

putexcel A2 = "Counterfactual"
putexcel B2 = "A"
putexcel C2 = "B"
putexcel D2 = "A"
putexcel E2 = "B"
putexcel F2 = "A"
putexcel G2 = "B"
putexcel H2 = "A"
putexcel I2 = "B"
putexcel J2 = "A"
putexcel K2 = "B"
putexcel L2 = "A"
putexcel M2 = "B"
putexcel N2 = "A"
putexcel O2 = "B"

**Child mortality
use "u5mr_analysis.dta", clear
putexcel A3 = "Child mortality"

*All developing
*CFA
putexcel B3= dev_cfA_lives_total
*CFB
putexcel C3= dev_cfB_lives_total

*China
*CFA
sort China_cfA_lives_total
carryforward China_cfA_lives_total, replace
putexcel D3= China_cfA_lives_total
*CFB
sort China_cfB_lives_total
carryforward China_cfB_lives_total, replace
putexcel E3= China_cfB_lives_total

*India
*CFA
sort India_cfA_lives_total
carryforward India_cfA_lives_total, replace
putexcel F3= India_cfA_lives_total
*CFB
sort India_cfB_lives_total
carryforward India_cfB_lives_total, replace
putexcel G3= India_cfB_lives_total

*Sub-Saharan Africa
*CFA
keep if Region=="SSA"
putexcel H3 = region_cfA_lives_total
*CFB
putexcel I3 = region_cfB_lives_total

*Rest of developing World 
use "u5mr_analysis.dta", clear
*CFA 
putexcel J3 = ROW_cfA_lives_total
*CFB
putexcel K3 = ROW_cfB_lives_total

*LIC excl. India
*CFA
sort LICxind_cfA_lives_total
carryforward LICxind_cfA_lives_total, replace
putexcel L3 = LICxind_cfA_lives_total
*CFB
sort LICxind_cfB_lives_total
carryforward LICxind_cfB_lives_total, replace
putexcel M3 = LICxind_cfB_lives_total

*MIC excl. China
*CFA
sort MICxchn_cfA_lives_total
carryforward MICxchn_cfA_lives_total, replace
putexcel N3 = MICxchn_cfA_lives_total
*CFB
sort MICxchn_cfB_lives_total
carryforward MICxchn_cfB_lives_total, replace
putexcel O3 = MICxchn_cfB_lives_total


**Maternal mortality
use "maternal_mort_modeled_analysis.dta", clear
putexcel A4 = "Maternal mortality"

*All developing
*CFA
putexcel B4= dev_cfA_lives_total
*CFB
putexcel C4= dev_cfB_lives_total

*China
*CFA
sort China_cfA_lives_total
carryforward China_cfA_lives_total, replace
putexcel D4= China_cfA_lives_total
*CFB
sort China_cfB_lives_total
carryforward China_cfB_lives_total, replace
putexcel E4= China_cfB_lives_total

*India
*CFA
sort India_cfA_lives_total
carryforward India_cfA_lives_total, replace
putexcel F4= India_cfA_lives_total
*CFB
sort India_cfB_lives_total
carryforward India_cfB_lives_total, replace
putexcel G4= India_cfB_lives_total

*Sub-Saharan Africa
*CFA
keep if Region=="SSA"
putexcel H4 = region_cfA_lives_total
*CFB
putexcel I4 = region_cfB_lives_total

*Rest of developing World 
use "maternal_mort_modeled_analysis.dta", clear
*CFA 
putexcel J4 = ROW_cfA_lives_total
*CFB
putexcel K4 = ROW_cfB_lives_total

*LIC excl. India
*CFA
sort LICxind_cfA_lives_total
carryforward LICxind_cfA_lives_total, replace
putexcel L4 = LICxind_cfA_lives_total
*CFB
sort LICxind_cfB_lives_total
carryforward LICxind_cfB_lives_total, replace
putexcel M4 = LICxind_cfB_lives_total

*MIC excl. China
*CFA
sort MICxchn_cfA_lives_total
carryforward MICxchn_cfA_lives_total, replace
putexcel N4 = MICxchn_cfA_lives_total
*CFB
sort MICxchn_cfB_lives_total
carryforward MICxchn_cfB_lives_total, replace
putexcel O4 = MICxchn_cfB_lives_total



**Tuberculosis deaths
use "TB_deaths_analysis.dta", clear
putexcel A5 = "Tuberculosis deaths"

*All developing
*CFD
putexcel B5:C5= dev_cfd_lives_all

*China
*CFD
sort China_cfd_lives_all
carryforward China_cfd_lives_all, replace
putexcel D5:E5= China_cfd_lives_all

*India
*CFD
sort India_cfd_lives_all
carryforward India_cfd_lives_all, replace
putexcel F5:G5= India_cfd_lives_all

*Sub-Saharan Africa
*CFD
keep if Region=="SSA"
putexcel H5:I5 = region_cfd_lives_all

*Rest of developing World 
use "TB_deaths_analysis.dta", clear
*CFD 
putexcel J5:K5 = ROW_cfd_lives_all


*LIC excl. India
*CFD
sort LICxind_cfd_lives_all
carryforward LICxind_cfd_lives_all, replace
putexcel L5:M5 = LICxind_cfd_lives_all

*MIC excl. China
*CFD
sort MICxchn_cfd_lives_all
carryforward MICxchn_cfd_lives_all, replace
putexcel N5:O5 = MICxchn_cfd_lives_all


**HIV/AIDS deaths
use "antiretro_pct_deathsaverted.dta", clear
putexcel A6 = "HIV/AIDS deaths"

*All developing
*CFA
putexcel B6:C6= dev_lives

*China
*CFA
keep if CountryCode=="CHN"
putexcel D6:E6= deathsaverted

*India
*CFA
use "antiretro_pct_deathsaverted.dta", clear
keep if CountryCode=="IND"
putexcel F6:G6= deathsaverted

*Sub-Saharan Africa
*CFA
use "antiretro_pct_deathsaverted.dta", clear
keep if Region=="SSA"
putexcel H6:I6 = reg_lives

*Rest of developing World 
use "antiretro_pct_deathsaverted.dta", clear
*CFA 
putexcel J6:K6 = ROW_lives

*LIC excl. India
*CFA
sort LICxInd_lives
carryforward LICxInd_lives, replace
putexcel L6:M6 = LICxInd_lives

*MIC excl. China
*CFA
sort MICxInd_lives
carryforward MICxInd_lives, replace
putexcel N6:O6 = MICxInd_lives



***TOTAL lives saved
import excel "table3.xlsx", sheet("WD") cellrange(A2:O6) firstrow clear
collapse (sum) A-O
putexcel A8 = "TOTAL LIVES SAVED"
putexcel B8 = A
putexcel C8 = B
putexcel D8 = D
putexcel E8 = E
putexcel F8 = F
putexcel G8 = G
putexcel H8 = H
putexcel I8 = I
putexcel J8 = J
putexcel K8 = K
putexcel L8 = L
putexcel M8 = M
putexcel N8 = N
putexcel O8 = O



**********************************************************************
* G. Table 4
* Lives improved as of 2015 - or not - due to accelerated progress since 2000
**********************************************************************

putexcel set table4.xlsx, sheet(WD) modify

*Heading
putexcel B1 = "All Developing"
putexcel D1 = "China"
putexcel F1 = "India"
putexcel H1 = "Sub-Saharan Africa"
putexcel J1 = "Rest of developing world"
putexcel L1 = "Low-income ex. India"
putexcel N1 = "Middle-income ex. China"

putexcel A2 = "Counterfactual"
putexcel B2 = "A"
putexcel C2 = "B"
putexcel D2 = "A"
putexcel E2 = "B"
putexcel F2 = "A"
putexcel G2 = "B"
putexcel H2 = "A"
putexcel I2 = "B"
putexcel J2 = "A"
putexcel K2 = "B"
putexcel L2 = "A"
putexcel M2 = "B"
putexcel N2 = "A"
putexcel O2 = "B"

**Improved water
use "improvedwater_pct__analysis.dta", clear
putexcel A3 = "Improved water"

*All developing
*CFA
putexcel B3= dev_cfA_lives_full

*China
*CFA
sort China_cfA_lives_full
carryforward China_cfA_lives_full, replace
putexcel D3= China_cfA_lives_full

*India
*CFA
sort India_cfA_lives_full
carryforward India_cfA_lives_full, replace
putexcel F3= India_cfA_lives_full

*Sub-Saharan Africa
*CFA
keep if Region=="SSA"
putexcel H3 = region_cfA_lives_full

*Rest of developing World 
use "improvedwater_pct__analysis.dta", clear
*CFA 
putexcel J3 = ROW_cfA_lives_full

*LIC excl. India
*CFA
sort LICxind_cfA_lives_full
carryforward LICxind_cfA_lives_full, replace
putexcel L3 = LICxind_cfA_lives_full

*MIC excl. China
*CFA
sort MICxchn_cfA_lives_full
carryforward MICxchn_cfA_lives_full, replace
putexcel N3 = MICxchn_cfA_lives_full


**Improved sanitation
use "improvedsanitation_pct__analysis.dta", clear
putexcel A4 = "Improved sanitation"

*All developing
*CFA
putexcel B4= dev_cfA_lives_full

*China
*CFA
sort China_cfA_lives_full
carryforward China_cfA_lives_full, replace
putexcel D4= China_cfA_lives_full

*India
*CFA
sort India_cfA_lives_full
carryforward India_cfA_lives_full, replace
putexcel F4= India_cfA_lives_full

*Sub-Saharan Africa
*CFA
keep if Region=="SSA"
putexcel H4 = region_cfA_lives_full

*Rest of developing World 
use "improvedsanitation_pct__analysis.dta", clear
*CFA 
putexcel J4 = ROW_cfA_lives_full

*LIC excl. India
*CFA
sort LICxind_cfA_lives_full
carryforward LICxind_cfA_lives_full, replace
putexcel L4 = LICxind_cfA_lives_full

*MIC excl. China
*CFA
sort MICxchn_cfA_lives_full
carryforward MICxchn_cfA_lives_full, replace
putexcel N4 = MICxchn_cfA_lives_full


**Undernourishment
use "undernourishment_AG_analysis.dta", clear
putexcel A5 = "Undernourishment"

*All developing
*CFA
keep if CountryCode=="LMY"
putexcel B5= xaff_cf9100_2015
*CFB
use "undernourishment_AG_analysis.dta", clear
keep if CountryCode=="LMY"
putexcel C5= xaff_cf9601_2015

*China
*CFA
use "undernourishment__analysis.dta", clear
keep if CountryCode=="CHN"
putexcel D5 = China_cfA_lives_2015
*CFB
putexcel E5 = China_cfB_lives_2015

*India
*CFA
use "undernourishment__analysis.dta", clear
keep if CountryCode=="IND"
putexcel F5= India_cfA_lives_2015
*CFB
putexcel G5= India_cfB_lives_2015

*Sub-Saharan Africa
*CFA
use "undernourishment_AG_analysis.dta", clear
keep if CountryCode=="SSA"
putexcel H5 = xaff_cf9100_2015
*CFB
putexcel I5 = xaff_cf9601_2015

*Rest of developing World 
use "undernourishment_AG_analysis.dta", clear
keep if CountryCode=="ROW"
*CFA 
putexcel J5 = xaff_cf9100_2015
*CFB
putexcel K5 = xaff_cf9601_2015



**Primary school completion
use "primary_completion_ag_clean_analysis.dta", clear
putexcel A6 = "Primary school completed"

*All developing
*CFA
keep if CountryCode=="LMY"
putexcel B6= xaff_cf9000_total
*CFB
use "primary_completion_ag_clean_analysis.dta", clear
keep if CountryCode=="LMY"
putexcel C6= xaff_cf9601_total


*Sub-Saharan Africa
*CFA
use "primary_completion_ag_clean_analysis.dta", clear
keep if CountryCode=="SSA"
putexcel H6 = xaff_cf9000_total
*CFB
putexcel I6 = xaff_cf9601_total



**Income Poverty
use "poverty_HCT_full_analysis.dta", clear
putexcel A7 = "Extreme income poverty"

*All developing
*CFA
keep if Region=="Developing World"
putexcel B7= (xaff_cf9002_2013*1000000) // in millions
*CFB
use "poverty_HCT_full_analysis.dta", clear
keep if Region=="Developing World"
putexcel C7= (xaff_cf9602_2013*1000000) // in millions

*China
*CFA
use "poverty_HCT_full_analysis.dta", clear
keep if Region=="China*"
putexcel D7 = (xaff_cf9002_2013*1000000) // in millions
*CFB
putexcel E7 = (xaff_cf9602_2013*1000000) // in millions

*India
*CFA
use "poverty_HCT_full_analysis.dta", clear
keep if Region=="India*"
putexcel F7= (xaff_cf9002_2013*1000000) // in millions
*CFB
putexcel G7= (xaff_cf9602_2013*1000000) // in millions

*Sub-Saharan Africa
*CFA
use "poverty_HCT_full_analysis.dta", clear
keep if Region=="Sub-Saharan Africa"
putexcel H7 = (xaff_cf9002_2013*1000000) // in millions
*CFB
putexcel I7 = (xaff_cf9602_2013*1000000) // in millions

*Rest of developing World 
use "poverty_HCT_full_analysis.dta", clear
keep if Region=="Rest of World"
*CFA 
putexcel J7 = (xaff_cf9002_2013*1000000) // in millions
*CFB
putexcel K7 = (xaff_cf9602_2013*1000000) // in millions



**********************************************************************
* H. Figure 5
* Acceleration versus progress during the MDG era, by initial icome group
**********************************************************************

****************************************************************
**MMR and U5MR - birth-weighted average for 1990, 2000, and 2015; RP 90-00 RP 00-15
*1. LIC ex India
*2. MIC ex China
****************************************************************
local lista "maternal_mort_modeled_analysis u5mr_analysis" 
foreach p of local lista{

use "`p'", clear

keep CountryName CountryCode IncomeGroup Region n1990 n2000 n2015 birth1990 birth2015 birth2000
 * Reshape long to enable collapse
reshape long n birth, i(CountryName CountryCode) j(year)
save "`p'_syn_LONG", replace

****************
*1. LIC ex India
****************
keep if IncomeGroup=="L"
drop if CountryCode=="IND"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "LIC ex India"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp0015 = 1- (n2015/n2000)^(1/15)
save "`p'_pctchng_LICexIND", replace

****************
*2. MIC ex China
****************
use "`p'_syn_LONG", clear
keep if IncomeGroup!="L"
drop if CountryCode=="CHN"
 * Birth-weighted Average
collapse (mean) n [weight=birth], by(year)
gen group = "MIC ex China"
reshape wide n, i(group) j(year)
 * RP calculations
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp0015 = 1- (n2015/n2000)^(1/15)
save "`p'_pctchng_MICexCHN", replace

append using "`p'_pctchng_LICexIND"
gen indicator ="`p'"
save "`p'_pctchngMICLIC", replace
}

********************************************************************************
**Water and Sanitation
*1. LIC ex India
*2. MIC ex China
********************************************************************************
local listd "improvedwater_pct__analysis improvedsanitation_pct__analysis"
foreach d of local listd{

use "`d'", clear

 *Missing data results in variations in initial/final year across countries, use country-level rate of progress calculation to extrapolate 1990 value, 2015, and 2000
gen created1990 = n1990
 replace created1990 = rppre*(-1)+n1991 if created1990==.
 replace created1990 = rppre*(-2)+n1992 if created1990==.
 replace created1990 = rppre*(-3)+n1993 if created1990==.
 replace created1990 = rppre*(-4)+n1994 if created1990==.
 replace created1990 = rppre*(-5)+n1995 if created1990==.

gen created2015 = n2015
 replace created2015 = rppost*(1)+n2014 if created2015==.
 replace created2015 = rppost*(2)+n2013 if created2015==.
 replace created2015 = rppost*(3)+n2012 if created2015==.
 replace created2015 = rppost*(4)+n2011 if created2015==.
 replace created2015 = rppost*(5)+n2010 if created2015==. 
 
gen created2000 = n2000
 replace created2000 = rppre*(-1)+n2001 if created2000==.
 replace created2000 = rppre*(1)+n1999 if created2000==.

keep CountryName CountryCode IncomeGroup Region created1990 created2015 created2000 fulln2015 pop1990 pop2000 pop2015
reshape long fulln pop created, i(CountryName CountryCode) j(year)
save "`d'_LONG_all.dta", replace
keep if IncomeGroup=="L"
save "`d'_LONG_LIC.dta", replace

****************
*1. LIC ex India
****************
use "`d'_LONG_all.dta", replace
keep if IncomeGroup=="L"
drop if CountryCode=="IND"
save "`d'_LONG_LICexIND.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "LIC ex IND"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * rate of progress; this is using the extrapolated value for 1990, 2000 and 2015
gen rppre_EX = 1-((created2000/created1990)^(1/10))
gen rppost_EX = 1-((created2015/created2000)^(1/15))
save "`d'_pctchngLICexIND", replace

****************
*2. MIC ex China
****************
use "`d'_LONG_all.dta", replace
keep if IncomeGroup!="L"
drop if CountryCode=="CHN"
save "`d'_LONG_MICexCHN.dta", replace

* Population-weighted average using extrapolated value for 1990 and 2015
collapse (mean) created [weight=pop], by(year)
gen group = "MIC ex CHN"
reshape wide created, i(group) j(year)
 *RP calculations use % without to standardize
foreach var of varlist created1990 created2000 created2015{
replace `var' = 1-`var'
}
 * rate of progress; this is using the extrapolated value for 1990, 2000 and 2015
gen rppre_EX = 1-((created2000/created1990)^(1/10))
gen rppost_EX = 1-((created2015/created2000)^(1/15))
save "`d'_pctchngMICexCHN", replace

append using "`d'_pctchngLICexIND"
gen indicator ="`d'"
save "`d'_pctchngMICLIC", replace
}

***APPEND ALL FOR EXPORT and standardize names
********************************************************************************
local lista "maternal_mort_modeled_analysis improvedwater_pct__analysis improvedsanitation_pct__analysis"
use "u5mr_analysis_pctchngMICLIC.dta", clear

foreach p of local lista{
append using "`p'_pctchngMICLIC"
}

replace n1990 = created1990 if created1990!=.
replace n2015 = created2015 if created2015!=.
replace n2000 = created2000 if created2000!=.

replace rp9000 = rppre_EX if rppre_EX!=.
replace rp0015 = rppost_EX if rppost_EX!=.

keep group n1990 n2000 n2015 rp9000 rp0015 indicator

order indicator group n1990 n2000 n2015 rp9000 rp0015
sort group indicator


**Calculate the value of the problem in percent
****************
gen prob_pct1990 = n1990
replace prob_pct1990 = n1990/100000 if indicator=="maternal_mort_modeled_analysis"
replace prob_pct1990 = n1990/1000 if indicator=="u5mr_analysis"

gen prob_pct2015 = n2015
replace prob_pct2015 = n2015/100000 if indicator=="maternal_mort_modeled_analysis"
replace prob_pct2015 = n2015/1000 if indicator=="u5mr_analysis"


**Calculate the share of the problem eliminated from 1990 to 2015
****************
gen share_elim = 1-(prob_pct2015/prob_pct1990)


**Calculate the ratio of rate of progress pre and post
****************
gen rp_ratio = rp0015/rp9000
replace rp_ratio = . if rp_ratio<0 //calculation cannot be performed when rates of progress flip from negative to positive 

replace indicator = "CMR" if indicator=="u5mr_analysis"
replace indicator = "MMR" if indicator=="maternal_mort_modeled_analysis"
replace indicator = "Water" if indicator=="improvedwater_pct__analysis"
replace indicator = "Sanitation" if indicator=="improvedsanitation_pct__analysis"


twoway (scatter rp_ratio share_elim if (group=="LIC ex IND"| group=="LIC ex India"), mcolor(ltblue) mlabel(indicator)) (scatter rp_ratio share_elim if (group=="MIC ex CHN" | group=="MIC ex China"), mcolor(cranberry) mlabel(indicator)), yscale (range (0 3)) ylabel(0(1)3) xscale (range (0 1)) xlabel(0(.2)1) legend (label(1 "LIC excl. India") label(2 "MIC excl. China"))
save "figure5.dta", replace
