clear
set more off
cd 

****************************************************************************
****************************************************************************
**  6.  NATURAL CAPITAL INDICATORS
** forest cover (% of land) * terrestrial protected area

** John W. McArthur & Krista Rasmussen
** January 2018
****************************************************************************
****************************************************************************

****************************************************************************
*** FOREST COVER * TERRESTRIAL PROTECTED AREA
* forest cover has annual data for all years (1990-2015)
* terrestrial protected area has data for only 1990, 2000, 2014
****************************************************************************
*I. Rate of progress and counterfactual calculations
	*A. Rate of progress (percentage point), pre and post-MDG
	*B. Difference in rate of progress
	*C. Extrapolate pre-MDG rate of progress to find counterfactual
*II. Country count acceleration test and lives improved
	*A. Acceleration test - country count
****************************************************************************

***************************************************
**I. RATE OF PROGRESS AND COUNTERFACTUAL CALCULATIONS
***************************************************
local lista "forest terrestrial_protected"

foreach p of local lista{
use "`p'_clean", clear

***************************************************
* A* Calculate Rate of Progress: average annual percentage point change 
***************************************************

 **Pre-MDG Average Annual Percentage Point Change
************************************** 
gen rp9000 = (n2000-n1990)/10
gen rp9601 = (n2001-n1996)/5 //only possible for forest cover

 **Post-MDG Average Annual Percentage Point Change
**************************************
gen rp0015 = (n2015-n2000)/15
 replace rp0015 = (n2014-n2000)/14 if n2015==. //forest area has data for 2015, protected land area ends at 2014
gen rp0115 = (n2015-n2001)/14 // only possible for forest cover


***************************************************
 * B * Calculate the difference between pre and post rates of progress
***************************************************
*1990-2000 v. 2000-2015 and 1996-2001 v. 2001-2015
local listb "9000 9601" //years 1990-2001  and 96-01
local listc "0015 0115" //years 2000-2015 and 01-15

foreach pre of local listb{
foreach pos of local listc{

gen difrp`pre'_`pos' = rp`pos'-rp`pre' 
label var difrp`pre'_`pos' "dif in rate of progress, (`pos')-(`pre')"

gen fulldata`pre'_`pos'=0
replace fulldata`pre'_`pos' = 1 if rp`pre'!=. & rp`pos'!=.
label var fulldata`pre'_`pos' "# countries with full data `pre' and `pos'"
}
}
drop *9601_0015 *9000_0115

***************************************************
 * C * Use rate of progress to generate counterfactual for 2001-2015
***************************************************
** at 1990-2000 and 
local listb "9000"

foreach pre of local listb{
for num 2001/2015: gen cf`pre'_X = n2000+(rp`pre'*(X - 2000)) if rp`pre'!=.
for num 2001/2015: replace cf`pre'_X = 1 if cf`pre'_X > 1 & cf`pre'_X!=. //can't have more than 100%
for num 2001/2015: label variable cf`pre'_X "`p' X extrapolation from `pre' rates"
}

** at 1996-2001 and 
local listb "9601"

foreach pre of local listb{
for num 2002/2015: gen cf`pre'_X = n2001+(rp`pre'*(X - 2001)) if rp`pre'!=.
for num 2002/2015: replace cf`pre'_X = 1 if cf`pre'_X > 1 & cf`pre'_X!=. //can't have more than 100%
for num 2002/2015: label variable cf`pre'_X "`p' X extrapolation from `pre' rates"
}

save "`p'_rpfull", replace
}


***************************************************
**II. COUNTRY COUNT ACCELERATION TEST AND FOREST COVER/LAND PROTECTED IMPROVED  
***************************************************

local lista "forest terrestrial_protected"
foreach p of local lista{
use "`p'_rpfull", clear

***************************************************
 * A * Acceleration test - simple country count
***************************************************

* (i) Create dummy variable for countries that had any acceleration between 1990-2000 and 2000-2015
gen difrp9000_0015_any = 0
 replace difrp9000_0015_any = 1 if difrp9000_0015>0
 replace difrp9000_0015_any = . if difrp9000_0015==.
 replace difrp9000_0015_any = 0 if rp0015<=0 & difrp9000_0015!=. //exclude countries from acceleration count that are still decreasing land cover (even if at a slower rate)

* (i) Create dummy variable for countries that had "real" acceleration between 1990-2000 and 2000-2015
 **Difference in rate is >= .33 percentage points per year
gen difrp9000_0015_1 = 0
 replace difrp9000_0015_1 = 1 if difrp9000_0015 >=.0033 
 replace difrp9000_0015_1 = . if difrp9000_0015==.
 replace difrp9000_0015_1 = 0 if rp0015<=0 & difrp9000_0015!=. //exclude countries from acceleration count that are still decreasing land cover (even if at a slower rate)
label variable difrp9000_0015_1 "rate of progress in 0015 .33 pct point greater than 9000"

save "`p'_analysis_expand", replace
}

