cd
set more off

****************************************
****************************************
**		GUIDE TO STATA FILES FOR
**    		Change Of Pace: 
** 		Accelerations and advances 
** during the Millennium Development Goal era

** John W. McArthur & Krista Rasmussen
** January 2018

** https://doi.org/10.1016/j.worlddev.2017.12.030
****************************************
****************************************

* Core sample includes 155 UN member states that were classified 
* as developing countries as of 2000, using World Bank criteria.

** Population data from U.N.-DESA (2017) 
** Primary school-aged population from U.N.-DESA (2017)
** Total child deaths from U.N.-IGME (2017)
** Births from U.N.-DESA (2017)
** Total land area from World Bank, WDI open data (2017)	

****************************************
****************************************
* Analysis do-files by indicator category
****************************************
****************************************

****************************************
*1. Mortality indicators
* Under-5 child mortality rate "u5mr_clean.dta"
* Maternal mortality rate "maternal_mort_modeled_clean.dta"
****************************************
do "2_mortality.do"

****************************************
*2. Infectious disease indicators
* Tuberculosis deaths "TB_deaths.dta"
* Malaria deaths "malaria_deaths_WHO.dta"
* Antiretroviral therapy coverage + HIV/AIDS deaths "antiretro_pct_clean"
****************************************
do "2_infectious.do"

****************************************
*3. Indicators with 50 percent targets
* Access to water "improvedwater_pct_clean.dta"
* Access to sanitation "improvedsanitation_pct_clean.dta"
* Undernourishment (country level and aggregate) "undernourishment_clean.dta" + "undernourishment_AG_clean.dta"
* Income poverty (country level) - use for country-level tests "inc_poverty_clean.dta"
****************************************
do "2_50pct.do"

****************************************
*4. Indicators with 100 percent targets
* Primary school completion rate (country level and aggregate) "primary_completion_85_clean.dta" + "primary_completion_ag_clean.dta"
* Gender parity index in primary, secondary, tertiary "genderratio_primary_85_clean.dta" + "genderratio_secondary_85_clean.dta" + "genderratio_tertiary_85_clean.dta"
****************************************
do "2_100pct.do"

****************************************
*5. Extreme income poverty - aggregate
* Income poverty (aggregate) - use for summing lives improved across countries "poverty_HCT.dta" + "chinainda_individual_HCT_long.dta" + "chinainda_individual_HCT.dta"
****************************************
do "2_povertyAg.do"

****************************************
*6. Natural capital indicators
* forest cover "forest_clean.dta"
* terretrial protected area "terrestrial_protected_clean.dta"
****************************************
do "2_natural.do"

****************************************
*7. Paper figures and tables
****************************************
do "3_tables_figures"

****************************************
*8. Appendix figures and tables
****************************************
do "4_apdex_tables_figures"
