cap log close
set more 1
tempfile temp1
clear

*this file produces figures for the comment "Health and longevity in America: a comment on Case and Deaton's "Morbidity and Mortality in the 21st century"

log using pictures.log, replace
cd "/Users/Alleras/Dropbox/Case-Deaton"
set scheme lean2

*set obs 500000
set obs 100000
set seed 339487731

/*******************************************************
*estimated parameters for Women from SSA data and SMM.
 I         delta      sigma    alpha     mu _0      I_growth rate
 0.0554    0.0012    0.1515    1.3049    1.7424    1.0224
********/

 
gen h0=rnormal(1.7424,1)
gen hy0=rnormal(1.7424,1)
gen hyy0=rnormal(1.7424,1)
gen hb0=rnormal(1.7424,1)
gen hc0=rnormal(1.7424,1)
gen hd0=rnormal(1.7424,1)
gen ha0=rnormal(1.7424,1)

*whites
gen hwb0=rnormal(1.7424,1)
gen hwas0=rnormal(1.92,1)

*low-ses
gen hbb0=rnormal(1,1)
gen hbas0=rnormal(1.3,1)

scalar define delta=0.0012
scalar define alpha=1.3049
scalar define hmin=0

forvalues t=1(1)100 {

*baseline population: white females born in 1940

gen shock`t'=rnormal(0,0.1515)
gen invest`t'=0.0554*1.0224^(`t'-1)

gen h`t'=h0+invest`t'-(delta*`t'^alpha)+shock`t'
gen drate`t'=(h`t'<=hmin) if h0~=.
replace h0=h`t' if drate`t'==0
replace h0=. if drate`t'==1 | drate`t'==.
gen stock`t'=h`t' if drate`t'==0
replace stock`t'=. if drate`t'==1 | drate`t'==.

gen disease`t'=.
replace disease`t'=1 if stock`t'<=0.9 & stock`t'>hmin
replace disease`t'=0 if stock`t'>0.9 & stock`t'~=.

gen age`t'=`t'
*end baseline

*increases in initial conditions but lower I at age 20
gen investwas`t'=1.1*0.0554*1.0224^(`t'-1) if `t'<20
replace investwas`t'=1.1*0.80*0.0554*1.0224^(`t'-1) if `t'>=20

gen hwas`t'=hwas0+investwas`t'-(delta*`t'^alpha)+shock`t'
gen dratewas`t'=(hwas`t'<=hmin) if hwas0~=.
replace hwas0=hwas`t' if dratewas`t'==0
replace hwas0=. if dratewas`t'==1 | dratewas`t'==.
gen stockwas`t'=hwas`t' if dratewas`t'==0
replace stockwas`t'=. if dratewas`t'==1 | dratewas`t'==.

*black population: start lower 
*basline black
gen investb`t'=0.051*1.0224^(`t'-1)

gen hbb`t'=hbb0+investb`t'-(delta*`t'^alpha)+shock`t'
gen dratebb`t'=(hbb`t'<=hmin) if hbb0~=.
replace hbb0=hbb`t' if dratebb`t'==0
replace hbb0=. if dratebb`t'==1 | dratebb`t'==.
gen stockbb`t'=h`t' if dratebb`t'==0
replace stockbb`t'=. if dratebb`t'==1 | drate`t'==.

*improvements in initial conditions but change in I at age 20
gen investbas`t'=1.17*0.051*1.0224^(`t'-1) if `t'<20
replace investbas`t'=1.17*0.80*0.051*1.0224^(`t'-1) if `t'>=20

gen hbas`t'=hbas0+investbas`t'-(delta*`t'^alpha)+shock`t'
gen dratebas`t'=(hbas`t'<=hmin) if hbas0~=.
replace hbas0=hbas`t' if dratebas`t'==0
replace hbas0=. if dratebas`t'==1 | dratebas`t'==.
gen stockbas`t'=hbas`t' if dratebas`t'==0
replace stockbas`t'=. if dratebas`t'==1 | dratebas`t'==.

*investment cut by half at 20

gen investy`t'=0.0554*1.0224^(`t'-1) if `t'<20
replace investy`t'=0.9*0.0554*1.0224^(`t'-1) if `t'>=20

gen hy`t'=hy0+investy`t'-(delta*`t'^alpha)+shock`t'
gen dratey`t'=(hy`t'<=hmin) if hy0~=.
replace hy0=hy`t' if dratey`t'==0
replace hy0=. if dratey`t'==1 | dratey`t'==.
gen stocky`t'=hy`t' if dratey`t'==0
replace stocky`t'=. if dratey`t'==1 | dratey`t'==.

gen diseasey`t'=.
replace diseasey`t'=1 if stocky`t'<=0.9 & stocky`t'>hmin
replace diseasey`t'=0 if stocky`t'>0.9 & stocky`t'~=.

*I-growth rate cut by half

gen investyy`t'=0.0554*1.0224^(`t'-1) if `t'<20
replace investyy`t'=0.0554*1.0112^(`t'-1) if `t'>=20

gen hyy`t'=hyy0+investyy`t'-(delta*`t'^alpha)+shock`t'
gen drateyy`t'=(hyy`t'<=hmin) if hyy0~=.
replace hyy0=hyy`t' if drateyy`t'==0
replace hyy0=. if drateyy`t'==1 | drateyy`t'==.
gen stockyy`t'=hyy`t' if drateyy`t'==0
replace stockyy`t'=. if drateyy`t'==1 | drateyy`t'==.

gen diseaseyy`t'=.
replace diseaseyy`t'=1 if stockyy`t'<=0.9 & stockyy`t'>hmin
replace diseaseyy`t'=0 if stockyy`t'>0.9 & stockyy`t'~=.

*accident increase 
gen hb`t'=hb0+invest`t'-(delta*`t'^alpha)+shock`t'
gen drateb`t'=(hb`t'<=hmin) if hb0~=.
gen u`t'=runiform() if  20<=`t' & hb0~=.
replace drateb`t'=1 if (u`t'<0.005) & 20<=`t' & hb0~=.
replace hb0=hb`t' if drateb`t'==0
replace hb0=. if drateb`t'==1 | drateb`t'==.
gen stockb`t'=hb`t' if drateb`t'==0
replace stockb`t'=. if drateb`t'==1 | drateb`t'==.

gen diseaseb`t'=.
replace diseaseb`t'=1 if stockb`t'<=0.9 & stockb`t'>hmin
replace diseaseb`t'=0 if stockb`t'>0.9 & stockb`t'~=.

*variance increase
gen shockc`t'=rnormal(0,0.1515) 
replace shockc`t'=rnormal(0,0.21) if `t'>=20

gen hc`t'=hc0+invest`t'-(delta*`t'^alpha)+shockc`t'
gen dratec`t'=(hc`t'<=hmin) if hc0~=.
replace hc0=hc`t' if dratec`t'==0
replace hc0=. if dratec`t'==1 | dratec`t'==.
gen stockc`t'=hc`t' if dratec`t'==0
replace stockc`t'=. if dratec`t'==1 | dratec`t'==.

gen diseasec`t'=.
replace diseasec`t'=1 if stockc`t'<=0.9 & stockc`t'>hmin
replace diseasec`t'=0 if stockc`t'>0.9 & stockc`t'~=.

*threshold increase 
gen hd`t'=hd0+invest`t'-(delta*`t'^alpha)+shock`t'
gen drated`t'=(hd`t'<=hmin) if hd0~=. & `t'<20
replace drated`t'=(hd`t'<=0.15) if hd0~=. & `t'>=20
replace hd0=hd`t' if drated`t'==0
replace hd0=. if drated`t'==1 | drated`t'==.
gen stockd`t'=hd`t' if drated`t'==0
replace stockd`t'=. if drated`t'==1 | drated`t'==.

gen diseased`t'=.
replace diseased`t'=1 if stockd`t'<=0.9 & stockd`t'>hmin & `t'<20
replace diseased`t'=1 if stockd`t'<=0.9 & stockd`t'>0.15 & `t'>=20
replace diseased`t'=0 if stockd`t'>0.9 & stockd`t'~=.

*increase in depreciation rate
gen ha`t'=ha0+invest`t'-(delta*`t'^alpha)+shock`t' if `t'<20
replace ha`t'=ha0+invest`t'-(delta*1.1*`t'^alpha)+shock`t' if `t'>=20
gen dratea`t'=(ha`t'<=hmin) if ha0~=.
replace ha0=ha`t' if dratea`t'==0
replace ha0=. if dratea`t'==1 | dratea`t'==.
gen stocka`t'=ha`t' if dratea`t'==0
replace stocka`t'=. if dratea`t'==1 | dratea`t'==.

gen diseasea`t'=.
replace diseasea`t'=1 if stocka`t'<=0.9 & stocka`t'>hmin
replace diseasea`t'=0 if stocka`t'>0.9 & stocka`t'~=.
*/
}


gen n=1

collapse drate* disease*, by(n)
*reshape long drate dratewas dratebb dratebas, i(n) j(age)

reshape long drate dratey drateyy drateb dratec drated dratea disease diseasey diseaseyy diseaseb diseasec diseased diseasea dratewas dratebb dratebas, i(n) j(age)
drop if age>70 
gen lndrate=ln(drate)
*check age profiles 
line lndrate age
line disease age
*generate figures 


twoway lpoly disease age if age>=20||  lpoly diseasey age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Lower I") pos(11) ring(0)) ytitle("Disease rate") xtitle("Age") saving(Ishock20d, replace)
twoway lpoly drate age if age>=20||  lpoly dratey age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Lower I") pos(11) ring(0)) ytitle("Mortality rate") xtitle("Age") saving(Ishock20m, replace)
graph combine Ishock20m.gph Ishock20d.gph, saving(casedeatonI, replace) title("A. Decrease in annual investment")
graph export casedeatonI.pdf, replace 

twoway lpoly disease age if age>=20||  lpoly diseaseyy age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Lower r") pos(11) ring(0)) ytitle("Disease rate") xtitle("Age") saving(Ishock20d2, replace)
twoway lpoly drate age if age>=20||  lpoly drateyy age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Lower r") pos(11) ring(0)) ytitle("Mortality rate") xtitle("Age") saving(Ishock20m2, replace)
graph combine Ishock20m2.gph Ishock20d2.gph, saving(casedeatonI, replace) title("B. Decrease in rate of growth of annual investment")
graph export casedeatonR.pdf, replace

twoway lpoly disease age if age>=20||  lpoly diseasea age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Higher D") pos(11) ring(0)) ytitle("Disease rate") xtitle("Age") saving(Dshock20d, replace)
twoway lpoly drate age if age>=20||  lpoly dratea age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Higher D") pos(11) ring(0)) ytitle("Mortality rate") xtitle("Age") saving(Dshock20m, replace)
graph combine Dshock20m.gph Dshock20d.gph , saving(casedeatonD, replace) title("C. Increase in depreciation")
graph export casedeatonD.pdf, replace 

twoway lpoly disease age if age>=20||  lpoly diseaseb age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Higher A ") pos(11) ring(0)) ytitle("Disease rate") xtitle("Age") saving(Ashock20d, replace)
twoway lpoly drate age if age>=20||  lpoly drateb age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Higher A") pos(11) ring(0)) ytitle("Mortality rate") xtitle("Age") saving(Ashock20m, replace)
graph combine Ashock20m.gph Ashock20d.gph , saving(casedeatonA, replace) title("A. Increase in accident rate")
graph export casedeatonA.pdf, replace 

twoway lpoly disease age if age>=20||  lpoly diseased age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Higher T") pos(11) ring(0)) ytitle("Disease rate") xtitle("Age") saving(Tshock20d, replace)
twoway lpoly drate age if age>=20||  lpoly drated age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Higher T") pos(11) ring(0)) ytitle("Mortality rate") xtitle("Age") saving(Tshock20m, replace)
graph combine Tshock20m.gph Tshock20d.gph , saving(casedeatonT, replace) title("B. Increase in death threshold")
graph export casedeatonT.pdf, replace 

twoway lpoly disease age if age>=20||  lpoly diseasec age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Higher V") pos(11) ring(0)) ytitle("Disease rate") xtitle("Age") saving(Vshock20d, replace)
twoway lpoly drate age if age>=20||  lpoly dratec age if age>=20, ylab(, nogrid) legend(label(1 Baseline) label(2 "Higher V") pos(11) ring(0)) ytitle("Mortality rate") xtitle("Age") saving(Vshock20m, replace)
graph combine Vshock20m.gph Vshock20d.gph , saving(casedeatonV, replace) title("C. Increase in variance of resources")
graph export casedeatonV.pdf, replace 

*graphs by SES

twoway lpoly dratebb age ||  lpoly dratebas age, legend(label(1 "1940") label(2 "1980") ring(0) col(2)) ylab(,nogrid) ytitle("Mortality rate") xtitle("Age") saving(blacks, replace) title("Low SES")
twoway lpoly drate age ||  lpoly dratewas age, legend(label(1 "1940") label(2 "1980") ring(0) col(2)) ylab(,nogrid) ytitle("Mortality rate") xtitle("Age") saving(whites, replace) title("Whites")
grc1leg whites.gph blacks.gph, saving(initial, replace) ycommon
graph export initial.pdf, replace
