
******************************************************************************************************************************
******************************************************************************************************************************
** Heterogeneity. OLS Specifications with controls. 
** Unemployment, General and Political Trust, and Political Beliefs. 
** Unemployment and Beliefs/Attitudes on Immigration
** Baseline. Individual data. All ESS rounds and countries. 
** Tables 20 and 21
******************************************************************************************************************************
******************************************************************************************************************************



use "$files/ESS_individual_data", clear 

set more off

global ess 	 ppltrst_new pplfair_new pplhlp_new trstprl_new trstplt_new trstlgl_new trstplc_new  trstep_new trstun_new stfdem_new lrscale_new clsprty_new euftf_new 
global imm	 freehms_new imsmetn_new  imdfetn_new impcntr_new imbgeco_new imueclt_new imwbcnt_new 

** Summary Statistics. Table 1 - Panel C. 
tabstat $ess if  essround<=4 & essround!=., columns(stats) statistics(n mean p50 sd )
tabstat $ess if  essround>4  & essround!=., columns(stats) statistics(n mean p50 sd )

** Summary Statistics. Table 1 - Panel C. 
tabstat $imm if essround<=4 & essround!=., columns(stats) statistics(n mean p50 sd )
tabstat $imm if essround>4  & essround!=., columns(stats) statistics(n mean p50 sd )


*TRUST

set more off

xi: reghdfe ppltrst_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rppltrst

xi: reghdfe pplfair_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplfair

xi: reghdfe pplhlp_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplhlp

xi: reghdfe trstep_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstep

xi: reghdfe trstprl_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstprl

xi: reghdfe trstplt_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplt

xi: reghdfe trstplc_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplc

xi: reghdfe trstlgl_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstlgl

xi: reghdfe trstun_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstun

xi: reghdfe stfdem_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rstfdem

xi: reghdfe lrscale_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rlrscale

xi: reghdfe clsprty_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rclsprty

xi: reghdfe euftf_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store reuftf


*IMMIGRATION


xi: reghdfe imbgeco_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimbgeco_new

xi: reghdfe imdfetn_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimdfetn_new

xi: reghdfe impcntr_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimpcntr_new

xi: reghdfe imsmetn_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimsmetn_new

xi: reghdfe imueclt_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimueclt_new

xi: reghdfe imwbcnt_new totunemp agea agea2 gndr1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimwbcnt_new



estout  rppltrst rpplfair rpplhlp rtrstprl rtrstplt rtrstlgl rtrstplc rtrstep rtrstun rstfdem, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" "trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
estout  rlrscale rclsprty reuftf, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

estout  rimsmetn_new  rimdfetn_new rimpcntr_new rimbgeco_new  rimueclt_new rimwbcnt_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
	
************************************************************************************************************
**MALES
************************************************************************************************************

*TRUST

set more off

xi: reghdfe ppltrst_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rppltrstm

xi: reghdfe pplfair_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplfairm

xi: reghdfe pplhlp_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplhlpm

xi: reghdfe trstep_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstepm

xi: reghdfe trstprl_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstprlm

xi: reghdfe trstplt_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstpltm

xi: reghdfe trstplc_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplcm

xi: reghdfe trstlgl_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstlglm

xi: reghdfe trstun_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstunm

xi: reghdfe stfdem_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rstfdemm

xi: reghdfe lrscale_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rlrscalem

xi: reghdfe clsprty_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rclsprtym

xi: reghdfe euftf_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store reuftfm


*IMMIGRATION


xi: reghdfe imbgeco_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimbgecom_new

xi: reghdfe imdfetn_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimdfetnm_new

xi: reghdfe impcntr_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimpcntrm_new

xi: reghdfe imsmetn_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimsmetnm_new

xi: reghdfe imueclt_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimuecltm_new

xi: reghdfe imwbcnt_new totunemp agea agea2 gndr1 if gndr==1, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimwbcntm_new



estout  rppltrstm rpplfairm rpplhlpm rtrstprlm rtrstpltm rtrstlglm rtrstplcm rtrstepm rtrstunm rstfdemm, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" "trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
estout  rlrscalem rclsprtym reuftfm, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

estout  rimsmetnm_new  rimdfetnm_new rimpcntrm_new rimbgecom_new  rimuecltm_new rimwbcntm_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
	
		
************************************************************************************************************
**FEMALES
************************************************************************************************************
	
*TRUST

set more off

xi: reghdfe ppltrst_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rppltrstf

xi: reghdfe pplfair_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplfairf

xi: reghdfe pplhlp_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplhlpf

xi: reghdfe trstep_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstepf

xi: reghdfe trstprl_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstprlf

xi: reghdfe trstplt_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstpltf

xi: reghdfe trstplc_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplcf

xi: reghdfe trstlgl_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstlglf

xi: reghdfe trstun_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstunf

xi: reghdfe stfdem_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rstfdemf

xi: reghdfe lrscale_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rlrscalef

xi: reghdfe clsprty_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rclsprtyf

xi: reghdfe euftf_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store reuftff


*IMMIGRATION


xi: reghdfe imbgeco_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimbgecof_new

xi: reghdfe imdfetn_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimdfetnf_new

xi: reghdfe impcntr_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimpcntrf_new

xi: reghdfe imsmetn_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimsmetnf_new

xi: reghdfe imueclt_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimuecltf_new

xi: reghdfe imwbcnt_new totunemp agea agea2 gndr1 if gndr==2, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimwbcntf_new



estout  rppltrstf rpplfairf rpplhlpf rtrstprlf rtrstpltf rtrstlglf rtrstplcf rtrstepf rtrstunf rstfdemf, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" "trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
estout  rlrscalef rclsprtyf reuftff, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

estout  rimsmetnf_new  rimdfetnf_new rimpcntrf_new rimbgecof_new  rimuecltf_new rimwbcntf_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 

	
	
************************************************************************************************************
**YOUNG
************************************************************************************************************
	
*TRUST

set more off

xi: reghdfe ppltrst_new totunemp agea agea2 gndr1 if agea<31 , absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rppltrsty

xi: reghdfe pplfair_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplfairy

xi: reghdfe pplhlp_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplhlpy

xi: reghdfe trstep_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstepy

xi: reghdfe trstprl_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstprly


xi: reghdfe trstplt_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplty

xi: reghdfe trstplc_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplcy

xi: reghdfe trstlgl_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstlgly

xi: reghdfe trstun_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstuny

xi: reghdfe stfdem_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rstfdemy

xi: reghdfe lrscale_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rlrscaley

xi: reghdfe clsprty_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rclsprtyy

xi: reghdfe euftf_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store reuftfy


*IMMIGRATION


xi: reghdfe imbgeco_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimbgecoy_new

xi: reghdfe imdfetn_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimdfetny_new

xi: reghdfe impcntr_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimpcntry_new

xi: reghdfe imsmetn_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimsmetny_new

xi: reghdfe imueclt_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimueclty_new

xi: reghdfe imwbcnt_new totunemp agea agea2 gndr1 if agea<31, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimwbcnty_new



estout  rppltrsty rpplfairy rpplhlpy rtrstprly rtrstplty rtrstlgly rtrstplcy rtrstepy rtrstuny rstfdemy, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" "trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
estout  rlrscaley rclsprtyy reuftfy, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

estout  rimsmetny_new  rimdfetny_new rimpcntry_new rimbgecoy_new  rimueclty_new rimwbcnty_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 



************************************************************************************************************
**MIDDLE AGED
************************************************************************************************************
	
*TRUST

set more off

xi: reghdfe ppltrst_new totunemp agea agea2 gndr1 if agea>30 & agea<61 , absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rppltrstma

xi: reghdfe pplfair_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplfairma

xi: reghdfe pplhlp_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplhlpma

xi: reghdfe trstep_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstepma

xi: reghdfe trstprl_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstprlma

xi: reghdfe trstplt_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstpltma

xi: reghdfe trstplc_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplcma

xi: reghdfe trstlgl_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstlglma

xi: reghdfe trstun_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstunma

xi: reghdfe stfdem_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rstfdemma

xi: reghdfe lrscale_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rlrscalema

xi: reghdfe clsprty_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rclsprtyma

xi: reghdfe euftf_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store reuftfma


*IMMIGRATION


xi: reghdfe imbgeco_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimbgecoma_new

xi: reghdfe imdfetn_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimdfetnma_new

xi: reghdfe impcntr_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimpcntrma_new

xi: reghdfe imsmetn_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimsmetnma_new

xi: reghdfe imueclt_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimuecltma_new

xi: reghdfe imwbcnt_new totunemp agea agea2 gndr1 if agea>30 & agea<61, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimwbcntma_new



estout  rppltrstma rpplfairma rpplhlpma rtrstprlma rtrstpltma rtrstlglma rtrstplcma rtrstepma rtrstunma rstfdemma, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" "trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
estout  rlrscalema rclsprtyma reuftfma, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

estout  rimsmetnma_new  rimdfetnma_new rimpcntrma_new rimbgecoma_new  rimuecltma_new rimwbcntma_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
	
************************************************************************************************************
**OLDER 
************************************************************************************************************
	
*TRUST

set more off

xi: reghdfe ppltrst_new totunemp agea agea2 gndr1 if  agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rppltrsto

xi: reghdfe pplfair_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplfairo

xi: reghdfe pplhlp_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplhlpo

xi: reghdfe trstep_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstepo

xi: reghdfe trstprl_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstprlo

xi: reghdfe trstplt_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplto

xi: reghdfe trstplc_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplco

xi: reghdfe trstlgl_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstlglo

xi: reghdfe trstun_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstuno

xi: reghdfe stfdem_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rstfdemo

xi: reghdfe lrscale_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rlrscaleo

xi: reghdfe clsprty_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rclsprtyo

xi: reghdfe euftf_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store reuftfo


*IMMIGRATION


xi: reghdfe imbgeco_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimbgecoo_new

xi: reghdfe imdfetn_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimdfetno_new

xi: reghdfe impcntr_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimpcntro_new

xi: reghdfe imsmetn_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimsmetno_new

xi: reghdfe imueclt_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimueclto_new

xi: reghdfe imwbcnt_new totunemp agea agea2 gndr1 if agea>60, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimwbcnto_new



estout  rppltrsto rpplfairo rpplhlpo rtrstprlo rtrstplto rtrstlglo rtrstplco rtrstepo rtrstuno rstfdemo, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" "trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
estout  rlrscaleo rclsprtyo reuftfo, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

estout  rimsmetno_new  rimdfetno_new rimpcntro_new rimbgecoo_new  rimueclto_new rimwbcnto_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
	
	

************************************************************************************************************
**COLLEGE 
************************************************************************************************************
	
*TRUST

set more off

xi: reghdfe ppltrst_new totunemp agea agea2 gndr1 if  edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rppltrstc

xi: reghdfe pplfair_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplfairc

xi: reghdfe pplhlp_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplhlpc

xi: reghdfe trstep_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstepc

xi: reghdfe trstprl_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstprlc

xi: reghdfe trstplt_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstpltc

xi: reghdfe trstplc_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplcc

xi: reghdfe trstlgl_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstlglc

xi: reghdfe trstun_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstunc

xi: reghdfe stfdem_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rstfdemc

xi: reghdfe lrscale_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rlrscalec

xi: reghdfe clsprty_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rclsprtyc

xi: reghdfe euftf_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store reuftfc


*IMMIGRATION


xi: reghdfe imbgeco_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimbgecoc_new

xi: reghdfe imdfetn_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimdfetnc_new

xi: reghdfe impcntr_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimpcntrc_new

xi: reghdfe imsmetn_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimsmetnc_new

xi: reghdfe imueclt_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimuecltc_new

xi: reghdfe imwbcnt_new totunemp agea agea2 gndr1 if edulvla_new>3, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimwbcntc_new



estout  rppltrstc rpplfairc rpplhlpc rtrstprlc rtrstpltc rtrstlglc rtrstplcc rtrstepc rtrstunc rstfdemc, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" "trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
estout  rlrscalec rclsprtyc reuftfc, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

estout  rimsmetnc_new  rimdfetnc_new rimpcntrc_new rimbgecoc_new  rimuecltc_new rimwbcntc_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	

	


************************************************************************************************************
**NON COLLEGE 
************************************************************************************************************
	
*TRUST

set more off

xi: reghdfe ppltrst_new totunemp agea agea2 gndr1 if  edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rppltrstnc

xi: reghdfe pplfair_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplfairnc

xi: reghdfe pplhlp_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rpplhlpnc

xi: reghdfe trstep_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstepnc

xi: reghdfe trstprl_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstprlnc

xi: reghdfe trstplt_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstpltnc

xi: reghdfe trstplc_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstplcnc

xi: reghdfe trstlgl_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstlglnc

xi: reghdfe trstun_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rtrstunnc

xi: reghdfe stfdem_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rstfdemnc

xi: reghdfe lrscale_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rlrscalenc

xi: reghdfe clsprty_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rclsprtync

xi: reghdfe euftf_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store reuftfnc


*IMMIGRATION


xi: reghdfe imbgeco_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimbgeconc_new

xi: reghdfe imdfetn_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimdfetnnc_new

xi: reghdfe impcntr_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimpcntrnc_new

xi: reghdfe imsmetn_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimsmetnnc_new

xi: reghdfe imueclt_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimuecltnc_new

xi: reghdfe imwbcnt_new totunemp agea agea2 gndr1 if edulvla_new<4, absorb(i.edulvla_new i.religion i.maritalc i.iscoco_new1 i.essround i.nuts1) vce (cluster  nuts1 cntry_essround) 
est store rimwbcntnc_new



estout  rppltrstnc rpplfairnc rpplhlpnc rtrstprlnc rtrstpltnc rtrstlglnc rtrstplcnc rtrstepnc rtrstunnc rstfdemnc, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" "trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
	
estout  rlrscalenc rclsprtync reuftfnc, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

estout  rimsmetnnc_new  rimdfetnnc_new rimpcntrnc_new rimbgeconc_new  rimuecltnc_new rimwbcntnc_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	

