
******************************************************************************************************************************
******************************************************************************************************************************
** OLS and 2SLS Specifications
** Unemployment, Changes in Unemployment and Brexit vote 
** Brexit vote, 379 British municipalities
** Table 11
******************************************************************************************************************************
******************************************************************************************************************************

use "$files/UK_data", clear

set more off


* log size of the constituency at the time of brexit vote
gen LogVoters=log(Electorate_br)
* log population according to Census 2011
gen LogPop=log(population_cen2011)
* log population density according to Census 2011
gen LogDensity=log(population_density_cen2011)
* share white
gen ShareWhite=pop_whiteUK_cen2011/population_cen2011
* log income
gen LogIncome2007=log(income_2007)
gen LogIncome2016=log(income_2016)



gen London=cond(id=="l", 1, 0)
gen Scotland=cond(id=="s", 1, 0)
gen Wales=cond(id=="w", 1, 0)

gen   pre_crisis_constr_share=(ind4_2005+ ind4_2006+ ind4_2007+ ind4_2008)/4 *100

label var brexit_vote "Vote Leave"
label var totunemp2014 "Unemployment 2014"
label var dtotunemp "Change in unemployment"
label var  LogPop "Log Population"
label var ShareWhite "Share of white"
label var    educ_percentl0_cen2011 "Share of no education"
label var    educ_percentl1_cen2011 "Share of Level 1 education"
label var    educ_percentl3_cen2011 "Share of Level 3 education"
label var  educ_percentl4_cen2011 "Share of Level 4 education (BA or equivalent)" 
label var sex_ratio_cen2011 "Male/female ratio"
label var median_age_cen2011 "Median age" 
label var LogIncome2007 "Log avg weekly household income 2007"
label var LogIncome2016 "Log avg weekly household income 2016"
label var urban_level3 "Urbanisation"
label var pre_crisis_constr_share "Construction share, 2005-08"

 
 
 
 
 
eststo clear
set more off
reg brexit_vote totunemp, ro
eststo m1, title("OLS")
reg brexit_vote totunemp  London Scotland Wales, ro
eststo m2, title("OLS")

reg brexit_vote dtotunemp, ro
eststo m3, title("OLS")
reg brexit_vote dtotunemp  London Scotland Wales, ro
eststo m4, title("OLS")

reg  dtotunemp pre_crisis_constr_share, ro
eststo m5, title("OLS")
reg  dtotunemp pre_crisis_constr_share London Scotland Wales, ro
eststo m6, title("OLS")

reg brexit_vote pre_crisis_constr_share  , ro
eststo m7, title("First stage")
reg brexit_vote pre_crisis_constr_share London Scotland Wales , ro
eststo m8, title("First stage")
reg brexit_vote pre_crisis_constr_share London Scotland Wales LogPop ShareWhite   sex_ratio_cen2011 median_age_cen2011  urban_level3, ro
eststo m9, title("Reduced form")

ivreg2 brexit_vote ( dtotunemp= pre_crisis_constr_share), ro
estadd scalar F_stat =e(widstat)
eststo m10, title("Second stage")
ivreg2 brexit_vote ( dtotunemp= pre_crisis_constr_share) London Scotland Wales, ro
estadd scalar F_stat =e(widstat)
eststo m11, title("Second stage")


ivreg2 brexit_vote ( dtotunemp= pre_crisis_constr_share) London Scotland Wales LogPop ShareWhite        sex_ratio_cen2011 median_age_cen2011  urban_level3, ro
estadd scalar F_stat =e(widstat)
eststo m12, title("Second stage")
 
estout m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 m11 m12  ,  ///
	keep ( totunemp2014 dtotunemp pre_crisis_constr_share London Scotland Wales LogPop ShareWhite sex_ratio_cen2011 median_age_cen2011 urban_level3) ///
	order (totunemp2014  dtotunemp pre_crisis_constr_share London Scotland Wales LogPop ShareWhite sex_ratio_cen2011 median_age_cen2011 urban_level3) ///
	cells(b(star fmt(%9.2f))  se(par fmt(%9.2f)))   label 	///
    stats(r2_a N F_stat, fmt(%9.2f %9.0g %9.1f) 	labels("Adj. R squared" "Observations" "F-statistics"))   starlevels(* 0.10 ** 0.05 *** 0.01) ///
	numbers mlabels(,  depvar )  collabels(" ") ///  
	prehead(Table 11. Regressions for 379 British municipalities.) /// 
	postfoot(Robust standard errors in parentheses, * p < 0.10, ** p < 0.05, *** p < 0.01. Columns 1-4: OLS. Columns 5-6: first stage. Columns 7-9: reduced form. Columns 10-12: second stage.) 
 
 
 
 
	
	