
***************************************************************************************************************************
***************************************************************************************************************************
**** Summary Program File. Generating All Tables (Main Paper)
***************************************************************************************************************************
***************************************************************************************************************************



clear all

set more off

global files="C:/Users/User/Dropbox/ETC"

cd "$files"

use "$files/voting_ESS_NUTS2", clear



** Preliminaries 1. Define variable lists
***************************************************************************************************************************

global econ  totunemp lppsgdp sh_const  sh_agri sh_finan sh_trade sh_govt sh_indus
global vote  extreme_per extreme_perel extreme_perer extreme_perp extreme_perae part blankinv_per
global ess 	 ppltrst_new pplfair_new pplhlp_new trstprl_new trstplt_new trstlgl_new trstplc_new stfdem_new trstep_new trstun_new lrscale_new clsprty_new euftf_new 
global imm	 imsmetn_new  imdfetn_new impcntr_new imbgeco_new imueclt_new imwbcnt_new 

** Main Variables (Defintions)
***************************************************************************************************************************

describe $econ $vote $ess $imm


** Preliminaries 2. define electoral 4 year periods for the elections based analysis
***************************************************************************************************************************
***************************************************************************************************************************
gen 		eperiod=1 
replace 	eperiod=2 if year>2004  & year<2009
replace 	eperiod=3 if year>2008  & year<2013
replace 	eperiod=4 if year>2012  & year<2018


egen eperiod_group=group(eperiod group1)
egen country_year=group(cntry1 year)
egen group_year=group(group1 year)
egen group_essround=group(group1 essround)




** Preliminaries 3. Get time-varying averages for industrial composition, unemployment and voting
***************************************************************************************************************************
***************************************************************************************************************************

foreach var of varlist sh_const sh_agri sh_finan sh_trade sh_govt sh_indus {
	tssmooth ma `var'_sm3 = `var', window(3 1) 
	tssmooth ma `var'_sm4 = `var', window(4 1) 
	
}

foreach var of varlist totunemp extreme_per extreme_perer extreme_perel extreme_perp extreme_perae part {
	tssmooth ma `var'_sm3 = `var', window(3 1) 
	tssmooth ma `var'_sm4 = `var', window(4 1) 
	tssmooth ma `var'_sm8 = `var', window(8 1) 
	
}
***************************************************************************************************************************



** Run Programs (.do files)
***************************************************************************************************************************
***************************************************************************************************************************
do "$files/program1.do"
do "$files/program2.do"
do "$files/program3.do"
do "$files/program4.do"


log using "$files/Main_Tables", text replace

** Table 1. Summary Statistics
***************************************************************************************************************************
** Summary Statistics. Table 1 - Panel A. 
***************************************************************************************************************************
** row (1). Unemployment rate
** row (2). Log real GDP per capita
** row (3). Employment shares
** row (4). Construction
** row (5). Agriculture (including forestry and fishing)
** row (6). Finance
** row (7). Commerce
** row (8). Government
** row (9). Industry (manufacturing)
***************************************************************************************************************************
tabstat $econ if nv1==0 & year<=2008 & year!=., columns(stats) statistics(n mean p50 sd )
tabstat $econ if nv1==0 & year>2008  & year!=., columns(stats) statistics(n mean p50 sd )

***************************************************************************************************************************
** Summary Statistics. Table 1 - Panel B. 
***************************************************************************************************************************
** row (1). Antiestablishment Parties. All Types
** row (2). Voting for Radical Left Parties
** row (3). Voting for Far Right Parties
** row (4). Voting for Populist Parties
** row (5). Voting for Eurosceptic / Separatist parties
** row (6). Participation Rate
** row (7). Blank/Invalid Votes in Percentage
***************************************************************************************************************************
tabstat $vote if nv==0 & year<=2008 & year!=., columns(stats) statistics(n mean p50 sd )
tabstat $vote if nv==0 & year>2008  & year!=., columns(stats) statistics(n mean p50 sd )

***************************************************************************************************************************
** Summary Statistics. Table 1 - Panel C. 
***************************************************************************************************************************
** row (1). Trust other people
** row (2). Belief that people are fair
** row (3). Belief that people are helpful
** row (4). Trust in national parliaments
** row (5). Trust in politicians
** row (6). Trust in the legal system
** row (7). Trust in police
** row (8). Satisfaction with how democracy is working
** row (9). Trust in European Parliament
** row (10). Trust in the United Nations
** row (11). Placement on the leftright continuum
** row (12). Feeling close to a particular party
** row (13). Belief that European unification should go further
***************************************************************************************************************************
tabstat $ess if nv==0 & year<=2008 & year!=., columns(stats) statistics(n mean p50 sd )
tabstat $ess if nv==0 & year>2008  & year!=., columns(stats) statistics(n mean p50 sd )

***************************************************************************************************************************
** Summary Statistics. Table 1 - Panel D. 
***************************************************************************************************************************
** row (1). We should allow immigrants of the same race
** row (2). We should allow immigrants of different races
** row (3). We should allow immigrants from poorer countries
** row (4). Belief that immigrants are good for the economy
** row (5). Belief that immigrants improve cultural life
** row (6). Belief that immigrants make the country a better place
***************************************************************************************************************************
tabstat $imm if nv==0 & year<=2008 & year!=., columns(stats) statistics(n mean p50 sd )
tabstat $imm if nv==0 & year>2008  & year!=., columns(stats) statistics(n mean p50 sd )




** Table 2. Baseline Panel OLS Specifications. Unemployment and Voting for Antiestablishment Parties
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. Region (NUTS Fixed-Effects) and Year  Fixed-Effects
***************************************************************************************************************************
estout v1rr v2rr v3rr v4rr v5rr v6rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(totunemp)  stats(r2_a  r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)
	   
** Panel B. Region (NUTS Fixed-Effects) and Electoral Cycle (4-year) Time  Fixed-Effects
***************************************************************************************************************************
estout v1 v2 v3 v4 v5 v6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(totunemp)  stats(r2_a  r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel C. Region (NUTS Fixed-Effects) and ESS-Round Country Group Fixed-Effects
***************************************************************************************************************************
estout v1r v2r v3r v4r v5r v6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(totunemp) stats(r2_a r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	

	   
	   

** Table 3. Unemployment and Voting for Antiestablishment Parties Before and After the Crisis
** OLS Difference Specifications.  
** Post-Crisis Average [2017-2009] - Pre-Crisis Average [2001-2008]
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. General Constant
***************************************************************************************************************************
estout dil1 dil2 dil3 dil4 dil5 dil6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( S9.totunemp_sm8)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)
	   
** Panel B. Country-Group Constants
***************************************************************************************************************************
estout dil1r dil2r dil3r dil4r dil5r dil6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( S9.totunemp_sm8)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)

log close	   

do "$files/program5.do"

log using "$files/Main_Tables", text append  

** Table 4. Employment/Population and Voting for Anti-Establishment Parties at NUTS3 Level Panel Fixed-Effects OLS Estimates. 2000-2017						
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. Region (NUTS Fixed-Effects) and Electoral Cycle (4-year) Time  Fixed-Effects
***************************************************************************************************************************
estout v1 v2 v3 v4 v5 v6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(emp_pop)  stats(r2_a  r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Table 4. Panel B. Employment and Voting for Antiestablishment Parties Before and After the Crisis, OLS Difference Specifications.  
** Post-Crisis Average [2017-2009] - Pre-Crisis Average [2001-2008]
***************************************************************************************************************************
estout dil1 dil2 dil3 dil4 dil5 dil6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( S9.emp_pop_sm8)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	   

	   
log close	   
	   
use "$files/voting_ESS_NUTS2.dta", clear

set more off


** Preliminaries 1. Define variable lists
***************************************************************************************************************************
global econ  totunemp lppsgdp sh_const  sh_agri sh_finan sh_trade sh_govt sh_indus
global vote  extreme_per extreme_perel extreme_perer extreme_perp extreme_perae part blankinv_per
global ess 	 ppltrst_new pplfair_new pplhlp_new trstprl_new trstplt_new trstlgl_new trstplc_new stfdem_new trstep_new trstun_new lrscale_new clsprty_new euftf_new 
global imm	 imsmetn_new  imdfetn_new impcntr_new imbgeco_new imueclt_new imwbcnt_new 



** Preliminaries 2. define electoral 4 year periods for the elections based analysis
***************************************************************************************************************************
***************************************************************************************************************************
gen 		eperiod=1 
replace 	eperiod=2 if year>2004  & year<2009
replace 	eperiod=3 if year>2008  & year<2013
replace 	eperiod=4 if year>2012  & year<2018


egen eperiod_group=group(eperiod group1)
egen country_year=group(cntry1 year)
egen group_year=group(group1 year)
egen group_essround=group(group1 essround)


** Preliminaries 3. Get time-varying averages for industrial composition, unemployment and voting
***************************************************************************************************************************
***************************************************************************************************************************

foreach var of varlist sh_const sh_agri sh_finan sh_trade sh_govt sh_indus {
	tssmooth ma `var'_sm3 = `var', window(3 1) 
	tssmooth ma `var'_sm4 = `var', window(4 1) 
	
}

foreach var of varlist totunemp extreme_per extreme_perer extreme_perel extreme_perp extreme_perae part {
	tssmooth ma `var'_sm3 = `var', window(3 1) 
	tssmooth ma `var'_sm4 = `var', window(4 1) 
	tssmooth ma `var'_sm8 = `var', window(8 1) 
	
}


** Run Programs (.do files)
********************************************************************************************************************
********************************************************************************************************************
do "$files/program1.do"
do "$files/program2.do"
do "$files/program3.do"
do "$files/program4.do"


log using "$files/Main_Tables", text append  
	   
** Table 5. Panel A. Construction Share in Regional Value Added and Unemployment Dynamics
** Dependent Variable. Regional Unemployment
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). region and year fixed-effects
** column (2). region and year fixed-effects and other-than-construction industrial shares as controls
** column (3). region and group-year fixed-effects
** column (4). region and group-year fixed-effects and other-than-construction industrial shares as controls
***************************************************************************************************************************
***************************************************************************************************************************
estout fs1a fs2a fs3a fs4a, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(sh_const)  stats(r2_a r2_w  N N_clust, fmt(%9.3f %9.0g) labels(r-square within_r-square  Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Table 5. Panel B. Post-Pre Crisis Difference in Unemployment [2017-2009]-[2008-2000] and Pre-Crisis Construction Share
**************************************************************************************************************************
**************************************************************************************************************************
** column 1. no controls
** column 2. country group constnats
** column 3. initial pre-crisis industrial composition
** column 4. country group constants and initial pre-crisis industrial composition
estout b1 b2 b3 b4, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( L10.sh_const_sm3)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	   
	    
 
 

** Table 6. Reduced-Form Specifications. Industrial Shares and Voting for Antiestablishment Parties
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
***************************************************************************************************************************

** Panel A. Region (NUTS Fixed-Effects) and Year  Fixed-Effects
***************************************************************************************************************************
estout fv1rr fv2rr fv3rr fv4rr fv5rr fv6rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(sh_const    )  stats(r2_a  r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)

** Panel B. Region (NUTS Fixed-Effects) and Electoral Cycle (4-year) Time  Fixed-Effects
***************************************************************************************************************************
estout fv1 fv2 fv3 fv4 fv5 fv6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(sh_const    )  stats(r2_a  r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel C. Region (NUTS Fixed-Effects) and ESS-Round Country Group Fixed-Effects
***************************************************************************************************************************
estout fv1r fv2r fv3r fv4r fv5r fv6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(sh_const    ) stats(r2_a r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	


	   

** Table 7. Reduced-Forms. Post-Pre Crisis Difference in Voting [2017-2009]-[2008-2000] and Pre-Crisis Construction Share
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
***************************************************************************************************************************

** Panel A. No Controls
***************************************************************************************************************************
estout rf1 rf2 rf3 rf4 rf5 rf6, cells(b(star fmt(%9.4f)) se(par)  t(fmt(%9.2f)))   ///
       keep(L10.sh_const_sm3 )  stats(r2_a   N_clust N , fmt(%9.3f %9.0g) labels(r-square  Countries Obs  ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)
 

** Panel B. Country-Group Constants
***************************************************************************************************************************
estout rf1r rf2r rf3r rf4r rf5r rf6r, cells(b(star fmt(%9.4f)) se(par)  t(fmt(%9.2f)))   ///
       keep(L10.sh_const_sm3 )  stats(r2_a   N_clust N , fmt(%9.3f %9.0g) labels(r-square  Countries Obs  ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)
 
	   	   

** Table 8. Panel 2SLS Specifications. Construction, Unemployment and Voting for Antiestablishment Parties
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
***************************************************************************************************************************

** Panel A. 2SLS Region (NUTS Fixed-Effects) and General Period (4-year) Fixed Effects
***************************************************************************************************************************
estout sslv1 sslv2 sslv3 sslv4 sslv5 sslv6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(totunemp)  stats(r2_a  cdf rkf  N N_clust, fmt(%9.3f %9.0g) labels(r-square F1 F2 Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel B. 2SLS Region (NUTS Fixed-Effects) and General Period (4-year)  Fixed-Effects
***************************************************************************************************************************
estout slv1 slv2 slv3 slv4 slv5 slv6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(totunemp)  stats(r2_a  cdf rkf  N N_clust, fmt(%9.3f %9.0g) labels(r-square F1 F2 Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel C. 2SLS Region (NUTS Fixed-Effects) and ESS-Round  Fixed-Effects
***************************************************************************************************************************
estout slv1r slv2r slv3r slv4r slv5r slv6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(totunemp)  stats(r2_a  cdf rkf  N N_clust, fmt(%9.3f %9.0g) labels(r-square F1 F2 Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel D. 2SLS Region (NUTS Fixed-Effects) and ESS-Round  Fixed-Effects
***************************************************************************************************************************
estout slv1rr slv2rr slv3rr slv4rr slv5rr slv6rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(totunemp)  stats(r2_a  cdf rkf  N N_clust, fmt(%9.3f %9.0g) labels(r-square F1 F2 Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   
	   


** Table 9. 2SLS Difference Specifications. 
** Post-Pre Crisis Difference in Voting [2017-2009]-[2008-2000], Difference in Unemployment & Pre-Crisis Construction Share
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. General Constant
***************************************************************************************************************************
 estout k1 k2 k3 k4 k5 k6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S9.totunemp_sm8) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel B. Country-Group Constants 
***************************************************************************************************************************
estout k1r k2r k3r k4r k5r k6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S9.totunemp_sm8) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   
	   
	   

**Table 10. Further Identification Tests.
**Construction, Unemployment and Voting for Anti-Establishment Parties,cond. On Education and Immigration Panel 
**and Difference 2SLS Estimates"
***************************************************************************************************************************						
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. 2SLS Region (NUTS Fixed-Effects) and General Period (4-year) Fixed Effects
***************************************************************************************************************************
estout h1 h2 h3 h4 h5 h6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a  cdf rkf  N N_clust, fmt(%9.3f %9.0g) labels(r-square F1 F2 Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)		   
 
***************************************************************************************************************************
** Panel B. 2SLS Cross Sectional Regressions - Differences
***************************************************************************************************************************
estout ww1 ww2 ww3 ww4 ww5 ww6  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a  cdf rkf  N N_clust, fmt(%9.3f %9.0g) labels(r-square F1 F2 Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	 
 
 
log close


do "$files/program10.do"


log using "$files/Main_Tables", text append   

**Table 11. Unemployment, Crisis-Related Changes in Unemployment and BREXIT Vote OLS Estimates, Regressions for 379 British municipalities. 														
***************************************************************************************************************************	
***************************************************************************************************************************
** columns (1)-(4). OLS: Leave the EU Vote		
** columns (5)-(6). First Stage: Change in Unemploymennt	
** columns (7)-(9). Reduced Form: Leave the EU Vote	
** columns (10)-(12). Second Stage: Leave the EU Vote	
***************************************************************************************************************************
***************************************************************************************************************************
estout m1 m2 m3 m4 m5 m6 m7 m8 m9 ,  ///
	keep ( totunemp2014 dtotunemp pre_crisis_constr_share London Scotland Wales LogPop ShareWhite sex_ratio_cen2011 median_age_cen2011 urban_level3) ///
	order (totunemp2014  dtotunemp pre_crisis_constr_share London Scotland Wales LogPop ShareWhite sex_ratio_cen2011 median_age_cen2011 urban_level3) ///
	cells(b(star fmt(%9.2f))  se(par fmt(%9.2f)))   label 	///
    stats(r2_a N F_stat, fmt(%9.2f %9.0g %9.1f) 	labels("Adj. R squared" "Observations" "F-statistics"))   starlevels(* 0.10 ** 0.05 *** 0.01) ///
	numbers mlabels(,  depvar )  collabels(" ")  
	
estout m10 m11 m12,  ///
	keep ( totunemp2014 dtotunemp pre_crisis_constr_share London Scotland Wales LogPop ShareWhite sex_ratio_cen2011 median_age_cen2011 urban_level3) ///
	order (totunemp2014  dtotunemp pre_crisis_constr_share London Scotland Wales LogPop ShareWhite sex_ratio_cen2011 median_age_cen2011 urban_level3) ///
	cells(b(star fmt(%9.2f))  se(par fmt(%9.2f)))   label 	///
    stats(r2_a N F_stat, fmt(%9.2f %9.0g %9.1f) 	labels("Adj. R squared" "Observations" "F-statistics"))   starlevels(* 0.10 ** 0.05 *** 0.01) ///
	numbers mlabels(,  depvar )  collabels(" ")  
	
  
log close



use "$files/voting_ESS_NUTS2", clear

set more off


** Preliminaries 1. Define variable lists
***************************************************************************************************************************
global econ  totunemp lppsgdp sh_const  sh_agri sh_finan sh_trade sh_govt sh_indus
global vote  extreme_per extreme_perel extreme_perer extreme_perp extreme_perae part blankinv_per
global ess 	 ppltrst_new pplfair_new pplhlp_new trstprl_new trstplt_new trstlgl_new trstplc_new stfdem_new trstep_new trstun_new lrscale_new clsprty_new euftf_new 
global imm	 imsmetn_new  imdfetn_new impcntr_new imbgeco_new imueclt_new imwbcnt_new 



** Preliminaries 2. define electoral 4 year periods for the elections based analysis
***************************************************************************************************************************
***************************************************************************************************************************
gen 		eperiod=1 
replace 	eperiod=2 if year>2004  & year<2009
replace 	eperiod=3 if year>2008  & year<2013
replace 	eperiod=4 if year>2012  & year<2018


egen eperiod_group=group(eperiod group1)
egen country_year=group(cntry1 year)
egen group_year=group(group1 year)
egen group_essround=group(group1 essround)


** Preliminaries 3. Get time-varying averages for industrial composition, unemployment and voting
***************************************************************************************************************************
***************************************************************************************************************************

foreach var of varlist sh_const sh_agri sh_finan sh_trade sh_govt sh_indus {
	tssmooth ma `var'_sm3 = `var', window(3 1) 
	tssmooth ma `var'_sm4 = `var', window(4 1) 
	
}

foreach var of varlist totunemp extreme_per extreme_perer extreme_perel extreme_perp extreme_perae part {
	tssmooth ma `var'_sm3 = `var', window(3 1) 
	tssmooth ma `var'_sm4 = `var', window(4 1) 
	tssmooth ma `var'_sm8 = `var', window(8 1) 
	
}


** Run Programs (.do files)
********************************************************************************************************************
********************************************************************************************************************
do "$files/program1.do"
do "$files/program2.do"
do "$files/program3.do"
do "$files/program4.do"


log using "$files/Main_Tables", text append   
 
** Table 12. Unemployment, General and Political Trust, and Political Beliefs. Panel Fixed-Effects Estimates. 2000-2014
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). General Trust
** column (2). People Fair
** column (3). People helpful
** column (4). Trust National Parliament
** column (5). Trust Politicians
** column (6). Trust  Legal System
** column (7). Trust in Police
** column (8). Trust in European Parliament  
** column (9).  Trust in the United Nations
** column (10). Satisfaction with Democracy
** column (11). Political Self-Orientation. Left-Right
** column (12). Close to a Party
** column (13). EU has gone too far
***************************************************************************************************************************
***************************************************************************************************************************

** Panel A. Region (NUTS Fixed-Effects) and ESS-Round  Fixed-Effects
***************************************************************************************************************************
estout aa1 aa2 aa3 aa4 aa5, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a r2_within N N_clust, fmt(%9.3f %9.0g) labels(r-square within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   
estout aa6 aa7 aa8 aa9 aa10, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a r2_within N N_clust, fmt(%9.3f %9.0g) labels(r-square within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   	   
estout aa11 aa12 aa13, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a  r2_within N N_clust, fmt(%9.3f %9.0g) labels(r-square within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	   

** Panel B. Region (NUTS Fixed-Effects) and ESS-Round Country Group Fixed-Effects
***************************************************************************************************************************
estout aa31 aa32 aa33 aa34 aa35, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a r2_within N N_clust, fmt(%9.3f %9.0g) labels(r-square within Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	   
estout aa36 aa37 aa38 aa39 aa310, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a r2_within N N_clust, fmt(%9.3f %9.0g) labels(r-square within Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	   
estout aa311 aa312 aa313, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a r2_within N N_clust, fmt(%9.3f %9.0g) labels(r-square within Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	
	
	
	

** Table 13. Unemployment, General and Political Trust, and Political Beliefs before and after the Economic Crisis
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). General Trust
** column (2). People Fair
** column (3). People helpful
** column (4). Trust National Parliament
** column (5). Trust Politicians
** column (6). Trust  Legal System
** column (7). Trust in Police
** column (8). Trust in European Parliament  
** column (9).  Trust in the United Nations
** column (10). Satisfaction with Democracy
** column (11). Political Self-Orientation. Left-Right
** column (12). Close to a Party
** column (13). EU has gone too far
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. Difference OLS. 2012-2008. 
***************************************************************************************************************************

estout bls1r bls2r bls3r bls4r bls5r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S4.totunemp ) stats(r2 N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	

estout bls6r bls7r bls8r bls9r bls10r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S4.totunemp ) stats(r2 N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	   
estout bls11r bls12r bls13r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S4.totunemp ) stats(r2 N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	   
	   
** Panel B. Difference OLS. 2014-2008. 
*************************************************************************************************************************
estout bls1 bls2 bls3 bls4 bls5, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S6.totunemp ) stats(r2 N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	

	   
estout bls6 bls7 bls8 bls9 bls10, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S6.totunemp ) stats(r2 N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	   
	   
estout bls11 bls12 bls13, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S6.totunemp ) stats(r2 N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	

	
	
	
** Table 14. Unemployment and Beliefs on Immigration
***************************************************************************************************************************
***************************************************************************************************************************	
** column (1). Allow many/few immigrants of same race/ethnic group as majority: (0) allow none (1) allow many
** column (2). Allow many/few immigrants of different race/ethnic group from majority: (0) allow none (1) allow many
** column (3). Allow many/few immigrants from poorer countries outside Europe: (0) allow none (1) allow many
** column (4). Immigration bad or good for country's economy: 0 (bad for the economy) to 1 (good for the economy)
** column (5). Country's cultural life undermined or enriched by immigrants: 0 (cultural life undermined) 1 (cultural life enriched)
** column (6). Immigrants make country worse or better place to live: 0 (worse place to live) 1 (better place to live)
***************************************************************************************************************************
***************************************************************************************************************************

** Panel A. Region (NUTS Fixed-Effects) and ESS-Round  Fixed-Effects
***************************************************************************************************************************
estout be1 be2 be3 be4 be5 be6  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(totunemp) stats(r2_a  r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square r_within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel B. Region (NUTS Fixed-Effects) and Country Group ESS-Round  Fixed-Effects
***************************************************************************************************************************
estout be1r be2r be3r be4r be5r be6r  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(totunemp) stats(r2_a  r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square r_within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

	   	
	

** Table 15. Unemployment and Beliefs on Immmigration before and after the Economic Crisis
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Allow many/few immigrants of same race/ethnic group as majority: (0) allow none (1) allow many
** column (2). Allow many/few immigrants of different race/ethnic group from majority: (0) allow none (1) allow many
** column (3). Allow many/few immigrants from poorer countries outside Europe: (0) allow none (1) allow many
** column (4). Immigration bad or good for country's economy: 0 (bad for the economy) to 1 (good for the economy)
** column (5). Country's cultural life undermined or enriched by immigrants: 0 (cultural life undermined) 1 (cultural life enriched)
** column (6). Immigrants make country worse or better place to live: 0 (worse place to live) 1 (better place to live)
***************************************************************************************************************************
***************************************************************************************************************************

** Panel A. Difference Specifications with Country Group Constants. 2012-2008
***************************************************************************************************************************
estout dbe1 dbe2 dbe3 dbe4 dbe5 dbe6  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(S4.totunemp) stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square  Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel B. Difference Specifications with Country Group Constants. 2014-2008
***************************************************************************************************************************
estout dbe1r dbe2r dbe3r dbe4r dbe5r dbe6r  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(S6.totunemp) stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square  Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

	   	

		
		
** Table 16. Construction Share, Unemployment, General and Political Trust, and Political Beliefs
** Panel 2SLS. 2000-2014. NUTS (region Fixed-Effects) and ESS Round Fixed-Effects
** instrument. share of construction.
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). General Trust
** column (2). People Fair
** column (3). People helpful
** column (4). Trust National Parliament
** column (5). Trust Politicians
** column (6). Trust  Legal System
** column (7). Trust in Police
** column (8). Trust in European Parliament  
** column (9).  Trust in the United Nations
** column (10). Satisfaction with Democracy
** column (11). Political Self-Orientation. Left-Right
** column (12). Close to a Party
** column (13). EU has gone too far
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. 2SLS Region (NUTS Fixed-Effects) and ESS-Round  Fixed-Effects
***************************************************************************************************************************
estout iva1 iva2 iva3 iva4 iva5, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (totunemp) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

estout iva6 iva7 iva8 iva9 iva10, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (totunemp) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   
estout iva11 iva12 iva13, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (totunemp) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   
	   
** Panel B. Region (NUTS Fixed-Effects) and ESS-Round Country Group Fixed-Effects
***************************************************************************************************************************
estout iva31 iva32 iva33 iva34 iva35, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
      keep (totunemp) stats(r2_a N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	

estout iva36 iva37 iva38 iva39 iva310, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
      keep (totunemp) stats(r2_a N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
		
estout iva311 iva312 iva313, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
      keep (totunemp) stats(r2_a N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	


	
	
** Table 17. Unemployment, General and Political Trust, and Political Beliefs before and after the Economic Crisis
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). General Trust
** column (2). People Fair
** column (3). People helpful
** column (4). Trust National Parliament
** column (5). Trust Politicians
** column (6). Trust  Legal System
** column (7). Trust in Police
** column (8). Trust in European Parliament  
** column (9).  Trust in the United Nations
** column (10). Satisfaction with Democracy
** column (11). Political Self-Orientation. Left-Right
** column (12). Close to a Party
** column (13). EU has gone too far
***************************************************************************************************************************
***************************************************************************************************************************

** Panel A. 2SLS Difference with Country-Group constants.  2012-2008.
***************************************************************************************************************************
estout iv1r iv2r iv3r iv4r iv5r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S4.totunemp ) stats(r2 N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-squared Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

	   
estout iv6r iv7r iv8r iv9r iv10r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S4.totunemp ) stats(r2 N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-squared Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   
	   
estout iv11r iv12r iv13r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S4.totunemp ) stats(r2 N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-squared Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel B. 2SLS Difference with Country-Group constants.  2014-2008.
***************************************************************************************************************************
estout iv1rr iv2rr iv3rr iv4rr iv5rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S6.totunemp ) stats(r2 N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-squared Countries F1 F2))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	   
estout iv6rr iv7rr iv8rr iv9rr iv10rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S6.totunemp ) stats(r2 N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-squared Countries F1 F2))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	   	   
estout iv11rr iv12rr iv13rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S6.totunemp ) stats(r2 N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-squared Countries F1 F2))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
	 	   	
	
	
	

** Table 18. Construction Share, Unemployment, and Beliefs on Immigration
** Panel 2SLS. instrument. share of construction.
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Allow many/few immigrants of same race/ethnic group as majority: (0) allow none (1) allow many
** column (2). Allow many/few immigrants of different race/ethnic group from majority: (0) allow none (1) allow many
** column (3). Allow many/few immigrants from poorer countries outside Europe: (0) allow none (1) allow many
** column (4). Immigration bad or good for country's economy: 0 (bad for the economy) to 1 (good for the economy)
** column (5). Country's cultural life undermined or enriched by immigrants: 0 (cultural life undermined) 1 (cultural life enriched)
** column (6). Immigrants make country worse or better place to live: 0 (worse place to live) 1 (better place to live)
***************************************************************************************************************************
***************************************************************************************************************************

** Panel A. 2SLS Region (NUTS Fixed-Effects) and ESS-Round  Fixed-Effects
***************************************************************************************************************************
estout pia1 pia2 pia3 pia4 pia5 pia6  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (totunemp) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel B. 2SLS Region (NUTS Fixed-Effects) and ESS-Round  Fixed-Effects
***************************************************************************************************************************
estout pia1r pia2r pia3r pia4r pia5r pia6r  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (totunemp) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   	   	
	
	

	

** Table 19. Construction Share, Unemployment and Beleifs on Immigration
** Difference 2SLS. share of contrsuction averaged over 4 years before the crisis.
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Allow many/few immigrants of same race/ethnic group as majority: (0) allow none (1) allow many
** column (2). Allow many/few immigrants of different race/ethnic group from majority: (0) allow none (1) allow many
** column (3). Allow many/few immigrants from poorer countries outside Europe: (0) allow none (1) allow many
** column (4). Immigration bad or good for country's economy: 0 (bad for the economy) to 1 (good for the economy)
** column (5). Country's cultural life undermined or enriched by immigrants: 0 (cultural life undermined) 1 (cultural life enriched)
** column (6). Immigrants make country worse or better place to live: 0 (worse place to live) 1 (better place to live)
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. 2SLS Difference with Country-Group constants.  2012-2008.
***************************************************************************************************************************
estout zz1 zz2 zz3 zz4 zz5 zz6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S4.totunemp ) stats(r2 N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-squared Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)

** Panel B. 2SLS Difference with Country-Group constants.  2012-2008.
***************************************************************************************************************************
estout zz1r zz2r zz3r zz4r zz5r zz6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S6.totunemp ) stats(r2 N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-squared Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	
	

log close 
  
do "$files/program11.do"

log using "$files/Main_Tables", text append  


** Table 20. 
**Heterogeneity. OLS: Unemployment, General and Political Trust, and Political Beliefs
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). General Trust
** column (2). People Fair
** column (3). People helpful
** column (4). Trust National Parliament
** column (5). Trust Politicians
** column (6). Trust  Legal System
** column (7). Trust in Police
** column (8). Trust in European Parliament  
** column (9).  Trust in the United Nations
** column (10). Satisfaction with Democracy
** column (11). Political Self-Orientation. Left-Right
** column (12). Close to a Party
** column (13). EU has gone too far
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. Full Sample.
***************************************************************************************************************************	   

estout  rppltrst rpplfair rpplhlp rtrstprl rtrstplt, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses)
	
estout  rtrstlgl rtrstplc rtrstep rtrstun rstfdem, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses)	
	
estout  rlrscale rclsprty reuftf, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	
	

***************************************************************************************************************************
** Panel B1. Males.
***************************************************************************************************************************	   

estout  rppltrstm rpplfairm rpplhlpm rtrstprlm rtrstpltm , /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
estout  rtrstlglm rtrstplcm rtrstepm rtrstunm rstfdemm, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
estout  rlrscalem rclsprtym reuftfm, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

***************************************************************************************************************************
** Panel B2. Females.
***************************************************************************************************************************	   

estout  rppltrstf rpplfairf rpplhlpf rtrstprlf rtrstpltf, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
estout   rtrstlglf rtrstplcf rtrstepf rtrstunf rstfdemf, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	
	
estout  rlrscalef rclsprtyf reuftff, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

***************************************************************************************************************************
** Panel C1. Young.
***************************************************************************************************************************	   

estout  rppltrsty rpplfairy rpplhlpy rtrstprly rtrstplty , /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
estout  rtrstlgly rtrstplcy rtrstepy rtrstuny rstfdemy, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	
	
estout  rlrscaley rclsprtyy reuftfy, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	   
	   
***************************************************************************************************************************
** Panel C2. Middle-Aged
***************************************************************************************************************************	   

estout  rppltrstma rpplfairma rpplhlpma rtrstprlma rtrstpltma, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses)
	
estout  rtrstlglma rtrstplcma rtrstepma rtrstunma rstfdemma, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses)	
	
estout  rlrscalema rclsprtyma reuftfma, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

***************************************************************************************************************************
** Panel C3. Older.
***************************************************************************************************************************	   

estout  rppltrsto rpplfairo rpplhlpo rtrstprlo rtrstplto, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses)
	
estout  rtrstlglo rtrstplco rtrstepo rtrstuno rstfdemo, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses)	
	
estout  rlrscaleo rclsprtyo reuftfo, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

***************************************************************************************************************************
** Panel D1. Attended College.
***************************************************************************************************************************	   

estout  rppltrstc rpplfairc rpplhlpc rtrstprlc rtrstpltc, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
estout  rtrstlglc rtrstplcc rtrstepc rtrstunc rstfdemc, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	
	
estout  rlrscalec rclsprtyc reuftfc, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	

***************************************************************************************************************************
** Panel D2. Have Not Attended College.
***************************************************************************************************************************	   

estout  rppltrstnc rpplfairnc rpplhlpnc rtrstprlnc rtrstpltnc, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_ppl" "ppl_fair" "ppl_help" "trust_parl" "trust_pltcn" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
estout  rtrstlglnc rtrstplcnc rtrstepnc rtrstunnc rstfdemnc, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("trust_lgl" "trust_plc" "trust_EU"  "trust_UN" "stsf_demo") ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	
	
estout  rlrscalenc rclsprtync reuftfnc, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("lrscale" "clsprty" "euftf" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 	


	


** Table 21. 
**Heterogeneity. OLS: Unemployment and Beliefs on Immigration"							
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Allow many/few immigrants of same race/ethnic group as majority: (0) allow none (1) allow many
** column (2). Allow many/few immigrants of different race/ethnic group from majority: (0) allow none (1) allow many
** column (3). Allow many/few immigrants from poorer countries outside Europe: (0) allow none (1) allow many
** column (4). Immigration bad or good for country's economy: 0 (bad for the economy) to 1 (good for the economy)
** column (5). Country's cultural life undermined or enriched by immigrants: 0 (cultural life undermined) 1 (cultural life enriched)
** column (6). Immigrants make country worse or better place to live: 0 (worse place to live) 1 (better place to live)
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. Full Sample.
***************************************************************************************************************************	   	

estout  rimsmetn_new  rimdfetn_new rimpcntr_new rimbgeco_new  rimueclt_new rimwbcnt_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
***************************************************************************************************************************
** Panel B1. Males.
***************************************************************************************************************************	   

estout  rimsmetnm_new  rimdfetnm_new rimpcntrm_new rimbgecom_new  rimuecltm_new rimwbcntm_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 

***************************************************************************************************************************
** Panel B2. Females.
***************************************************************************************************************************	   
 
 estout  rimsmetnf_new  rimdfetnf_new rimpcntrf_new rimbgecof_new  rimuecltf_new rimwbcntf_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses)  
	
***************************************************************************************************************************
** Panel C1. Young.
***************************************************************************************************************************	   

estout  rimsmetny_new  rimdfetny_new rimpcntry_new rimbgecoy_new  rimueclty_new rimwbcnty_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 				   
	   
***************************************************************************************************************************
** Panel C2. Middle Aged.
***************************************************************************************************************************	   

estout  rimsmetnma_new  rimdfetnma_new rimpcntrma_new rimbgecoma_new  rimuecltma_new rimwbcntma_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 

***************************************************************************************************************************
** Panel C3. Older.
***************************************************************************************************************************	   

estout  rimsmetno_new  rimdfetno_new rimpcntro_new rimbgecoo_new  rimueclto_new rimwbcnto_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 
	
***************************************************************************************************************************
** Panel D1. Attended College.
***************************************************************************************************************************	   

estout  rimsmetnc_new  rimdfetnc_new rimpcntrc_new rimbgecoc_new  rimuecltc_new rimwbcntc_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 

***************************************************************************************************************************
** Panel D2. Have Not Attended College.
***************************************************************************************************************************	   

estout  rimsmetnnc_new  rimdfetnnc_new rimpcntrnc_new rimbgeconc_new  rimuecltnc_new rimwbcntnc_new, /// 
	cells(b(star fmt(%9.4f)) t(par fmt(%9.2f)))   ///
    stats(r2 r2_a r2_within N,fmt( %9.3f %9.3f %9.3f %9.0g)  labels( R2 Adj_R2 Within_R2  N)) ///
	keep(totunemp) starlevels(* 0.1 ** 0.05  *** 0.01) ///
	mlabels("imsmetn" "imdfetn" "impcntr" "imbgeco" "imueclt" "imwbcnt" ) ///
	prehead(Dependent variable: Trust Variables: Time FE estimator) ///
	postfoot(Standard erros adjusted for clustering on country level, t-stat in parentheses) 

***************************************************************************************************************************

log close

