
***************************************************************************************************************************
***************************************************************************************************************************
**** Summary Program File. Generating All Supplementary Appendix Tables
***************************************************************************************************************************
***************************************************************************************************************************



clear all
set more off

global files="C:/Users/User/Dropbox/ETC"

cd "$files"

use "$files/ESS_individual_data", clear


** Preliminaries 1. Define variable lists
***************************************************************************************************************************
global ess 	 ppltrst_new pplfair_new pplhlp_new trstprl_new trstplt_new trstlgl_new trstplc_new stfdem_new trstep_new trstun_new lrscale_new clsprty_new euftf_new 
global imm	 imsmetn_new  imdfetn_new impcntr_new imbgeco_new imueclt_new imwbcnt_new 

** Main Variables (Defintions)
***************************************************************************************************************************
describe $ess $imm


log using "$files/Appendix_Tables", text replace

** Appendix Table 1. Summary Statistics
***************************************************************************************************************************

***************************************************************************************************************************
** Summary Statistics. Appendix Table 1 - Panel A. General and Political Trust and Political Attitudes. European Social Survey								
***************************************************************************************************************************
** row (1). Trust other people
** row (2). Belief that people are fair
** row (3). Belief that people are helpful
** row (4). Trust in national parliaments
** row (5). Trust in politicians
** row (6). Trust in the legal system
** row (7). Trust in police
** row (8). Satisfaction with how democracy is working
** row (9). Trust in European Parliament
** row (10). Trust in the United Nations
** row (11). Placement on the leftright continuum
** row (12). Feeling close to a particular party
** row (13). Belief that European unification should go further
***************************************************************************************************************************
tabstat $ess if essround<=4 & essround!=., columns(stats) statistics(n mean p50 sd )
tabstat $ess if essround>4  & essround!=., columns(stats) statistics(n mean p50 sd )

***************************************************************************************************************************
** Summary Statistics. Appendix Table 1 - Panel B. Beliefs on Immigration. European Social Survey								
***************************************************************************************************************************
** row (1). We should allow immigrants of the same race
** row (2). We should allow immigrants of different races
** row (3). We should allow immigrants from poorer countries
** row (4). Belief that immigrants are good for the economy
** row (5). Belief that immigrants improve cultural life
** row (6). Belief that immigrants make the country a better place
***************************************************************************************************************************
tabstat $imm if essround<=4 & essround!=., columns(stats) statistics(n mean p50 sd )
tabstat $imm if essround>4  & essround!=., columns(stats) statistics(n mean p50 sd )


log close


use "$files/voting_NUTS3.dta", clear 
set more off

do "$files/program5.do"

log using "$files/Appendix_Tables", text append


** Appendix Table 2. Employment/Population and Voting for Anti-Establishment Parties at NUTS3 Level Panel Fixed-Effects OLS Estimates. 2000-2017						
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
** Panel A. Panel A. Panel Fixed-Effects with Core-Periphery Specific Period (4-year) Time Constants					
***************************************************************************************************************************
estout v1r v2r v3r v4r v5r v6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(emp_pop) stats(r2_a r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	

**Panel B. OLS Difference Specifications with Core-Periphery Constants, Post-Crisis Average [2017-2009] - Pre-Crisis Average [2001-2008]					
***************************************************************************************************************************
estout dil1r dil2r dil3r dil4r dil5r dil6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   /// 
       keep( S9.emp_pop_sm8)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)


log close


use "$files/voting_ESS_NUTS2.dta", clear 
set more off

** Preliminaries 1. Define variable lists
***************************************************************************************************************************
global econ  totunemp lppsgdp sh_const  sh_agri sh_finan sh_trade sh_govt sh_indus
global vote  extreme_per extreme_perel extreme_perer extreme_perp extreme_perae part blankinv_per
global ess 	 ppltrst_new pplfair_new pplhlp_new trstprl_new trstplt_new trstlgl_new trstplc_new stfdem_new trstep_new trstun_new lrscale_new clsprty_new euftf_new 
global imm	 imsmetn_new  imdfetn_new impcntr_new imbgeco_new imueclt_new imwbcnt_new 

** Main Variables (Defintions)
***************************************************************************************************************************
describe $econ $vote $ess $imm


** Preliminaries 2. define electoral 4 year periods for the elections based analysis
***************************************************************************************************************************
***************************************************************************************************************************
gen 		eperiod=1 
replace 	eperiod=2 if year>2004  & year<2009
replace 	eperiod=3 if year>2008  & year<2013
replace 	eperiod=4 if year>2012  & year<2018


egen eperiod_group=group(eperiod group1)
egen country_year=group(cntry1 year)
egen group_year=group(group1 year)
egen group_essround=group(group1 essround)




** Preliminaries 3. Get time-varying averages for industrial composition, unemployment and voting
***************************************************************************************************************************
***************************************************************************************************************************

foreach var of varlist sh_const sh_agri sh_finan sh_trade sh_govt sh_indus {
	tssmooth ma `var'_sm3 = `var', window(3 1) 
	tssmooth ma `var'_sm4 = `var', window(4 1) 
	
}

foreach var of varlist totunemp extreme_per extreme_perer extreme_perel extreme_perp extreme_perae part {
	tssmooth ma `var'_sm3 = `var', window(3 1) 
	tssmooth ma `var'_sm4 = `var', window(4 1) 
	tssmooth ma `var'_sm8 = `var', window(8 1) 
	
}

foreach var of varlist ppltrst_new pplfair_new pplhlp_new trstprl_new trstplt_new trstlgl_new trstplc_new stfdem_new trstep_new trstun_new lrscale_new clsprty_new euftf_new {
	tssmooth ma `var'_sm3 = `var', window(3 1) 
	tssmooth ma `var'_sm4 = `var', window(4 1) 
	tssmooth ma `var'_sm8 = `var', window(8 1) 
	
}

***************************************************************************************************************************



** Run Programs (.do files)
***************************************************************************************************************************
***************************************************************************************************************************

do "$files/program6.do"
do "$files/program7.do"
do "$files/program8.do"
do "$files/program9.do"
do "$files/program12.do"


log using "$files/Appendix_Tables", text append
	     

** Appendix Table 3. Lagged Construction Share and Unemployment Panel Region Fixed-Effects OLS Estimates			
** Dependent Variable. Regional Unemployment
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). region and year fixed-effects
** column (2). region and year fixed-effects and other-than-construction industrial shares as controls
** column (3). region and group-year fixed-effects
** column (4). region and group-year fixed-effects and other-than-construction industrial shares as controls
***************************************************************************************************************************
***************************************************************************************************************************
estout fs1ar fs2ar fs3ar fs4ar, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(L1sh_const)  stats(r2_a r2_w  N N_clust, fmt(%9.3f %9.0g) labels(r-square within-r-square Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)
	   

	   
	   
	   
** Appendix Table 4. Pre-Crisis Construction Share and Unemployment Dynamics during the Crisis OLS Estimates				
***************************************************************************************************************************
***************************************************************************************************************************
** column 1. no controls
** column 2. initial pre-crisis industrial composition
** column 3. country group constants
** column 4. country group constants and initial pre-crisis industrial composition
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. Industrial Share in 2007
***************************************************************************************************************************
estout b1r b2r b3r b4r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( L10.sh_const)  stats(r2_a r2_w  N N_clust, fmt(%9.3f %9.0g) labels(r-square within_r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	  
	     
	   
** Panel B. Industrial Share in 2003
***************************************************************************************************************************
estout b1rr b2rr b3rr b4rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( L14.sh_const)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	  	   
		   

		   
		   
		   
** Appendix Table 5. Pre-Crisis Construction and Unemployment Dynamics during the Crisis OLS specifications					
***************************************************************************************************************************
***************************************************************************************************************************  
** column (1). 2016-2008
** column (2). 2015-2008
** column (3). 2014-2008
** column (4). 2013-2008
** column (5). 2012-2008
***************************************************************************************************************************
***************************************************************************************************************************	
**  Panel A.   Industrial Share in 2007
***************************************************************************************************************************
**  2016-2008
estout b1rt b2rt b3rt b4rt b5rt, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( L9.sh_const L8.sh_const L7.sh_const L6.sh_const L5.sh_const)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	  	   

**  Panel B.  Industrial Share in 2004-2007 
***************************************************************************************************************************
estout b1rtt b2rtt b3rtt b4rtt b5rtt, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( L9.sh_const_sm3 L8.sh_const_sm3 L7.sh_const_sm3 L6.sh_const_sm3 L5.sh_const_sm3)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	  	   
		   

		   

		   	   
** Appendix Table 6. Industrial Regional Composition and Voting for Anti-Establishment Parties "Reduced-Form" Estimates. 2000-2017						
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. General Year Fixed-Effects					
***************************************************************************************************************************
estout rfv1rr rfv2rr rfv3rr rfv4rr rfv5rr rfv6rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(sh_const sh_agri sh_trade sh_govt sh_finan )  stats(r2_a  r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)

** Panel B. General Period (4-year) Time Fixed-Effects					
***************************************************************************************************************************
estout rfv1 rfv2 rfv3 rfv4 rfv5 rfv6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(sh_const sh_agri sh_trade sh_govt sh_finan )  stats(r2_a  r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel C. Country-Group Period (4-year) Time Fixed-Effects					
***************************************************************************************************************************
estout rfv1r rfv2r rfv3r rfv4r rfv5r rfv6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(sh_const sh_agri sh_trade sh_govt sh_finan ) stats(r2_a r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	  


	   
	   

** Appendix Table 7. Unemployment and Voting for Anti-Establishment Parties Before and After the Crisis 2SLS Difference Specifications.  
** Post-Crisis Average [2017-2013] - Pre-Crisis Average [2004-2008]						
******************************************************************************************************************************
******************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
******************************************************************************************************************************
******************************************************************************************************************************
** Panel A. General Constant
******************************************************************************************************************************
 estout kk1 kk2 kk3 kk4 kk5 kk6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S9.totunemp_sm4) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel B. Country-Group Constants 
******************************************************************************************************************************
estout kk1r kk2r kk3r kk4r kk5r kk6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (S9.totunemp_sm4) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   		   


			   
** Appendix Table 8. Construction and Self-Reported Corruption and Views on Corruption Cross-Sectional Estimates in 2003/2004					
******************************************************************************************************************************
******************************************************************************************************************************
** column (1). Public Official Asked Favor/Bribe past 5 years
** column (2). Public Official Asking Favor/Bribe is Wrong
** column (3). Respondent Offered Favor/Bribe last 5 years
** column (4). Public Official Asked Favor/Bribe past 5 years, Country Fixed-Effects
** column (5). Public Official Asking Favor/Bribe is Wrong, Country Fixed-Effects
** column (6). Respondent Offered Favor/Bribe past 5 years, Country Fixed-Effects
******************************************************************************************************************************
******************************************************************************************************************************
estout co1 co2 co3 co4 co5 co6  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a    N N_clust, fmt(%9.3f %9.0g) labels(r-square  Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   			   

				   
				   
	   		   
** Appendix Table 9. Further Identification Tests Construction, Unemployment and Voting for Anti-Establishment Parties
** Panel 2SLS Estimates with Country-Group Time Effects					
******************************************************************************************************************************
******************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types - Lag College Attainment
** column (2). Voting for Populist Parties - Lag College Attainment
** column (3). Voting for Eurosceptic / Separatist parties - Lag College Attainment
** column (4). Antiestablishment Parties. All Types - Lag Net Migration Indicator
** column (5). Voting for Populist Parties - Lag Net Migration Indicator
** column (6). Voting for Eurosceptic / Separatist parties - Lag Net Migration Indicator
******************************************************************************************************************************
******************************************************************************************************************************
estout hh1r hh2r hh3r hh4r hh5r hh6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a  cdf rkf  N N_clust, fmt(%9.3f %9.0g) labels(r-square F1 F2 Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	      

		  
		  
** Appendix Table 10. Further Identification Tests Construction, Unemployment and Voting for Anti-Establishment Parties
** Panel 2SLS Estimates with General Time Effects						
******************************************************************************************************************************
******************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
******************************************************************************************************************************
******************************************************************************************************************************

** Panel A. Panel A. Controlling for Share of ESS Respondents being Citizens 					
******************************************************************************************************************************
estout ch1 ch2 ch3 ch4 ch5 ch6  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a  cdf rkf  N N_clust, fmt(%9.3f %9.0g) labels(r-square F1 F2 Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)		 
	   
** Panel B. Panel B. Controlling for Share of ESS Respondents Born in the Country					
******************************************************************************************************************************
estout ch1r ch2r ch3r ch4r ch5r ch6r  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       stats(r2_a  cdf rkf  N N_clust, fmt(%9.3f %9.0g) labels(r-square F1 F2 Obs Countries ))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)
				   
			
			


** Appendix Table 11.  Precrisis Construction and General and Political Trust, and Political Beliefs before and after the Economic Crisis
** "Reduced-Form" Estimates in Differences												
******************************************************************************************************************************	   
******************************************************************************************************************************
** row (1). Trust other people
** row (2). Belief that people are fair
** row (3). Belief that people are helpful
** row (4). Trust in national parliaments
** row (5). Trust in politicians
** row (6). Trust in the legal system
** row (7). Trust in police
** row (8). Satisfaction with how democracy is working
** row (9). Trust in European Parliament
** row (10). Trust in the United Nations
** row (11). Placement on the leftright continuum
** row (12). Feeling close to a particular party
** row (13). Belief that European unification should go further
******************************************************************************************************************************
******************************************************************************************************************************
** Panel A. 2012-2008
******************************************************************************************************************************
estout rf1r rf2r rf3r rf4r rf5r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (L5.sh_const_sm3 ) stats(r2_a N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

estout rf6r rf7r rf8r rf9r rf10r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (L5.sh_const_sm3 ) stats(r2_a N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

estout rf11r rf12r rf13r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (L5.sh_const_sm3 ) stats(r2_a N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	


** Panel B. 2014-2008
******************************************************************************************************************************
estout rf1rr rf2rr rf3rr rf4rr rf5rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (L7.sh_const_sm3  ) stats(r2_a N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

estout rf6rr rf7rr rf8rr rf9rr rf10rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (L7.sh_const_sm3  ) stats(r2_a N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	 
estout rf11rr rf12rr rf13rr, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (L7.sh_const_sm3  ) stats(r2_a N N_clust , fmt(%9.3f %9.0g) labels(r-squared Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

	 	 
	   
	   	  
** Appendix Table 12. Unemployment, General and Political Trust, and Political Beliefs
** Panel Fixed-Effects 2SLS Estimates. 2000-2014.		
***************************************************************************************************************************
***************************************************************************************************************************
** row (1). Trust other people
** row (2). Belief that people are fair
** row (3). Belief that people are helpful
** row (4). Trust in national parliaments
** row (5). Trust in politicians
** row (6). Trust in the legal system
** row (7). Trust in police
** row (8). Satisfaction with how democracy is working
** row (9). Trust in European Parliament
** row (10). Trust in the United Nations
** row (11). Placement on the leftright continuum
** row (12). Feeling close to a particular party
** row (13). Belief that European unification should go further
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. General ESS Round (Time) Fixed-Effects											
***************************************************************************************************************************
estout ivaa1 ivaa2 ivaa3 ivaa4 ivaa5, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (totunemp) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

estout ivaa6 ivaa7 ivaa8 ivaa9 ivaa10, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (totunemp) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

estout ivaa11 ivaa12 ivaa13, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (totunemp) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	   
** Panel B. Country-Group ESS Round (Time) Fixed-Effects											
***************************************************************************************************************************
estout ivaa31 ivaa32 ivaa33 ivaa34 ivaa35, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
      keep (totunemp) stats(r2_a N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	

estout ivaa36 ivaa37 ivaa38 ivaa39 ivaa310, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
      keep (totunemp) stats(r2_a N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
		  
estout ivaa311 ivaa312 ivaa313, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
      keep (totunemp) stats(r2_a N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	
		
		
		

** Appendix Table 13. Unemployment and Beliefs on Immigration Panel Fixed-Effects 2SLS Estimates. 2000-2014.							
***************************************************************************************************************************
***************************************************************************************************************************
** row (1). We should allow immigrants of the same race
** row (2). We should allow immigrants of different races
** row (3). We should allow immigrants from poorer countries
** row (4). Belief that immigrants are good for the economy
** row (5). Belief that immigrants improve cultural life
** row (6). Belief that immigrants make the country a better place
***************************************************************************************************************************
***************************************************************************************************************************
** Panel A. General ESS Round (Time) Fixed-Effects						
***************************************************************************************************************************
estout ia1 ia2 ia3 ia4 ia5 ia6  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (totunemp) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel B. Country-Group ESS Round (Time) Fixed-Effects						
***************************************************************************************************************************
estout ia1r ia2r ia3r ia4r ia5r ia6r  , cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep (totunemp) stats(r2_a  N N_clust cdf rkf, fmt(%9.3f %9.0g) labels(r-square  Obs Countries F1 F2))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	
	



	   
log close	   
	   
