
******************************************************************************************************************************
***********************************************************************************************************************************
** Panel. OLS . Unemployment and Voting. NUTS3 level, 11 countries.
** Difference Specifications. OLS Unemployment and Voting. NUTS3 level, 11 countries.
** Baseline and Robustness [Main Paper and Appendix Tables]
** Table 4, Appendix Table 2
************************************************************************************************************************************
************************************************************************************************************************************


use "$files/voting_NUTS3", clear

set more off

egen eperiod_groupa=group(eperiod groupa)
foreach var of varlist emp_pop extreme_per extreme_perer extreme_perel extreme_perp extreme_perae part {
	tssmooth ma `var'_sm8 = `var', window(8 1) 
	}	



** Table 4. OLS Panel Estimates (NUTS fixed-effects) and Period Fixed-Effects
*******************************************************************************************************************

** Panel A. Region and Period (4-year)  fixed-effects
***************************************** ********************************************
xi: xtreg extreme_per 		emp_pop i.eperiod if iv==3, fe cluster (cntry) 
est store v1

xi: xtreg extreme_perel 	emp_pop i.eperiod if iv==3, fe cluster (cntry) 
est store v2

xi: xtreg extreme_perer 	emp_pop i.eperiod if iv==3, fe cluster (cntry) 
est store v3

xi: xtreg extreme_perp 		emp_pop i.eperiod if iv==3, fe cluster (cntry) 
est store v4

xi: xtreg extreme_perae 	emp_pop i.eperiod if iv==3, fe cluster (cntry) 
est store v5

xi: xtreg part 				emp_pop i.eperiod if iv==3, fe cluster (cntry) 
est store v6


** Table 4. Panel B. Employment and Voting for Antiestablishment Parties Before and After the Crisis
** OLS Difference Specifications.  
** Post-Crisis Average [2017-2009] - Pre-Crisis Average [2001-2008]
**********************************************************************************************************
**********************************************************************************************************
xtset nuts1 year
xi: reg S9.extreme_per_sm8 S9.emp_pop_sm8    if iv==3 & year==2017, r cluster(cntry)
est store dil1

xi: reg S9.extreme_perel_sm8 S9.emp_pop_sm8    if iv==3 & year==2017, r cluster(cntry)
est store dil2

xi: reg S9.extreme_perer_sm8 S9.emp_pop_sm8     if iv==3 & year==2017, r cluster(cntry)
est store dil3

xi: reg S9.extreme_perp_sm8 S9.emp_pop_sm8     if iv==3 & year==2017, r cluster(cntry)
est store dil4

xi: reg S9.extreme_perae_sm8 S9.emp_pop_sm8     if iv==3 & year==2017, r cluster(cntry)
est store dil5

xi: reg S9.part_sm8 S9.emp_pop_sm8     if iv==3 & year==2017, r cluster(cntry)
est store dil6

** Panel A. Region (NUTS Fixed-Effects) and Electoral Cycle (4-year) Time  Fixed-Effects
***********************************************************************************************
estout v1 v2 v3 v4 v5 v6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(emp_pop)  stats(r2_a  r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)	

** Panel B. General Constant
estout dil1 dil2 dil3 dil4 dil5 dil6, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep( S9.emp_pop_sm8)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)
	   



** Table A2 Panel A. Country-Group Period (4-year) time fixed-effects
*************************************************************************************
set more off

xi: xtreg extreme_per 		emp_pop i.eperiod_groupa if iv==3, fe cluster (cntry) 
est store v1r

xi: xtreg extreme_perel 	emp_pop i.eperiod_groupa if iv==3, fe cluster (cntry) 
est store v2r

xi: xtreg extreme_perer 	emp_pop i.eperiod_groupa if iv==3, fe cluster (cntry) 
est store v3r

xi: xtreg extreme_perp 		emp_pop i.eperiod_groupa if iv==3, fe cluster (cntry) 
est store v4r

xi: xtreg extreme_perae 	emp_pop i.eperiod_groupa if iv==3, fe cluster (cntry) 
est store v5r

xi: xtreg part 				emp_pop i.eperiod_groupa if iv==3, fe cluster (cntry) 
est store v6r


** Table A2. Panel B. Unemployment and Voting for Antiestablishment Parties Before and After the Crisis
** OLS Difference Specifications.  
** Post-Crisis Average [2017-2009] - Pre-Crisis Average [2001-2008]
**********************************************************************************************************
**********************************************************************************************************

set more off
xi: reg S9.extreme_per_sm8 S9.emp_pop_sm8    i.groupa if iv==3 & year==2017, r cluster(cntry)
est store dil1r
 
xi: reg S9.extreme_perel_sm8 S9.emp_pop_sm8    i.groupa if iv==3 & year==2017, r cluster(cntry)
est store dil2r

xi: reg S9.extreme_perer_sm8 S9.emp_pop_sm8    i.groupa if iv==3 & year==2017, r cluster(cntry)
est store dil3r
 
xi: reg S9.extreme_perp_sm8 S9.emp_pop_sm8    i.groupa if iv==3 & year==2017, r cluster(cntry)
est store dil4r

xi: reg S9.extreme_perae_sm8 S9.emp_pop_sm8    i.groupa if iv==3 & year==2017, r cluster(cntry)
est store dil5r

xi: reg S9.part_sm8 S9.emp_pop_sm8    i.groupa if iv==3 & year==2017, r cluster(cntry)
est store dil6r


** Table A2. Employment/Population and Voting for Anti-Establishment Parties at NUTS3 Level Panel Fixed-Effects OLS Estimates. 2000-2017						
***************************************************************************************************************************
***************************************************************************************************************************
** column (1). Antiestablishment Parties. All Types
** column (2). Voting for Radical Left Parties
** column (3). Voting for Far Right Parties
** column (4). Voting for Populist Parties
** column (5). Voting for Eurosceptic / Separatist parties
** column (6). Participation Rate
***************************************************************************************************************************
** Panel A. Panel A. Panel Fixed-Effects with Core-Periphery Specific Period (4-year) Time Constants					
***************************************************************************************************************************
estout v1r v2r v3r v4r v5r v6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   ///
       keep(emp_pop) stats(r2_a r2_w N N_clust, fmt(%9.3f %9.0g) labels(r-square  r_within Obs Countries))  starlevels( * 0.1 ** 0.05  *** 0.01) style(fixed)	

**Panel B. OLS Difference Specifications with Core-Periphery Constants, Post-Crisis Average [2017-2009] - Pre-Crisis Average [2001-2008]					
***************************************************************************************************************************
estout dil1r dil2r dil3r dil4r dil5r dil6r, cells(b(star fmt(%9.4f)) se(par) t(fmt(%9.2f)))   /// 
       keep( S9.emp_pop_sm8)  stats(r2_a   N N_clust, fmt(%9.3f %9.0g) labels(r-square   Obs Countries))  starlevels( * 0.1  ** 0.05  *** 0.01) style(fixed)

	   
	