function recession_bars(x_lim,y_lim)
% This function adds recession bars to the current figure
% See the example below for how it can be used
% Input: x_lim and y_lim are 1 x 2 vectors with X and Y axis limits
%
% Note that this puts the bar "over" the figure, so the figure needs to be
% redrawn, so it is on top of the bars .. see the example;

hold on;

NBER_PT = NBER_Peak_Trough_Decimal_Dates;
nbc = size(NBER_PT,1);
y1 = y_lim(1);
y2 = y_lim(2);
ydif = y2-y1;
y1 = y1-ydif;
y2 = y2+ydif;
for bc = 1:nbc;
    % Check to see if this BC is included in plot
    if (NBER_PT(bc,1) <= x_lim(2)) & (NBER_PT(bc,2) >= x_lim(1))
        x1 = NBER_PT(bc,1);
        x2 = NBER_PT(bc,2);
        if x1 < x_lim(1);
            x1 = x_lim(1);
        end;
        if x2 > x_lim(2);
            x2 = x_lim(2);
        end;
        %area([x1 x2], [y_lim(2) y_lim(2)],y_lim(1),'LineStyle','none','FaceColor',[0.8 0.8 0.8]); 
        %patch([x1 x2 x2 x1],[y1 y1 y2 y2],[0.8 0.8 0.8],'EdgeColor','none');
        % alpha(0.3);
        patch([x1 x2 x2 x1],[y1 y1 y2 y2],'k','EdgeColor','none');
        alpha(0.1);
        % Note: color of shading [0.8 0.8 0.8] uses RGB triplet. Can be
        % changed. alpha(0.3) governs the transparency of the shading
    end;
end;

hold off;


% % Example
% [nobs,calvec,calds] = calendar_make([1915 6],[2015 6], 12);
%%% Note .. can also use quarterly calendar with no modfications
% X = (1:nobs)';
% plot(calvec,X);
% ax = gca;  % This gets axis limits for current plot (must be open)
% x_lim = ax.XLim;
% y_lim = ax.YLim;
% recession_bars(x_lim,y_lim);
% hold on;
%  plot(calvec,X,'- b','LineWidth',2);
% hold off;



end

