function [ dz_mu ] = mu_ca( dz,xca,ismpl_ol,bw_bw)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

% Compute Okun's law coefficients to cyclically adjust dz
  x = [ones(size(dz,1),1) xca];
  [b_okun,v_okun,se_okun,ser_okun,rbarsq_okun_2]=hac(dz(ismpl_ol==1),x(ismpl_ol==1,:),4,1);
  cycl_adj = xca*b_okun(2:end);
  dz_ca = dz-cycl_adj;
  % Full-sample indicator using dy_ca
  ii_fs = 1-isnan(dz_ca);
  T = sum(ii_fs);
  % Compute weights for Bi-weight estimates of trend
  bw_mat = NaN(T,T);
  trend = (1:1:T)';
  for t = 1:T;
        dt = (trend-t)/bw_bw;
        bw_weight = (15/16)*((1-dt.^2).^2);   % Bi-Weight 
        bw_weight = bw_weight.*(abs(dt) < 1);
        bw_weight = bw_weight/sum(bw_weight); % Rows sum to one
        bw_mat(t,:)= bw_weight';
   end;
   % Biweight Estimates of mu(t)
   dz_mu = NaN(size(dz,1),1);
   dz_mu(ii_fs==1)=bw_mat*dz_ca(ii_fs==1);   % Estimate of mu

end