% Set up data and calendars for FHSW BPEA Paper
% 20170217, mww

if load_data == 1;

% ----------- Features of Data Set ---------
miss_code = 1.0e+32;

% ----- Full-Sample Calendar -----
[dnobs_fs,calvec_fs,calds_fs] = calendar_make([1947 1],[2016 4],4);


% --------------- Read In NIPA Table 1.1.3  ---------------- 
xlsname = '../data/nipa_table_1_1_3.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 24;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_1_1_3_definitions;
var_def = var_def_1_1_3;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 1.1.4 (Price Index .. Not deflator) ---------------- 
xlsname = '../data/nipa_table_1_1_4.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 24;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_1_1_4_definitions;
var_def = var_def_1_1_4;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);  
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 1.1.5 ---------------- 
xlsname = '../data/nipa_table_1_1_5.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 26;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_1_1_5_definitions;
var_def = var_def_1_1_5;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 1.3.3 ---------------- 
xlsname = '../data/nipa_table_1_3_3.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 11;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_1_3_3_definitions;
var_def = var_def_1_3_3;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 1.3.4 ---------------- 
xlsname = '../data/nipa_table_1_3_4.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 11;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_1_3_4_definitions;
var_def = var_def_1_3_4;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);  
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 1.3.5 ---------------- 
xlsname = '../data/nipa_table_1_3_5.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 11;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_1_3_5_definitions;
var_def = var_def_1_3_5;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);  
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 7.1 ---------------- 
xlsname = '../data/nipa_table_7_1.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 18;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_7_1_definitions;
var_def = var_def_7_1;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);  
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end


% --------------- Read In NIPA Table 1.10 ---------------- 
xlsname = '../data/nipa_table_1_10.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 24;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_1_10_definitions;
var_def = var_def_1_10;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 2.3.3 ---------------- 
xlsname = '../data/nipa_table_2_3_3.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 28;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_2_3_3_definitions;
var_def = var_def_2_3_3;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 2.3.4 ---------------- 
xlsname = '../data/nipa_table_2_3_4.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 28;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_2_3_4_definitions;
var_def = var_def_2_3_4;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 2.3.5 ---------------- 
xlsname = '../data/nipa_table_2_3_5.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 28;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_2_3_5_definitions;
var_def = var_def_2_3_5;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 4.2.3 ---------------- 
xlsname = '../data/nipa_table_4_2_3.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 2;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_4_2_3_definitions;
var_def = var_def_4_2_3;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 4.2.4 ---------------- 
xlsname = '../data/nipa_table_4_2_4.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 2;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_4_2_4_definitions;
var_def = var_def_4_2_4;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 4.2.5 ---------------- 
xlsname = '../data/nipa_table_4_2_5.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 2;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_4_2_5_definitions;
var_def = var_def_4_2_5;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 2.1 ---------------- 
xlsname = '../data/nipa_table_2_1.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 1;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 4],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_2_1_definitions;
var_def = var_def_2_1;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end
% --------------- Read In NIPA Table 5.3.3 ---------------- 
xlsname = '../data/nipa_table_5_3_3.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 31;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 4],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_5_3_3_definitions;
var_def = var_def_5_3_3;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 5.3.5 ---------------- 
xlsname = '../data/nipa_table_5_3_5.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 31;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 4],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_5_3_5_definitions;
var_def = var_def_5_3_5;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end

% --------------- Read In NIPA Table 3.1 ---------------- 
xlsname = '../data/nipa_table_3_1.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 4;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 4],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
nipa_table_3_1_definitions;
var_def = var_def_3_1;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);   
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end


% --------------- Read In Labor Productivity and Cost Data ---------------- 
xlsname = '../data/labor_productivity_and_costs.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Quarterly';
ns = 12;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
labor_productivity_and_costs_definitions;
var_def = var_def_lpc;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xdata = datamat(:,j); 
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end
nfb_r_output = nfb_output./nfb_price;
tmp = {'','nfb_r_output',''};
var_def_lpc = [var_def_lpc;tmp];

% --------------- Read In CES Employment Data ---------------- 
xlsname = '../data/employment_situation_ces_table_b_1.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Monthly';
ns = 17;
[dnobs_m,calvec_m,calds_m] = calendar_make([1947 1],[2016 12],12);
[dnobs_q,calvec_q,calds_q] = calendar_make([1947 1],[2016 4],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec_q);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs_m,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
employment_situation_ces_table_b_1_definitions;
var_def = var_def_ces;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xm = datamat(:,j);   
  xq = mtoq(xm,calds_m,calds_q,0); 
  xdata = xq;
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end;
ces_emp_gov_sl = ces_emp_gov_state + ces_emp_gov_local;


% --------------- Read In CPS Employment Data ---------------- 
xlsname = '../data/employment_situation_cps_table_a_1.xlsx';
% Read Data 
ndesc=0;
ncodes=0;
sheet='Monthly';
ns = 9;
[dnobs_m,calvec_m,calds_m] = calendar_make([1948 1],[2016 12],12);
[dnobs_q,calvec_q,calds_q] = calendar_make([1948 1],[2016 4],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec_q);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs_m,ndesc,ncodes);
% % Convert Namestrings to upper case 
namevec = upper(namevec);
% Get Variable definitions
employment_situation_cps_table_a_1_definitions;
var_def = var_def_cps;
for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  xm = datamat(:,j);   
  xq = mtoq(xm,calds_m,calds_q,0); 
  xdata = xq;
  x = NaN(dnobs_fs,1);
  x(i1==1)=xdata(i2==1);
  str = var_def(i,2);
  str=lower(str);
  str = char(str);
  eval([str '=x;']);
end;

% --------------- Read In Other Data Series ---------------- 
xlsname = '../data/quarterly_tfp.xlsx';
% Read Data 
sheet='quarterly';
ns = 21;
[dnobs,calvec,calds] = calendar_make([1947 1],[2016 3],4);
[i1,i2]=calendar_subsets(calvec_fs,calvec);
[namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
ii = datamat == 9999;
datamat(ii)=NaN;
% Convert Namestrings to upper case 
namevec = upper(namevec);

% Get Variable definitions
quarterly_tfp_definitions;
var_def = var_def_quarterly_tfp;

for i = 1:size(var_def,1);
  str=var_def{i,1};    
  str=upper(str);
  j = colnumber(str,namevec);
  if j > 0;
   xdata = datamat(:,j);   
   x = NaN(dnobs_fs,1);
   x(i1==1)=xdata(i2==1);
   str = var_def(i,2);
   str=lower(str);
   str = char(str);
   eval([str '=x;']);
  end;
end;

% ------------- Create a list of variables to save ---------
% Create a list of variables to save
slist = [var_def_1_1_3(:,2);var_def_1_1_4(:,2);var_def_1_1_5(:,2);var_def_1_3_3(:,2);var_def_1_3_4(:,2);var_def_1_3_5(:,2);var_def_7_1(:,2)];
slist = [slist;var_def_1_10(:,2)];
slist = [slist;var_def_2_3_3(:,2);slist;var_def_2_3_4(:,2);var_def_2_3_5(:,2)];
slist = [slist;var_def_lpc(:,2)];
slist = [slist;var_def_ces(:,2)];
slist = [slist;var_def_cps(:,2)];
slist = [slist;var_def_quarterly_tfp(:,2)];
slist = [slist;var_def_4_2_3(:,2);var_def_4_2_4(:,2);var_def_4_2_5(:,2)];
slist = [slist;var_def_5_3_3(:,2);var_def_5_3_5(:,2)];
slist = [slist;var_def_3_1(:,2)];

% Calendar
dnobs = dnobs_fs;
calvec = calvec_fs;
calds = calds_fs;
dlist = {'dnobs';'calvec';'calds'};

str_tmp = [matdir 'slist'];
save(str_tmp,'slist');
for iseries = 1:size(slist,1);
     ustr = char(slist(iseries));
     str_tmp = [matdir ustr];
     str_tmp1 = 'save(str_tmp,''';
     str_tmp2 = ''');';
     eval([str_tmp1 ustr str_tmp2]);
end;

str_tmp = [matdir 'dlist'];
save(str_tmp,'dlist');
for iseries = 1:size(dlist,1);
     ustr = char(dlist(iseries));
     str_tmp = [matdir ustr];
     str_tmp1 = 'save(str_tmp,''';
     str_tmp2 = ''');';
     eval([str_tmp1 ustr str_tmp2]);
end;

  
end;  %Load Data end;
 
  
% Load Variables and Give Standard Names 
str_tmp = [matdir 'slist'];
load(str_tmp); 
for iseries = 1:size(slist,1);
     ustr = char(slist(iseries));
     str_tmp = [matdir ustr];
     load(str_tmp);
end; 

str_tmp = [matdir 'dlist'];
load(str_tmp); 
for iseries = 1:size(dlist,1);
     ustr = char(dlist(iseries));
     str_tmp = [matdir ustr];
     load(str_tmp);
end; 

  