function [dz_cycle,dz_ca,dz_mu,dz_irregular,var_dz_mu,b_okun_sum,se_b_okun_sum ] = cyclical_adjustment(dz,xca,ismpl_ol,bw_bw)

  % Input
  %   dz .. data vector
  %   xca .. leads and lags of d_urate for cyclical adjustment (constant not included)
  %   ismpl_ol .. sample vector for Okun's law regressions
  %   bw_bw .. bandwidth for biweight kernel for computing trend
  % Ouptut:
  %  dz_cycle: Fitted Cyclical Component
  %  dz_ca: Cyclically adjusted dz
  %  dz_mu: Trend estimate for cyclically adjusted dz
  %  dz_irregular: Irregular component
  %  var_dz_mu:  Covariance matrix for dz_mu (T x T)
  %  b_okun_sum:  Sum of Okun's law coefficients
  %  se_b_okun_sum: SE of sum of Okun's law coefficients

  dnobs = size(dz,1);
  x = [ones(dnobs,1) xca];
  [b_okun,v_okun,se_okun,ser_okun,rbarsq_okun_2]=hac(dz(ismpl_ol==1),x(ismpl_ol==1,:),4,1);
  dz_cycle = xca*b_okun(2:end);
  dz_ca = dz-dz_cycle;
  nb = length(b_okun)-1;
  b_okun_sum = ones(nb,1)'*b_okun(2:end);
  se_b_okun_sum = sqrt(ones(nb,1)'*v_okun(2:end,2:end)*ones(nb,1));
  
  % Compute AR(1) Coefficeints for dz_ca for use in SE_mu calculation
  x = [ones(dnobs,1),lag(dz_ca,1)];
  [barhat,vbar,se_bar,ser_ar,rbarsq_ar]=hac(dz_ca(ismpl_ol==1),x(ismpl_ol==1,:),0,1);
  omega = (ser_ar^2)*AR1_cov(dnobs,barhat(2));
  
  % Compute Cycle-adjusted trend
  % Full-sample indicator using dy_ca
  ii_fs = 1-isnan(dz_ca);
  T = sum(ii_fs);
  % Compute weights for Bi-weight estimates of trend
  bw_mat = NaN(T,T);
  trend = (1:1:T)';
  for t = 1:T;
        dt = (trend-t)/bw_bw;
        bw_weight = (15/16)*((1-dt.^2).^2);   % Bi-Weight 
        bw_weight = bw_weight.*(abs(dt) < 1);
        bw_weight = bw_weight/sum(bw_weight); % Rows sum to one
        bw_mat(t,:)= bw_weight';
   end;
   % Biweight Estimates of mu(t)
   dz_mu = NaN(size(dz,1),1);
   dz_mu(ii_fs==1)=bw_mat*dz_ca(ii_fs==1);   % Estimate of mu
   var_dz_mu = NaN(dnobs,dnobs);
   var_dz_mu(ii_fs==1,ii_fs==1)=bw_mat*omega(ii_fs==1,ii_fs==1)*bw_mat';  % Variance of estimate of mu 
   dz_irregular = dz - dz_cycle - dz_mu;
   
end