% Figure 1.b
% 
%

clear all;
small = 1.0e-10;
big = 1.0e+6;
this_date = datestr(now,'yyyymmdd');

% -----  File Directories -- overhead, etc.
 outdir = 'out/';
 figdir = 'fig/';
 matdir = 'mat/';
 p_initial = path;
 vardef_dir = 'variable_definitions/';            % Directory for necessary matlab_procs and functions                         
 p1=path(vardef_dir,p_initial);
 utility_dir = 'm_utilities';
 path(utility_dir,p1);

% -- Load Data
load_data=1;         % Set = 1 first time to read data from Excel files (then they are saved as MATLAB file)
fhsw_bpea_data;      % fhsw_bpea_data reads in the full dataset .. all variables, etc. saved in datain.xx

  
  axis_font_size = 20;
  title_font_size = 18;
  figure('position',[200 200 550 400]);
  plot(calvec,cps_urate,'- k','LineWidth',3);
  hold on;
  ax = gca;  % This gets axis limits for current plot (must be open)
  x_lim = ax.XLim;
  y_lim = ax.YLim;
  xlim([1960 2017]);
  ylim([0.0, 12.0]);
  ax.FontSize = axis_font_size;
  title('Unemployment rate','fontsize',title_font_size);
  recession_bars(x_lim,y_lim);
  hold on;
    plot(calvec,cps_urate,'- k','LineWidth',3);
  hold off;
  savefig([figdir 'Fig_1a_' this_date]);
  saveas(gcf,[figdir 'Fig_1a.epsc']);

  
% ... overheard .. reset path to initial path  
path(p_initial);  % Reset path
