cap log close
log using reg_panel.log, replace

clear 
set more off

* Import first sheet
import excel "data_for_panel.xlsx", sheet("dTFPv") firstrow
sort year BLSindustry
* Save in Stata format
save "dTFPv.dta", replace
clear

* Import second sheet 
import excel "data_for_panel.xlsx", sheet("regulatory") firstrow
sort year BLSindustry
* Save in Stata format
save "regulatory.dta", replace

* Merge sheets together
merge 1:1 year BLSindustry using "dTFPv.dta"
sort BLSindustry year
drop _merge

* Create lags up to 6 years for regulation indices 
forval i=1/6 {
	by BLSindustry: gen restrict_L`i' = restrict_L0[_n-`i']
}

* Create averages of lags
	egen restrict_L012 = rowmean(restrict_L0 restrict_L1 restrict_L2)
	egen restrict_L345 = rowmean(restrict_L3 restrict_L4 restrict_L5)
	
preserve
keep if year>=1988
xtset BLSindustry year

xtreg dTFPv restrict_L0 restrict_L1 restrict_L2 restrict_L3, fe vce(cluster BLSindustry)
test restrict_L0 restrict_L1 restrict_L2 restrict_L3

xtreg dTFPv restrict_L0 restrict_L1 restrict_L2 restrict_L3 i.year, fe vce(cluster BLSindustry)
test restrict_L0 restrict_L1 restrict_L2 restrict_L3

xtreg dTFPv restrict_L012 i.year, fe vce(cluster BLSindustry)
test restrict_L012

xtreg dTFPv restrict_L012 restrict_L345 i.year, fe vce(cluster BLSindustry)
test restrict_L012 restrict_L345


log close
