% GDP, GDI, and GDO
 y_prod = r_gdp;
 p_y_prod = q_gdp./r_gdp;          % GDP Price Deflator
 y_inc = q_gdi./p_y_prod;          % Real GDI
 y_gdo = sqrt(y_prod.*y_inc);      % Real 'GDO' .. average of GDP and GDI

% USE GDP for GDO when GDI data are unavailable
 ismpl = isnan(y_inc);
 y_gdo(ismpl==1) = y_prod(ismpl==1);

% Business Output
 % Business output, product side
 bus_y_prod = r_gva_business;                    % Quantity Index
 p_bus_y_prod = q_gva_business./r_gva_business;    % Price Deflator (not chained price index)
 % Business output, income side
 q_bus_y_inc = q_gdi - (q_gva_households_inst+q_gva_government);
 bus_y_inc = q_bus_y_inc./p_bus_y_prod;
 % Geometric average
 bus_y_gdo = sqrt(bus_y_prod.*bus_y_inc);    % GDO for business sector
 ismpl = isnan(bus_y_inc);
 bus_y_gdo(ismpl==1) = bus_y_prod(ismpl==1);
 
 % Capital and labor share
 kshare = fern_alpha;
 lshare = 1-kshare;
 
 % Some Level Indices (re-converted to growth rates below) 
 fern_dk_adj = fern_dk/400;
 fern_dlq_adj = fern_dlq/400;
 fern_dk_adj(1) = 0;
 fern_dlq_adj(1) = 0;
 bus_cap = exp(cumsum(fern_dk_adj));   % 'level' index for capital stock
 bus_lq = exp(cumsum(fern_dlq_adj));   % 'level' index for labor quality
 bus_labor = bus_lq.*bus_hours;
 d_bus_tfp = dif(log(bus_y_gdo),1) - kshare.*dif(log(bus_cap),1) - lshare.*dif(log(bus_labor),1);
 d_bus_tfp(1) = 0;
 bus_tfp = exp(cumsum(d_bus_tfp));
 
 % Labor Force participation rate
 cps_lfpr = cps_lf./cps_pop;
 
 ces_emp_gov_sl = ces_emp_gov_state+ces_emp_gov_local;
 
 % Compute some growth rates and other transformations;
 ylist = { ...
'y_prod' ...
'y_inc' ...
'y_gdo' ...
'bus_y_gdo' ...
'bus_tfp' ...
'bus_cap' ...
'bus_hours' ...
'bus_lq' ...
'bus_emp' ...
'ces_emp' ...
'ces_emp_gov_sl' ...
'cps_emp' ...
'cps_lf' ...
'cps_pop' ...
'cps_lfpr' ...
};

% Growth rates are needed for all variables
%   For some variables we need products with shares or functions of shares. For simplicity, these are computed for all variables and use standardized names
% 
for iseries = 1:size(ylist,2);
  sname = char(ylist(iseries));
  eval_str = ['z = ' sname ';'];
  eval(eval_str);
  dz = 400*dif(log(z),1);
  lshare_dz = lshare.*dz;
  kshare_dz = kshare.*dz;
  kshare2_dz = (1./(1-kshare)).*dz;
  kshare3_dz = (kshare./(1-kshare)).*dz;
  eval_str = ['d_' sname '= dz;'];
  eval(eval_str);
  eval_str = ['lshare_d_' sname '= lshare_dz;'];
  eval(eval_str);
  eval_str = ['kshare_d_' sname '= kshare_dz;'];
  eval(eval_str);
  eval_str = ['kshare2_d_' sname '= kshare2_dz;'];
  eval(eval_str);
  eval_str = ['kshare3_d_' sname '= kshare3_dz;'];
  eval(eval_str);
end; 
