% Compute Time Series and Bottom up trend estimates

% (1) Time Series Estimates of mu(t)
% Variable List
ylist = { ...
'y_prod' ...
'y_inc' ...
'y_gdo' ...
'bus_y_gdo' ...
'bus_tfp' ...
'bus_cap' ...
'bus_hours' ...
'bus_lq' ...
'bus_emp' ...
'ces_emp' ...
'cps_emp' ...
'cps_lf' ...
'cps_pop' ...
'cps_lfpr' ...
'ces_emp' ...
'ces_emp_gov_sl' ...
};

% Growth rates are needed for all variables
%   For some variables we need products with shares or functions of shares. For simplicity, these are computed for all variables and use standardized names
%
iT_fcst = find(calvec > (-0.001+T_oos_first(1) + (T_oos_first(2)-1)/4),1);  % Date for First OOS forecast
 
for iseries = 1:size(ylist,2);
  sname = char(ylist(iseries));
  eval_str = ['dz = d_' sname ';'];
  eval(eval_str);
  [dz_cycle,dz_ca,dz_mu,dz_irregular,var_dz_my,b_okun_sum,se_b_okun_sum ] = cyclical_adjustment(dz,xca,ismpl_ol,bw_bw);
  dz_mu_fcst = dz_mu;
  dz_mu_fcst(iT_fcst+1:end) = dz_mu(iT_fcst);
  eval_str = ['d_' sname '_mu = dz_mu;'];
  eval(eval_str);
  eval_str = ['d_' sname '_mu_fcst_ts = dz_mu_fcst;'];
  eval(eval_str);
 
  eval_str = ['dz = lshare_d_' sname ';'];
  eval(eval_str);
  [dz_cycle,dz_ca,dz_mu,dz_irregular,var_dz_my,b_okun_sum,se_b_okun_sum ] = cyclical_adjustment(dz,xca,ismpl_ol,bw_bw);
  dz_mu_fcst = dz_mu;
  dz_mu_fcst(iT_fcst+1:end) = dz_mu(iT_fcst);
  eval_str = ['lshare_d_' sname '_mu = dz_mu;'];
  eval(eval_str);
  eval_str = ['lshare_d_' sname '_mu_fcst_ts = dz_mu_fcst;'];
  eval(eval_str);
  
  eval_str = ['dz = kshare_d_' sname ';'];
  eval(eval_str);
  [dz_cycle,dz_ca,dz_mu,dz_irregular,var_dz_my,b_okun_sum,se_b_okun_sum ] = cyclical_adjustment(dz,xca,ismpl_ol,bw_bw);
  dz_mu_fcst = dz_mu;
  dz_mu_fcst(iT_fcst+1:end) = dz_mu(iT_fcst);
  eval_str = ['kshare_d_' sname '_mu = dz_mu;'];
  eval(eval_str);
  eval_str = ['kshare_d_' sname '_mu_fcst_ts = dz_mu_fcst;'];
  eval(eval_str);
  
  eval_str = ['dz = kshare2_d_' sname ';'];
  eval(eval_str);
  [dz_cycle,dz_ca,dz_mu,dz_irregular,var_dz_my,b_okun_sum,se_b_okun_sum ] = cyclical_adjustment(dz,xca,ismpl_ol,bw_bw);
  dz_mu_fcst = dz_mu;
  dz_mu_fcst(iT_fcst+1:end) = dz_mu(iT_fcst);
  eval_str = ['kshare2_d_' sname '_mu = dz_mu;'];
  eval(eval_str);
  eval_str = ['kshare2_d_' sname '_mu_fcst_ts = dz_mu_fcst;'];
  eval(eval_str);
  
  eval_str = ['dz = kshare3_d_' sname ';'];
  eval(eval_str);
  [dz_cycle,dz_ca,dz_mu,dz_irregular,var_dz_my,b_okun_sum,se_b_okun_sum ] = cyclical_adjustment(dz,xca,ismpl_ol,bw_bw);
  dz_mu_fcst = dz_mu;
  dz_mu_fcst(iT_fcst+1:end) = dz_mu(iT_fcst);
  eval_str = ['kshare3_d_' sname '_mu = dz_mu;'];
  eval(eval_str);
  eval_str = ['kshare3_d_' sname '_mu_fcst_ts = dz_mu_fcst;'];
  eval(eval_str);
     
end;

% (2) Compute bottom-up forecasts version for post 2007:Q4 period
% Share component of LFPR .. Annual change from 2007 Value to 2016 (from REH
% Spreadsheet)
share_dif_2016 =(-1.588+0.019)/66.2418;...
dif_ann = 100*share_dif_2016/9;  % Percentage change per year;
                                 % Use this as percentage change from
                                 % 2007-2016
ismpl = smpl(calvec,[2007 1],[2016 4],4);
d_lfpr_mu_jhs = NaN(dnobs,1);
d_lfpr_mu_jhs(ismpl==1)=dif_ann;
lshare_d_lfpr_mu_jhs = lshare.*d_lfpr_mu_jhs;
kshare_d_lfpr_mu_jhs = kshare.*d_lfpr_mu_jhs;
kshare2_d_lfpr_mu_jhs = (1./(1-kshare)).*d_lfpr_mu_jhs;
kshare3_d_lfpr_mu_jhs = (kshare./(1-kshare)).*d_lfpr_mu_jhs;
% Splice
nsplice = 12;
iT_jhs = find(calvec > 2006.999,1);

d_cps_lfpr_mu_fcst = splice_lfpr_mu(d_lfpr_mu_jhs,d_cps_lfpr_mu,iT_jhs,nsplice);
lshare_d_cps_lfpr_mu_fcst = splice_lfpr_mu(lshare_d_lfpr_mu_jhs,lshare_d_cps_lfpr_mu,iT_jhs,nsplice);
kshare_d_cps_lfpr_mu_fcst = splice_lfpr_mu(kshare_d_lfpr_mu_jhs,kshare_d_cps_lfpr_mu,iT_jhs,nsplice);
kshare2_d_cps_lfpr_mu_fcst = splice_lfpr_mu(kshare2_d_lfpr_mu_jhs,kshare2_d_cps_lfpr_mu,iT_jhs,nsplice);
kshare3_d_cps_lfpr_mu_fcst = splice_lfpr_mu(kshare3_d_lfpr_mu_jhs,kshare3_d_cps_lfpr_mu,iT_jhs,nsplice);
    
% Construct Various Forecasts used in the analysis
d_y_prod_mu_fcst = d_y_prod_mu_fcst_ts + (lshare_d_cps_lfpr_mu_fcst-lshare_d_cps_lfpr_mu_fcst_ts);
d_y_inc_mu_fcst = d_y_inc_mu_fcst_ts + (lshare_d_cps_lfpr_mu_fcst-lshare_d_cps_lfpr_mu_fcst_ts);
d_y_gdo_mu_fcst = d_y_gdo_mu_fcst_ts + (lshare_d_cps_lfpr_mu_fcst-lshare_d_cps_lfpr_mu_fcst_ts);
d_bus_y_gdo_mu_fcst = d_bus_y_gdo_mu_fcst_ts + (lshare_d_cps_lfpr_mu_fcst-lshare_d_cps_lfpr_mu_fcst_ts);
kshare3_d_bus_y_gdo_mu_fcst = kshare3_d_bus_y_gdo_mu_fcst_ts + (kshare_d_cps_lfpr_mu_fcst-kshare_d_cps_lfpr_mu_fcst_ts);

d_bus_hours_mu_fcst = d_bus_hours_mu_fcst_ts + (d_cps_lfpr_mu_fcst-d_cps_lfpr_mu_fcst_ts);
d_bus_emp_mu_fcst = d_bus_emp_mu_fcst_ts + (d_cps_lfpr_mu_fcst-d_cps_lfpr_mu_fcst_ts);
d_cps_emp_mu_fcst = d_cps_emp_mu_fcst_ts + (d_cps_lfpr_mu_fcst-d_cps_lfpr_mu_fcst_ts);
d_cps_lf_mu_fcst = d_cps_lf_mu_fcst_ts + (d_cps_lfpr_mu_fcst-d_cps_lfpr_mu_fcst_ts);
kshare_d_bus_hours_mu_fcst = kshare_d_bus_hours_mu_fcst_ts + (kshare_d_cps_lfpr_mu_fcst-kshare_d_cps_lfpr_mu_fcst_ts);
lshare_d_bus_hours_mu_fcst = lshare_d_bus_hours_mu_fcst_ts + (lshare_d_cps_lfpr_mu_fcst-lshare_d_cps_lfpr_mu_fcst_ts);

d_cps_pop_mu_fcst = d_cps_pop_mu_fcst_ts;
kshare_d_cps_pop_mu_fcst = kshare_d_cps_pop_mu_fcst_ts;
lshare_d_cps_pop_mu_fcst = lshare_d_cps_pop_mu_fcst_ts;

d_bus_cap_mu_fcst = d_bus_cap_mu_fcst_ts;
kshare_d_bus_cap_mu_fcst = kshare_d_bus_cap_mu_fcst_ts;
kshare3_d_bus_cap_mu_fcst = kshare3_d_bus_cap_mu_fcst_ts;

d_bus_lq_mu_fcst = d_bus_lq_mu_fcst_ts;
kshare_d_bus_lq_mu_fcst = kshare_d_bus_lq_mu_fcst_ts;
lshare_d_bus_lq_mu_fcst = lshare_d_bus_lq_mu_fcst_ts;

d_bus_tfp_mu_fcst = d_bus_tfp_mu_fcst_ts;
kshare2_d_bus_tfp_mu_fcst = kshare2_d_bus_tfp_mu_fcst_ts;

d_ces_emp_mu_fcst = d_ces_emp_mu_fcst_ts + (d_cps_lfpr_mu_fcst-d_cps_lfpr_mu_fcst_ts);
d_ces_emp_gov_sl_mu_fcst = d_ces_emp_gov_sl_mu_fcst_ts;

