% Table 2 for Discussants' draft
% 
%

clear all;
small = 1.0e-10;
big = 1.0e+6;
this_date = datestr(now,'yyyymmdd');

% -----  File Directories -- overhead, etc.
 outdir = 'out/';
 figdir = 'fig/';
 matdir = 'mat/';
 p_initial = path;
  vardef_dir = 'variable_definitions/';            % Directory for necessary matlab_procs and functions                         
  p1=path(vardef_dir,p_initial);
  utility_dir = 'm_utilities';
  path(utility_dir,p1);

% -- Load Data
load_data=0;         % Set = 1 first time to read data from Excel files (then they are saved as MATLAB file)
fhsw_bpea_data;      % fhsw_bpea_data reads in the full dataset .. all variables, etc. saved in datain.xx

% --- Parameters for Cyclical Adjustment and Cyclically adjusted Trend
  % Cyclcical Adjustment Parameters
  ismpl_ol = smpl(calvec,[1981 3],[2016 2],4);  % Sample period for estimating Cyclical adjustment coefficients
  du_nlead = 2;                                 % number of leads
  du_nlag = 12;                                  % number of lags
  % Cyclical adjusted trend bandwidth
  bw_bw = 60;  % Biweight bandwidth for 
  
% -- Set up regressors for cylical adjustment
  d_urate = dif(cps_urate,1);     % first difference of unemployment rate
  xca = lag(d_urate,-du_nlead);   % xca is cyclical adjustment variable
  for i = (-du_nlead+1):du_nlag;
    xca = [xca lag(d_urate,i)];
  end;
 
 % Output file
  outfile_name = [outdir ['Table_A2_2_' this_date '.csv'] ];
  fileID = fopen(outfile_name,'w');
  
 % Misc 
 fprintf(fileID,'Dates Used for Okuns law regressions:');
 cal = calds(ismpl_ol==1,:);
 fprintf(fileID,'%4i:Q%1i - %4i:Q%1i \n',[cal(1,1) cal(1,2) cal(end,1) cal(end,2)]);
 fprintf(fileID,'Number of leads: %2i \n', du_nlead);
 fprintf(fileID,'Number of lags: %2i \n', du_nlag);

 % Construct Variables used in Supply-side analyis;
 supply_variables;  % This computes all of the data series used here
     
% Variable to use for decomposition
  ymat = d_y_prod;
  ymat = [ymat d_y_gdo];
  ymat = [ymat d_bus_y_gdo];
  ymat = [ymat d_y_prod-d_cps_pop];
  ymat = [ymat d_y_gdo-d_cps_pop];
  ymat = [ymat d_bus_y_gdo-d_cps_pop];
  ymat = [ymat d_bus_tfp];
  ymat = [ymat kshare_d_bus_cap-kshare_d_cps_pop];
  ymat = [ymat lshare_d_bus_lq+lshare_d_bus_hours-lshare_d_cps_pop];
  ymat = [ymat d_bus_hours-d_cps_pop];
  ymat = [ymat d_bus_hours-d_bus_emp];
  ymat = [ymat d_bus_emp-d_cps_emp];
  ymat = [ymat d_cps_emp-d_cps_lf];
  ymat = [ymat d_cps_lf-d_cps_pop];
  ymat = [ymat d_bus_y_gdo - d_bus_hours];
  ymat = [ymat kshare2_d_bus_tfp];
  ymat = [ymat kshare3_d_bus_cap-kshare3_d_bus_y_gdo]; 
  ymat = [ymat d_bus_lq];
  ymat = [ymat d_bus_cap-d_bus_hours-d_bus_lq];
  ymat = [ymat d_bus_cap-d_bus_y_gdo];
 
  % Labels for for output
  ymat_str = {...
  'GDP' ...
  'GDO' ...
  'GDO(Bus)' ...
  '\nGDP-Pop' ...
  'GDO-Pop' ...
  '\nGDO(bus)-Pop' ...
  'TFP' ...
  'kshare*(cap-pop)' ...
  'lshare(lq+hours-pop)' ...
  '\nHours-Pop' ...
  'Hours(bus)-Emp(bus)' ...
  'Emp(bus)-Emp(CPS)' ...
  'Emp(CPS)-LF(CPS)' ...
  'LF(CPS)-Pop(CPS)' ...
  '\nGDO(bus)-Hours' ...
  'TFP/lshare' ...
  '(kshare/lshare)*(Capital-Output)' ...
  'LQuality' ...
  '\n\nCapital-Hours-Quality' ...
  'Capital - output' ...
  }; 
 
  % File Setup
  % Print Results
   fprintf(fileID,'Component,,');
   fprintf(fileID,'Generalized OL Coefficient,,,');
   fprintf(fileID,'Standard Deviation of Components \n');
   fprintf(fileID,',,,,,cycle(c),trend(mu),irregular(z) \n');
  
  % Carry out Analysis
  for iseries = 1:size(ymat,2);
      sname = char(ymat_str(iseries));
      dz = ymat(:,iseries);
      fprintf(fileID,[sname ',,']);
      
      [dz_cycle,dz_ca,dz_mu,dz_irregular,var_dz_my,b_okun_sum,se_b_okun_sum ] = cyclical_adjustment(dz,xca,ismpl_ol,bw_bw);
       
      fprintf(fileID,'%5.4f,',b_okun_sum/4);       % Divide by 4 Percentage points per quarter
      fprintf(fileID,'%5.4f,,',se_b_okun_sum/4);
      fprintf(fileID,'%5.4f,',std(dz_cycle(ismpl_ol==1)));
      fprintf(fileID,'%5.4f,',std(dz_mu(ismpl_ol==1)));
      fprintf(fileID,'%5.4f\n',std(dz_irregular(ismpl_ol==1)));
  end;  

% ... overheard .. reset path to initial path  
path(p_initial);  % Reset path
