cap log close
cap drop _all
set more off
# delimit ;
log using c:\AAmortality102716\dofiles\make_WNHrates_SY_MF_2564_ed12_again_9215.log, replace;
/* counting mortality by cause and all-cause for non-Hispanic whites 1992-2015 by single year of age and education class 1 and 2 */
/* EXCLUDING FOUR STATES THAT DON'T HAVE EDUCATION DATA IN EARLY 1990S ON DEATH CERTS: GA,OK,RI,SD */
/* for education work: don't use data prior to 1992 */
/* we will make pop counts for SY groups from March CPS  */

/* count overall death and death by cause by year   */
/* here is what we'll call them:
        Tmort = total number in the sex/age group who died
        Pmort = deaths by poisoning or intent undetermined by alcohol/drugs and sequelae
        Smort = suicide deaths and sequelae
        Cmort = cancer deaths
        Hmort = heart disease
        Lmort = alcoholic liver diseases (includes cirrhosis)
*/



/**********************************************************************/

use "c:\AAmortality102716\outfiles\mort_8915";
/**  keep white non-Hispanics  1992-2015  ****/
*keep if sex==1;
keep if year>=1992;
keep if ind_WNH==1;
keep if edclass<=2;
keep if age>=25 & age<=64 ;

* drop the four states we won't use *;
drop if (fipsstr==13|fipsstr==40|fipsstr==44|fipsstr==46);

keep  icd9 icd9n icd10 year age ;
gen str1 xcode = icd10 ;

/* make our cause of death indicators */

/*******************/
/*** poison ***/

gen pois = 0;

/* the icd9 selection here has been changed to add alcohol to poisoning, and remove things from intent undetermined */
replace pois=1 if icd9n>=8500 & icd9n<=8609 ;
replace pois=1 if icd9n>=9800 & icd9n<=9804;
replace pois=1 if (icd9n>=850 & icd9n<=860 & length(icd9)==3)| (icd9n==980  & length(icd9)==3);

forval i = 10(1)15{;
replace pois = 1 if icd10=="Y`i'" ;
};
forval i = 40(1)45{;
replace pois = 1 if icd10=="X`i'" ;
};
forval i = 45(2)49{;
replace pois = 1 if icd10=="Y`i'" ;
};

/* don't include sequelae of deaths w/ intent undetermined in our counts -- for now */
*replace pois = 1 if icd10=="Y872";

/*******************/
/*** suicide ***/

gen suicide = 0;

replace suicide=1 if icd9n>=9500 & icd9n<=9599 ;
replace suicide= 1 if icd9n>=950 & icd9n<=959 & length(icd9)==3;

forval i = 60(1)84{;
replace suicide = 1 if icd10=="X`i'" ;
};
replace suicide = 1 if icd10=="Y870";

/*******************/
/*** liver ***/
gen liver = 0;

replace liver=1 if icd9n>=5710 & icd9n<=5719 ;
replace liver=1 if icd10=="K70";

forval i = 0(1)9{;
replace liver=1 if icd10=="K70`i'";
};

forval i = 30(1)49{;
replace liver=1 if icd10=="K7`i'";
};

/****************************************/
/*** heart disease as defined by CDC  ***/

gen heart = 0;

replace heart=1 if icd9n>=390 & icd9n<=429 & length(icd9)==3;
replace heart=1 if icd9n>=3900 & icd9n<=4299;


forval i = 0(1)99{;
replace heart=1 if icd10=="I0`i'";
};

forval i = 11(2)13{;
replace heart=1 if icd10=="I`i'";
};

forval i = 0(1)9{;
replace heart=1 if icd10=="I11`i'";
replace heart=1 if icd10=="I13`i'";
};

forval i = 20(1)51{;
replace heart=1 if icd10=="I`i'";
};
forval i = 200(1)519{;
replace heart=1 if icd10=="I`i'";
};



/************************************/
/*** cancer (malignant neoplasms) ***/

gen cancer=0;

replace cancer =1 if icd9n>=140 & icd9n<=208 & length(icd9)==3;
replace cancer =1 if icd9n>=1400 & icd9n<=2089;
replace cancer =1 if xcode=="C";

* LUNG CANCER;
gen lungC=0;
replace lungC =1 if icd9n>=1622 & icd9n<=1629 & length(icd9)==4;
replace lungC=1 if substr(icd10,1,3)=="C34";


/****
/***************************************/
/*** diabetes isn't a big COD - leave it for now ***/
gen diab=0;
forval i =10(1)14{;
forval j =0(1)9{;
replace diab=1 if icd10=="E`i'";
replace diab=1 if icd10=="E`i'`j'";
};
};
****/

/*************************************/
gen cereb=0;
replace cereb=1 if icd9n>=430 & icd9n<=438 & length(icd9)==3;
replace cereb=1 if icd9n>=4300 & icd9n<=4389;
forval i = 60(1)69 {;
forval j = 0(1)9 {;
replace cereb=1 if icd10=="I`i'";
replace cereb=1 if icd10=="I`i'`j'";
};
};


/*************************************/
gen resp=0;
replace resp=1 if icd9n>=490 & icd9n<=496 & length(icd9)==3;
replace resp=1 if icd9n>=4900 & icd9n<=4969 ;
forval i = 40(1)47{;
forval j = 0(1)9{;
replace resp=1 if icd10=="J`i'";
replace resp=1 if icd10=="J`i'`j'";
};
};

sum;

label data "mortality numbers WNH edclasses 1 and 2";
save c:\AAmortality102716\outfiles\WNH_mortbycause_SY_MF_2564_ed12_9215.dta, replace;


/******************************** sum by cause of death  *******************/

use c:\AAmortality102716\outfiles\WNH_mortbycause_SY_MF_2564_ed12_9215.dta ;

gen one=1;
bysort age  year: egen Tmort = total(one);
bysort age  year: egen Pmort = total(pois);
bysort age  year: egen Smort = total(suicide);
bysort age  year: egen Lmort = total(liver);
bysort age  year: egen Hmort = total(heart);
bysort age  year: egen Cmort = total(cancer);
bysort age  year: egen lungCmort = total(lungC);
bysort age  year: egen CDmort = total(cereb);
bysort age  year: egen CLmort = total(resp);

by age year, sort: keep if _n==1;
save c:\AAmortality102716\outfiles\WNH_mort_SY_MF_2564_ed12_9215, replace;


/*****************************************************************/



/* now combine deaths with population by cell */
	

tempfile tempdat;

use c:\users\accase\dropbox\cepr_march\data\stcross.dta;
ren State state;
merge 1:m  state using c:\users\accase\dropbox\cepr_march\data\cps_march_inc_8016.dta ;
drop _m;
drop if year>2015;
*keep if female==0;
keep if wbho==1;
keep if age>=25 & age<=64 ;
keep if edclass<=2;

/* drop states that don't have education on death certificates */
/* and keep records from 1992 on to use in education work */
  drop if year<1992;
  drop if (fipsstr==13|fipsstr==40|fipsstr==44|fipsstr==46);



bysort year age : egen TPop = total(wgt);
bysort year age : keep if _n==1;

keep year age  TPop ;

save `tempdat';


merge 1:1 year age using c:\AAmortality102716\outfiles\WNH_mort_SY_MF_2564_ed12_9215;

/* _m==1 is for groups that recorded no deaths in that year */

  foreach var in T P S L H C lungC CD CL {;
   replace `var'mort = 0 if _m==1 ;
   gen `var'rate   = (`var'mort/TPop)*100000;
   };

tab year if _m==2;
drop _m;
label var Prate "alc/drug poisoning";
label var Hrate "heart disease";
label var Crate "cancer";
label var Srate "suicide";
label var Trate "all cause";
label var Lrate "alcoholic liver";
label var lungCrate "lung cancer";
label var CDrate "cerebrovascular disease";
label var CLrate "chrnc lower resp disease";


save c:\AAmortality102716\outfiles\WNHrates_SY_MF_2564_ed12_again_9215, replace;
log close;
